/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.schemaregistry.confluent.formatter;

import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.kafka.common.errors.SerializationException;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]3QAB\u0004\u0001\u0013]A\u0001b\t\u0001\u0003\u0002\u0003\u0006I!\n\u0005\u0006Y\u0001!\t!\f\u0005\bc\u0001\u0011\r\u0011\"\u00033\u0011\u0019i\u0004\u0001)A\u0005g!)a\b\u0001C\u0001\u007f\ti2i\u001c8gYV,g\u000e^!we>lUm]:bO\u00164uN]7biR,'O\u0003\u0002\t\u0013\u0005Iam\u001c:nCR$XM\u001d\u0006\u0003\u0015-\t\u0011bY8oM2,XM\u001c;\u000b\u00051i\u0011AD:dQ\u0016l\u0017M]3hSN$(/\u001f\u0006\u0003\u001d=\tA!\u0019<s_*\u0011\u0001#E\u0001\u0007K:<\u0017N\\3\u000b\u0005I\u0019\u0012a\u00038vgN\\g.Y2lKJT!\u0001F\u000b\u0002\tQ|Wo\u001b\u0006\u0002-\u0005\u0011\u0001\u000f\\\n\u0003\u0001a\u0001\"!G\u0011\u000e\u0003iQ!a\u0007\u000f\u0002\u0017M,'/[1mSj,'o\u001d\u0006\u0003;y\tQa[1gW\u0006T!AC\u0010\u000b\u0003\u0001\n!![8\n\u0005\tR\"!H!cgR\u0014\u0018m\u0019;LC\u001a\\\u0017-\u0011<s_\u0012+7/\u001a:jC2L'0\u001a:\u0002)M\u001c\u0007.Z7b%\u0016<\u0017n\u001d;ss\u000ec\u0017.\u001a8u\u0007\u0001\u0001\"A\n\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\r\rd\u0017.\u001a8u\u0015\taA$\u0003\u0002,O\t!2k\u00195f[\u0006\u0014VmZ5tiJL8\t\\5f]R\fa\u0001P5oSRtDC\u0001\u00181!\ty\u0003!D\u0001\b\u0011\u0015\u0019#\u00011\u0001&\u00039)gnY8eKJ4\u0015m\u0019;pef,\u0012a\r\t\u0003imj\u0011!\u000e\u0006\u0003AYR!AD\u001c\u000b\u0005aJ\u0014AB1qC\u000eDWMC\u0001;\u0003\ry'oZ\u0005\u0003yU\u0012a\"\u00128d_\u0012,'OR1di>\u0014\u00180A\bf]\u000e|G-\u001a:GC\u000e$xN]=!\u0003\u001d9(/\u001b;f)>$2\u0001\u0011$O!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u0011)f.\u001b;\t\u000b\u001d+\u0001\u0019\u0001%\u0002\t\u0011\fG/\u0019\t\u0004\u0003&[\u0015B\u0001&C\u0005\u0015\t%O]1z!\t\tE*\u0003\u0002N\u0005\n!!)\u001f;f\u0011\u0015yU\u00011\u0001Q\u0003\u0019yW\u000f\u001e9viB\u0011\u0011+V\u0007\u0002%*\u0011\u0001e\u0015\u0006\u0002)\u0006!!.\u0019<b\u0013\t1&KA\u0006Qe&tGo\u0015;sK\u0006l\u0007")
public class ConfluentAvroMessageFormatter
extends AbstractKafkaAvroDeserializer {
    private final EncoderFactory encoderFactory = EncoderFactory.get();

    private EncoderFactory encoderFactory() {
        return this.encoderFactory;
    }

    public void writeTo(byte[] data, PrintStream output) {
        Object obj = this.deserialize(data);
        Schema schema = AvroSchemaUtils.getSchema((Object)obj);
        try {
            JsonEncoder encoder = this.encoderFactory().jsonEncoder(schema, (OutputStream)output);
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            Object object = obj;
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                writer.write((Object)ByteBuffer.wrap(byArray), (Encoder)encoder);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                writer.write(obj, (Encoder)encoder);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            encoder.flush();
        }
        catch (AvroRuntimeException ex) {
            throw new SerializationException(String.format("Error serializing Avro data of schema %s to json", schema), (Throwable)ex);
        }
    }

    public ConfluentAvroMessageFormatter(SchemaRegistryClient schemaRegistryClient) {
        this.schemaRegistry = schemaRegistryClient;
    }
}

