/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.formats.avro.typeutils.AvroSerializerDebugInitHelper;
import org.apache.flink.formats.avro.typeutils.LogicalTypesAvroFactory;
import org.apache.flink.formats.avro.typeutils.LogicalTypesAvroSerializerSnapshot;
import org.apache.flink.formats.avro.typeutils.NkSerializableAvroSchema;
import org.apache.flink.formats.avro.utils.DataInputDecoder;
import org.apache.flink.formats.avro.utils.DataOutputEncoder;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalTypesAvroSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = -2289777083431834102L;
    private static final Logger LOG = LoggerFactory.getLogger(LogicalTypesAvroSerializer.class);
    private static final boolean CONCURRENT_ACCESS_CHECK = LOG.isDebugEnabled() || AvroSerializerDebugInitHelper.setToDebug;
    @Nonnull
    private Class<T> type;
    @Nonnull
    private NkSerializableAvroSchema schema;
    @Nonnull
    private NkSerializableAvroSchema previousSchema;
    private transient GenericData avroData;
    private transient DatumWriter<T> writer;
    private transient DataOutputEncoder encoder;
    private transient DataInputDecoder decoder;
    private transient DatumReader<T> reader;
    private transient Schema runtimeSchema;
    private transient TypeSerializerSnapshot<T> configSnapshot;
    private volatile transient Thread currentThread;

    public LogicalTypesAvroSerializer(Class<T> clazz) {
        this((Class)Preconditions.checkNotNull(clazz), new NkSerializableAvroSchema(), new NkSerializableAvroSchema());
        Preconditions.checkArgument((!LogicalTypesAvroSerializer.isGenericRecord(clazz) ? 1 : 0) != 0, (Object)"For GenericData.Record use constructor with explicit schema.");
    }

    public LogicalTypesAvroSerializer(Class<T> clazz, Schema schema) {
        this((Class)Preconditions.checkNotNull(clazz), new NkSerializableAvroSchema((Schema)Preconditions.checkNotNull((Object)schema)), new NkSerializableAvroSchema());
        Preconditions.checkArgument((boolean)LogicalTypesAvroSerializer.isGenericRecord(clazz), (Object)"For classes other than GenericData.Record use constructor without explicit schema.");
    }

    @Internal
    LogicalTypesAvroSerializer(Class<T> clazz, NkSerializableAvroSchema nkSerializableAvroSchema, NkSerializableAvroSchema nkSerializableAvroSchema2) {
        this.type = (Class)Preconditions.checkNotNull(clazz);
        this.schema = (NkSerializableAvroSchema)Preconditions.checkNotNull((Object)nkSerializableAvroSchema);
        this.previousSchema = (NkSerializableAvroSchema)Preconditions.checkNotNull((Object)nkSerializableAvroSchema2);
    }

    @Deprecated
    public LogicalTypesAvroSerializer(Class<T> clazz, Class<? extends T> clazz2) {
        this(clazz);
    }

    @Nonnull
    public Class<T> getType() {
        return this.type;
    }

    public boolean isImmutableType() {
        return false;
    }

    public int getLength() {
        return -1;
    }

    public T createInstance() {
        return (T)InstantiationUtil.instantiate(this.type);
    }

    public void serialize(T t, DataOutputView dataOutputView) throws IOException {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            this.checkAvroInitialized();
            this.encoder.setOut((DataOutput)dataOutputView);
            this.writer.write(t, (Encoder)this.encoder);
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    public T deserialize(DataInputView dataInputView) throws IOException {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            this.checkAvroInitialized();
            this.decoder.setIn((DataInput)dataInputView);
            Object object = this.reader.read(null, (Decoder)this.decoder);
            return (T)object;
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T deserialize(T t, DataInputView dataInputView) throws IOException {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            this.checkAvroInitialized();
            this.decoder.setIn((DataInput)dataInputView);
            Object object = this.reader.read(t, (Decoder)this.decoder);
            return (T)object;
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    public T copy(T t) {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            this.checkAvroInitialized();
            Object object = this.avroData.deepCopy(this.runtimeSchema, t);
            return (T)object;
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    public T copy(T t, T t2) {
        return this.copy(t);
    }

    public void copy(DataInputView dataInputView, DataOutputView dataOutputView) throws IOException {
        this.serialize(this.deserialize(dataInputView), dataOutputView);
    }

    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        if (this.configSnapshot == null) {
            this.checkAvroInitialized();
            this.configSnapshot = new LogicalTypesAvroSerializerSnapshot<T>(this.runtimeSchema, this.type);
        }
        return this.configSnapshot;
    }

    static boolean isGenericRecord(Class<?> clazz) {
        return !SpecificRecord.class.isAssignableFrom(clazz) && GenericRecord.class.isAssignableFrom(clazz);
    }

    public TypeSerializer<T> duplicate() {
        this.checkAvroInitialized();
        return new LogicalTypesAvroSerializer<T>(this.type, new NkSerializableAvroSchema(this.runtimeSchema), this.previousSchema);
    }

    public int hashCode() {
        return 42 + this.type.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == LogicalTypesAvroSerializer.class) {
            LogicalTypesAvroSerializer logicalTypesAvroSerializer = (LogicalTypesAvroSerializer)((Object)object);
            return this.type == logicalTypesAvroSerializer.type;
        }
        return false;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " (" + this.getType().getName() + ')';
    }

    private void checkAvroInitialized() {
        if (this.writer == null) {
            this.initializeAvro();
        }
    }

    private void initializeAvro() {
        LogicalTypesAvroFactory<T> logicalTypesAvroFactory = LogicalTypesAvroFactory.create(this.type, this.schema.getAvroSchema(), this.previousSchema.getAvroSchema());
        this.runtimeSchema = logicalTypesAvroFactory.getSchema();
        this.writer = logicalTypesAvroFactory.getWriter();
        this.reader = logicalTypesAvroFactory.getReader();
        this.encoder = logicalTypesAvroFactory.getEncoder();
        this.decoder = logicalTypesAvroFactory.getDecoder();
        this.avroData = logicalTypesAvroFactory.getAvroData();
    }

    private void enterExclusiveThread() {
        Thread thread = this.currentThread;
        Thread thread2 = Thread.currentThread();
        if (thread == null) {
            this.currentThread = thread2;
        } else if (thread != thread2) {
            throw new IllegalStateException("Concurrent access to KryoSerializer. Thread 1: " + thread2.getName() + " , Thread 2: " + thread.getName());
        }
    }

    private void exitExclusiveThread() {
        this.currentThread = null;
    }

    Schema getAvroSchema() {
        this.checkAvroInitialized();
        return this.runtimeSchema;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object = objectInputStream.readObject();
        if (object == null) {
            this.read16Layout(null, objectInputStream);
        } else if (object instanceof String) {
            this.read16Layout((String)object, objectInputStream);
        } else if (object instanceof Class) {
            Class clazz = (Class)object;
            this.read15Layout(clazz);
        } else if (object instanceof NkSerializableAvroSchema) {
            this.readCurrentLayout((NkSerializableAvroSchema)object, objectInputStream);
        } else {
            throw new IllegalStateException("Failed to Java-Deserialize an AvroSerializer instance. Was expecting a first field to be either a String or SerializableAvroSchema, but got: " + object.getClass());
        }
    }

    private void read15Layout(Class<T> clazz) {
        this.previousSchema = new NkSerializableAvroSchema();
        this.schema = new NkSerializableAvroSchema();
        this.type = clazz;
    }

    private void read16Layout(@Nullable String string, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Schema schema = LogicalTypesAvroFactory.parseSchemaString(string);
        Class clazz = (Class)objectInputStream.readObject();
        this.previousSchema = new NkSerializableAvroSchema();
        this.schema = new NkSerializableAvroSchema(schema);
        this.type = clazz;
    }

    private void readCurrentLayout(NkSerializableAvroSchema nkSerializableAvroSchema, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.previousSchema = nkSerializableAvroSchema;
        this.schema = (NkSerializableAvroSchema)objectInputStream.readObject();
        this.type = (Class)objectInputStream.readObject();
    }

    @Deprecated
    public static final class LogicalTypesAvroSchemaSerializerConfigSnapshot<T>
    extends LogicalTypesAvroSerializerSnapshot<T> {
    }
}

