/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.sink;

import cats.Applicative;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import java.io.Serializable;
import org.apache.avro.Schema;
import pl.touk.nussknacker.engine.api.context.ProcessCompilationError;
import pl.touk.nussknacker.engine.avro.sink.AvroSinkRecordParameter$;
import pl.touk.nussknacker.engine.avro.sink.AvroSinkSingleValueParameter$;
import pl.touk.nussknacker.engine.avro.sink.AvroSinkValueParameter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;

public final class AvroSinkValueParameter$ {
    public static AvroSinkValueParameter$ MODULE$;
    private final Set<String> restrictedParamNames;

    static {
        new AvroSinkValueParameter$();
    }

    public Set<String> restrictedParamNames() {
        return this.restrictedParamNames;
    }

    public Validated<NonEmptyList<ProcessCompilationError>, AvroSinkValueParameter> apply(Schema schema, ProcessCompilationError.NodeId nodeId) {
        return this.toSinkValueParameter(schema, (Option<String>)None$.MODULE$, nodeId);
    }

    private Validated<NonEmptyList<ProcessCompilationError>, AvroSinkValueParameter> toSinkValueParameter(Schema schema, Option<String> paramName, ProcessCompilationError.NodeId nodeId) {
        Validated.Valid valid;
        Schema.Type type = schema.getType();
        Schema.Type type2 = Schema.Type.RECORD;
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            List recordFields = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).toList();
            if (this.containsRestrictedNames((List<Schema.Field>)recordFields)) {
                valid = new Validated.Invalid((Object)NonEmptyList$.MODULE$.one((Object)new ProcessCompilationError.CustomNodeError(nodeId.id(), new StringBuilder(54).append("Record field name is restricted. Restricted names are ").append(this.restrictedParamNames().mkString(", ")).toString(), (Option)None$.MODULE$)));
            } else {
                List listOfValidatedParams = (List)recordFields.map((Function1 & Serializable & scala.Serializable)recordField -> {
                    String fieldName = recordField.name();
                    Schema fieldSchema = recordField.schema();
                    String concatName = (String)paramName.map((Function1 & Serializable & scala.Serializable)pn -> new StringBuilder(1).append((String)pn).append(".").append(fieldName).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> fieldName);
                    Some x$1 = new Some((Object)concatName);
                    Schema x$2 = fieldSchema;
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fieldName), MODULE$.toSinkValueParameter(x$2, (Option<String>)x$1, nodeId));
                }, List$.MODULE$.canBuildFrom());
                valid = this.sequence((List<Tuple2<String, Validated<NonEmptyList<ProcessCompilationError>, AvroSinkValueParameter>>>)listOfValidatedParams).map((Function1)AvroSinkRecordParameter$.MODULE$);
            }
        } else {
            valid = new Validated.Valid((Object)AvroSinkSingleValueParameter$.MODULE$.apply(paramName, schema));
        }
        return valid;
    }

    private boolean containsRestrictedNames(List<Schema.Field> fields) {
        Set fieldNames = ((TraversableOnce)fields.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), List$.MODULE$.canBuildFrom())).toSet();
        return fieldNames.nonEmpty() & ((TraversableOnce)fieldNames.$amp(this.restrictedParamNames())).nonEmpty();
    }

    private Validated<NonEmptyList<ProcessCompilationError>, List<Tuple2<String, AvroSinkValueParameter>>> sequence(List<Tuple2<String, Validated<NonEmptyList<ProcessCompilationError>, AvroSinkValueParameter>>> l) {
        return (Validated)implicits$.MODULE$.toTraverseOps(l.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String fieldName = (String)tuple2._1();
            Validated validated = (Validated)tuple2._2();
            Validated validated2 = validated.map((Function1 & Serializable & scala.Serializable)sinkValueParam -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fieldName), sinkValueParam));
            return validated2;
        }, List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()));
    }

    private AvroSinkValueParameter$() {
        MODULE$ = this;
        this.restrictedParamNames = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema version", "Key", "Value validation mode", "Topic"}));
    }
}

