/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.lang.reflect.Type;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.annotation.Internal;
import org.apache.flink.formats.avro.utils.DataInputDecoder;
import org.apache.flink.formats.avro.utils.DataOutputEncoder;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.nussknacker.engine.avro.AvroUtils;
import pl.touk.nussknacker.engine.avro.schema.StringForcingDatumReaderProvider;

@Internal
public final class LogicalTypesAvroFactory<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LogicalTypesAvroFactory.class);
    private final DataOutputEncoder encoder = new DataOutputEncoder();
    private final DataInputDecoder decoder = new DataInputDecoder();
    private final GenericData avroData;
    private final Schema schema;
    private final DatumWriter<T> writer;
    private final DatumReader<T> reader;

    static <T> LogicalTypesAvroFactory<T> create(Class<T> clazz, @Nullable Schema schema, @Nullable Schema schema2) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (SpecificRecord.class.isAssignableFrom(clazz)) {
            return LogicalTypesAvroFactory.fromSpecific(clazz, classLoader, Optional.ofNullable(schema2));
        }
        if (GenericRecord.class.isAssignableFrom(clazz)) {
            return LogicalTypesAvroFactory.fromGeneric(classLoader, schema);
        }
        return LogicalTypesAvroFactory.fromReflective(clazz, classLoader, Optional.ofNullable(schema2));
    }

    @Nullable
    static Schema parseSchemaString(@Nullable String string) {
        return string == null ? null : new Schema.Parser().parse(string);
    }

    private static <T> LogicalTypesAvroFactory<T> fromSpecific(Class<T> clazz, ClassLoader classLoader, Optional<Schema> optional) {
        SpecificData specificData = AvroUtils.specificData();
        Schema schema = LogicalTypesAvroFactory.extractAvroSpecificSchema(clazz, specificData);
        return new LogicalTypesAvroFactory((GenericData)specificData, schema, new StringForcingDatumReaderProvider().specificDatumReader(optional.orElse(schema), schema, specificData), new SpecificDatumWriter(schema, specificData));
    }

    private static <T> LogicalTypesAvroFactory<T> fromGeneric(ClassLoader classLoader, Schema schema) {
        Preconditions.checkNotNull((Object)schema, (String)"Unable to create an AvroSerializer with a GenericRecord type without a schema");
        GenericData genericData = AvroUtils.genericData();
        return new LogicalTypesAvroFactory(genericData, schema, new StringForcingDatumReaderProvider().genericDatumReader(schema, schema, genericData), new GenericDatumWriter(schema, genericData));
    }

    private static <T> LogicalTypesAvroFactory<T> fromReflective(Class<T> clazz, ClassLoader classLoader, Optional<Schema> optional) {
        ReflectData reflectData = AvroUtils.reflectData();
        Schema schema = reflectData.getSchema(clazz);
        return new LogicalTypesAvroFactory((GenericData)reflectData, schema, new StringForcingDatumReaderProvider().reflectDatumReader(optional.orElse(schema), schema, reflectData), new ReflectDatumWriter(schema, reflectData));
    }

    public static <T> Schema extractAvroSpecificSchema(Class<T> clazz, SpecificData specificData) {
        Optional<Schema> optional = LogicalTypesAvroFactory.tryExtractAvroSchemaViaInstance(clazz);
        return optional.orElseGet(() -> specificData.getSchema((Type)clazz));
    }

    private static Optional<Schema> tryExtractAvroSchemaViaInstance(Class<?> clazz) {
        try {
            SpecificRecord specificRecord = (SpecificRecord)clazz.newInstance();
            return Optional.ofNullable(specificRecord.getSchema());
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            LOG.warn("Could not extract schema from Avro-generated SpecificRecord class {}: {}.", clazz, (Object)reflectiveOperationException);
            return Optional.empty();
        }
    }

    private LogicalTypesAvroFactory(GenericData genericData, Schema schema, DatumReader<T> datumReader, DatumWriter<T> datumWriter) {
        this.avroData = (GenericData)Preconditions.checkNotNull((Object)genericData);
        this.schema = (Schema)Preconditions.checkNotNull((Object)schema);
        this.writer = (DatumWriter)Preconditions.checkNotNull(datumWriter);
        this.reader = (DatumReader)Preconditions.checkNotNull(datumReader);
    }

    DataOutputEncoder getEncoder() {
        return this.encoder;
    }

    DataInputDecoder getDecoder() {
        return this.decoder;
    }

    Schema getSchema() {
        return this.schema;
    }

    DatumWriter<T> getWriter() {
        return this.writer;
    }

    DatumReader<T> getReader() {
        return this.reader;
    }

    GenericData getAvroData() {
        return this.avroData;
    }
}

