/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.schemaregistry.confluent.formatter;

import io.circe.Json;
import io.circe.parser.package$;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.kafka.common.errors.SerializationException;
import pl.touk.nussknacker.engine.avro.schema.DatumReaderWriterMixin;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00194QAB\u0004\u0001\u0013]A\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006e\u0001!\ta\r\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0011\u0019\u0019\u0005\u0001)A\u0005s!)A\t\u0001C\u0001\u000b\ni2i\u001c8gYV,g\u000e^!we>lUm]:bO\u00164uN]7biR,'O\u0003\u0002\t\u0013\u0005Iam\u001c:nCR$XM\u001d\u0006\u0003\u0015-\t\u0011bY8oM2,XM\u001c;\u000b\u00051i\u0011AD:dQ\u0016l\u0017M]3hSN$(/\u001f\u0006\u0003\u001d=\tA!\u0019<s_*\u0011\u0001#E\u0001\u0007K:<\u0017N\\3\u000b\u0005I\u0019\u0012a\u00038vgN\\g.Y2lKJT!\u0001F\u000b\u0002\tQ|Wo\u001b\u0006\u0002-\u0005\u0011\u0001\u000f\\\n\u0004\u0001a\u0019\u0003CA\r\"\u001b\u0005Q\"BA\u000e\u001d\u0003-\u0019XM]5bY&TXM]:\u000b\u0005uq\u0012!B6bM.\f'B\u0001\u0006 \u0015\u0005\u0001\u0013AA5p\u0013\t\u0011#DA\u000fBEN$(/Y2u\u0017\u000647.Y!we>$Um]3sS\u0006d\u0017N_3s!\t!s%D\u0001&\u0015\t1S\"\u0001\u0004tG\",W.Y\u0005\u0003Q\u0015\u0012a\u0003R1uk6\u0014V-\u00193fe^\u0013\u0018\u000e^3s\u001b&D\u0018N\\\u0001\u0015g\u000eDW-\\1SK\u001eL7\u000f\u001e:z\u00072LWM\u001c;\u0004\u0001A\u0011A\u0006M\u0007\u0002[)\u0011afL\u0001\u0007G2LWM\u001c;\u000b\u00051a\u0012BA\u0019.\u0005Q\u00196\r[3nCJ+w-[:uef\u001cE.[3oi\u00061A(\u001b8jiz\"\"\u0001\u000e\u001c\u0011\u0005U\u0002Q\"A\u0004\t\u000b%\u0012\u0001\u0019A\u0016\u0002\u001d\u0015t7m\u001c3fe\u001a\u000b7\r^8ssV\t\u0011\b\u0005\u0002;\u00036\t1H\u0003\u0002!y)\u0011a\"\u0010\u0006\u0003}}\na!\u00199bG\",'\"\u0001!\u0002\u0007=\u0014x-\u0003\u0002Cw\tqQI\\2pI\u0016\u0014h)Y2u_JL\u0018aD3oG>$WM\u001d$bGR|'/\u001f\u0011\u0002\r\u0005\u001c(j]8o+\t1%\f\u0006\u0002HIR\u0011\u0001J\u0014\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017~\tQaY5sG\u0016L!!\u0014&\u0003\t)\u001bxN\u001c\u0005\b\u001f\u0016\t\t\u0011q\u0001Q\u0003))g/\u001b3f]\u000e,G%\r\t\u0004#ZCV\"\u0001*\u000b\u0005M#\u0016a\u0002:fM2,7\r\u001e\u0006\u0002+\u0006)1oY1mC&\u0011qK\u0015\u0002\t\u00072\f7o\u001d+bOB\u0011\u0011L\u0017\u0007\u0001\t\u0015YVA1\u0001]\u0005\u0005!\u0016CA/b!\tqv,D\u0001U\u0013\t\u0001GKA\u0004O_RD\u0017N\\4\u0011\u0005y\u0013\u0017BA2U\u0005\r\te.\u001f\u0005\u0006K\u0016\u0001\r\u0001W\u0001\u0004_\nT\u0007")
public class ConfluentAvroMessageFormatter
extends AbstractKafkaAvroDeserializer
implements DatumReaderWriterMixin {
    private final EncoderFactory encoderFactory;
    private final Map<String, Schema> primitives;

    @Override
    public GenericDatumWriter<Object> createDatumWriter(Object record, Schema schema, boolean useSchemaReflection) {
        return DatumReaderWriterMixin.createDatumWriter$(this, record, schema, useSchemaReflection);
    }

    @Override
    public DatumReader<Object> createDatumReader(Schema writerSchema, Schema readerSchema, boolean useSchemaReflection, boolean useSpecificAvroReader) {
        return DatumReaderWriterMixin.createDatumReader$(this, writerSchema, readerSchema, useSchemaReflection, useSpecificAvroReader);
    }

    @Override
    public Map<String, Schema> primitives() {
        return this.primitives;
    }

    @Override
    public void pl$touk$nussknacker$engine$avro$schema$DatumReaderWriterMixin$_setter_$primitives_$eq(Map<String, Schema> x$1) {
        this.primitives = x$1;
    }

    private EncoderFactory encoderFactory() {
        return this.encoderFactory;
    }

    public <T> Json asJson(T obj, ClassTag<T> evidence$1) {
        Json json;
        Schema schema = AvroSchemaUtils.getSchema(obj);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream output = new PrintStream((OutputStream)bos, true, StandardCharsets.UTF_8.toString());
        try {
            Object object;
            JsonEncoder encoder2 = this.encoderFactory().jsonEncoder(schema, (OutputStream)output, false);
            T t = obj;
            if (t instanceof byte[]) {
                byte[] byArray = (byte[])t;
                object = ByteBuffer.wrap(byArray);
            } else {
                object = t;
            }
            T record = object;
            GenericDatumWriter<Object> writer = this.createDatumWriter(record, schema, false);
            writer.write(record, (Encoder)encoder2);
            encoder2.flush();
            String str = bos.toString(StandardCharsets.UTF_8);
            json = (Json)package$.MODULE$.parse(str).right().get();
        }
        catch (Exception ex) {
            throw new SerializationException(String.format("Error serializing Avro data of schema %s to json", schema), (Throwable)ex);
        }
        return json;
    }

    public ConfluentAvroMessageFormatter(SchemaRegistryClient schemaRegistryClient) {
        DatumReaderWriterMixin.$init$(this);
        this.encoderFactory = EncoderFactory.get();
        this.schemaRegistry = schemaRegistryClient;
    }
}

