/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.schemaregistry.confluent.formatter;

import io.circe.Json;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.kafka.common.errors.SerializationException;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000114Qa\u0002\u0005\u0001\u0015aA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006[\u0001!\tA\f\u0005\be\u0001\u0011\r\u0011\"\u00034\u0011\u0019q\u0004\u0001)A\u0005i!)q\b\u0001C\u0001\u0001\")Q\r\u0001C\u0005M\nQ2i\u001c8gYV,g\u000e^!we>lUm]:bO\u0016\u0014V-\u00193fe*\u0011\u0011BC\u0001\nM>\u0014X.\u0019;uKJT!a\u0003\u0007\u0002\u0013\r|gN\u001a7vK:$(BA\u0007\u000f\u00039\u00198\r[3nCJ,w-[:uefT!a\u0004\t\u0002\t\u00054(o\u001c\u0006\u0003#I\ta!\u001a8hS:,'BA\n\u0015\u0003-qWo]:l]\u0006\u001c7.\u001a:\u000b\u0005U1\u0012\u0001\u0002;pk.T\u0011aF\u0001\u0003a2\u001c\"\u0001A\r\u0011\u0005i\u0011S\"A\u000e\u000b\u0005qi\u0012aC:fe&\fG.\u001b>feNT!AH\u0010\u0002\u000b-\fgm[1\u000b\u0005-\u0001#\"A\u0011\u0002\u0005%|\u0017BA\u0012\u001c\u0005m\t%m\u001d;sC\u000e$8*\u00194lC\u00063(o\\*fe&\fG.\u001b>fe\u0006!2o\u00195f[\u0006\u0014VmZ5tiJL8\t\\5f]R\u001c\u0001\u0001\u0005\u0002(W5\t\u0001F\u0003\u0002*U\u000511\r\\5f]RT!!D\u000f\n\u00051B#\u0001F*dQ\u0016l\u0017MU3hSN$(/_\"mS\u0016tG/\u0001\u0004=S:LGO\u0010\u000b\u0003_E\u0002\"\u0001\r\u0001\u000e\u0003!AQ\u0001\n\u0002A\u0002\u0019\na\u0002Z3d_\u0012,'OR1di>\u0014\u00180F\u00015!\t)D(D\u00017\u0015\t\tsG\u0003\u0002\u0010q)\u0011\u0011HO\u0001\u0007CB\f7\r[3\u000b\u0003m\n1a\u001c:h\u0013\tidG\u0001\bEK\u000e|G-\u001a:GC\u000e$xN]=\u0002\u001f\u0011,7m\u001c3fe\u001a\u000b7\r^8ss\u0002\n\u0001B]3bI*\u001bxN\u001c\u000b\u0005\u0003*\u0013\u0006\fE\u0002C\u000b\u001ek\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0005\"K!!S\"\u0003\t\tKH/\u001a\u0005\u0006\u0017\u0016\u0001\r\u0001T\u0001\bUN|gn\u00142k!\ti\u0005+D\u0001O\u0015\ty\u0005%A\u0003dSJ\u001cW-\u0003\u0002R\u001d\n!!j]8o\u0011\u0015\u0019V\u00011\u0001U\u0003\u0019\u00198\r[3nCB\u0011QKV\u0007\u0002o%\u0011qk\u000e\u0002\u0007'\u000eDW-\\1\t\u000be+\u0001\u0019\u0001.\u0002\u000fM,(M[3diB\u00111L\u0019\b\u00039\u0002\u0004\"!X\"\u000e\u0003yS!aX\u0013\u0002\rq\u0012xn\u001c;?\u0013\t\t7)\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u0014aa\u0015;sS:<'BA1D\u0003)Q7o\u001c8U_\u00063(o\u001c\u000b\u0004O*\\\u0007C\u0001\"i\u0013\tI7I\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u0017\u001a\u0001\r\u0001\u0014\u0005\u0006'\u001a\u0001\r\u0001\u0016")
public class ConfluentAvroMessageReader
extends AbstractKafkaAvroSerializer {
    private final DecoderFactory decoderFactory;

    private DecoderFactory decoderFactory() {
        return this.decoderFactory;
    }

    public byte[] readJson(Json jsonObj, Schema schema, String subject) {
        byte[] byArray;
        try {
            Object avroObj = this.jsonToAvro(jsonObj, schema);
            byArray = this.serializeImpl(subject, avroObj, new AvroSchema(schema));
        }
        catch (Exception ex) {
            throw new SerializationException("Error reading from input", (Throwable)ex);
        }
        return byArray;
    }

    private Object jsonToAvro(Json jsonObj, Schema schema) {
        Object object;
        String jsonString = jsonObj.noSpaces();
        try {
            DatumReader reader = GenericData.get().createDatumReader(schema);
            Object obj = reader.read(null, (Decoder)this.decoderFactory().jsonDecoder(schema, jsonString));
            Schema.Type type = schema.getType();
            Schema.Type type2 = Schema.Type.STRING;
            object = !(type != null ? !type.equals(type2) : type2 != null) ? ((Utf8)obj).toString() : obj;
        }
        catch (Exception ex) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), (Throwable)ex);
        }
        return object;
    }

    public ConfluentAvroMessageReader(SchemaRegistryClient schemaRegistryClient) {
        this.schemaRegistry = schemaRegistryClient;
        this.decoderFactory = DecoderFactory.get();
    }
}

