/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.api.typed;

import cats.data.NonEmptyList;
import cats.data.Validated;
import cats.implicits$;
import cats.syntax.ValidatedIdSyntax$;
import io.circe.ACursor;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.DecodingFailure$;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import pl.touk.nussknacker.engine.api.typed.typing;
import pl.touk.nussknacker.engine.api.typed.typing$Typed$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class SimpleObjectEncoder$ {
    public static SimpleObjectEncoder$ MODULE$;
    private final typing.TypedClass intClass;
    private final typing.TypedClass longClass;
    private final typing.TypedClass floatClass;
    private final typing.TypedClass doubleClass;
    private final typing.TypedClass booleanClass;
    private final typing.TypedClass stringClass;

    static {
        new SimpleObjectEncoder$();
    }

    private typing.TypedClass intClass() {
        return this.intClass;
    }

    private typing.TypedClass longClass() {
        return this.longClass;
    }

    private typing.TypedClass floatClass() {
        return this.floatClass;
    }

    private typing.TypedClass doubleClass() {
        return this.doubleClass;
    }

    private typing.TypedClass booleanClass() {
        return this.booleanClass;
    }

    private typing.TypedClass stringClass() {
        return this.stringClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Validated<NonEmptyList<String>, Json> encode(typing.TypedClass typ, Object data) {
        Tuple2 tuple2 = new Tuple2((Object)typ, data);
        if (tuple2 != null) {
            typing.TypedClass typedClass2 = (typing.TypedClass)tuple2._1();
            Object intValue = tuple2._2();
            typing.TypedClass typedClass3 = this.intClass();
            typing.TypedClass typedClass4 = typedClass2;
            if (!(typedClass3 != null ? !((Object)typedClass3).equals(typedClass4) : typedClass4 != null) && intValue instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)intValue);
                return ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)Json$.MODULE$.fromInt(n)));
            }
        }
        if (tuple2 != null) {
            typing.TypedClass typedClass5 = (typing.TypedClass)tuple2._1();
            Object longValue = tuple2._2();
            typing.TypedClass typedClass6 = this.longClass();
            typing.TypedClass typedClass7 = typedClass5;
            if (!(typedClass6 != null ? !((Object)typedClass6).equals(typedClass7) : typedClass7 != null) && longValue instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)longValue);
                return ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)Json$.MODULE$.fromLong(l)));
            }
        }
        if (tuple2 != null) {
            typing.TypedClass typedClass8 = (typing.TypedClass)tuple2._1();
            Object floatValue = tuple2._2();
            typing.TypedClass typedClass9 = this.floatClass();
            typing.TypedClass typedClass10 = typedClass8;
            if (!(typedClass9 != null ? !((Object)typedClass9).equals(typedClass10) : typedClass10 != null) && floatValue instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)floatValue);
                return (Validated)Json$.MODULE$.fromFloat(f).map((Function1 & Serializable & scala.Serializable)x$1 -> ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new StringBuilder(26).append("Could not encode ").append(f).append(" as json.").toString())));
            }
        }
        if (tuple2 != null) {
            typing.TypedClass typedClass11 = (typing.TypedClass)tuple2._1();
            Object doubleValue = tuple2._2();
            typing.TypedClass typedClass12 = this.doubleClass();
            typing.TypedClass typedClass13 = typedClass11;
            if (!(typedClass12 != null ? !((Object)typedClass12).equals(typedClass13) : typedClass13 != null) && doubleValue instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)doubleValue);
                return (Validated)Json$.MODULE$.fromDouble(d).map((Function1 & Serializable & scala.Serializable)x$2 -> ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new StringBuilder(26).append("Could not encode ").append(d).append(" as json.").toString())));
            }
        }
        if (tuple2 != null) {
            typing.TypedClass typedClass14 = (typing.TypedClass)tuple2._1();
            Object booleanValue = tuple2._2();
            typing.TypedClass typedClass15 = this.booleanClass();
            typing.TypedClass typedClass16 = typedClass14;
            if (!(typedClass15 != null ? !((Object)typedClass15).equals(typedClass16) : typedClass16 != null) && booleanValue instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)booleanValue);
                return ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)Json$.MODULE$.fromBoolean(bl)));
            }
        }
        if (tuple2 != null) {
            typing.TypedClass typedClass17 = (typing.TypedClass)tuple2._1();
            Object stringValue = tuple2._2();
            typing.TypedClass typedClass18 = this.stringClass();
            typing.TypedClass typedClass19 = typedClass17;
            if (!(typedClass18 != null ? !((Object)typedClass18).equals(typedClass19) : typedClass19 != null) && stringValue instanceof String) {
                String string = (String)stringValue;
                return ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)Json$.MODULE$.fromString(string)));
            }
        }
        if (tuple2 != null) {
            typing.TypedClass klass = (typing.TypedClass)tuple2._1();
            Object value = tuple2._2();
            Class<?> clazz = value.getClass();
            Class<?> clazz2 = klass.klass();
            if (clazz == null) {
                if (clazz2 == null) return ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new StringBuilder(23).append("No encoding logic for ").append(typ).append(".").toString()));
            } else if (clazz.equals(clazz2)) {
                return ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new StringBuilder(23).append("No encoding logic for ").append(typ).append(".").toString()));
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        typing.TypedClass klass = (typing.TypedClass)tuple2._1();
        Object value = tuple2._2();
        return ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new StringBuilder(33).append("Mismatched class and value: ").append(klass).append(" and ").append(value).toString()));
    }

    public Either<DecodingFailure, Object> decode(typing.TypedClass typ, ACursor obj) {
        Object object;
        typing.TypedClass typedClass2 = typ;
        typing.TypedClass typedClass3 = this.intClass();
        typing.TypedClass typedClass4 = typedClass2;
        if (!(typedClass3 != null ? !((Object)typedClass3).equals(typedClass4) : typedClass4 != null)) {
            object = obj.as(Decoder$.MODULE$.decodeInt());
        } else {
            typing.TypedClass typedClass5 = this.longClass();
            typing.TypedClass typedClass6 = typedClass2;
            if (!(typedClass5 != null ? !((Object)typedClass5).equals(typedClass6) : typedClass6 != null)) {
                object = obj.as(Decoder$.MODULE$.decodeLong());
            } else {
                typing.TypedClass typedClass7 = this.floatClass();
                typing.TypedClass typedClass8 = typedClass2;
                if (!(typedClass7 != null ? !((Object)typedClass7).equals(typedClass8) : typedClass8 != null)) {
                    object = obj.as(Decoder$.MODULE$.decodeFloat());
                } else {
                    typing.TypedClass typedClass9 = this.doubleClass();
                    typing.TypedClass typedClass10 = typedClass2;
                    if (!(typedClass9 != null ? !((Object)typedClass9).equals(typedClass10) : typedClass10 != null)) {
                        object = obj.as(Decoder$.MODULE$.decodeDouble());
                    } else {
                        typing.TypedClass typedClass11 = this.booleanClass();
                        typing.TypedClass typedClass12 = typedClass2;
                        if (!(typedClass11 != null ? !((Object)typedClass11).equals(typedClass12) : typedClass12 != null)) {
                            object = obj.as(Decoder$.MODULE$.decodeBoolean());
                        } else {
                            typing.TypedClass typedClass13 = this.stringClass();
                            typing.TypedClass typedClass14 = typedClass2;
                            object = !(typedClass13 != null ? !((Object)typedClass13).equals(typedClass14) : typedClass14 != null) ? obj.as(Decoder$.MODULE$.decodeString()) : package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply(new StringBuilder(23).append("No decoding logic for ").append(typedClass2).append(".").toString(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
                        }
                    }
                }
            }
        }
        return object;
    }

    private SimpleObjectEncoder$() {
        MODULE$ = this;
        this.intClass = typing$Typed$.MODULE$.typedClass(ClassTag$.MODULE$.Int());
        this.longClass = typing$Typed$.MODULE$.typedClass(ClassTag$.MODULE$.Long());
        this.floatClass = typing$Typed$.MODULE$.typedClass(ClassTag$.MODULE$.Float());
        this.doubleClass = typing$Typed$.MODULE$.typedClass(ClassTag$.MODULE$.Double());
        this.booleanClass = typing$Typed$.MODULE$.typedClass(ClassTag$.MODULE$.Boolean());
        this.stringClass = typing$Typed$.MODULE$.typedClass(ClassTag$.MODULE$.apply(String.class));
    }
}

