/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.api.context;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import java.io.Serializable;
import pl.touk.nussknacker.engine.api.NodeId;
import pl.touk.nussknacker.engine.api.context.ContextTransformation;
import pl.touk.nussknacker.engine.api.context.ContextTransformationDef;
import pl.touk.nussknacker.engine.api.context.ProcessCompilationError;
import pl.touk.nussknacker.engine.api.context.ProcessCompilationError$CustomNodeError$;
import pl.touk.nussknacker.engine.api.context.ValidationContext;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class ContextTransformation$
implements Serializable {
    public static final ContextTransformation$ MODULE$ = new ContextTransformation$();

    public String sanitizeBranchName(String branchId) {
        return Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.collect$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.charArrayOps(branchId.toCharArray()))), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                char a;
                char a2;
                A1 A1 = x1;
                if (A1 != null) {
                    char a3 = A1._1$mcC$sp();
                    int n = A1._2$mcI$sp();
                    if (0 == n && Character.isJavaIdentifierStart(a3)) {
                        return (B1)BoxesRunTime.boxToCharacter((char)a3);
                    }
                }
                if (A1 != null) {
                    char a4 = A1._1$mcC$sp();
                    int n = A1._2$mcI$sp();
                    if (0 == n && !Character.isJavaIdentifierStart(a4)) {
                        return (B1)"_";
                    }
                }
                if (A1 != null && Character.isJavaIdentifierPart(a2 = A1._1$mcC$sp())) {
                    return (B1)BoxesRunTime.boxToCharacter((char)a2);
                }
                if (A1 != null && !Character.isJavaIdentifierPart(a = A1._1$mcC$sp())) {
                    return (B1)"_";
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                char a;
                char a2;
                Tuple2<Object, Object> tuple2 = x1;
                if (tuple2 != null) {
                    char a3 = tuple2._1$mcC$sp();
                    int n = tuple2._2$mcI$sp();
                    if (0 == n && Character.isJavaIdentifierStart(a3)) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    char a4 = tuple2._1$mcC$sp();
                    int n = tuple2._2$mcI$sp();
                    if (0 == n && !Character.isJavaIdentifierStart(a4)) {
                        return true;
                    }
                }
                if (tuple2 != null && Character.isJavaIdentifierPart(a2 = tuple2._1$mcC$sp())) {
                    return true;
                }
                return tuple2 != null && !Character.isJavaIdentifierPart(a = tuple2._1$mcC$sp());
            }
        }, ClassTag$.MODULE$.Any())).mkString();
    }

    public List<ProcessCompilationError> checkNotAllowedNodeNames(List<String> nodeIds, Set<String> notAllowedNames, NodeId nodeId) {
        Set sanitizedNotAllowedNames = (Set)notAllowedNames.map((Function1 & Serializable)branchId -> MODULE$.sanitizeBranchName((String)branchId));
        return nodeIds.flatMap((Function1 & Serializable)x -> {
            if (sanitizedNotAllowedNames.contains((Object)MODULE$.sanitizeBranchName((String)x))) {
                return new .colon.colon((Object)ProcessCompilationError$CustomNodeError$.MODULE$.apply("Input node can not be named \"" + x + "\"", (Option<String>)None$.MODULE$, nodeId), (List)Nil$.MODULE$);
            }
            return Nil$.MODULE$;
        });
    }

    public List<ProcessCompilationError> checkIdenticalSanitizedNodeNames(List<String> nodeIds, NodeId nodeId) {
        return ((IterableOnceOps)nodeIds.groupBy((Function1 & Serializable)branchId -> MODULE$.sanitizeBranchName((String)branchId)).flatMap((Function1 & Serializable)x0$1 -> {
            List values;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && (values = (List)tuple2._2()).size() >= 2) {
                String namesList = values.map((Function1 & Serializable)x$1 -> "\"" + x$1 + "\"").mkString(", ");
                return new .colon.colon((Object)ProcessCompilationError$CustomNodeError$.MODULE$.apply("Nodes " + namesList + " have too similar names", (Option<String>)None$.MODULE$, nodeId), (List)Nil$.MODULE$);
            }
            return Nil$.MODULE$;
        })).toList();
    }

    public Validated<NonEmptyList<ProcessCompilationError>, Option<ValidationContext>> findUniqueParentContext(Map<String, ValidationContext> contextMap, NodeId nodeId) {
        List list = (List)((IterableOnceOps)contextMap.values().map((Function1 & Serializable)x$2 -> x$2.parent())).toList().distinct();
        if (Nil$.MODULE$.equals(list)) {
            return new Validated.Valid((Object)None$.MODULE$);
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Option a = (Option)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return new Validated.Valid((Object)a);
            }
        }
        return new Validated.Invalid((Object)NonEmptyList$.MODULE$.of((Object)new ProcessCompilationError.CustomNodeError(nodeId.id(), "Not consistent parent contexts: " + list, (Option<String>)None$.MODULE$), (Seq)Nil$.MODULE$));
    }

    public ContextTransformation.JoinBuilder join() {
        return new ContextTransformation.JoinBuilder();
    }

    public ContextTransformation.DefinedByBuilder definedBy(ContextTransformationDef definition) {
        return new ContextTransformation.DefinedByBuilder(definition);
    }

    public ContextTransformation.DefinedByBuilder definedBy(Function1<ValidationContext, Validated<NonEmptyList<ProcessCompilationError>, ValidationContext>> transformContext) {
        return new ContextTransformation.DefinedByBuilder(new ContextTransformationDef(transformContext){
            private final Function1 transformContext$1;

            public ContextTransformationDef andThen(ContextTransformationDef nextTransformation) {
                return ContextTransformationDef.andThen$(this, nextTransformation);
            }

            public Validated<NonEmptyList<ProcessCompilationError>, ValidationContext> transform(ValidationContext context) {
                return (Validated)this.transformContext$1.apply((Object)context);
            }
            {
                this.transformContext$1 = transformContext$1;
                ContextTransformationDef.$init$(this);
            }
        });
    }

    public ContextTransformation apply(ContextTransformationDef definition, Object implementation) {
        return new ContextTransformation(definition, implementation);
    }

    public Option<Tuple2<ContextTransformationDef, Object>> unapply(ContextTransformation x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.definition(), x$0.implementation()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ContextTransformation$.class);
    }

    private ContextTransformation$() {
    }
}

