/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.api.definition;

import cats.data.Validated;
import cats.data.Validated$;
import java.io.Serializable;
import java.util.regex.Pattern;
import pl.touk.nussknacker.engine.api.NodeId;
import pl.touk.nussknacker.engine.api.context.PartSubGraphCompilationError;
import pl.touk.nussknacker.engine.api.context.ProcessCompilationError;
import pl.touk.nussknacker.engine.api.definition.ParameterValidator;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class NotBlankParameterValidator$
implements ParameterValidator,
Product,
Serializable {
    public static final NotBlankParameterValidator$ MODULE$ = new NotBlankParameterValidator$();
    private static Pattern blankStringLiteralPattern;
    private static volatile boolean bitmap$0;

    static {
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    private Pattern blankStringLiteralPattern$lzycompute() {
        NotBlankParameterValidator$ notBlankParameterValidator$ = this;
        synchronized (notBlankParameterValidator$) {
            if (!bitmap$0) {
                blankStringLiteralPattern = Pattern.compile("['\"]\\s*['\"]");
                bitmap$0 = true;
            }
        }
        return blankStringLiteralPattern;
    }

    private final Pattern blankStringLiteralPattern() {
        if (!bitmap$0) {
            return this.blankStringLiteralPattern$lzycompute();
        }
        return blankStringLiteralPattern;
    }

    @Override
    public Validated<PartSubGraphCompilationError, BoxedUnit> isValid(String paramName, String expression, Option<String> label, NodeId nodeId) {
        if (this.isBlankStringLiteral(expression)) {
            return Validated$.MODULE$.invalid((Object)this.error(paramName, nodeId.id()));
        }
        return Validated$.MODULE$.valid((Object)BoxedUnit.UNIT);
    }

    private ProcessCompilationError.BlankParameter error(String paramName, String nodeId) {
        return new ProcessCompilationError.BlankParameter("This field value is required and can not be blank", "Please fill field value for this parameter", paramName, nodeId);
    }

    private boolean isBlankStringLiteral(String expression) {
        return this.blankStringLiteralPattern().matcher(expression.trim()).matches();
    }

    public String productPrefix() {
        return "NotBlankParameterValidator";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NotBlankParameterValidator$;
    }

    public int hashCode() {
        return 833483242;
    }

    public String toString() {
        return "NotBlankParameterValidator";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NotBlankParameterValidator$.class);
    }

    private NotBlankParameterValidator$() {
    }
}

