/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.util.functions;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import pl.touk.nussknacker.engine.api.Documentation;
import pl.touk.nussknacker.engine.api.HideToString;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001\u0002\r\u001a\u0001\u0019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006w\u0001!\t\u0001\u0010\u0005\u0006\u0001\u0002!\t!\u0011\u0005\u0006=\u0002!\ta\u0018\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006a\u0002!\t!\u001d\u0005\u0006s\u0002!\tA\u001f\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011\u0019\u0001\u0005\u0001\"\u0001\u0002\u0018!1a\f\u0001C\u0001\u0003KAaa\u001a\u0001\u0005\u0002\u0005E\u0002BB=\u0001\t\u0003\ti\u0004C\u0004\u0002\u0006\u0001!\t!!\u0013\t\r\u0001\u0003A\u0011AA+\u0011\u0019q\u0006\u0001\"\u0001\u0002l!1q\r\u0001C\u0001\u0003oBa!\u001f\u0001\u0005\u0002\u0005\r\u0005bBA\u0003\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003;\u0001A\u0011AAN\u0011\u001d\t\t\f\u0001C\u0001\u0003gCq!!-\u0001\t\u0003\ty\fC\u0004\u0002N\u0002!\t!a4\t\u000f\u00055\u0007\u0001\"\u0001\u0002Z\nyA)\u0019;f\r>\u0014X.\u0019;Vi&d7O\u0003\u0002\u001b7\u0005Ia-\u001e8di&|gn\u001d\u0006\u00039u\tA!\u001e;jY*\u0011adH\u0001\u0007K:<\u0017N\\3\u000b\u0005\u0001\n\u0013a\u00038vgN\\g.Y2lKJT!AI\u0012\u0002\tQ|Wo\u001b\u0006\u0002I\u0005\u0011\u0001\u000f\\\u0002\u0001'\r\u0001qe\f\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\nA\u0001\\1oO*\tA&\u0001\u0003kCZ\f\u0017B\u0001\u0018*\u0005\u0019y%M[3diB\u0011\u0001gM\u0007\u0002c)\u0011!'H\u0001\u0004CBL\u0017B\u0001\u001b2\u00051A\u0015\u000eZ3U_N#(/\u001b8h\u00035!WMZ1vYRdunY1mKB\u0011q'O\u0007\u0002q)\u0011AdK\u0005\u0003ua\u0012a\u0001T8dC2,\u0017A\u0002\u001fj]&$h\b\u0006\u0002>\u007fA\u0011a\bA\u0007\u00023!)QG\u0001a\u0001m\u0005q\u0001/\u0019:tK2{7-\u00197US6,GC\u0001\"I!\t\u0019e)D\u0001E\u0015\t)5&\u0001\u0003uS6,\u0017BA$E\u0005%aunY1m)&lW\rC\u0003J\u0007\u0001\u0007!*\u0001\u0003uKb$\bCA&U\u001d\ta%\u000b\u0005\u0002N!6\taJ\u0003\u0002PK\u00051AH]8pizR\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u000ba\u0001\u0015:fI\u00164\u0017BA+W\u0005\u0019\u0019FO]5oO*\u00111\u000b\u0015\u0015\u0005\u0007a[F\f\u0005\u000213&\u0011!,\r\u0002\u000e\t>\u001cW/\\3oi\u0006$\u0018n\u001c8\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0002;\u0006i\u0004+\u0019:tK\u0002bunY1m)&lW\rI5oA%\u001bv*\f\u001d7aE\u0002cm\u001c:nCR\u0004SML4/A\u001d\n\u0004GO\u00196O\u0001z'\u000fI\u00142ai\nTGO\u001a1O\u0005q\u0001/\u0019:tK2{7-\u00197ECR,GC\u00011d!\t\u0019\u0015-\u0003\u0002c\t\nIAj\\2bY\u0012\u000bG/\u001a\u0005\u0006\u0013\u0012\u0001\rA\u0013\u0015\u0005\ta[V-I\u0001g\u0003Q\u0002\u0016M]:fA1{7-\u00197ECR,\u0007%\u001b8!\u0013N{U\u0006\u000f\u001c1c\u00012wN]7bi\u0002*gf\u001a\u0018!OI\u0002\u0014'M\u00172e5\u00024gJ\u0001\u0013a\u0006\u00148/\u001a'pG\u0006dG)\u0019;f)&lW\r\u0006\u0002jYB\u00111I[\u0005\u0003W\u0012\u0013Q\u0002T8dC2$\u0015\r^3US6,\u0007\"B%\u0006\u0001\u0004Q\u0005\u0006B\u0003Y7:\f\u0013a\\\u0001B!\u0006\u00148/\u001a\u0011M_\u000e\fG\u000eR1uKRKW.\u001a\u0011j]\u0002J5kT\u00179mA\n\u0004EZ8s[\u0006$\b%\u001a\u0018h]\u0001:#\u0007M\u00192[E\u0012T\u0006M\u001aUcAR\u0014'\u000e\u001e4a\u001d\nA\u0002]1sg\u0016Len\u001d;b]R$\"A];\u0011\u0005\r\u001b\u0018B\u0001;E\u0005\u001dIen\u001d;b]RDQ!\u0013\u0004A\u0002)CCA\u0002-\\o\u0006\n\u00010\u0001\u001fQCJ\u001cX\rI%ogR\fg\u000e\u001e\u0011j]\u0002J5kT\u00179mA\n\u0004EZ8s[\u0006$\b%\u001a\u0018h]\u0001:#\u0007M\u00192[E\u0012T\u0006M\u001aUcAR\u0014'\u000e\u001e4ai;\u0013a\u00059beN,wJ\u001a4tKR$\u0015\r^3US6,GCA>\u007f!\t\u0019E0\u0003\u0002~\t\nqqJ\u001a4tKR$\u0015\r^3US6,\u0007\"B%\b\u0001\u0004Q\u0005&B\u0004Y7\u0006\u0005\u0011EAA\u0002\u0003!\u0003\u0016M]:fA=3gm]3u\t\u0006$X\rV5nK\u0002Jg\u000eI%T\u001f6Bd\u0007M\u0019!M>\u0014X.\u0019;!K::g\u0006I\u00143aE\nT&\r\u001a.aM\"\u0016\u0007\r\u001e2ki\u001a\u0004g\u000b\u00192uA\u0002t%\u0001\nqCJ\u001cXMW8oK\u0012$\u0015\r^3US6,G\u0003BA\u0005\u0003\u001f\u00012aQA\u0006\u0013\r\ti\u0001\u0012\u0002\u000e5>tW\r\u001a#bi\u0016$\u0016.\\3\t\u000b%C\u0001\u0019\u0001&)\u000b!A6,a\u0005\"\u0005\u0005U\u0011!\u0016)beN,\u0007EW8oK\u0012$\u0015\r^3US6,\u0007%\u001b8!\u0013N{U\u0006\u000f\u001c1c\u00012wN]7bi\u0002*gf\u001a\u0018!OI\u0002\u0014'M\u00172e5\u00024\u0007V\u00191uE*$h\r\u0019,aER\u0004\u0007M.FkJ|\u0007/Z\u0018QCJL7/X\u0014\u0015\u000b\t\u000bI\"a\u0007\t\u000b%K\u0001\u0019\u0001&\t\r\u0005u\u0011\u00021\u0001K\u0003\u00191wN]7bi\"*\u0011\u0002W.\u0002\"\u0005\u0012\u00111E\u0001,!\u0006\u00148/\u001a\u0011M_\u000e\fG\u000eV5nK\u0002Jg\u000e\t#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\u00022wN]7biR)\u0001-a\n\u0002*!)\u0011J\u0003a\u0001\u0015\"1\u0011Q\u0004\u0006A\u0002)CSA\u0003-\\\u0003[\t#!a\f\u0002WA\u000b'o]3!\u0019>\u001c\u0017\r\u001c#bi\u0016\u0004\u0013N\u001c\u0011ECR,G+[7f\r>\u0014X.\u0019;uKJ\u0004cm\u001c:nCR$R![A\u001a\u0003kAQ!S\u0006A\u0002)Ca!!\b\f\u0001\u0004Q\u0005&B\u0006Y7\u0006e\u0012EAA\u001e\u0003=\u0002\u0016M]:fA1{7-\u00197ECR,G+[7fA%t\u0007\u0005R1uKRKW.\u001a$pe6\fG\u000f^3sA\u0019|'/\\1u)\u0015Y\u0018qHA!\u0011\u0015IE\u00021\u0001K\u0011\u0019\ti\u0002\u0004a\u0001\u0015\"*A\u0002W.\u0002F\u0005\u0012\u0011qI\u00011!\u0006\u00148/\u001a\u0011PM\u001a\u001cX\r\u001e#bi\u0016$\u0016.\\3!S:\u0004C)\u0019;f)&lWMR8s[\u0006$H/\u001a:!M>\u0014X.\u0019;\u0015\r\u0005%\u00111JA'\u0011\u0015IU\u00021\u0001K\u0011\u0019\ti\"\u0004a\u0001\u0015\"*Q\u0002W.\u0002R\u0005\u0012\u00111K\u00010!\u0006\u00148/\u001a\u0011[_:,G\rR1uKRKW.\u001a\u0011j]\u0002\"\u0015\r^3US6,gi\u001c:nCR$XM\u001d\u0011g_Jl\u0017\r\u001e\u000b\u0006\u0005\u0006]\u0013\u0011\f\u0005\u0006\u0013:\u0001\rA\u0013\u0005\b\u0003;q\u0001\u0019AA.!\u0011\ti&!\u0019\u000e\u0005\u0005}#bAA\u000f\t&!\u00111MA0\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM\u001d\u0015\u0006\u001da[\u0016qM\u0011\u0003\u0003S\nQ\u0005U1sg\u0016\u0004Cj\\2bYRKW.\u001a\u0011vg&tw\rI4jm\u0016t\u0007EZ8s[\u0006$H/\u001a:\u0015\u000b\u0001\fi'a\u001c\t\u000b%{\u0001\u0019\u0001&\t\u000f\u0005uq\u00021\u0001\u0002\\!*q\u0002W.\u0002t\u0005\u0012\u0011QO\u0001&!\u0006\u00148/\u001a\u0011M_\u000e\fG\u000eR1uK\u0002*8/\u001b8hA\u001dLg/\u001a8!M>\u0014X.\u0019;uKJ$R![A=\u0003wBQ!\u0013\tA\u0002)Cq!!\b\u0011\u0001\u0004\tY\u0006K\u0003\u00111n\u000by(\t\u0002\u0002\u0002\u0006I\u0003+\u0019:tK\u0002bunY1m\t\u0006$X\rV5nK\u0002*8/\u001b8hA\u001dLg/\u001a8!M>\u0014X.\u0019;uKJ$Ra_AC\u0003\u000fCQ!S\tA\u0002)Cq!!\b\u0012\u0001\u0004\tY\u0006K\u0003\u00121n\u000bY)\t\u0002\u0002\u000e\u0006Q\u0003+\u0019:tK\u0002zeMZ:fi\u0012\u000bG/\u001a+j[\u0016\u0004So]5oO\u0002:\u0017N^3oA\u0019|'/\\1ui\u0016\u0014HCBA\u0005\u0003#\u000b\u0019\nC\u0003J%\u0001\u0007!\nC\u0004\u0002\u001eI\u0001\r!a\u0017)\u000bIA6,a&\"\u0005\u0005e\u0015!\u000b)beN,\u0007EW8oK\u0012$\u0015\r^3US6,\u0007%^:j]\u001e\u0004s-\u001b<f]\u00022wN]7biR,'\u000fF\u0002K\u0003;Cq!a(\u0014\u0001\u0004\t\t+\u0001\u0005uK6\u0004xN]1m!\u0011\t\u0019+a*\u000e\u0005\u0005\u0015&bAAP\t&!\u0011\u0011VAS\u0005A!V-\u001c9pe\u0006d\u0017iY2fgN|'\u000fK\u0003\u00141n\u000bi+\t\u0002\u00020\u0006q&+\u001a8eKJ\u0004Cj\\2bYRKW.\u001a\u0017!\u0019>\u001c\u0017\r\u001c#bi\u0016d\u0003\u0005T8dC2$\u0015\r^3US6,G\u0006I(gMN,G\u000fR1uKRKW.\u001a\u0011pe\u0002RvN\\3e\t\u0006$X\rV5nK\u0002Jg\u000eI%T\u001f6Bd\u0007M\u0019!M>\u0014X.\u0019;\u0002\u0013\u0019|'/\\1ui\u0016\u0014H\u0003BA.\u0003kCa!a.\u0015\u0001\u0004Q\u0015a\u00029biR,'O\u001c\u0015\u0006)a[\u00161X\u0011\u0003\u0003{\u000bQf\u0011:fCR,7\u000f\t#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\u0002*8/\u001b8hA\u001dLg/\u001a8!a\u0006$H/\u001a:o)\u0019\tY&!1\u0002D\"1\u0011qW\u000bA\u0002)Ca!!2\u0016\u0001\u00041\u0014A\u00027pG\u0006dW\rK\u0003\u00161n\u000bI-\t\u0002\u0002L\u0006A4I]3bi\u0016\u001c\b\u0005R1uKRKW.\u001a$pe6\fG\u000f^3sAU\u001c\u0018N\\4!O&4XM\u001c\u0011qCR$XM\u001d8!C:$\u0007\u0005\\8dC2,\u0017\u0001\u00057f]&,g\u000e\u001e$pe6\fG\u000f^3s)\u0011\tY&!5\t\r\u0005]f\u00031\u0001KQ\u00151\u0002lWAkC\t\t9.\u0001!De\u0016\fG/Z:!Y\u0016t\u0017.\u001a8uAY,'o]5p]\u0002zg\r\t#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\u0002*8/\u001b8hA\u001dLg/\u001a8!a\u0006$H/\u001a:o)\u0019\tY&a7\u0002^\"1\u0011qW\fA\u0002)Ca!!2\u0018\u0001\u00041\u0004&B\fY7\u0006\u0005\u0018EAAr\u0003-\u001b%/Z1uKN\u0004C.\u001a8jK:$\bE^3sg&|g\u000eI8gA\u0011\u000bG/\u001a+j[\u00164uN]7biR,'\u000fI;tS:<\u0007eZ5wK:\u0004\u0003/\u0019;uKJt\u0007%\u00198eA1|7-\u00197f\u0001")
public class DateFormatUtils
implements HideToString {
    private final Locale defaultLocale;

    @Documentation(description="Parse LocalTime in ISO-8601 format e.g. '10:15' or '10:15:30'")
    public LocalTime parseLocalTime(String text) {
        return LocalTime.parse(text);
    }

    @Documentation(description="Parse LocalDate in ISO-8601 format e.g. '2011-12-03'")
    public LocalDate parseLocalDate(String text) {
        return LocalDate.parse(text);
    }

    @Documentation(description="Parse LocalDateTime in ISO-8601 format e.g. '2011-12-03T10:15:30'")
    public LocalDateTime parseLocalDateTime(String text) {
        return LocalDateTime.parse(text);
    }

    @Documentation(description="Parse Instant in ISO-8601 format e.g. '2011-12-03T10:15:30Z'")
    public Instant parseInstant(String text) {
        return Instant.parse(text);
    }

    @Documentation(description="Parse OffsetDateTime in ISO-8601 format e.g. '2011-12-03T10:15:30+01:00'")
    public OffsetDateTime parseOffsetDateTime(String text) {
        return OffsetDateTime.parse(text);
    }

    @Documentation(description="Parse ZonedDateTime in ISO-8601 format e.g. '2011-12-03T10:15:30+01:00[Europe/Paris]'")
    public ZonedDateTime parseZonedDateTime(String text) {
        return ZonedDateTime.parse(text);
    }

    @Documentation(description="Parse LocalTime in DateTimeFormatter format")
    public LocalTime parseLocalTime(String text, String format) {
        return LocalTime.parse(text, DateTimeFormatter.ofPattern(format, this.defaultLocale));
    }

    @Documentation(description="Parse LocalDate in DateTimeFormatter format")
    public LocalDate parseLocalDate(String text, String format) {
        return LocalDate.parse(text, DateTimeFormatter.ofPattern(format, this.defaultLocale));
    }

    @Documentation(description="Parse LocalDateTime in DateTimeFormatter format")
    public LocalDateTime parseLocalDateTime(String text, String format) {
        return LocalDateTime.parse(text, DateTimeFormatter.ofPattern(format, this.defaultLocale));
    }

    @Documentation(description="Parse OffsetDateTime in DateTimeFormatter format")
    public OffsetDateTime parseOffsetDateTime(String text, String format) {
        return OffsetDateTime.parse(text, DateTimeFormatter.ofPattern(format, this.defaultLocale));
    }

    @Documentation(description="Parse ZonedDateTime in DateTimeFormatter format")
    public ZonedDateTime parseZonedDateTime(String text, String format) {
        return ZonedDateTime.parse(text, DateTimeFormatter.ofPattern(format, this.defaultLocale));
    }

    @Documentation(description="Parse LocalTime using given formatter")
    public LocalTime parseLocalTime(String text, DateTimeFormatter format) {
        return LocalTime.parse(text, format);
    }

    @Documentation(description="Parse LocalDate using given formatter")
    public LocalDate parseLocalDate(String text, DateTimeFormatter format) {
        return LocalDate.parse(text, format);
    }

    @Documentation(description="Parse LocalDateTime using given formatter")
    public LocalDateTime parseLocalDateTime(String text, DateTimeFormatter format) {
        return LocalDateTime.parse(text, format);
    }

    @Documentation(description="Parse OffsetDateTime using given formatter")
    public OffsetDateTime parseOffsetDateTime(String text, DateTimeFormatter format) {
        return OffsetDateTime.parse(text, format);
    }

    @Documentation(description="Parse ZonedDateTime using given formatter")
    public ZonedDateTime parseZonedDateTime(String text, DateTimeFormatter format) {
        return ZonedDateTime.parse(text, format);
    }

    @Documentation(description="Render LocalTime, LocalDate, LocalDateTime, OffsetDateTime or ZonedDateTime in ISO-8601 format")
    public String format(TemporalAccessor temporal) {
        DateTimeFormatter dateTimeFormatter;
        TemporalAccessor temporalAccessor = temporal;
        if (temporalAccessor instanceof Instant) {
            dateTimeFormatter = DateTimeFormatter.ISO_INSTANT;
        } else if (temporalAccessor instanceof LocalDate) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE;
        } else if (temporalAccessor instanceof LocalTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_TIME;
        } else if (temporalAccessor instanceof LocalDateTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        } else if (temporalAccessor instanceof OffsetDateTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        } else if (temporalAccessor instanceof ZonedDateTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_ZONED_DATE_TIME;
        } else {
            throw new MatchError((Object)temporalAccessor);
        }
        DateTimeFormatter formatter = dateTimeFormatter;
        return formatter.format(temporal);
    }

    @Documentation(description="Creates DateTimeFormatter using given pattern")
    public DateTimeFormatter formatter(String pattern) {
        return this.formatter(pattern, this.defaultLocale);
    }

    @Documentation(description="Creates DateTimeFormatter using given pattern and locale")
    public DateTimeFormatter formatter(String pattern, Locale locale) {
        return DateTimeFormatter.ofPattern(pattern, locale);
    }

    @Documentation(description="Creates lenient version of DateTimeFormatter using given pattern")
    public DateTimeFormatter lenientFormatter(String pattern) {
        return this.lenientFormatter(pattern, this.defaultLocale);
    }

    @Documentation(description="Creates lenient version of DateTimeFormatter using given pattern and locale")
    public DateTimeFormatter lenientFormatter(String pattern, Locale locale) {
        return new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(pattern).toFormatter(locale);
    }

    public DateFormatUtils(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }
}

