/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.util.functions;

import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import pl.touk.nussknacker.engine.api.Documentation;
import pl.touk.nussknacker.engine.api.HideToString;
import pl.touk.nussknacker.engine.util.functions.DateConstants;
import pl.touk.nussknacker.engine.util.functions.DateConversions;
import pl.touk.nussknacker.engine.util.functions.DateRangeChecker;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001\u0002\u0006\f\u0001aA\u0001b\f\u0001\u0003\u0006\u0004%\t\u0006\r\u0005\ts\u0001\u0011\t\u0011)A\u0005c!)!\b\u0001C\u0001w!)a\b\u0001C\u0001\u007f!)!\n\u0001C\u0001\u0017\")q\u000b\u0001C\u00011\")A\r\u0001C\u0001K\")\u0011\u000e\u0001C\u0001U\")Q\f\u0001C\u0001u\nIA)\u0019;f+RLGn\u001d\u0006\u0003\u00195\t\u0011BZ;oGRLwN\\:\u000b\u00059y\u0011\u0001B;uS2T!\u0001E\t\u0002\r\u0015tw-\u001b8f\u0015\t\u00112#A\u0006okN\u001c8N\\1dW\u0016\u0014(B\u0001\u000b\u0016\u0003\u0011!x.^6\u000b\u0003Y\t!\u0001\u001d7\u0004\u0001M1\u0001!G\u0010$M%\u0002\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011\"\u001b\u0005Y\u0011B\u0001\u0012\f\u0005=!\u0015\r^3D_:4XM]:j_:\u001c\bC\u0001\u0011%\u0013\t)3BA\u0007ECR,7i\u001c8ti\u0006tGo\u001d\t\u0003A\u001dJ!\u0001K\u0006\u0003!\u0011\u000bG/\u001a*b]\u001e,7\t[3dW\u0016\u0014\bC\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0010\u0003\r\t\u0007/[\u0005\u0003]-\u0012A\u0002S5eKR{7\u000b\u001e:j]\u001e\fQa\u00197pG.,\u0012!\r\t\u0003e]j\u0011a\r\u0006\u0003iU\nA\u0001^5nK*\ta'\u0001\u0003kCZ\f\u0017B\u0001\u001d4\u0005\u0015\u0019En\\2l\u0003\u0019\u0019Gn\\2lA\u00051A(\u001b8jiz\"\"\u0001P\u001f\u0011\u0005\u0001\u0002\u0001\"B\u0018\u0004\u0001\u0004\t\u0014a\u00018poR\t\u0001\t\u0005\u00023\u0003&\u0011!i\r\u0002\b\u0013:\u001cH/\u00198uQ\u0011!Ai\u0012%\u0011\u0005)*\u0015B\u0001$,\u00055!unY;nK:$\u0018\r^5p]\u0006YA-Z:de&\u0004H/[8oC\u0005I\u0015A\t*fiV\u0014hn\u001d\u0011dkJ\u0014XM\u001c;!i&lW\rI1tA\u0005t\u0007%\u00138ti\u0006tG/A\u0005o_^\fEOW8oKR\u0011Aj\u0014\t\u0003e5K!AT\u001a\u0003\u001bi{g.\u001a3ECR,G+[7f\u0011\u0015\u0001V\u00011\u0001R\u0003\u0019QxN\\3JIB\u0011!GU\u0005\u0003'N\u0012aAW8oK&#\u0007\u0006B\u0003E\u000fV\u000b\u0013AV\u0001;%\u0016$XO\u001d8tA\r,(O]3oi\u0002\"\u0018.\\3!CR\u0004s-\u001b<f]\u0002\"\u0018.\\3!u>tW\rI1tA\u0005\u0004#l\u001c8fI\u0012\u000bG/\u001a+j[\u0016\f1B\\8x\u0003R|eMZ:fiR\u0011\u0011\f\u0018\t\u0003eiK!aW\u001a\u0003\u001d=3gm]3u\t\u0006$X\rV5nK\")QL\u0002a\u0001=\u0006Q!p\u001c8f\u001f\u001a47/\u001a;\u0011\u0005Iz\u0016B\u000114\u0005)QvN\\3PM\u001a\u001cX\r\u001e\u0015\u0005\r\u0011;%-I\u0001d\u0003\u0015\u0013V\r^;s]N\u00043-\u001e:sK:$\b\u0005^5nK\u0002:\u0018\u000e\u001e5!O&4XM\u001c\u0011uS6,\u0007E_8oK\u0002zgMZ:fi\u0002\n7\u000fI1oA=3gm]3u\t\u0006$X\rV5nK\u0006!bn\\<Bi\u0012+g-Y;miRKW.\u001a.p]\u0016$\u0012\u0001\u0014\u0015\u0005\u000f\u0011;u-I\u0001i\u0003q\u0012V\r^;s]N\u00043-\u001e:sK:$\b\u0005^5nK\u0002\nG\u000f\t3fM\u0006,H\u000e\u001e\u0011uS6,\u0007E_8oK\u0002\n7\u000fI1!5>tW\r\u001a#bi\u0016$\u0016.\\3\u0002\ti|g.\u001a\u000b\u0003#.DQ\u0001\u0015\u0005A\u00021\u0004\"!\u001c;\u000f\u00059\u0014\bCA8\u001c\u001b\u0005\u0001(BA9\u0018\u0003\u0019a$o\\8u}%\u00111oG\u0001\u0007!J,G-\u001a4\n\u0005U4(AB*ue&twM\u0003\u0002t7!\"\u0001\u0002R$yC\u0005I\u0018a\u000e*fiV\u0014hn\u001d\u0011uS6,\u0007E_8oK\u0002:\u0018\u000e\u001e5!O&4XM\u001c\u0011{_:,\u0007%\u001b3!K::g\u0006I#ve>\u0004XmL,beN\fw\u000f\u0006\u0002_w\")A0\u0003a\u0001Y\u0006AqN\u001a4tKRLE\r\u000b\u0003\n\t\u001es\u0018%A@\u0002sI+G/\u001e:og\u0002RxN\\3!_\u001a47/\u001a;!o&$\b\u000eI4jm\u0016t\u0007E_8oK\u0002zgMZ:fi\u0002JG\rI3/O:\u00023\u0006M\u0019;aA\u0002")
public class DateUtils
implements DateConversions,
DateConstants,
DateRangeChecker,
HideToString {
    private final Clock clock;

    @Override
    @Documentation(description="Computes Period between two dates: start date inclusive and end date exclusive")
    public Period periodBetween(LocalDate startDateInclusive, LocalDate endDateExclusive) {
        return DateRangeChecker.periodBetween$((DateRangeChecker)this, startDateInclusive, endDateExclusive);
    }

    @Override
    @Documentation(description="Computes Period between two dates: start date inclusive and end date exclusive")
    public Period periodBetween(ZonedDateTime startDateInclusive, ZonedDateTime endDateExclusive) {
        return DateRangeChecker.periodBetween$((DateRangeChecker)this, startDateInclusive, endDateExclusive);
    }

    @Override
    @Documentation(description="Computes Period between two dates: start date inclusive and end date exclusive")
    public Period periodBetween(OffsetDateTime startDateInclusive, OffsetDateTime endDateExclusive) {
        return DateRangeChecker.periodBetween$((DateRangeChecker)this, startDateInclusive, endDateExclusive);
    }

    @Override
    @Documentation(description="Computes Duration between two dates: start date inclusive and end date exclusive")
    public Duration durationBetween(Temporal startDateInclusive, Temporal endDateExclusive) {
        return DateRangeChecker.durationBetween$(this, startDateInclusive, endDateExclusive);
    }

    @Override
    @Documentation(description="Checks if time is in range <fromInclusive, toInclusive>. if to < from, then checks if time is in one of ranges <from, 24:00> and <00:00, to>")
    public boolean isBetween(LocalTime time, LocalTime fromInclusive, LocalTime toInclusive) {
        return DateRangeChecker.isBetween$((DateRangeChecker)this, time, fromInclusive, toInclusive);
    }

    @Override
    @Documentation(description="Checks if day of week is in range <fromInclusive, toInclusive>. if to < from in ISO standard (numerous from MONDAY), then checks if day of week is in one of ranges <from, SUNDAY> and <MONDAY, to>")
    public boolean isBetween(DayOfWeek dayOfWeek, DayOfWeek fromInclusive, DayOfWeek toInclusive) {
        return DateRangeChecker.isBetween$((DateRangeChecker)this, dayOfWeek, fromInclusive, toInclusive);
    }

    @Override
    @Documentation(description="Checks if month is in range <fromInclusive, toInclusive>. if to < from, then checks if month is in one of ranges <from, DECEMBER> and <JANUARY, to>")
    public boolean isBetween(Month month, Month fromInclusive, Month toInclusive) {
        return DateRangeChecker.isBetween$((DateRangeChecker)this, month, fromInclusive, toInclusive);
    }

    @Override
    @Documentation(description="Checks if day is in range <fromInclusive, toInclusive>.")
    public boolean isBetween(LocalDate date2, LocalDate fromInclusive, LocalDate toInclusive) {
        return DateRangeChecker.isBetween$((DateRangeChecker)this, date2, fromInclusive, toInclusive);
    }

    @Override
    @Documentation(description="Checks if day is in range <fromInclusive, toInclusive>.")
    public boolean isBetween(LocalDateTime date2, LocalDateTime fromInclusive, LocalDateTime toInclusive) {
        return DateRangeChecker.isBetween$((DateRangeChecker)this, date2, fromInclusive, toInclusive);
    }

    @Override
    @Documentation(description="Returns Zulu time zone which has offset always equals to UTC+0")
    public ZoneId zuluTimeZone() {
        return DateConstants.zuluTimeZone$(this);
    }

    @Override
    @Documentation(description="Returns UTC time zone offset")
    public ZoneOffset UTCOffset() {
        return DateConstants.UTCOffset$(this);
    }

    @Override
    @Documentation(description="Returns default time zone")
    public ZoneId defaultTimeZone() {
        return DateConstants.defaultTimeZone$(this);
    }

    @Override
    public DayOfWeek MONDAY() {
        return DateConstants.MONDAY$(this);
    }

    @Override
    public DayOfWeek TUESDAY() {
        return DateConstants.TUESDAY$(this);
    }

    @Override
    public DayOfWeek WEDNESDAY() {
        return DateConstants.WEDNESDAY$(this);
    }

    @Override
    public DayOfWeek THURSDAY() {
        return DateConstants.THURSDAY$(this);
    }

    @Override
    public DayOfWeek FRIDAY() {
        return DateConstants.FRIDAY$(this);
    }

    @Override
    public DayOfWeek SATURDAY() {
        return DateConstants.SATURDAY$(this);
    }

    @Override
    public DayOfWeek SUNDAY() {
        return DateConstants.SUNDAY$(this);
    }

    @Override
    public Month JANUARY() {
        return DateConstants.JANUARY$(this);
    }

    @Override
    public Month FEBRUARY() {
        return DateConstants.FEBRUARY$(this);
    }

    @Override
    public Month MARCH() {
        return DateConstants.MARCH$(this);
    }

    @Override
    public Month APRIL() {
        return DateConstants.APRIL$(this);
    }

    @Override
    public Month MAY() {
        return DateConstants.MAY$(this);
    }

    @Override
    public Month JUNE() {
        return DateConstants.JUNE$(this);
    }

    @Override
    public Month JULY() {
        return DateConstants.JULY$(this);
    }

    @Override
    public Month AUGUST() {
        return DateConstants.AUGUST$(this);
    }

    @Override
    public Month SEPTEMBER() {
        return DateConstants.SEPTEMBER$(this);
    }

    @Override
    public Month OCTOBER() {
        return DateConstants.OCTOBER$(this);
    }

    @Override
    public Month NOVEMBER() {
        return DateConstants.NOVEMBER$(this);
    }

    @Override
    public Month DECEMBER() {
        return DateConstants.DECEMBER$(this);
    }

    @Override
    @Documentation(description="Converts ZonedDateTime into epoch (millis from 1970-01-01)")
    public long toEpochMilli(ZonedDateTime zoned) {
        return DateConversions.toEpochMilli$((DateConversions)this, zoned);
    }

    @Override
    @Documentation(description="Converts OffsetDateTime into epoch (millis from 1970-01-01)")
    public long toEpochMilli(OffsetDateTime offset) {
        return DateConversions.toEpochMilli$((DateConversions)this, offset);
    }

    @Override
    @Documentation(description="Converts LocalDateTime at given time zone into epoch (millis from 1970-01-01)")
    public long toEpochMilli(LocalDateTime offset, ZoneId zone) {
        return DateConversions.toEpochMilli$((DateConversions)this, offset, zone);
    }

    @Override
    @Documentation(description="Converts LocalDateTime with given time zone offset into epoch (millis from 1970-01-01)")
    public long toEpochMilli(LocalDateTime offset, ZoneOffset zoneOffset) {
        return DateConversions.toEpochMilli$((DateConversions)this, offset, zoneOffset);
    }

    @Override
    @Documentation(description="Converts epoch (millis from 1970-01-01) into an Instant")
    public Instant toInstant(long timestampMillis) {
        return DateConversions.toInstant$(this, timestampMillis);
    }

    @Override
    @Documentation(description="Converts LocalDateTime at default time zone into an Instant")
    public Instant toInstantAtDefaultTimeZone(LocalDateTime localDateTime) {
        return DateConversions.toInstantAtDefaultTimeZone$(this, localDateTime);
    }

    @Override
    @Documentation(description="Returns LocalDateTime based on LocalDate and LocalTime")
    public LocalDateTime localDateTime(LocalDate date2, LocalTime time) {
        return DateConversions.localDateTime$(this, date2, time);
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Documentation(description="Returns current time as an Instant")
    public Instant now() {
        return Instant.now(this.clock());
    }

    @Documentation(description="Returns current time at given time zone as a ZonedDateTime")
    public ZonedDateTime nowAtZone(ZoneId zoneId) {
        return this.now().atZone(zoneId);
    }

    @Documentation(description="Returns current time with given time zone offset as an OffsetDateTime")
    public OffsetDateTime nowAtOffset(ZoneOffset zoneOffset) {
        return this.now().atOffset(zoneOffset);
    }

    @Documentation(description="Returns current time at default time zone as a ZonedDateTime")
    public ZonedDateTime nowAtDefaultTimeZone() {
        return this.now().atZone(this.clock().getZone());
    }

    @Documentation(description="Returns time zone with given zone id e.g. Europe/Warsaw")
    public ZoneId zone(String zoneId) {
        return ZoneId.of(zoneId);
    }

    @Documentation(description="Returns zone offset with given zone offset id e.g. +01:00")
    public ZoneOffset zoneOffset(String offsetId) {
        return ZoneOffset.of(offsetId);
    }

    public DateUtils(Clock clock) {
        this.clock = clock;
        DateConversions.$init$(this);
        DateConstants.$init$(this);
        DateRangeChecker.$init$(this);
    }
}

