/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.util.functions;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import pl.touk.nussknacker.engine.api.Documentation;
import pl.touk.nussknacker.engine.util.functions.date$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005i9Qa\u0001\u0003\t\u0002E1Qa\u0005\u0003\t\u0002QAQ\u0001G\u0001\u0005\u0002e\tA\u0001Z1uK*\u0011QAB\u0001\nMVt7\r^5p]NT!a\u0002\u0005\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0013)\ta!\u001a8hS:,'BA\u0006\r\u0003-qWo]:l]\u0006\u001c7.\u001a:\u000b\u00055q\u0011\u0001\u0002;pk.T\u0011aD\u0001\u0003a2\u001c\u0001\u0001\u0005\u0002\u0013\u00035\tAA\u0001\u0003eCR,7CA\u0001\u0016!\t\u0011b#\u0003\u0002\u0018\t\tIA)\u0019;f+RLGn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001")
public final class date {
    @Documentation(description="Returns zone offset with given zone offset id e.g. +01:00")
    public static ZoneOffset zoneOffset(String offsetId) {
        return date$.MODULE$.zoneOffset(offsetId);
    }

    @Documentation(description="Returns time zone with given zone id e.g. Europe/Warsaw")
    public static ZoneId zone(String zoneId) {
        return date$.MODULE$.zone(zoneId);
    }

    @Documentation(description="Returns current time at default time zone as a ZonedDateTime")
    public static ZonedDateTime nowAtDefaultTimeZone() {
        return date$.MODULE$.nowAtDefaultTimeZone();
    }

    @Documentation(description="Returns current time with given time zone offset as an OffsetDateTime")
    public static OffsetDateTime nowAtOffset(ZoneOffset zoneOffset) {
        return date$.MODULE$.nowAtOffset(zoneOffset);
    }

    @Documentation(description="Returns current time at given time zone as a ZonedDateTime")
    public static ZonedDateTime nowAtZone(ZoneId zoneId) {
        return date$.MODULE$.nowAtZone(zoneId);
    }

    @Documentation(description="Returns current time as an Instant")
    public static Instant now() {
        return date$.MODULE$.now();
    }

    @Documentation(description="Checks if day is in range <fromInclusive, toInclusive>.")
    public static boolean isBetween(LocalDateTime date2, LocalDateTime fromInclusive, LocalDateTime toInclusive) {
        return date$.MODULE$.isBetween(date2, fromInclusive, toInclusive);
    }

    @Documentation(description="Checks if day is in range <fromInclusive, toInclusive>.")
    public static boolean isBetween(LocalDate date2, LocalDate fromInclusive, LocalDate toInclusive) {
        return date$.MODULE$.isBetween(date2, fromInclusive, toInclusive);
    }

    @Documentation(description="Checks if month is in range <fromInclusive, toInclusive>. if to < from, then checks if month is in one of ranges <from, DECEMBER> and <JANUARY, to>")
    public static boolean isBetween(Month month, Month fromInclusive, Month toInclusive) {
        return date$.MODULE$.isBetween(month, fromInclusive, toInclusive);
    }

    @Documentation(description="Checks if day of week is in range <fromInclusive, toInclusive>. if to < from in ISO standard (numerous from MONDAY), then checks if day of week is in one of ranges <from, SUNDAY> and <MONDAY, to>")
    public static boolean isBetween(DayOfWeek dayOfWeek, DayOfWeek fromInclusive, DayOfWeek toInclusive) {
        return date$.MODULE$.isBetween(dayOfWeek, fromInclusive, toInclusive);
    }

    @Documentation(description="Checks if time is in range <fromInclusive, toInclusive>. if to < from, then checks if time is in one of ranges <from, 24:00> and <00:00, to>")
    public static boolean isBetween(LocalTime time, LocalTime fromInclusive, LocalTime toInclusive) {
        return date$.MODULE$.isBetween(time, fromInclusive, toInclusive);
    }

    @Documentation(description="Computes Duration between two dates: start date inclusive and end date exclusive")
    public static Duration durationBetween(Temporal startDateInclusive, Temporal endDateExclusive) {
        return date$.MODULE$.durationBetween(startDateInclusive, endDateExclusive);
    }

    @Documentation(description="Computes Period between two dates: start date inclusive and end date exclusive")
    public static Period periodBetween(OffsetDateTime startDateInclusive, OffsetDateTime endDateExclusive) {
        return date$.MODULE$.periodBetween(startDateInclusive, endDateExclusive);
    }

    @Documentation(description="Computes Period between two dates: start date inclusive and end date exclusive")
    public static Period periodBetween(ZonedDateTime startDateInclusive, ZonedDateTime endDateExclusive) {
        return date$.MODULE$.periodBetween(startDateInclusive, endDateExclusive);
    }

    @Documentation(description="Computes Period between two dates: start date inclusive and end date exclusive")
    public static Period periodBetween(LocalDate startDateInclusive, LocalDate endDateExclusive) {
        return date$.MODULE$.periodBetween(startDateInclusive, endDateExclusive);
    }

    public static Month DECEMBER() {
        return date$.MODULE$.DECEMBER();
    }

    public static Month NOVEMBER() {
        return date$.MODULE$.NOVEMBER();
    }

    public static Month OCTOBER() {
        return date$.MODULE$.OCTOBER();
    }

    public static Month SEPTEMBER() {
        return date$.MODULE$.SEPTEMBER();
    }

    public static Month AUGUST() {
        return date$.MODULE$.AUGUST();
    }

    public static Month JULY() {
        return date$.MODULE$.JULY();
    }

    public static Month JUNE() {
        return date$.MODULE$.JUNE();
    }

    public static Month MAY() {
        return date$.MODULE$.MAY();
    }

    public static Month APRIL() {
        return date$.MODULE$.APRIL();
    }

    public static Month MARCH() {
        return date$.MODULE$.MARCH();
    }

    public static Month FEBRUARY() {
        return date$.MODULE$.FEBRUARY();
    }

    public static Month JANUARY() {
        return date$.MODULE$.JANUARY();
    }

    public static DayOfWeek SUNDAY() {
        return date$.MODULE$.SUNDAY();
    }

    public static DayOfWeek SATURDAY() {
        return date$.MODULE$.SATURDAY();
    }

    public static DayOfWeek FRIDAY() {
        return date$.MODULE$.FRIDAY();
    }

    public static DayOfWeek THURSDAY() {
        return date$.MODULE$.THURSDAY();
    }

    public static DayOfWeek WEDNESDAY() {
        return date$.MODULE$.WEDNESDAY();
    }

    public static DayOfWeek TUESDAY() {
        return date$.MODULE$.TUESDAY();
    }

    public static DayOfWeek MONDAY() {
        return date$.MODULE$.MONDAY();
    }

    @Documentation(description="Returns default time zone")
    public static ZoneId defaultTimeZone() {
        return date$.MODULE$.defaultTimeZone();
    }

    @Documentation(description="Returns UTC time zone offset")
    public static ZoneOffset UTCOffset() {
        return date$.MODULE$.UTCOffset();
    }

    @Documentation(description="Returns Zulu time zone which has offset always equals to UTC+0")
    public static ZoneId zuluTimeZone() {
        return date$.MODULE$.zuluTimeZone();
    }

    @Documentation(description="Returns LocalDateTime based on LocalDate and LocalTime")
    public static LocalDateTime localDateTime(LocalDate date2, LocalTime time) {
        return date$.MODULE$.localDateTime(date2, time);
    }

    @Documentation(description="Converts LocalDateTime at default time zone into an Instant")
    public static Instant toInstantAtDefaultTimeZone(LocalDateTime localDateTime) {
        return date$.MODULE$.toInstantAtDefaultTimeZone(localDateTime);
    }

    @Documentation(description="Converts epoch (millis from 1970-01-01) into an Instant")
    public static Instant toInstant(long timestampMillis) {
        return date$.MODULE$.toInstant(timestampMillis);
    }

    @Documentation(description="Converts LocalDateTime with given time zone offset into epoch (millis from 1970-01-01)")
    public static long toEpochMilli(LocalDateTime offset, ZoneOffset zoneOffset) {
        return date$.MODULE$.toEpochMilli(offset, zoneOffset);
    }

    @Documentation(description="Converts LocalDateTime at given time zone into epoch (millis from 1970-01-01)")
    public static long toEpochMilli(LocalDateTime offset, ZoneId zone) {
        return date$.MODULE$.toEpochMilli(offset, zone);
    }

    @Documentation(description="Converts OffsetDateTime into epoch (millis from 1970-01-01)")
    public static long toEpochMilli(OffsetDateTime offset) {
        return date$.MODULE$.toEpochMilli(offset);
    }

    @Documentation(description="Converts ZonedDateTime into epoch (millis from 1970-01-01)")
    public static long toEpochMilli(ZonedDateTime zoned) {
        return date$.MODULE$.toEpochMilli(zoned);
    }
}

