/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.util.functions;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import pl.touk.nussknacker.engine.api.Documentation;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001\u0002\r\u001a\u0001\u0019B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006k\u0001!\tA\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\u00063\u0002!\tA\u0017\u0005\u0006E\u0002!\ta\u0019\u0005\u0006W\u0002!\t\u0001\u001c\u0005\u0006i\u0002!\t!\u001e\u0005\u0006{\u0002!\tA \u0005\u0007u\u0001!\t!!\u0004\t\re\u0003A\u0011AA\u000e\u0011\u0019\u0011\u0007\u0001\"\u0001\u0002(!1A\u000f\u0001C\u0001\u0003gAa! \u0001\u0005\u0002\u0005}\u0002B\u0002\u001e\u0001\t\u0003\tY\u0005\u0003\u0004Z\u0001\u0011\u0005\u0011\u0011\r\u0005\u0007E\u0002!\t!!\u001c\t\rQ\u0004A\u0011AA=\u0011\u0019i\b\u0001\"\u0001\u0002\u0006\"9\u00111\u0003\u0001\u0005\u0002\u0005E\u0005bBAT\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003O\u0003A\u0011AA[\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000bDq!a1\u0001\t\u0003\tyMA\bECR,gi\u001c:nCR,F/\u001b7t\u0015\tQ2$A\u0005gk:\u001cG/[8og*\u0011A$H\u0001\u0005kRLGN\u0003\u0002\u001f?\u00051QM\\4j]\u0016T!\u0001I\u0011\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003E\r\nA\u0001^8vW*\tA%\u0001\u0002qY\u000e\u00011C\u0001\u0001(!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fM\u0006iA-\u001a4bk2$Hj\\2bY\u0016\u0004\"aL\u001a\u000e\u0003AR!\u0001H\u0019\u000b\u0003I\nAA[1wC&\u0011A\u0007\r\u0002\u0007\u0019>\u001c\u0017\r\\3\u0002\rqJg.\u001b;?)\t9\u0014\b\u0005\u00029\u00015\t\u0011\u0004C\u0003.\u0005\u0001\u0007a&\u0001\bqCJ\u001cX\rT8dC2$\u0016.\\3\u0015\u0005q\u0012\u0005CA\u001fA\u001b\u0005q$BA 2\u0003\u0011!\u0018.\\3\n\u0005\u0005s$!\u0003'pG\u0006dG+[7f\u0011\u0015\u00195\u00011\u0001E\u0003\u0011!X\r\u001f;\u0011\u0005\u0015ceB\u0001$K!\t9\u0015&D\u0001I\u0015\tIU%\u0001\u0004=e>|GOP\u0005\u0003\u0017&\na\u0001\u0015:fI\u00164\u0017BA'O\u0005\u0019\u0019FO]5oO*\u00111*\u000b\u0015\u0005\u0007A3v\u000b\u0005\u0002R)6\t!K\u0003\u0002T;\u0005\u0019\u0011\r]5\n\u0005U\u0013&!\u0004#pGVlWM\u001c;bi&|g.A\u0006eKN\u001c'/\u001b9uS>t\u0017%\u0001-\u0002{A\u000b'o]3!\u0019>\u001c\u0017\r\u001c+j[\u0016\u0004\u0013N\u001c\u0011J'>k\u0003H\u000e\u00192A\u0019|'/\\1uA\u0015tsM\f\u0011(cAR\u0014'N\u0014!_J\u0004s%\r\u0019;cUR4\u0007M\u0014\u0002\u001dA\f'o]3M_\u000e\fG\u000eR1uKR\u00111L\u0018\t\u0003{qK!!\u0018 \u0003\u00131{7-\u00197ECR,\u0007\"B\"\u0005\u0001\u0004!\u0005\u0006\u0002\u0003Q-\u0002\f\u0013!Y\u00015!\u0006\u00148/\u001a\u0011M_\u000e\fG\u000eR1uK\u0002Jg\u000eI%T\u001f6Bd\u0007M\u0019!M>\u0014X.\u0019;!K::g\u0006I\u00143aE\nT&\r\u001a.aM:\u0013A\u00059beN,Gj\\2bY\u0012\u000bG/\u001a+j[\u0016$\"\u0001Z4\u0011\u0005u*\u0017B\u00014?\u00055aunY1m\t\u0006$X\rV5nK\")1)\u0002a\u0001\t\"\"Q\u0001\u0015,jC\u0005Q\u0017!\u0011)beN,\u0007\u0005T8dC2$\u0015\r^3US6,\u0007%\u001b8!\u0013N{U\u0006\u000f\u001c1c\u00012wN]7bi\u0002*gf\u001a\u0018!OI\u0002\u0014'M\u00172e5\u00024\u0007V\u00191uE*$h\r\u0019(\u00031\u0001\u0018M]:f\u0013:\u001cH/\u00198u)\ti\u0007\u000f\u0005\u0002>]&\u0011qN\u0010\u0002\b\u0013:\u001cH/\u00198u\u0011\u0015\u0019e\u00011\u0001EQ\u00111\u0001K\u0016:\"\u0003M\fA\bU1sg\u0016\u0004\u0013J\\:uC:$\b%\u001b8!\u0013N{U\u0006\u000f\u001c1c\u00012wN]7bi\u0002*gf\u001a\u0018!OI\u0002\u0014'M\u00172e5\u00024\u0007V\u00191uE*$h\r\u0019[O\u0005\u0019\u0002/\u0019:tK>3gm]3u\t\u0006$X\rV5nKR\u0011a/\u001f\t\u0003{]L!\u0001\u001f \u0003\u001d=3gm]3u\t\u0006$X\rV5nK\")1i\u0002a\u0001\t\"\"q\u0001\u0015,|C\u0005a\u0018\u0001\u0013)beN,\u0007e\u00144gg\u0016$H)\u0019;f)&lW\rI5oA%\u001bv*\f\u001d7aE\u0002cm\u001c:nCR\u0004SML4/A\u001d\u0012\u0004'M\u0019.cIj\u0003g\r+2ai\nTGO\u001a1WA\n$\b\r\u0019(\u0003I\u0001\u0018M]:f5>tW\r\u001a#bi\u0016$\u0016.\\3\u0015\u0007}\f)\u0001E\u0002>\u0003\u0003I1!a\u0001?\u00055QvN\\3e\t\u0006$X\rV5nK\")1\t\u0003a\u0001\t\"*\u0001\u0002\u0015,\u0002\n\u0005\u0012\u00111B\u0001V!\u0006\u00148/\u001a\u0011[_:,G\rR1uKRKW.\u001a\u0011j]\u0002J5kT\u00179mA\n\u0004EZ8s[\u0006$\b%\u001a\u0018h]\u0001:#\u0007M\u00192[E\u0012T\u0006M\u001aUcAR\u0014'\u000e\u001e4a-\u0002\u0014G\u000f\u001917\u0016+(o\u001c9f_A\u000b'/[:^OQ)A(a\u0004\u0002\u0012!)1)\u0003a\u0001\t\"1\u00111C\u0005A\u0002\u0011\u000baAZ8s[\u0006$\b&B\u0005Q-\u0006]\u0011EAA\r\u0003-\u0002\u0016M]:fA1{7-\u00197US6,\u0007%\u001b8!\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014\bEZ8s[\u0006$H#B.\u0002\u001e\u0005}\u0001\"B\"\u000b\u0001\u0004!\u0005BBA\n\u0015\u0001\u0007A\tK\u0003\u000b!Z\u000b\u0019#\t\u0002\u0002&\u0005Y\u0003+\u0019:tK\u0002bunY1m\t\u0006$X\rI5oA\u0011\u000bG/\u001a+j[\u00164uN]7biR,'\u000f\t4pe6\fG\u000fF\u0003e\u0003S\tY\u0003C\u0003D\u0017\u0001\u0007A\t\u0003\u0004\u0002\u0014-\u0001\r\u0001\u0012\u0015\u0006\u0017A3\u0016qF\u0011\u0003\u0003c\tq\u0006U1sg\u0016\u0004Cj\\2bY\u0012\u000bG/\u001a+j[\u0016\u0004\u0013N\u001c\u0011ECR,G+[7f\r>\u0014X.\u0019;uKJ\u0004cm\u001c:nCR$RA^A\u001b\u0003oAQa\u0011\u0007A\u0002\u0011Ca!a\u0005\r\u0001\u0004!\u0005&\u0002\u0007Q-\u0006m\u0012EAA\u001f\u0003A\u0002\u0016M]:fA=3gm]3u\t\u0006$X\rV5nK\u0002Jg\u000e\t#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\u00022wN]7biR)q0!\u0011\u0002D!)1)\u0004a\u0001\t\"1\u00111C\u0007A\u0002\u0011CS!\u0004)W\u0003\u000f\n#!!\u0013\u0002_A\u000b'o]3!5>tW\r\u001a#bi\u0016$\u0016.\\3!S:\u0004C)\u0019;f)&lWMR8s[\u0006$H/\u001a:!M>\u0014X.\u0019;\u0015\u000bq\ni%a\u0014\t\u000b\rs\u0001\u0019\u0001#\t\u000f\u0005Ma\u00021\u0001\u0002RA!\u00111KA,\u001b\t\t)FC\u0002\u0002\u0014yJA!!\u0017\u0002V\t\tB)\u0019;f)&lWMR8s[\u0006$H/\u001a:)\u000b9\u0001f+!\u0018\"\u0005\u0005}\u0013!\n)beN,\u0007\u0005T8dC2$\u0016.\\3!kNLgn\u001a\u0011hSZ,g\u000e\t4pe6\fG\u000f^3s)\u0015Y\u00161MA3\u0011\u0015\u0019u\u00021\u0001E\u0011\u001d\t\u0019b\u0004a\u0001\u0003#BSa\u0004)W\u0003S\n#!a\u001b\u0002KA\u000b'o]3!\u0019>\u001c\u0017\r\u001c#bi\u0016\u0004So]5oO\u0002:\u0017N^3oA\u0019|'/\\1ui\u0016\u0014H#\u00023\u0002p\u0005E\u0004\"B\"\u0011\u0001\u0004!\u0005bBA\n!\u0001\u0007\u0011\u0011\u000b\u0015\u0006!A3\u0016QO\u0011\u0003\u0003o\n\u0011\u0006U1sg\u0016\u0004Cj\\2bY\u0012\u000bG/\u001a+j[\u0016\u0004So]5oO\u0002:\u0017N^3oA\u0019|'/\\1ui\u0016\u0014H#\u0002<\u0002|\u0005u\u0004\"B\"\u0012\u0001\u0004!\u0005bBA\n#\u0001\u0007\u0011\u0011\u000b\u0015\u0006#A3\u0016\u0011Q\u0011\u0003\u0003\u0007\u000b!\u0006U1sg\u0016\u0004sJ\u001a4tKR$\u0015\r^3US6,\u0007%^:j]\u001e\u0004s-\u001b<f]\u00022wN]7biR,'\u000fF\u0003\u0000\u0003\u000f\u000bI\tC\u0003D%\u0001\u0007A\tC\u0004\u0002\u0014I\u0001\r!!\u0015)\u000bI\u0001f+!$\"\u0005\u0005=\u0015!\u000b)beN,\u0007EW8oK\u0012$\u0015\r^3US6,\u0007%^:j]\u001e\u0004s-\u001b<f]\u00022wN]7biR,'\u000fF\u0002E\u0003'Cq!!&\u0014\u0001\u0004\t9*\u0001\u0005uK6\u0004xN]1m!\u0011\tI*!(\u000e\u0005\u0005m%bAAK}%!\u0011qTAN\u0005A!V-\u001c9pe\u0006d\u0017iY2fgN|'\u000fK\u0003\u0014!Z\u000b\u0019+\t\u0002\u0002&\u0006q&+\u001a8eKJ\u0004Cj\\2bYRKW.\u001a\u0017!\u0019>\u001c\u0017\r\u001c#bi\u0016d\u0003\u0005T8dC2$\u0015\r^3US6,G\u0006I(gMN,G\u000fR1uKRKW.\u001a\u0011pe\u0002RvN\\3e\t\u0006$X\rV5nK\u0002Jg\u000eI%T\u001f6Bd\u0007M\u0019!M>\u0014X.\u0019;\u0002\u0013\u0019|'/\\1ui\u0016\u0014H\u0003BA)\u0003WCa!!,\u0015\u0001\u0004!\u0015a\u00029biR,'O\u001c\u0015\u0006)A3\u0016\u0011W\u0011\u0003\u0003g\u000bQf\u0011:fCR,7\u000f\t#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\u0002*8/\u001b8hA\u001dLg/\u001a8!a\u0006$H/\u001a:o)\u0019\t\t&a.\u0002:\"1\u0011QV\u000bA\u0002\u0011Ca!a/\u0016\u0001\u0004q\u0013A\u00027pG\u0006dW\rK\u0003\u0016!Z\u000by,\t\u0002\u0002B\u0006A4I]3bi\u0016\u001c\b\u0005R1uKRKW.\u001a$pe6\fG\u000f^3sAU\u001c\u0018N\\4!O&4XM\u001c\u0011qCR$XM\u001d8!C:$\u0007\u0005\\8dC2,\u0017\u0001\u00057f]&,g\u000e\u001e$pe6\fG\u000f^3s)\u0011\t\t&a2\t\r\u00055f\u00031\u0001EQ\u00151\u0002KVAfC\t\ti-\u0001!De\u0016\fG/Z:!Y\u0016t\u0017.\u001a8uAY,'o]5p]\u0002zg\r\t#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\u0002*8/\u001b8hA\u001dLg/\u001a8!a\u0006$H/\u001a:o)\u0019\t\t&!5\u0002T\"1\u0011QV\fA\u0002\u0011Ca!a/\u0018\u0001\u0004q\u0003&B\fQ-\u0006]\u0017EAAm\u0003-\u001b%/Z1uKN\u0004C.\u001a8jK:$\bE^3sg&|g\u000eI8gA\u0011\u000bG/\u001a+j[\u00164uN]7biR,'\u000fI;tS:<\u0007eZ5wK:\u0004\u0003/\u0019;uKJt\u0007%\u00198eA1|7-\u00197f\u0001")
public class DateFormatUtils {
    private final Locale defaultLocale;

    @Documentation(description="Parse LocalTime in ISO-8601 format e.g. '10:15' or '10:15:30'")
    public LocalTime parseLocalTime(String text) {
        return LocalTime.parse(text);
    }

    @Documentation(description="Parse LocalDate in ISO-8601 format e.g. '2011-12-03'")
    public LocalDate parseLocalDate(String text) {
        return LocalDate.parse(text);
    }

    @Documentation(description="Parse LocalDateTime in ISO-8601 format e.g. '2011-12-03T10:15:30'")
    public LocalDateTime parseLocalDateTime(String text) {
        return LocalDateTime.parse(text);
    }

    @Documentation(description="Parse Instant in ISO-8601 format e.g. '2011-12-03T10:15:30Z'")
    public Instant parseInstant(String text) {
        return Instant.parse(text);
    }

    @Documentation(description="Parse OffsetDateTime in ISO-8601 format e.g. '2011-12-03T10:15:30+01:00'")
    public OffsetDateTime parseOffsetDateTime(String text) {
        return OffsetDateTime.parse(text);
    }

    @Documentation(description="Parse ZonedDateTime in ISO-8601 format e.g. '2011-12-03T10:15:30+01:00[Europe/Paris]'")
    public ZonedDateTime parseZonedDateTime(String text) {
        return ZonedDateTime.parse(text);
    }

    @Documentation(description="Parse LocalTime in DateTimeFormatter format")
    public LocalTime parseLocalTime(String text, String format) {
        return LocalTime.parse(text, DateTimeFormatter.ofPattern(format, this.defaultLocale));
    }

    @Documentation(description="Parse LocalDate in DateTimeFormatter format")
    public LocalDate parseLocalDate(String text, String format) {
        return LocalDate.parse(text, DateTimeFormatter.ofPattern(format, this.defaultLocale));
    }

    @Documentation(description="Parse LocalDateTime in DateTimeFormatter format")
    public LocalDateTime parseLocalDateTime(String text, String format) {
        return LocalDateTime.parse(text, DateTimeFormatter.ofPattern(format, this.defaultLocale));
    }

    @Documentation(description="Parse OffsetDateTime in DateTimeFormatter format")
    public OffsetDateTime parseOffsetDateTime(String text, String format) {
        return OffsetDateTime.parse(text, DateTimeFormatter.ofPattern(format, this.defaultLocale));
    }

    @Documentation(description="Parse ZonedDateTime in DateTimeFormatter format")
    public ZonedDateTime parseZonedDateTime(String text, String format) {
        return ZonedDateTime.parse(text, DateTimeFormatter.ofPattern(format, this.defaultLocale));
    }

    @Documentation(description="Parse LocalTime using given formatter")
    public LocalTime parseLocalTime(String text, DateTimeFormatter format) {
        return LocalTime.parse(text, format);
    }

    @Documentation(description="Parse LocalDate using given formatter")
    public LocalDate parseLocalDate(String text, DateTimeFormatter format) {
        return LocalDate.parse(text, format);
    }

    @Documentation(description="Parse LocalDateTime using given formatter")
    public LocalDateTime parseLocalDateTime(String text, DateTimeFormatter format) {
        return LocalDateTime.parse(text, format);
    }

    @Documentation(description="Parse OffsetDateTime using given formatter")
    public OffsetDateTime parseOffsetDateTime(String text, DateTimeFormatter format) {
        return OffsetDateTime.parse(text, format);
    }

    @Documentation(description="Parse ZonedDateTime using given formatter")
    public ZonedDateTime parseZonedDateTime(String text, DateTimeFormatter format) {
        return ZonedDateTime.parse(text, format);
    }

    @Documentation(description="Render LocalTime, LocalDate, LocalDateTime, OffsetDateTime or ZonedDateTime in ISO-8601 format")
    public String format(TemporalAccessor temporal) {
        DateTimeFormatter dateTimeFormatter;
        TemporalAccessor temporalAccessor = temporal;
        if (temporalAccessor instanceof Instant) {
            dateTimeFormatter = DateTimeFormatter.ISO_INSTANT;
        } else if (temporalAccessor instanceof LocalDate) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE;
        } else if (temporalAccessor instanceof LocalTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_TIME;
        } else if (temporalAccessor instanceof LocalDateTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        } else if (temporalAccessor instanceof OffsetDateTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        } else if (temporalAccessor instanceof ZonedDateTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_ZONED_DATE_TIME;
        } else {
            throw new MatchError((Object)temporalAccessor);
        }
        DateTimeFormatter formatter = dateTimeFormatter;
        return formatter.format(temporal);
    }

    @Documentation(description="Creates DateTimeFormatter using given pattern")
    public DateTimeFormatter formatter(String pattern) {
        return this.formatter(pattern, this.defaultLocale);
    }

    @Documentation(description="Creates DateTimeFormatter using given pattern and locale")
    public DateTimeFormatter formatter(String pattern, Locale locale) {
        return DateTimeFormatter.ofPattern(pattern, locale);
    }

    @Documentation(description="Creates lenient version of DateTimeFormatter using given pattern")
    public DateTimeFormatter lenientFormatter(String pattern) {
        return this.lenientFormatter(pattern, this.defaultLocale);
    }

    @Documentation(description="Creates lenient version of DateTimeFormatter using given pattern and locale")
    public DateTimeFormatter lenientFormatter(String pattern, Locale locale) {
        return new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(pattern).toFormatter(locale);
    }

    public DateFormatUtils(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }
}

