/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.util.functions;

import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import pl.touk.nussknacker.engine.api.Documentation;
import pl.touk.nussknacker.engine.util.functions.DateConstants;
import pl.touk.nussknacker.engine.util.functions.DateConversions;
import pl.touk.nussknacker.engine.util.functions.DateRangeChecker;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005u4AAC\u0006\u00011!A\u0011\u0006\u0001BC\u0002\u0013E#\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u0003,\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u00151\u0007\u0001\"\u0001h\u0011\u0015Q\u0006\u0001\"\u0001x\u0005%!\u0015\r^3Vi&d7O\u0003\u0002\r\u001b\u0005Ia-\u001e8di&|gn\u001d\u0006\u0003\u001d=\tA!\u001e;jY*\u0011\u0001#E\u0001\u0007K:<\u0017N\\3\u000b\u0005I\u0019\u0012a\u00038vgN\\g.Y2lKJT!\u0001F\u000b\u0002\tQ|Wo\u001b\u0006\u0002-\u0005\u0011\u0001\u000f\\\u0002\u0001'\u0015\u0001\u0011dH\u0012'!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fMB\u0011\u0001%I\u0007\u0002\u0017%\u0011!e\u0003\u0002\u0010\t\u0006$XmQ8om\u0016\u00148/[8ogB\u0011\u0001\u0005J\u0005\u0003K-\u0011Q\u0002R1uK\u000e{gn\u001d;b]R\u001c\bC\u0001\u0011(\u0013\tA3B\u0001\tECR,'+\u00198hK\u000eCWmY6fe\u0006)1\r\\8dWV\t1\u0006\u0005\u0002-c5\tQF\u0003\u0002/_\u0005!A/[7f\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!AM\u0017\u0003\u000b\rcwnY6\u0002\r\rdwnY6!\u0003\u0019a\u0014N\\5u}Q\u0011ag\u000e\t\u0003A\u0001AQ!K\u0002A\u0002-\n1A\\8x)\u0005Q\u0004C\u0001\u0017<\u0013\taTFA\u0004J]N$\u0018M\u001c;)\t\u0011qD)\u0012\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003>\t1!\u00199j\u0013\t\u0019\u0005IA\u0007E_\u000e,X.\u001a8uCRLwN\\\u0001\fI\u0016\u001c8M]5qi&|g.I\u0001G\u0003\t\u0012V\r^;s]N\u00043-\u001e:sK:$\b\u0005^5nK\u0002\n7\u000fI1oA%s7\u000f^1oi\u0006Ian\\<Bij{g.\u001a\u000b\u0003\u00132\u0003\"\u0001\f&\n\u0005-k#!\u0004.p]\u0016$G)\u0019;f)&lW\rC\u0003N\u000b\u0001\u0007a*\u0001\u0004{_:,\u0017\n\u001a\t\u0003Y=K!\u0001U\u0017\u0003\ri{g.Z%eQ\u0011)a\b\u0012*\"\u0003M\u000b!HU3ukJt7\u000fI2veJ,g\u000e\u001e\u0011uS6,\u0007%\u0019;!O&4XM\u001c\u0011uS6,\u0007E_8oK\u0002\n7\u000fI1!5>tW\r\u001a#bi\u0016$\u0016.\\3\u0002\u00179|w/\u0011;PM\u001a\u001cX\r\u001e\u000b\u0003-f\u0003\"\u0001L,\n\u0005ak#AD(gMN,G\u000fR1uKRKW.\u001a\u0005\u00065\u001a\u0001\raW\u0001\u000bu>tWm\u00144gg\u0016$\bC\u0001\u0017]\u0013\tiVF\u0001\u0006[_:,wJ\u001a4tKRDCA\u0002 E?\u0006\n\u0001-A#SKR,(O\\:!GV\u0014(/\u001a8uAQLW.\u001a\u0011xSRD\u0007eZ5wK:\u0004C/[7fAi|g.\u001a\u0011pM\u001a\u001cX\r\u001e\u0011bg\u0002\ng\u000eI(gMN,G\u000fR1uKRKW.Z\u0001\u0015]><\u0018\t\u001e#fM\u0006,H\u000e\u001e+j[\u0016TvN\\3\u0015\u0003%CCa\u0002 EI\u0006\nQ-\u0001\u001fSKR,(O\\:!GV\u0014(/\u001a8uAQLW.\u001a\u0011bi\u0002\"WMZ1vYR\u0004C/[7fAi|g.\u001a\u0011bg\u0002\n\u0007EW8oK\u0012$\u0015\r^3US6,\u0017\u0001\u0002>p]\u0016$\"A\u00145\t\u000b5C\u0001\u0019A5\u0011\u0005)\fhBA6p!\ta7$D\u0001n\u0015\tqw#\u0001\u0004=e>|GOP\u0005\u0003an\ta\u0001\u0015:fI\u00164\u0017B\u0001:t\u0005\u0019\u0019FO]5oO*\u0011\u0001o\u0007\u0015\u0005\u0011y\"U/I\u0001w\u0003]\u0012V\r^;s]N\u0004C/[7fAi|g.\u001a\u0011xSRD\u0007eZ5wK:\u0004#p\u001c8fA%$\u0007%\u001a\u0018h]\u0001*UO]8qK>:\u0016M]:boR\u00111\f\u001f\u0005\u0006s&\u0001\r![\u0001\t_\u001a47/\u001a;JI\"\"\u0011B\u0010#|C\u0005a\u0018!\u000f*fiV\u0014hn\u001d\u0011{_:,\u0007e\u001c4gg\u0016$\be^5uQ\u0002:\u0017N^3oAi|g.\u001a\u0011pM\u001a\u001cX\r\u001e\u0011jI\u0002*gf\u001a\u0018!WA\n$\b\r\u0019")
public class DateUtils
implements DateConversions,
DateConstants,
DateRangeChecker {
    private final Clock clock;

    @Override
    @Documentation(description="Computes Period between two dates: start date inclusive and end date exclusive")
    public Period periodBetween(LocalDate startDateInclusive, LocalDate endDateExclusive) {
        return DateRangeChecker.periodBetween$((DateRangeChecker)this, startDateInclusive, endDateExclusive);
    }

    @Override
    @Documentation(description="Computes Period between two dates: start date inclusive and end date exclusive")
    public Period periodBetween(ZonedDateTime startDateInclusive, ZonedDateTime endDateExclusive) {
        return DateRangeChecker.periodBetween$((DateRangeChecker)this, startDateInclusive, endDateExclusive);
    }

    @Override
    @Documentation(description="Computes Period between two dates: start date inclusive and end date exclusive")
    public Period periodBetween(OffsetDateTime startDateInclusive, OffsetDateTime endDateExclusive) {
        return DateRangeChecker.periodBetween$((DateRangeChecker)this, startDateInclusive, endDateExclusive);
    }

    @Override
    @Documentation(description="Computes Duration between two dates: start date inclusive and end date exclusive")
    public Duration durationBetween(Temporal startDateInclusive, Temporal endDateExclusive) {
        return DateRangeChecker.durationBetween$(this, startDateInclusive, endDateExclusive);
    }

    @Override
    @Documentation(description="Checks if time is in range <fromInclusive, toInclusive>. if to < from, then checks if time is in one of ranges <from, 24:00> and <00:00, to>")
    public boolean isBetween(LocalTime time, LocalTime fromInclusive, LocalTime toInclusive) {
        return DateRangeChecker.isBetween$((DateRangeChecker)this, time, fromInclusive, toInclusive);
    }

    @Override
    @Documentation(description="Checks if day of week is in range <fromInclusive, toInclusive>. if to < from in ISO standard (numerous from MONDAY), then checks if day of week is in one of ranges <from, SUNDAY> and <MONDAY, to>")
    public boolean isBetween(DayOfWeek dayOfWeek, DayOfWeek fromInclusive, DayOfWeek toInclusive) {
        return DateRangeChecker.isBetween$((DateRangeChecker)this, dayOfWeek, fromInclusive, toInclusive);
    }

    @Override
    @Documentation(description="Checks if month is in range <fromInclusive, toInclusive>. if to < from, then checks if month is in one of ranges <from, DECEMBER> and <JANUARY, to>")
    public boolean isBetween(Month month, Month fromInclusive, Month toInclusive) {
        return DateRangeChecker.isBetween$((DateRangeChecker)this, month, fromInclusive, toInclusive);
    }

    @Override
    @Documentation(description="Checks if day is in range <fromInclusive, toInclusive>.")
    public boolean isBetween(LocalDate date2, LocalDate fromInclusive, LocalDate toInclusive) {
        return DateRangeChecker.isBetween$((DateRangeChecker)this, date2, fromInclusive, toInclusive);
    }

    @Override
    @Documentation(description="Checks if day is in range <fromInclusive, toInclusive>.")
    public boolean isBetween(LocalDateTime date2, LocalDateTime fromInclusive, LocalDateTime toInclusive) {
        return DateRangeChecker.isBetween$((DateRangeChecker)this, date2, fromInclusive, toInclusive);
    }

    @Override
    @Documentation(description="Returns Zulu time zone which has offset always equals to UTC+0")
    public ZoneId zuluTimeZone() {
        return DateConstants.zuluTimeZone$(this);
    }

    @Override
    @Documentation(description="Returns UTC time zone offset")
    public ZoneOffset UTCOffset() {
        return DateConstants.UTCOffset$(this);
    }

    @Override
    @Documentation(description="Returns default time zone")
    public ZoneId defaultTimeZone() {
        return DateConstants.defaultTimeZone$(this);
    }

    @Override
    public DayOfWeek MONDAY() {
        return DateConstants.MONDAY$(this);
    }

    @Override
    public DayOfWeek TUESDAY() {
        return DateConstants.TUESDAY$(this);
    }

    @Override
    public DayOfWeek WEDNESDAY() {
        return DateConstants.WEDNESDAY$(this);
    }

    @Override
    public DayOfWeek THURSDAY() {
        return DateConstants.THURSDAY$(this);
    }

    @Override
    public DayOfWeek FRIDAY() {
        return DateConstants.FRIDAY$(this);
    }

    @Override
    public DayOfWeek SATURDAY() {
        return DateConstants.SATURDAY$(this);
    }

    @Override
    public DayOfWeek SUNDAY() {
        return DateConstants.SUNDAY$(this);
    }

    @Override
    public Month JANUARY() {
        return DateConstants.JANUARY$(this);
    }

    @Override
    public Month FEBRUARY() {
        return DateConstants.FEBRUARY$(this);
    }

    @Override
    public Month MARCH() {
        return DateConstants.MARCH$(this);
    }

    @Override
    public Month APRIL() {
        return DateConstants.APRIL$(this);
    }

    @Override
    public Month MAY() {
        return DateConstants.MAY$(this);
    }

    @Override
    public Month JUNE() {
        return DateConstants.JUNE$(this);
    }

    @Override
    public Month JULY() {
        return DateConstants.JULY$(this);
    }

    @Override
    public Month AUGUST() {
        return DateConstants.AUGUST$(this);
    }

    @Override
    public Month SEPTEMBER() {
        return DateConstants.SEPTEMBER$(this);
    }

    @Override
    public Month OCTOBER() {
        return DateConstants.OCTOBER$(this);
    }

    @Override
    public Month NOVEMBER() {
        return DateConstants.NOVEMBER$(this);
    }

    @Override
    public Month DECEMBER() {
        return DateConstants.DECEMBER$(this);
    }

    @Override
    @Documentation(description="Converts ZonedDateTime into epoch (millis from 1970-01-01)")
    public long toEpochMilli(ZonedDateTime zoned) {
        return DateConversions.toEpochMilli$((DateConversions)this, zoned);
    }

    @Override
    @Documentation(description="Converts OffsetDateTime into epoch (millis from 1970-01-01)")
    public long toEpochMilli(OffsetDateTime offset) {
        return DateConversions.toEpochMilli$((DateConversions)this, offset);
    }

    @Override
    @Documentation(description="Converts LocalDateTime at given time zone into epoch (millis from 1970-01-01)")
    public long toEpochMilli(LocalDateTime offset, ZoneId zone) {
        return DateConversions.toEpochMilli$((DateConversions)this, offset, zone);
    }

    @Override
    @Documentation(description="Converts LocalDateTime with given time zone offset into epoch (millis from 1970-01-01)")
    public long toEpochMilli(LocalDateTime offset, ZoneOffset zoneOffset) {
        return DateConversions.toEpochMilli$((DateConversions)this, offset, zoneOffset);
    }

    @Override
    @Documentation(description="Converts epoch (millis from 1970-01-01) into an Instant")
    public Instant toInstant(long timestampMillis) {
        return DateConversions.toInstant$(this, timestampMillis);
    }

    @Override
    @Documentation(description="Converts LocalDateTime at default time zone into an Instant")
    public Instant toInstantAtDefaultTimeZone(LocalDateTime localDateTime) {
        return DateConversions.toInstantAtDefaultTimeZone$(this, localDateTime);
    }

    @Override
    @Documentation(description="Returns LocalDateTime based on LocalDate and LocalTime")
    public LocalDateTime localDateTime(LocalDate date2, LocalTime time) {
        return DateConversions.localDateTime$(this, date2, time);
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Documentation(description="Returns current time as an Instant")
    public Instant now() {
        return Instant.now(this.clock());
    }

    @Documentation(description="Returns current time at given time zone as a ZonedDateTime")
    public ZonedDateTime nowAtZone(ZoneId zoneId) {
        return this.now().atZone(zoneId);
    }

    @Documentation(description="Returns current time with given time zone offset as an OffsetDateTime")
    public OffsetDateTime nowAtOffset(ZoneOffset zoneOffset) {
        return this.now().atOffset(zoneOffset);
    }

    @Documentation(description="Returns current time at default time zone as a ZonedDateTime")
    public ZonedDateTime nowAtDefaultTimeZone() {
        return this.now().atZone(this.clock().getZone());
    }

    @Documentation(description="Returns time zone with given zone id e.g. Europe/Warsaw")
    public ZoneId zone(String zoneId) {
        return ZoneId.of(zoneId);
    }

    @Documentation(description="Returns zone offset with given zone offset id e.g. +01:00")
    public ZoneOffset zoneOffset(String offsetId) {
        return ZoneOffset.of(offsetId);
    }

    public DateUtils(Clock clock) {
        this.clock = clock;
        DateConversions.$init$(this);
        DateConstants.$init$(this);
        DateRangeChecker.$init$(this);
    }
}

