/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.util.functions;

import pl.touk.nussknacker.engine.api.Documentation;
import pl.touk.nussknacker.engine.api.ParamName;
import pl.touk.nussknacker.engine.util.functions.Point;
import scala.Predef$;
import scala.math.package$;
import scala.runtime.RichDouble$;

public final class geo$ {
    public static final geo$ MODULE$ = new geo$();

    @Documentation(description="Calculate distance in km between two points (with decimal coordinates), using haversine algorithm")
    public double distanceInKm(@ParamName(value="first point latitude") Number currentLat, @ParamName(value="first point longitude") Number currentLon, @ParamName(value="second point latitude") Number otherLat, @ParamName(value="first point longitude") Number otherLon) {
        return this.distanceInKm(this.toPoint(currentLat, currentLon), this.toPoint(otherLat, otherLon));
    }

    @Documentation(description="Calculate distance in km between two points (with decimal coordinates), using haversine algorithm")
    public double distanceInKm(@ParamName(value="first point") Point current, @ParamName(value="second point") Point other) {
        double dLat = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(current.lat() - other.lat()));
        double dLon = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(current.lon() - other.lon()));
        double a = package$.MODULE$.pow(package$.MODULE$.sin(dLat / (double)2), 2.0) + package$.MODULE$.pow(package$.MODULE$.sin(dLon / (double)2), 2.0) * package$.MODULE$.cos(RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(current.lon()))) * package$.MODULE$.cos(RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(other.lat())));
        double c = (double)2 * package$.MODULE$.asin(package$.MODULE$.sqrt(a));
        double R = 6372.8;
        return c * R;
    }

    public Point toPoint(Number lat, Number lon) {
        return new Point(lat.doubleValue(), lon.doubleValue());
    }

    private geo$() {
    }
}

