/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.cardinality;

import com.clearspring.analytics.hash.MurmurHash;
import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.clearspring.analytics.util.IBuilder;
import java.io.Serializable;
import java.util.Arrays;

public class LinearCounting
implements ICardinality {
    protected byte[] map;
    protected final int length;
    protected int count;

    public LinearCounting(int size2) {
        this.count = this.length = 8 * size2;
        this.map = new byte[size2];
    }

    public LinearCounting(byte[] map23) {
        this.map = map23;
        this.length = 8 * map23.length;
        this.count = this.computeCount();
    }

    @Override
    public long cardinality() {
        return Math.round((double)this.length * Math.log((double)this.length / (double)this.count));
    }

    @Override
    public byte[] getBytes() {
        return this.map;
    }

    @Override
    public boolean offerHashed(long hashedLong) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offerHashed(int hashedInt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(Object o) {
        int i;
        byte b;
        boolean modified = false;
        long hash2 = MurmurHash.hash(o);
        int bit = (int)((hash2 & 0xFFFFFFFFL) % (long)this.length);
        byte mask = (byte)(1 << bit % 8);
        if ((mask & (b = this.map[i = bit / 8])) == 0) {
            this.map[i] = (byte)(b | mask);
            --this.count;
            modified = true;
        }
        return modified;
    }

    @Override
    public int sizeof() {
        return this.map.length;
    }

    protected int computeCount() {
        int c = 0;
        for (byte b : this.map) {
            c += Integer.bitCount(b & 0xFF);
        }
        return this.length - c;
    }

    public double getUtilization() {
        return (double)(this.length - this.count) / (double)this.length;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isSaturated() {
        return this.count == 0;
    }

    protected String mapAsBitString() {
        StringBuilder sb = new StringBuilder();
        for (byte b : this.map) {
            String bits = Integer.toBinaryString(b);
            for (int i = 0; i < 8 - bits.length(); ++i) {
                sb.append('0');
            }
            sb.append(bits);
        }
        return sb.toString();
    }

    @Override
    public ICardinality merge(ICardinality ... estimators) throws LinearCountingMergeException {
        if (estimators == null) {
            return new LinearCounting(this.map);
        }
        LinearCounting[] lcs = (LinearCounting[])Arrays.copyOf(estimators, estimators.length + 1, LinearCounting[].class);
        lcs[lcs.length - 1] = this;
        return LinearCounting.mergeEstimators(lcs);
    }

    public static LinearCounting mergeEstimators(LinearCounting ... estimators) throws LinearCountingMergeException {
        LinearCounting merged = null;
        if (estimators != null && estimators.length > 0) {
            int size2 = estimators[0].map.length;
            byte[] mergedBytes = new byte[size2];
            for (LinearCounting estimator : estimators) {
                if (estimator.map.length != size2) {
                    throw new LinearCountingMergeException("Cannot merge estimators of different sizes");
                }
                for (int b = 0; b < size2; ++b) {
                    int n = b;
                    mergedBytes[n] = (byte)(mergedBytes[n] | estimator.map[b]);
                }
            }
            merged = new LinearCounting(mergedBytes);
        }
        return merged;
    }

    public static class Builder
    implements IBuilder<ICardinality>,
    Serializable {
        private static final long serialVersionUID = -4245416224034648428L;
        protected static final int[] onePercentErrorLength = new int[]{5034, 5067, 5100, 5133, 5166, 5199, 5231, 5264, 5296, 5329, 5647, 5957, 6260, 6556, 6847, 7132, 7412, 7688, 7960, 10506, 12839, 15036, 17134, 19156, 21117, 23029, 24897, 26729, 43710, 59264, 73999, 88175, 101932, 115359, 128514, 141441, 154171, 274328, 386798, 494794, 599692, 702246, 802931, 902069, 999894, 1096582};
        protected final int size;

        public Builder() {
            this(65536);
        }

        public Builder(int size2) {
            this.size = size2;
        }

        @Override
        public LinearCounting build() {
            return new LinearCounting(this.size);
        }

        @Override
        public int sizeof() {
            return this.size;
        }

        public static Builder onePercentError(int maxCardinality) {
            if (maxCardinality <= 0) {
                throw new IllegalArgumentException("maxCardinality (" + maxCardinality + ") must be a positive integer");
            }
            int length = -1;
            if (maxCardinality < 100) {
                length = onePercentErrorLength[0];
            } else if (maxCardinality < 10000000) {
                int logscale = (int)Math.log10(maxCardinality);
                int scaleValue = (int)Math.pow(10.0, logscale);
                int scaleIndex = maxCardinality / scaleValue;
                int index2 = 9 * (logscale - 2) + (scaleIndex - 1);
                int lowerBound = scaleValue * scaleIndex;
                length = Builder.lerp(lowerBound, onePercentErrorLength[index2], lowerBound + scaleValue, onePercentErrorLength[index2 + 1], maxCardinality);
            } else {
                length = maxCardinality < 50000000 ? Builder.lerp(10000000, 1096582, 50000000, 4584297, maxCardinality) : (maxCardinality < 100000000 ? Builder.lerp(50000000, 4584297, 100000000, 8571013, maxCardinality) : (maxCardinality <= 120000000 ? Builder.lerp(100000000, 8571013, 120000000, 10112529, maxCardinality) : maxCardinality / 12));
            }
            int sz = (int)Math.ceil((double)length / 8.0);
            return new Builder(sz);
        }

        public static Builder withError(double eps, int maxCardinality) {
            int sz = Builder.computeRequiredBitMaskLength(maxCardinality, eps);
            return new Builder((int)Math.ceil((double)sz / 8.0));
        }

        private static int computeRequiredBitMaskLength(double n, double eps) {
            double eq2;
            int m;
            if (eps >= 1.0 || eps <= 0.0) {
                throw new IllegalArgumentException("Epsilon should be in (0, 1) range");
            }
            if (n <= 0.0) {
                throw new IllegalArgumentException("Cardinality should be positive");
            }
            int fromM = 1;
            int toM = 100000000;
            do {
                if ((double)(m = (toM + fromM) / 2) > (eq2 = Builder.precisionInequalityRV(n / (double)m, eps))) {
                    toM = m;
                    continue;
                }
                fromM = m + 1;
            } while (toM > fromM);
            return (double)m > eq2 ? m : m + 1;
        }

        private static double precisionInequalityRV(double t, double eps) {
            return Math.max(1.0 / Math.pow(eps * t, 2.0), 5.0) * (Math.exp(t) - t - 1.0);
        }

        protected static int lerp(int x0, int y0, int x1, int y1, int x) {
            return (int)Math.ceil((double)y0 + (double)(x - x0) * (double)(y1 - y0) / (double)(x1 - x0));
        }
    }

    protected static class LinearCountingMergeException
    extends CardinalityMergeException {
        public LinearCountingMergeException(String message2) {
            super(message2);
        }
    }
}

