/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class Varint {
    private Varint() {
    }

    public static void writeSignedVarLong(long value2, DataOutput out) throws IOException {
        Varint.writeUnsignedVarLong(value2 << 1 ^ value2 >> 63, out);
    }

    public static void writeUnsignedVarLong(long value2, DataOutput out) throws IOException {
        while ((value2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((int)value2 & 0x7F | 0x80);
            value2 >>>= 7;
        }
        out.writeByte((int)value2 & 0x7F);
    }

    public static void writeSignedVarInt(int value2, DataOutput out) throws IOException {
        Varint.writeUnsignedVarInt(value2 << 1 ^ value2 >> 31, out);
    }

    public static void writeUnsignedVarInt(int value2, DataOutput out) throws IOException {
        while ((long)(value2 & 0xFFFFFF80) != 0L) {
            out.writeByte(value2 & 0x7F | 0x80);
            value2 >>>= 7;
        }
        out.writeByte(value2 & 0x7F);
    }

    public static byte[] writeSignedVarInt(int value2) {
        return Varint.writeUnsignedVarInt(value2 << 1 ^ value2 >> 31);
    }

    public static byte[] writeUnsignedVarInt(int value2) {
        byte[] byteArrayList = new byte[10];
        int i = 0;
        while ((long)(value2 & 0xFFFFFF80) != 0L) {
            byteArrayList[i++] = (byte)(value2 & 0x7F | 0x80);
            value2 >>>= 7;
        }
        byteArrayList[i] = (byte)(value2 & 0x7F);
        byte[] out = new byte[i + 1];
        while (i >= 0) {
            out[i] = byteArrayList[i];
            --i;
        }
        return out;
    }

    public static long readSignedVarLong(DataInput in2) throws IOException {
        long raw = Varint.readUnsignedVarLong(in2);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    public static long readUnsignedVarLong(DataInput in2) throws IOException {
        long b;
        long value2 = 0L;
        int i = 0;
        while (((b = (long)in2.readByte()) & 0x80L) != 0L) {
            value2 |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IllegalArgumentException("Variable length quantity is too long");
        }
        return value2 | b << i;
    }

    public static int readSignedVarInt(DataInput in2) throws IOException {
        int raw = Varint.readUnsignedVarInt(in2);
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    public static int readUnsignedVarInt(DataInput in2) throws IOException {
        byte b;
        int value2 = 0;
        int i = 0;
        while (((b = in2.readByte()) & 0x80) != 0) {
            value2 |= (b & 0x7F) << i;
            if ((i += 7) <= 35) continue;
            throw new IllegalArgumentException("Variable length quantity is too long");
        }
        return value2 | b << i;
    }

    public static int readSignedVarInt(byte[] bytes) {
        int raw = Varint.readUnsignedVarInt(bytes);
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    public static int readUnsignedVarInt(byte[] bytes) {
        int value2 = 0;
        int i = 0;
        int rb = -128;
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int j = 0; j < n; ++j) {
            int b;
            rb = b = byArray[j];
            if ((b & 0x80) == 0) break;
            value2 |= (b & 0x7F) << i;
            if ((i += 7) <= 35) continue;
            throw new IllegalArgumentException("Variable length quantity is too long");
        }
        return value2 | rb << i;
    }
}

