/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;

public final class CharSemiIndirectHeaps {
    private CharSemiIndirectHeaps() {
    }

    public static int downHeap(char[] refArray, int[] heap, int size2, int i, CharComparator c) {
        assert (i < size2);
        int e = heap[i];
        char E = refArray[e];
        if (c == null) {
            int child;
            while ((child = (i << 1) + 1) < size2) {
                int t = heap[child];
                int right2 = child + 1;
                if (right2 < size2 && refArray[heap[right2]] < refArray[t]) {
                    child = right2;
                    t = heap[child];
                }
                if (E > refArray[t]) {
                    heap[i] = t;
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = (i << 1) + 1) < size2) {
                int t = heap[child];
                int right3 = child + 1;
                if (right3 < size2 && c.compare(refArray[heap[right3]], refArray[t]) < 0) {
                    child = right3;
                    t = heap[child];
                }
                if (c.compare(E, refArray[t]) > 0) {
                    heap[i] = t;
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        return i;
    }

    public static int upHeap(char[] refArray, int[] heap, int size2, int i, CharComparator c) {
        assert (i < size2);
        int e = heap[i];
        char E = refArray[e];
        if (c == null) {
            int parent;
            int t;
            while (i != 0 && refArray[t = heap[parent = i - 1 >>> 1]] > E) {
                heap[i] = t;
                i = parent;
            }
        } else {
            int parent;
            int t;
            while (i != 0 && c.compare(refArray[t = heap[parent = i - 1 >>> 1]], E) > 0) {
                heap[i] = t;
                i = parent;
            }
        }
        heap[i] = e;
        return i;
    }

    public static void makeHeap(char[] refArray, int offset, int length, int[] heap, CharComparator c) {
        CharArrays.ensureOffsetLength(refArray, offset, length);
        if (heap.length < length) {
            throw new IllegalArgumentException("The heap length (" + heap.length + ") is smaller than the number of elements (" + length + ")");
        }
        int i = length;
        while (i-- != 0) {
            heap[i] = offset + i;
        }
        i = length >>> 1;
        while (i-- != 0) {
            CharSemiIndirectHeaps.downHeap(refArray, heap, length, i, c);
        }
    }

    public static int[] makeHeap(char[] refArray, int offset, int length, CharComparator c) {
        int[] heap = length <= 0 ? IntArrays.EMPTY_ARRAY : new int[length];
        CharSemiIndirectHeaps.makeHeap(refArray, offset, length, heap, c);
        return heap;
    }

    public static void makeHeap(char[] refArray, int[] heap, int size2, CharComparator c) {
        int i = size2 >>> 1;
        while (i-- != 0) {
            CharSemiIndirectHeaps.downHeap(refArray, heap, size2, i, c);
        }
    }

    public static int front(char[] refArray, int[] heap, int size2, int[] a) {
        char top = refArray[heap[0]];
        int j = 0;
        int l = 0;
        int r2 = 1;
        int f = 0;
        for (int i = 0; i < r2; ++i) {
            if (i == f) {
                if (l >= r2) break;
                f = (f << 1) + 1;
                i = l;
                l = -1;
            }
            if (top != refArray[heap[i]]) continue;
            a[j++] = heap[i];
            if (l == -1) {
                l = i * 2 + 1;
            }
            r2 = Math.min(size2, i * 2 + 3);
        }
        return j;
    }

    public static int front(char[] refArray, int[] heap, int size2, int[] a, CharComparator c) {
        char top = refArray[heap[0]];
        int j = 0;
        int l = 0;
        int r2 = 1;
        int f = 0;
        for (int i = 0; i < r2; ++i) {
            if (i == f) {
                if (l >= r2) break;
                f = (f << 1) + 1;
                i = l;
                l = -1;
            }
            if (c.compare(top, refArray[heap[i]]) != 0) continue;
            a[j++] = heap[i];
            if (l == -1) {
                l = i * 2 + 1;
            }
            r2 = Math.min(size2, i * 2 + 3);
        }
        return j;
    }
}

