/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractFloatList
extends AbstractFloatCollection
implements FloatList,
FloatStack {
    protected AbstractFloatList() {
    }

    protected void ensureIndex(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int index2, float k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(float k) {
        this.add(this.size(), k);
        return true;
    }

    @Override
    public float removeFloat(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float set(int index2, float k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index2, Collection<? extends Float> c) {
        this.ensureIndex(index2);
        Iterator<? extends Float> i = c.iterator();
        boolean retVal = i.hasNext();
        while (i.hasNext()) {
            this.add(index2++, i.next().floatValue());
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Float> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public FloatListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public FloatListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public FloatListIterator listIterator(final int index2) {
        this.ensureIndex(index2);
        return new FloatListIterator(){
            int pos;
            int last;
            {
                this.pos = index2;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < AbstractFloatList.this.size();
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public float nextFloat() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractFloatList.this.getFloat(this.last);
            }

            @Override
            public float previousFloat() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractFloatList.this.getFloat(this.pos);
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(float k) {
                AbstractFloatList.this.add(this.pos++, k);
                this.last = -1;
            }

            @Override
            public void set(float k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractFloatList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractFloatList.this.removeFloat(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    @Override
    public boolean contains(float k) {
        return this.indexOf(k) >= 0;
    }

    @Override
    public int indexOf(float k) {
        FloatListIterator i = this.listIterator();
        while (i.hasNext()) {
            float e = i.nextFloat();
            if (Float.floatToIntBits(k) != Float.floatToIntBits(e)) continue;
            return i.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(float k) {
        FloatListIterator i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            float e = i.previousFloat();
            if (Float.floatToIntBits(k) != Float.floatToIntBits(e)) continue;
            return i.nextIndex();
        }
        return -1;
    }

    @Override
    public void size(int size2) {
        int i = this.size();
        if (size2 > i) {
            while (i++ < size2) {
                this.add(0.0f);
            }
        } else {
            while (i-- != size2) {
                this.removeFloat(i);
            }
        }
    }

    @Override
    public FloatList subList(int from2, int to2) {
        this.ensureIndex(from2);
        this.ensureIndex(to2);
        if (from2 > to2) {
            throw new IndexOutOfBoundsException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        return new FloatSubList(this, from2, to2);
    }

    @Override
    public void removeElements(int from2, int to2) {
        this.ensureIndex(to2);
        FloatListIterator i = this.listIterator(from2);
        int n = to2 - from2;
        if (n < 0) {
            throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        while (n-- != 0) {
            i.nextFloat();
            i.remove();
        }
    }

    @Override
    public void addElements(int index2, float[] a, int offset, int length) {
        this.ensureIndex(index2);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        while (length-- != 0) {
            this.add(index2++, a[offset++]);
        }
    }

    @Override
    public void addElements(int index2, float[] a) {
        this.addElements(index2, a, 0, a.length);
    }

    @Override
    public void getElements(int from2, float[] a, int offset, int length) {
        FloatListIterator i = this.listIterator(from2);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        if (from2 + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from2 + length) + ") is greater than list size (" + this.size() + ")");
        }
        while (length-- != 0) {
            a[offset++] = i.nextFloat();
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @Override
    public int hashCode() {
        FloatListIterator i = this.iterator();
        int h = 1;
        int s = this.size();
        while (s-- != 0) {
            float k = i.nextFloat();
            h = 31 * h + HashCommon.float2int(k);
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        if (l instanceof FloatList) {
            FloatListIterator i1 = this.listIterator();
            FloatListIterator i2 = ((FloatList)l).listIterator();
            while (s-- != 0) {
                if (i1.nextFloat() == i2.nextFloat()) continue;
                return false;
            }
            return true;
        }
        FloatListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (s-- != 0) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Float> l) {
        if (l == this) {
            return 0;
        }
        if (l instanceof FloatList) {
            FloatListIterator i1 = this.listIterator();
            FloatListIterator i2 = ((FloatList)l).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                float e2;
                float e1 = i1.nextFloat();
                int r2 = Float.compare(e1, e2 = i2.nextFloat());
                if (r2 == 0) continue;
                return r2;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        FloatListIterator i1 = this.listIterator();
        ListIterator<? extends Float> i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r3 = ((Comparable)i1.next()).compareTo(i2.next());
            if (r3 == 0) continue;
            return r3;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public void push(float o) {
        this.add(o);
    }

    @Override
    public float popFloat() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeFloat(this.size() - 1);
    }

    @Override
    public float topFloat() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getFloat(this.size() - 1);
    }

    @Override
    public float peekFloat(int i) {
        return this.getFloat(this.size() - 1 - i);
    }

    @Override
    public boolean rem(float k) {
        int index2 = this.indexOf(k);
        if (index2 == -1) {
            return false;
        }
        this.removeFloat(index2);
        return true;
    }

    @Override
    public boolean addAll(int index2, FloatCollection c) {
        this.ensureIndex(index2);
        FloatIterator i = c.iterator();
        boolean retVal = i.hasNext();
        while (i.hasNext()) {
            this.add(index2++, i.nextFloat());
        }
        return retVal;
    }

    @Override
    public boolean addAll(int index2, FloatList l) {
        return this.addAll(index2, (FloatCollection)l);
    }

    @Override
    public boolean addAll(FloatCollection c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(FloatList l) {
        return this.addAll(this.size(), l);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        FloatListIterator i = this.iterator();
        int n = this.size();
        boolean first2 = true;
        s.append("[");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s.append(", ");
            }
            float k = i.nextFloat();
            s.append(String.valueOf(k));
        }
        s.append("]");
        return s.toString();
    }

    public static class FloatSubList
    extends AbstractFloatList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final FloatList l;
        protected final int from;
        protected int to;

        public FloatSubList(FloatList l, int from2, int to2) {
            this.l = l;
            this.from = from2;
            this.to = to2;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size());
            assert (this.to <= this.l.size());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(float k) {
            this.l.add(this.to, k);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(int index2, float k) {
            this.ensureIndex(index2);
            this.l.add(this.from + index2, k);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(int index2, Collection<? extends Float> c) {
            this.ensureIndex(index2);
            this.to += c.size();
            return this.l.addAll(this.from + index2, c);
        }

        @Override
        public float getFloat(int index2) {
            this.ensureRestrictedIndex(index2);
            return this.l.getFloat(this.from + index2);
        }

        @Override
        public float removeFloat(int index2) {
            this.ensureRestrictedIndex(index2);
            --this.to;
            return this.l.removeFloat(this.from + index2);
        }

        @Override
        public float set(int index2, float k) {
            this.ensureRestrictedIndex(index2);
            return this.l.set(this.from + index2, k);
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int from2, float[] a, int offset, int length) {
            this.ensureIndex(from2);
            if (from2 + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from2 + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from2, a, offset, length);
        }

        @Override
        public void removeElements(int from2, int to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            this.l.removeElements(this.from + from2, this.from + to2);
            this.to -= to2 - from2;
            assert (this.assertRange());
        }

        @Override
        public void addElements(int index2, float[] a, int offset, int length) {
            this.ensureIndex(index2);
            this.l.addElements(this.from + index2, a, offset, length);
            this.to += length;
            assert (this.assertRange());
        }

        @Override
        public FloatListIterator listIterator(final int index2) {
            this.ensureIndex(index2);
            return new FloatListIterator(){
                int pos;
                int last;
                {
                    this.pos = index2;
                    this.last = -1;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < this.size();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                @Override
                public float nextFloat() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return l.getFloat(from + this.last);
                }

                @Override
                public float previousFloat() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return l.getFloat(from + this.pos);
                }

                @Override
                public int nextIndex() {
                    return this.pos;
                }

                @Override
                public int previousIndex() {
                    return this.pos - 1;
                }

                @Override
                public void add(float k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.add(this.pos++, k);
                    this.last = -1;
                    assert (this.assertRange());
                }

                @Override
                public void set(float k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.set(this.last, k);
                }

                @Override
                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.removeFloat(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                    assert (this.assertRange());
                }
            };
        }

        @Override
        public FloatList subList(int from2, int to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            if (from2 > to2) {
                throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
            }
            return new FloatSubList(this, from2, to2);
        }

        @Override
        public boolean rem(float k) {
            int index2 = this.indexOf(k);
            if (index2 == -1) {
                return false;
            }
            --this.to;
            this.l.removeFloat(this.from + index2);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(int index2, FloatCollection c) {
            this.ensureIndex(index2);
            return super.addAll(index2, c);
        }

        @Override
        public boolean addAll(int index2, FloatList l) {
            this.ensureIndex(index2);
            return super.addAll(index2, l);
        }
    }
}

