/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentRuntimeException;

public class ConcurrentUtils {
    private ConcurrentUtils() {
    }

    public static ConcurrentException extractCause(ExecutionException ex) {
        if (ex == null || ex.getCause() == null) {
            return null;
        }
        ConcurrentUtils.throwCause(ex);
        return new ConcurrentException(ex.getMessage(), ex.getCause());
    }

    public static ConcurrentRuntimeException extractCauseUnchecked(ExecutionException ex) {
        if (ex == null || ex.getCause() == null) {
            return null;
        }
        ConcurrentUtils.throwCause(ex);
        return new ConcurrentRuntimeException(ex.getMessage(), ex.getCause());
    }

    public static void handleCause(ExecutionException ex) throws ConcurrentException {
        ConcurrentException cex = ConcurrentUtils.extractCause(ex);
        if (cex != null) {
            throw cex;
        }
    }

    public static void handleCauseUnchecked(ExecutionException ex) {
        ConcurrentRuntimeException crex = ConcurrentUtils.extractCauseUnchecked(ex);
        if (crex != null) {
            throw crex;
        }
    }

    static Throwable checkedException(Throwable ex) {
        Validate.isTrue(ex != null && !(ex instanceof RuntimeException) && !(ex instanceof Error), "Not a checked exception: " + ex, new Object[0]);
        return ex;
    }

    private static void throwCause(ExecutionException ex) {
        if (ex.getCause() instanceof RuntimeException) {
            throw (RuntimeException)ex.getCause();
        }
        if (ex.getCause() instanceof Error) {
            throw (Error)ex.getCause();
        }
    }

    public static <T> T initialize(ConcurrentInitializer<T> initializer) throws ConcurrentException {
        return initializer != null ? (T)initializer.get() : null;
    }

    public static <T> T initializeUnchecked(ConcurrentInitializer<T> initializer) {
        try {
            return ConcurrentUtils.initialize(initializer);
        }
        catch (ConcurrentException cex) {
            throw new ConcurrentRuntimeException(cex.getCause());
        }
    }

    public static <K, V> V putIfAbsent(ConcurrentMap<K, V> map23, K key, V value2) {
        if (map23 == null) {
            return null;
        }
        V result2 = map23.putIfAbsent(key, value2);
        return result2 != null ? result2 : value2;
    }

    public static <K, V> V createIfAbsent(ConcurrentMap<K, V> map23, K key, ConcurrentInitializer<V> init2) throws ConcurrentException {
        if (map23 == null || init2 == null) {
            return null;
        }
        Object value2 = map23.get(key);
        if (value2 == null) {
            return ConcurrentUtils.putIfAbsent(map23, key, init2.get());
        }
        return value2;
    }

    public static <K, V> V createIfAbsentUnchecked(ConcurrentMap<K, V> map23, K key, ConcurrentInitializer<V> init2) {
        try {
            return ConcurrentUtils.createIfAbsent(map23, key, init2);
        }
        catch (ConcurrentException cex) {
            throw new ConcurrentRuntimeException(cex.getCause());
        }
    }

    public static <T> Future<T> constantFuture(T value2) {
        return new ConstantFuture<T>(value2);
    }

    static final class ConstantFuture<T>
    implements Future<T> {
        private final T value;

        ConstantFuture(T value2) {
            this.value = value2;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public T get(long timeout, TimeUnit unit2) {
            return this.value;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }
    }
}

