/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.SimilarityScore;

public class LongestCommonSubsequence
implements SimilarityScore<Integer> {
    @Override
    public Integer apply(CharSequence left2, CharSequence right2) {
        if (left2 == null || right2 == null) {
            throw new IllegalArgumentException("Inputs must not be null");
        }
        return this.longestCommonSubsequence(left2, right2).length();
    }

    @Deprecated
    public CharSequence logestCommonSubsequence(CharSequence left2, CharSequence right2) {
        return this.longestCommonSubsequence(left2, right2);
    }

    public CharSequence longestCommonSubsequence(CharSequence left2, CharSequence right2) {
        if (left2 == null || right2 == null) {
            throw new IllegalArgumentException("Inputs must not be null");
        }
        StringBuilder longestCommonSubstringArray = new StringBuilder(Math.max(left2.length(), right2.length()));
        int[][] lcsLengthArray = this.longestCommonSubstringLengthArray(left2, right2);
        int i = left2.length() - 1;
        int j = right2.length() - 1;
        int k = lcsLengthArray[left2.length()][right2.length()] - 1;
        while (k >= 0) {
            if (left2.charAt(i) == right2.charAt(j)) {
                longestCommonSubstringArray.append(left2.charAt(i));
                --i;
                --j;
                --k;
                continue;
            }
            if (lcsLengthArray[i + 1][j] < lcsLengthArray[i][j + 1]) {
                --i;
                continue;
            }
            --j;
        }
        return longestCommonSubstringArray.reverse().toString();
    }

    public int[][] longestCommonSubstringLengthArray(CharSequence left2, CharSequence right2) {
        int[][] lcsLengthArray = new int[left2.length() + 1][right2.length() + 1];
        for (int i = 0; i < left2.length(); ++i) {
            for (int j = 0; j < right2.length(); ++j) {
                if (i == 0) {
                    lcsLengthArray[i][j] = 0;
                }
                if (j == 0) {
                    lcsLengthArray[i][j] = 0;
                }
                lcsLengthArray[i + 1][j + 1] = left2.charAt(i) == right2.charAt(j) ? lcsLengthArray[i][j] + 1 : Math.max(lcsLengthArray[i + 1][j], lcsLengthArray[i][j + 1]);
            }
        }
        return lcsLengthArray;
    }
}

