/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.lang3.Validate;
import org.apache.commons.text.similarity.SimilarityScore;

public class SimilarityScoreFrom<R> {
    private final SimilarityScore<R> similarityScore;
    private final CharSequence left;

    public SimilarityScoreFrom(SimilarityScore<R> similarityScore, CharSequence left2) {
        Validate.isTrue(similarityScore != null, "The edit distance may not be null.", new Object[0]);
        this.similarityScore = similarityScore;
        this.left = left2;
    }

    public R apply(CharSequence right2) {
        return this.similarityScore.apply(this.left, right2);
    }

    public CharSequence getLeft() {
        return this.left;
    }

    public SimilarityScore<R> getSimilarityScore() {
        return this.similarityScore;
    }
}

