/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.HashMap;
import java.util.function.Consumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.table.descriptors.ConnectorDescriptorValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;

@Internal
public class KafkaValidator
extends ConnectorDescriptorValidator {
    public static final String CONNECTOR_TYPE_VALUE_KAFKA = "kafka";
    public static final String CONNECTOR_VERSION_VALUE_08 = "0.8";
    public static final String CONNECTOR_VERSION_VALUE_09 = "0.9";
    public static final String CONNECTOR_VERSION_VALUE_010 = "0.10";
    public static final String CONNECTOR_VERSION_VALUE_011 = "0.11";
    public static final String CONNECTOR_VERSION_VALUE_UNIVERSAL = "universal";
    public static final String CONNECTOR_TOPIC = "connector.topic";
    public static final String CONNECTOR_STARTUP_MODE = "connector.startup-mode";
    public static final String CONNECTOR_STARTUP_MODE_VALUE_EARLIEST = "earliest-offset";
    public static final String CONNECTOR_STARTUP_MODE_VALUE_LATEST = "latest-offset";
    public static final String CONNECTOR_STARTUP_MODE_VALUE_GROUP_OFFSETS = "group-offsets";
    public static final String CONNECTOR_STARTUP_MODE_VALUE_SPECIFIC_OFFSETS = "specific-offsets";
    public static final String CONNECTOR_SPECIFIC_OFFSETS = "connector.specific-offsets";
    public static final String CONNECTOR_SPECIFIC_OFFSETS_PARTITION = "partition";
    public static final String CONNECTOR_SPECIFIC_OFFSETS_OFFSET = "offset";
    public static final String CONNECTOR_PROPERTIES = "connector.properties";
    public static final String CONNECTOR_PROPERTIES_KEY = "key";
    public static final String CONNECTOR_PROPERTIES_VALUE = "value";
    public static final String CONNECTOR_SINK_PARTITIONER = "connector.sink-partitioner";
    public static final String CONNECTOR_SINK_PARTITIONER_VALUE_FIXED = "fixed";
    public static final String CONNECTOR_SINK_PARTITIONER_VALUE_ROUND_ROBIN = "round-robin";
    public static final String CONNECTOR_SINK_PARTITIONER_VALUE_CUSTOM = "custom";
    public static final String CONNECTOR_SINK_PARTITIONER_CLASS = "connector.sink-partitioner-class";

    public void validate(DescriptorProperties properties2) {
        super.validate(properties2);
        properties2.validateValue("connector.type", CONNECTOR_TYPE_VALUE_KAFKA, false);
        properties2.validateString(CONNECTOR_TOPIC, false, 1, Integer.MAX_VALUE);
        this.validateStartupMode(properties2);
        this.validateKafkaProperties(properties2);
        this.validateSinkPartitioner(properties2);
    }

    private void validateStartupMode(DescriptorProperties properties2) {
        HashMap<String, Consumer<String>> specificOffsetValidators = new HashMap<String, Consumer<String>>();
        specificOffsetValidators.put(CONNECTOR_SPECIFIC_OFFSETS_PARTITION, key -> properties2.validateInt(key, false, 0, Integer.MAX_VALUE));
        specificOffsetValidators.put(CONNECTOR_SPECIFIC_OFFSETS_OFFSET, key -> properties2.validateLong(key, false, 0L, Long.MAX_VALUE));
        HashMap<String, Consumer<String>> startupModeValidation = new HashMap<String, Consumer<String>>();
        startupModeValidation.put(CONNECTOR_STARTUP_MODE_VALUE_GROUP_OFFSETS, DescriptorProperties.noValidation());
        startupModeValidation.put(CONNECTOR_STARTUP_MODE_VALUE_EARLIEST, DescriptorProperties.noValidation());
        startupModeValidation.put(CONNECTOR_STARTUP_MODE_VALUE_LATEST, DescriptorProperties.noValidation());
        startupModeValidation.put(CONNECTOR_STARTUP_MODE_VALUE_SPECIFIC_OFFSETS, key -> properties2.validateFixedIndexedProperties(CONNECTOR_SPECIFIC_OFFSETS, false, specificOffsetValidators));
        properties2.validateEnum(CONNECTOR_STARTUP_MODE, true, startupModeValidation);
    }

    private void validateKafkaProperties(DescriptorProperties properties2) {
        HashMap<String, Consumer<String>> propertyValidators = new HashMap<String, Consumer<String>>();
        propertyValidators.put(CONNECTOR_PROPERTIES_KEY, key -> properties2.validateString(key, false, 1));
        propertyValidators.put(CONNECTOR_PROPERTIES_VALUE, key -> properties2.validateString(key, false, 0));
        properties2.validateFixedIndexedProperties(CONNECTOR_PROPERTIES, true, propertyValidators);
    }

    private void validateSinkPartitioner(DescriptorProperties properties2) {
        HashMap<String, Consumer<String>> sinkPartitionerValidators = new HashMap<String, Consumer<String>>();
        sinkPartitionerValidators.put(CONNECTOR_SINK_PARTITIONER_VALUE_FIXED, DescriptorProperties.noValidation());
        sinkPartitionerValidators.put(CONNECTOR_SINK_PARTITIONER_VALUE_ROUND_ROBIN, DescriptorProperties.noValidation());
        sinkPartitionerValidators.put(CONNECTOR_SINK_PARTITIONER_VALUE_CUSTOM, key -> properties2.validateString(CONNECTOR_SINK_PARTITIONER_CLASS, false, 1));
        properties2.validateEnum(CONNECTOR_SINK_PARTITIONER, true, sinkPartitionerValidators);
    }

    public static String normalizeStartupMode(StartupMode startupMode) {
        switch (startupMode) {
            case EARLIEST: {
                return CONNECTOR_STARTUP_MODE_VALUE_EARLIEST;
            }
            case LATEST: {
                return CONNECTOR_STARTUP_MODE_VALUE_LATEST;
            }
            case GROUP_OFFSETS: {
                return CONNECTOR_STARTUP_MODE_VALUE_GROUP_OFFSETS;
            }
            case SPECIFIC_OFFSETS: {
                return CONNECTOR_STARTUP_MODE_VALUE_SPECIFIC_OFFSETS;
            }
        }
        throw new IllegalArgumentException("Invalid startup mode.");
    }
}

