/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class CreatePartitionsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<CreatePartitionsTopicResult> results;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public CreatePartitionsResponseData(Readable readable, short version) {
        this.results = new ArrayList<CreatePartitionsTopicResult>();
        this.read(readable, version);
    }

    public CreatePartitionsResponseData(Struct struct, short version) {
        this.results = new ArrayList<CreatePartitionsTopicResult>();
        this.fromStruct(struct, version);
    }

    public CreatePartitionsResponseData() {
        this.throttleTimeMs = 0;
        this.results = new ArrayList<CreatePartitionsTopicResult>();
    }

    @Override
    public short apiKey() {
        return 37;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.results.clear();
        } else {
            this.results.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.results.add(new CreatePartitionsTopicResult(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeInt(this.results.size());
        for (CreatePartitionsTopicResult element : this.results) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] nestedObjects = struct.getArray("results");
        this.results = new ArrayList<CreatePartitionsTopicResult>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.results.add(new CreatePartitionsTopicResult((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] nestedObjects = new Struct[this.results.size()];
        int i = 0;
        for (CreatePartitionsTopicResult element : this.results) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("results", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size2 = 0;
        size2 += 4;
        size2 += 4;
        for (CreatePartitionsTopicResult element : this.results) {
            size2 += element.size(version);
        }
        return size2;
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof CreatePartitionsResponseData)) {
            return false;
        }
        CreatePartitionsResponseData other = (CreatePartitionsResponseData)obj2;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.results == null ? other.results != null : !this.results.equals(other.results));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    public String toString() {
        return "CreatePartitionsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<CreatePartitionsTopicResult> results() {
        return this.results;
    }

    public CreatePartitionsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public CreatePartitionsResponseData setResults(List<CreatePartitionsTopicResult> v) {
        this.results = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new ArrayOf(CreatePartitionsTopicResult.SCHEMA_0), "The partition creation results for each topic."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class CreatePartitionsTopicResult
    implements Message {
        private String name;
        private short errorCode;
        private String errorMessage;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public CreatePartitionsTopicResult(Readable readable, short version) {
            this.read(readable, version);
        }

        public CreatePartitionsTopicResult(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public CreatePartitionsTopicResult() {
            this.name = "";
            this.errorCode = 0;
            this.errorMessage = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            this.errorCode = readable.readShort();
            this.errorMessage = readable.readNullableString();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeShort(this.errorCode);
            writable.writeNullableString(this.errorMessage);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = struct.getString("error_message");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("error_message", (Object)this.errorMessage);
            return struct;
        }

        @Override
        public int size(short version) {
            int size2 = 0;
            size2 += 2;
            size2 += MessageUtil.serializedUtf8Length(this.name);
            size2 += 2;
            size2 += 2;
            if (this.errorMessage != null) {
                size2 += MessageUtil.serializedUtf8Length(this.errorMessage);
            }
            return size2;
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof CreatePartitionsTopicResult)) {
                return false;
            }
            CreatePartitionsTopicResult other = (CreatePartitionsTopicResult)obj2;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            return !(this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            return hashCode;
        }

        public String toString() {
            return "CreatePartitionsTopicResult(name='" + this.name + "', errorCode=" + this.errorCode + ", errorMessage='" + this.errorMessage + "')";
        }

        public String name() {
            return this.name;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public CreatePartitionsTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public CreatePartitionsTopicResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public CreatePartitionsTopicResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("error_code", Type.INT16, "The result error, or zero if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The result message, or null if there was no error."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

