/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class FindCoordinatorResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private String errorMessage;
    private int nodeId;
    private String host;
    private int port;
    public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("node_id", Type.INT32, "The node id."), new Field("host", Type.STRING, "The host name."), new Field("port", Type.INT32, "The port."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public FindCoordinatorResponseData(Readable readable, short version) {
        this.read(readable, version);
    }

    public FindCoordinatorResponseData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public FindCoordinatorResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.nodeId = 0;
        this.host = "";
        this.port = 0;
    }

    @Override
    public short apiKey() {
        return 10;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = version >= 1 ? readable.readInt() : 0;
        this.errorCode = readable.readShort();
        this.errorMessage = version >= 1 ? readable.readNullableString() : "";
        this.nodeId = readable.readInt();
        this.host = readable.readNullableString();
        this.port = readable.readInt();
    }

    @Override
    public void write(Writable writable, short version) {
        if (version >= 1) {
            writable.writeInt(this.throttleTimeMs);
        }
        writable.writeShort(this.errorCode);
        if (version >= 1) {
            writable.writeNullableString(this.errorMessage);
        }
        writable.writeInt(this.nodeId);
        writable.writeString(this.host);
        writable.writeInt(this.port);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        this.errorCode = struct.getShort("error_code");
        this.errorMessage = version >= 1 ? struct.getString("error_message") : "";
        this.nodeId = struct.getInt("node_id");
        this.host = struct.getString("host");
        this.port = struct.getInt("port");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        struct.set("error_code", (Object)this.errorCode);
        if (version >= 1) {
            struct.set("error_message", (Object)this.errorMessage);
        }
        struct.set("node_id", (Object)this.nodeId);
        struct.set("host", (Object)this.host);
        struct.set("port", (Object)this.port);
        return struct;
    }

    @Override
    public int size(short version) {
        int size2 = 0;
        if (version >= 1) {
            size2 += 4;
        }
        size2 += 2;
        if (version >= 1) {
            size2 += 2;
            if (this.errorMessage != null) {
                size2 += MessageUtil.serializedUtf8Length(this.errorMessage);
            }
        }
        size2 += 4;
        size2 += 2;
        size2 += MessageUtil.serializedUtf8Length(this.host);
        return size2 += 4;
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof FindCoordinatorResponseData)) {
            return false;
        }
        FindCoordinatorResponseData other = (FindCoordinatorResponseData)obj2;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.nodeId != other.nodeId) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        return this.port == other.port;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + this.nodeId;
        hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
        hashCode = 31 * hashCode + this.port;
        return hashCode;
    }

    public String toString() {
        return "FindCoordinatorResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage='" + this.errorMessage + "', nodeId=" + this.nodeId + ", host='" + this.host + "', port=" + this.port + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public int nodeId() {
        return this.nodeId;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public FindCoordinatorResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public FindCoordinatorResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public FindCoordinatorResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public FindCoordinatorResponseData setNodeId(int v) {
        this.nodeId = v;
        return this;
    }

    public FindCoordinatorResponseData setHost(String v) {
        this.host = v;
        return this;
    }

    public FindCoordinatorResponseData setPort(int v) {
        this.port = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("node_id", Type.INT32, "The node id."), new Field("host", Type.STRING, "The host name."), new Field("port", Type.INT32, "The port."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }
}

