/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class LeaveGroupRequestData
implements ApiMessage {
    private String groupId;
    private String memberId;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public LeaveGroupRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public LeaveGroupRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public LeaveGroupRequestData() {
        this.groupId = "";
        this.memberId = "";
    }

    @Override
    public short apiKey() {
        return 13;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable readable, short version) {
        this.groupId = readable.readNullableString();
        this.memberId = readable.readNullableString();
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeString(this.groupId);
        writable.writeString(this.memberId);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.groupId = struct.getString("group_id");
        this.memberId = struct.getString("member_id");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("group_id", (Object)this.groupId);
        struct.set("member_id", (Object)this.memberId);
        return struct;
    }

    @Override
    public int size(short version) {
        int size2 = 0;
        size2 += 2;
        size2 += MessageUtil.serializedUtf8Length(this.groupId);
        size2 += 2;
        return size2 += MessageUtil.serializedUtf8Length(this.memberId);
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof LeaveGroupRequestData)) {
            return false;
        }
        LeaveGroupRequestData other = (LeaveGroupRequestData)obj2;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        return hashCode;
    }

    public String toString() {
        return "LeaveGroupRequestData(groupId='" + this.groupId + "', memberId='" + this.memberId + "')";
    }

    public String groupId() {
        return this.groupId;
    }

    public String memberId() {
        return this.memberId;
    }

    public LeaveGroupRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public LeaveGroupRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("group_id", Type.STRING, "The ID of the group to leave."), new Field("member_id", Type.STRING, "The member ID to remove from the group.")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }
}

