/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransportLayers;
import org.apache.kafka.common.record.BaseRecords;

public abstract class RecordsSend<T extends BaseRecords>
implements Send {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    private final String destination;
    private final T records;
    private final int maxBytesToWrite;
    private int remaining;
    private boolean pending = false;

    protected RecordsSend(String destination, T records, int maxBytesToWrite) {
        this.destination = destination;
        this.records = records;
        this.maxBytesToWrite = maxBytesToWrite;
        this.remaining = maxBytesToWrite;
    }

    @Override
    public String destination() {
        return this.destination;
    }

    @Override
    public boolean completed() {
        return this.remaining <= 0 && !this.pending;
    }

    @Override
    public final long writeTo(GatheringByteChannel channel) throws IOException {
        long written2 = 0L;
        if (this.remaining > 0) {
            written2 = this.writeTo(channel, this.size() - (long)this.remaining, this.remaining);
            if (written2 < 0L) {
                throw new EOFException("Wrote negative bytes to channel. This shouldn't happen.");
            }
            this.remaining = (int)((long)this.remaining - written2);
        }
        this.pending = TransportLayers.hasPendingWrites(channel);
        if (this.remaining <= 0 && this.pending) {
            channel.write(EMPTY_BYTE_BUFFER);
        }
        return written2;
    }

    @Override
    public long size() {
        return this.maxBytesToWrite;
    }

    protected T records() {
        return this.records;
    }

    protected abstract long writeTo(GatheringByteChannel var1, long var2, int var4) throws IOException;
}

