/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.server.HsqlSocketFactory;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.TimestampData;

public class ClientConnection
implements SessionInterface,
Cloneable {
    public static final String NETWORK_COMPATIBILITY_VERSION = "2.3.4.0";
    public static final int NETWORK_COMPATIBILITY_VERSION_INT = -2030400;
    static final int BUFFER_SIZE = 4096;
    final byte[] mainBuffer = new byte[4096];
    private boolean isClosed;
    private Socket socket;
    protected DataOutputStream dataOutput;
    protected DataInputStream dataInput;
    protected RowOutputInterface rowOut;
    protected RowInputBinary rowIn;
    private Result resultOut;
    private long sessionID;
    private long lobIDSequence = -1L;
    protected int randomID;
    private boolean isReadOnlyDefault = false;
    private boolean isAutoCommit = true;
    private int zoneSeconds;
    private Scanner scanner;
    private String zoneString;
    private Calendar calendar;
    private Calendar calendarGMT;
    SimpleDateFormat simpleDateFormatGMT;
    JDBCConnection connection;
    String host;
    int port;
    String path;
    String database;
    boolean isTLS;
    boolean isTLSWrapper;
    int databaseID;
    String clientPropertiesString;
    HsqlProperties clientProperties;
    String databaseUniqueName;

    public ClientConnection(String string2, int n, String string3, String string4, boolean bl, boolean bl2, String string5, String string6, int n2) {
        this.host = string2;
        this.port = n;
        this.path = string3;
        this.database = string4;
        this.isTLS = bl;
        this.isTLSWrapper = bl2;
        this.zoneSeconds = n2;
        this.zoneString = TimeZone.getDefault().getID();
        this.initStructures();
        this.initConnection(string2, n, bl);
        Result result2 = Result.newConnectionAttemptRequest(string5, string6, string4, this.zoneString, n2);
        Result result3 = this.execute(result2);
        if (result3.isError()) {
            throw Error.error(result3);
        }
        this.sessionID = result3.getSessionId();
        this.databaseID = result3.getDatabaseId();
        this.databaseUniqueName = result3.getDatabaseName();
        this.clientPropertiesString = result3.getMainString();
        this.randomID = result3.getSessionRandomID();
    }

    protected ClientConnection(ClientConnection clientConnection) {
        this.host = clientConnection.host;
        this.port = clientConnection.port;
        this.path = clientConnection.path;
        this.database = clientConnection.database;
        this.isTLS = clientConnection.isTLS;
        this.isTLSWrapper = clientConnection.isTLSWrapper;
        this.zoneSeconds = clientConnection.zoneSeconds;
        this.zoneString = clientConnection.zoneString;
        this.sessionID = clientConnection.sessionID;
        this.databaseID = clientConnection.databaseID;
        this.databaseUniqueName = clientConnection.databaseUniqueName;
        this.clientPropertiesString = clientConnection.clientPropertiesString;
        this.randomID = clientConnection.randomID;
        this.initStructures();
        this.initConnection(this.host, this.port, this.isTLS);
    }

    private void initStructures() {
        RowOutputBinary rowOutputBinary = new RowOutputBinary(this.mainBuffer);
        this.rowOut = rowOutputBinary;
        this.rowIn = new RowInputBinary(rowOutputBinary);
        this.resultOut = Result.newSessionAttributesResult();
    }

    protected void initConnection(String string2, int n, boolean bl) {
        this.openConnection(string2, n, bl);
    }

    protected void openConnection(String string2, int n, boolean bl) {
        try {
            if (this.isTLSWrapper) {
                this.socket = HsqlSocketFactory.getInstance(false).createSocket(string2, n);
            }
            this.socket = HsqlSocketFactory.getInstance(bl).createSocket(this.socket, string2, n);
            this.socket.setTcpNoDelay(true);
            this.dataOutput = new DataOutputStream(this.socket.getOutputStream());
            this.dataInput = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.handshake();
        }
        catch (Exception exception) {
            throw new HsqlException(exception, Error.getStateString(1301), -1301);
        }
    }

    protected void closeConnection() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    @Override
    public synchronized Result execute(Result result2) {
        if (this.isClosed) {
            return Result.newErrorResult(Error.error(1353));
        }
        try {
            result2.setSessionId(this.sessionID);
            result2.setDatabaseId(this.databaseID);
            this.write(result2);
            return this.read();
        }
        catch (Throwable throwable) {
            throw Error.error(1305, throwable.toString());
        }
    }

    @Override
    public synchronized RowSetNavigatorClient getRows(long l, int n, int n2) {
        try {
            this.resultOut.setResultType(13);
            this.resultOut.setResultId(l);
            this.resultOut.setUpdateCount(n);
            this.resultOut.setFetchSize(n2);
            Result result2 = this.execute(this.resultOut);
            return (RowSetNavigatorClient)result2.getNavigator();
        }
        catch (Throwable throwable) {
            throw Error.error(1305, throwable.toString());
        }
    }

    @Override
    public synchronized void closeNavigator(long l) {
        try {
            this.resultOut.setResultType(40);
            this.resultOut.setResultId(l);
            this.execute(this.resultOut);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        try {
            this.resultOut.setResultType(32);
            this.execute(this.resultOut);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isClosed = true;
    }

    @Override
    public synchronized Object getAttribute(int n) {
        this.resultOut.setResultType(7);
        this.resultOut.setStatementType(n);
        Result result2 = this.execute(this.resultOut);
        if (result2.isError()) {
            throw Error.error(result2);
        }
        Object[] objectArray = result2.getSingleRowData();
        switch (n) {
            case 1: {
                return objectArray[2];
            }
            case 2: {
                return objectArray[2];
            }
            case 0: {
                return objectArray[1];
            }
            case 3: {
                return objectArray[3];
            }
        }
        return null;
    }

    @Override
    public synchronized void setAttribute(int n, Object object) {
        this.resultOut.setResultType(6);
        Object[] objectArray = this.resultOut.getSingleRowData();
        objectArray[0] = ValuePool.getInt(n);
        switch (n) {
            case 1: 
            case 2: {
                objectArray[2] = object;
                break;
            }
            case 0: {
                objectArray[1] = object;
                break;
            }
            case 3: {
                objectArray[3] = object;
                break;
            }
        }
        Result result2 = this.execute(this.resultOut);
        if (result2.isError()) {
            throw Error.error(result2);
        }
    }

    @Override
    public synchronized boolean isReadOnlyDefault() {
        Object object = this.getAttribute(2);
        this.isReadOnlyDefault = (Boolean)object;
        return this.isReadOnlyDefault;
    }

    @Override
    public synchronized void setReadOnlyDefault(boolean bl) {
        if (bl != this.isReadOnlyDefault) {
            this.setAttribute(2, bl ? Boolean.TRUE : Boolean.FALSE);
            this.isReadOnlyDefault = bl;
        }
    }

    @Override
    public synchronized boolean isAutoCommit() {
        Object object = this.getAttribute(1);
        this.isAutoCommit = (Boolean)object;
        return this.isAutoCommit;
    }

    @Override
    public synchronized void setAutoCommit(boolean bl) {
        if (bl != this.isAutoCommit) {
            this.setAttribute(1, bl ? Boolean.TRUE : Boolean.FALSE);
            this.isAutoCommit = bl;
        }
    }

    @Override
    public synchronized void setIsolationDefault(int n) {
        this.setAttribute(0, ValuePool.getInt(n));
    }

    @Override
    public synchronized int getIsolation() {
        Object object = this.getAttribute(0);
        return (Integer)object;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public Session getSession() {
        return null;
    }

    @Override
    public synchronized void startPhasedTransaction() {
    }

    @Override
    public synchronized void prepareCommit() {
        this.resultOut.setAsTransactionEndRequest(12, null);
        Result result2 = this.execute(this.resultOut);
        if (result2.isError()) {
            throw Error.error(result2);
        }
    }

    @Override
    public synchronized void commit(boolean bl) {
        this.resultOut.setAsTransactionEndRequest(0, null);
        Result result2 = this.execute(this.resultOut);
        if (result2.isError()) {
            throw Error.error(result2);
        }
    }

    @Override
    public synchronized void rollback(boolean bl) {
        this.resultOut.setAsTransactionEndRequest(1, null);
        Result result2 = this.execute(this.resultOut);
        if (result2.isError()) {
            throw Error.error(result2);
        }
    }

    @Override
    public synchronized void rollbackToSavepoint(String string2) {
        this.resultOut.setAsTransactionEndRequest(2, string2);
        Result result2 = this.execute(this.resultOut);
        if (result2.isError()) {
            throw Error.error(result2);
        }
    }

    @Override
    public synchronized void savepoint(String string2) {
        Result result2 = Result.newSetSavepointRequest(string2);
        Result result3 = this.execute(result2);
        if (result3.isError()) {
            throw Error.error(result3);
        }
    }

    @Override
    public synchronized void releaseSavepoint(String string2) {
        this.resultOut.setAsTransactionEndRequest(4, string2);
        Result result2 = this.execute(this.resultOut);
        if (result2.isError()) {
            throw Error.error(result2);
        }
    }

    @Override
    public void addWarning(HsqlException hsqlException) {
    }

    @Override
    public synchronized long getId() {
        return this.sessionID;
    }

    @Override
    public int getRandomId() {
        return this.randomID;
    }

    @Override
    public synchronized void resetSession() {
        Result result2 = Result.newResetSessionRequest();
        Result result3 = this.execute(result2);
        if (result3.isError()) {
            this.isClosed = true;
            this.closeConnection();
            throw Error.error(result3);
        }
        this.sessionID = result3.getSessionId();
        this.databaseID = result3.getDatabaseId();
    }

    protected void write(Result result2) throws IOException, HsqlException {
        result2.write(this, this.dataOutput, this.rowOut);
    }

    protected Result read() throws IOException, HsqlException {
        Result result2 = Result.newResult(this.dataInput, this.rowIn);
        result2.readAdditionalResults(this, this.dataInput, this.rowIn);
        this.rowOut.reset(this.mainBuffer);
        this.rowIn.resetRow(this.mainBuffer.length);
        return result2;
    }

    @Override
    public synchronized String getInternalConnectionURL() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result cancel(Result result2) {
        ClientConnection clientConnection = new ClientConnection(this);
        try {
            Result result3 = clientConnection.execute(result2);
            return result3;
        }
        finally {
            clientConnection.closeConnection();
        }
    }

    public synchronized long getLobId() {
        return this.lobIDSequence--;
    }

    @Override
    public BlobDataID createBlob(long l) {
        BlobDataID blobDataID = new BlobDataID(this.getLobId());
        return blobDataID;
    }

    @Override
    public ClobDataID createClob(long l) {
        ClobDataID clobDataID = new ClobDataID(this.getLobId());
        return clobDataID;
    }

    @Override
    public void allocateResultLob(ResultLob resultLob, InputStream inputStream) {
    }

    @Override
    public Scanner getScanner() {
        if (this.scanner == null) {
            this.scanner = new Scanner();
        }
        return this.scanner;
    }

    @Override
    public Calendar getCalendar() {
        if (this.calendar == null) {
            TimeZone timeZone = TimeZone.getTimeZone(this.zoneString);
            this.calendar = new GregorianCalendar(timeZone);
        }
        return this.calendar;
    }

    @Override
    public Calendar getCalendarGMT() {
        if (this.calendarGMT == null) {
            this.calendarGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"), HsqlDateTime.defaultLocale);
            this.calendarGMT.setLenient(false);
        }
        return this.calendarGMT;
    }

    @Override
    public SimpleDateFormat getSimpleDateFormatGMT() {
        if (this.simpleDateFormatGMT == null) {
            this.simpleDateFormatGMT = new SimpleDateFormat("MMMM", Locale.ENGLISH);
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"), HsqlDateTime.defaultLocale);
            gregorianCalendar.setLenient(false);
            this.simpleDateFormatGMT.setCalendar(gregorianCalendar);
        }
        return this.simpleDateFormatGMT;
    }

    @Override
    public TimestampData getCurrentDate() {
        long l = System.currentTimeMillis();
        l = HsqlDateTime.getNormalisedDate(l);
        return new TimestampData(l / 1000L);
    }

    @Override
    public int getZoneSeconds() {
        return this.zoneSeconds;
    }

    @Override
    public int getStreamBlockSize() {
        return 524288;
    }

    @Override
    public HsqlProperties getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = this.clientPropertiesString.length() > 0 ? HsqlProperties.delimitedArgPairsToProps(this.clientPropertiesString, "=", ";", null) : new HsqlProperties();
        }
        return this.clientProperties;
    }

    @Override
    public JDBCConnection getJDBCConnection() {
        return this.connection;
    }

    @Override
    public void setJDBCConnection(JDBCConnection jDBCConnection) {
        this.connection = jDBCConnection;
    }

    @Override
    public String getDatabaseUniqueName() {
        return this.databaseUniqueName;
    }

    public static String toNetCompVersionString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((n *= -1) / 1000000);
        stringBuilder.append('.');
        stringBuilder.append((n %= 1000000) / 10000);
        stringBuilder.append('.');
        stringBuilder.append((n %= 10000) / 100);
        stringBuilder.append('.');
        stringBuilder.append(n %= 100);
        return stringBuilder.toString();
    }

    protected void handshake() throws IOException {
        this.dataOutput.writeInt(-2030400);
        this.dataOutput.flush();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

