/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.error.Error;

public enum DatabaseType {
    DB_MEM("mem:"),
    DB_FILE("file:"),
    DB_RES("res:");

    private String value;

    private DatabaseType(String string3) {
        this.value = string3;
    }

    public String value() {
        return this.value;
    }

    public boolean isFileBased() {
        switch (this) {
            case DB_FILE: 
            case DB_RES: {
                return true;
            }
        }
        return false;
    }

    public static boolean isInProcessDatabaseType(String string2) {
        return DatabaseType.DB_FILE.value.equals(string2) || DatabaseType.DB_RES.value.equals(string2) || DatabaseType.DB_MEM.value.equals(string2);
    }

    public static DatabaseType get(String string2) {
        if (DatabaseType.DB_MEM.value.equals(string2)) {
            return DB_MEM;
        }
        if (DatabaseType.DB_FILE.value.equals(string2)) {
            return DB_FILE;
        }
        if (DatabaseType.DB_RES.value.equals(string2)) {
            return DB_RES;
        }
        throw Error.runtimeError(201, "DatabaseType");
    }
}

