/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.map.BitMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.Crypto;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.LobData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class FunctionCustom
extends FunctionSQL {
    private static final int FUNC_ACOS = 71;
    private static final int FUNC_ACTION_ID = 72;
    private static final int FUNC_ADD_MONTHS = 73;
    private static final int FUNC_ASCII = 74;
    private static final int FUNC_ASIN = 75;
    private static final int FUNC_ATAN = 76;
    private static final int FUNC_ATAN2 = 77;
    private static final int FUNC_BITAND = 78;
    private static final int FUNC_BITANDNOT = 79;
    private static final int FUNC_BITNOT = 80;
    private static final int FUNC_BITOR = 81;
    private static final int FUNC_BITXOR = 82;
    private static final int FUNC_CHAR = 83;
    private static final int FUNC_CONCAT = 84;
    private static final int FUNC_COS = 85;
    private static final int FUNC_COSH = 86;
    private static final int FUNC_COT = 87;
    private static final int FUNC_CRYPT_KEY = 88;
    private static final int FUNC_DATABASE = 89;
    private static final int FUNC_DATABASE_ISOLATION_LEVEL = 90;
    private static final int FUNC_DATABASE_NAME = 91;
    private static final int FUNC_DATABASE_TIMEZONE = 92;
    private static final int FUNC_DATABASE_VERSION = 93;
    private static final int FUNC_DATE_ADD = 94;
    private static final int FUNC_DATE_SUB = 95;
    private static final int FUNC_DATEADD = 96;
    private static final int FUNC_DATEDIFF = 97;
    private static final int FUNC_DAYS = 98;
    private static final int FUNC_DBTIMEZONE = 99;
    private static final int FUNC_DEGREES = 100;
    private static final int FUNC_DIAGNOSTICS = 101;
    private static final int FUNC_DIFFERENCE = 102;
    private static final int FUNC_FROM_BASE64 = 103;
    private static final int FUNC_FROM_TZ = 104;
    private static final int FUNC_HEX = 105;
    private static final int FUNC_HEXTORAW = 106;
    private static final int FUNC_IDENTITY = 107;
    private static final int FUNC_INSTR = 108;
    private static final int FUNC_ISAUTOCOMMIT = 109;
    private static final int FUNC_ISOLATION_LEVEL = 110;
    private static final int FUNC_ISREADONLYDATABASE = 111;
    private static final int FUNC_ISREADONLYDATABASEFILES = 112;
    private static final int FUNC_ISREADONLYSESSION = 113;
    private static final int FUNC_LAST_DAY = 114;
    private static final int FUNC_LEFT = 115;
    private static final int FUNC_LOAD_FILE = 116;
    private static final int FUNC_LOB_ID = 117;
    private static final int FUNC_LOCATE = 118;
    private static final int FUNC_LOG10 = 119;
    private static final int FUNC_LPAD = 120;
    private static final int FUNC_LTRIM = 121;
    private static final int FUNC_MONTHS_BETWEEN = 122;
    private static final int FUNC_NEW_TIME = 123;
    private static final int FUNC_NEXT_DAY = 124;
    private static final int FUNC_NUMTODSINTERVAL = 125;
    private static final int FUNC_NUMTOYMINTERVAL = 126;
    private static final int FUNC_PI = 127;
    private static final int FUNC_POSITION_ARRAY = 128;
    private static final int FUNC_RADIANS = 129;
    private static final int FUNC_RAND = 130;
    private static final int FUNC_RAWTOHEX = 131;
    private static final int FUNC_REGEXP_MATCHES = 132;
    private static final int FUNC_REGEXP_REPLACE = 133;
    private static final int FUNC_REGEXP_SUBSTRING = 134;
    private static final int FUNC_REGEXP_SUBSTRING_ARRAY = 135;
    private static final int FUNC_REPEAT = 136;
    private static final int FUNC_REPLACE = 137;
    private static final int FUNC_REVERSE = 138;
    private static final int FUNC_RIGHT = 139;
    private static final int FUNC_ROUND = 140;
    private static final int FUNC_ROUNDMAGIC = 141;
    private static final int FUNC_RPAD = 142;
    private static final int FUNC_RTRIM = 143;
    private static final int FUNC_SECONDS_MIDNIGHT = 144;
    private static final int FUNC_SEQUENCE_ARRAY = 145;
    private static final int FUNC_SESSION_ID = 146;
    private static final int FUNC_SESSION_ISOLATION_LEVEL = 147;
    private static final int FUNC_SESSION_TIMEZONE = 148;
    private static final int FUNC_SESSIONTIMEZONE = 149;
    private static final int FUNC_SIGN = 150;
    private static final int FUNC_SIN = 151;
    private static final int FUNC_SINH = 152;
    private static final int FUNC_SOUNDEX = 153;
    private static final int FUNC_SORT_ARRAY = 154;
    private static final int FUNC_SPACE = 155;
    private static final int FUNC_SUBSTR = 156;
    private static final int FUNC_SYS_EXTRACT_UTC = 157;
    private static final int FUNC_SYS_GUID = 158;
    private static final int FUNC_SYSDATE = 159;
    private static final int FUNC_SYSTIMESTAMP = 160;
    private static final int FUNC_TAN = 161;
    private static final int FUNC_TANH = 162;
    private static final int FUNC_TIMESTAMP = 163;
    private static final int FUNC_TIMESTAMP_WITH_ZONE = 164;
    private static final int FUNC_TIMESTAMPADD = 165;
    private static final int FUNC_TIMESTAMPDIFF = 166;
    private static final int FUNC_TIMEZONE = 167;
    private static final int FUNC_TO_BASE64 = 168;
    private static final int FUNC_TO_CHAR = 169;
    private static final int FUNC_TO_DATE = 170;
    private static final int FUNC_TO_DSINTERVAL = 171;
    private static final int FUNC_TO_YMINTERVAL = 172;
    private static final int FUNC_TO_NUMBER = 173;
    private static final int FUNC_TO_TIMESTAMP = 174;
    private static final int FUNC_TO_TIMESTAMP_TZ = 175;
    private static final int FUNC_TRANSACTION_CONTROL = 176;
    private static final int FUNC_TRANSACTION_ID = 177;
    private static final int FUNC_TRANSACTION_SIZE = 178;
    private static final int FUNC_TRANSLATE = 179;
    private static final int FUNC_TRUNC = 180;
    private static final int FUNC_TRUNCATE = 181;
    private static final int FUNC_UNHEX = 182;
    private static final int FUNC_UUID = 183;
    private static final int FUNC_UNIX_TIMESTAMP = 184;
    private static final int FUNC_UNIX_MILLIS = 185;
    private static final int FUNC_DATEPART = 186;
    private static final int FUNC_DATENAME = 187;
    private static final int FUNC_NANVL = 188;
    private static final int FUNC_SQLCODE = 189;
    private static final int FUNC_SQLERRM = 190;
    static final IntKeyIntValueHashMap customRegularFuncMap = new IntKeyIntValueHashMap();
    static final IntKeyIntValueHashMap customValueFuncMap;
    private int extractSpec;
    private Pattern pattern;
    private IntKeyIntValueHashMap charLookup;

    public static FunctionSQL newCustomFunction(Session session, String string2, int n) {
        int n2 = customRegularFuncMap.get(n, -1);
        if (n2 == -1) {
            n2 = customValueFuncMap.get(n, -1);
        }
        if (n2 == -1) {
            return null;
        }
        switch (n) {
            case 453: 
            case 712: 
            case 762: 
            case 767: 
            case 783: 
            case 837: {
                return new FunctionSQL(n2);
            }
            case 723: 
            case 724: 
            case 780: 
            case 831: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = optionalNoParamList;
                return functionSQL;
            }
            case 812: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = tripleParamList;
                return functionSQL;
            }
            case 852: 
            case 853: 
            case 854: 
            case 855: {
                if (session.database.sqlSyntaxMss) break;
                return null;
            }
            case 742: 
            case 816: 
            case 857: {
                if (session.database.sqlSyntaxOra) break;
                return null;
            }
        }
        FunctionCustom functionCustom = new FunctionCustom(n2);
        if (n2 == 31) {
            switch (n) {
                case 770: {
                    functionCustom.extractSpec = 161;
                    break;
                }
                case 798: {
                    functionCustom.extractSpec = 302;
                    break;
                }
            }
        }
        if (n2 == 5) {
            switch (n) {
                case 737: {
                    functionCustom.extractSpec = 733;
                    break;
                }
                case 773: {
                    functionCustom.extractSpec = 772;
                    break;
                }
                case 738: {
                    functionCustom.extractSpec = 734;
                    break;
                }
                case 739: {
                    functionCustom.extractSpec = 735;
                    break;
                }
                case 740: {
                    functionCustom.extractSpec = 736;
                    break;
                }
                case 842: {
                    functionCustom.extractSpec = 843;
                    break;
                }
                default: {
                    functionCustom.extractSpec = n;
                }
            }
        }
        if (functionCustom.name == null) {
            functionCustom.name = string2;
        }
        return functionCustom;
    }

    public static boolean isRegularFunction(int n) {
        return customRegularFuncMap.get(n, -1) != -1;
    }

    public static boolean isValueFunction(int n) {
        return customValueFuncMap.get(n, -1) != -1;
    }

    private FunctionCustom(int n) {
        this.funcType = n;
        this.isDeterministic = !nonDeterministicFuncSet.contains(n);
        switch (n) {
            case 189: 
            case 190: {
                this.parseList = optionalNoParamList;
                break;
            }
            case 99: 
            case 149: 
            case 159: 
            case 160: {
                this.parseList = optionalNoParamList;
                break;
            }
            case 72: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 127: 
            case 146: 
            case 147: 
            case 148: 
            case 158: 
            case 167: 
            case 176: 
            case 177: 
            case 178: {
                this.parseList = emptyParamList;
                break;
            }
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 80: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 98: 
            case 100: 
            case 103: 
            case 105: 
            case 106: 
            case 114: 
            case 117: 
            case 119: 
            case 129: 
            case 131: 
            case 138: 
            case 141: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 161: 
            case 162: 
            case 164: 
            case 168: 
            case 171: 
            case 172: 
            case 173: 
            case 182: {
                this.parseList = singleParamList;
                break;
            }
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 88: 
            case 102: 
            case 104: 
            case 115: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 132: 
            case 134: 
            case 135: 
            case 136: 
            case 139: 
            case 188: {
                this.parseList = doubleParamList;
                break;
            }
            case 169: 
            case 170: 
            case 174: 
            case 175: {
                this.parseList = optionalDoubleParamList;
                break;
            }
            case 116: 
            case 140: 
            case 163: 
            case 180: 
            case 181: {
                this.parseList = optionalDoubleParamList;
                break;
            }
            case 97: {
                this.parseList = new short[]{936, 1005, 924, 938, 924, 938, 922};
                this.parseListAlt = new short[]{936, 938, 924, 938, 1002, 2, 924, 938, 922};
                break;
            }
            case 96: {
                this.parseList = new short[]{936, 1005, 924, 938, 924, 938, 922};
                this.parseListAlt = tripleParamList;
                break;
            }
            case 186: 
            case 187: {
                this.parseList = new short[]{936, 1005, 924, 938, 922};
                break;
            }
            case 94: 
            case 95: {
                this.parseList = doubleParamList;
                break;
            }
            case 123: 
            case 145: 
            case 179: {
                this.parseList = tripleParamList;
                break;
            }
            case 1: 
            case 120: 
            case 137: 
            case 142: {
                this.parseList = new short[]{936, 938, 924, 938, 1002, 2, 924, 938, 922};
                break;
            }
            case 133: {
                this.parseList = new short[]{936, 938, 924, 938, 1002, 2, 924, 938, 1002, 2, 924, 938, 1002, 2, 924, 938, 1002, 2, 924, 938, 922};
                break;
            }
            case 183: 
            case 184: 
            case 185: {
                this.parseList = optionalSingleParamList;
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = singleParamList;
                break;
            }
            case 31: {
                this.name = "TRIM";
                this.parseList = singleParamList;
                break;
            }
            case 32: {
                this.name = "OVERLAY";
                this.parseList = quadParamList;
                break;
            }
            case 107: {
                this.name = "IDENTITY";
                this.parseList = emptyParamList;
                break;
            }
            case 101: {
                this.parseList = new short[]{936, 517, 922};
                break;
            }
            case 128: {
                this.parseList = new short[]{936, 938, 140, 938, 1002, 2, 124, 938, 922};
                break;
            }
            case 154: {
                this.parseList = new short[]{936, 938, 1002, 4, 1001, 2, 359, 410, 1002, 5, 473, 1001, 2, 423, 452, 922};
                break;
            }
            case 165: {
                this.name = "TIMESTAMPADD";
                this.parseList = new short[]{936, 1001, 22, 981, 983, 982, 984, 985, 986, 987, 988, 989, 990, 991, 873, 871, 872, 264, 179, 137, 78, 842, 183, 786, 341, 924, 938, 924, 938, 922};
                break;
            }
            case 166: {
                this.name = "TIMESTAMPDIFF";
                this.parseList = new short[]{936, 1001, 22, 981, 983, 982, 984, 985, 986, 987, 988, 989, 990, 991, 873, 871, 872, 264, 179, 137, 78, 842, 183, 786, 341, 924, 938, 924, 938, 922};
                break;
            }
            case 130: {
                this.parseList = optionalSingleParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public void setArguments(Expression[] expressionArray) {
        switch (this.funcType) {
            case 1: {
                Expression[] expressionArray2 = new Expression[4];
                if ("LOCATE".equals(this.name)) {
                    expressionArray2[0] = expressionArray[0];
                    expressionArray2[1] = expressionArray[1];
                    expressionArray2[3] = expressionArray[2];
                    expressionArray = expressionArray2;
                    break;
                }
                if (!"INSTR".equals(this.name)) break;
                expressionArray2[0] = expressionArray[1];
                expressionArray2[1] = expressionArray[0];
                expressionArray2[3] = expressionArray[2];
                expressionArray = expressionArray2;
                break;
            }
            case 32: {
                Expression expression2 = expressionArray[1];
                Expression expression3 = expressionArray[2];
                expressionArray[1] = expressionArray[3];
                expressionArray[2] = expression2;
                expressionArray[3] = expression3;
                break;
            }
            case 5: {
                Expression[] expressionArray3 = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), expressionArray[0]};
                expressionArray = expressionArray3;
                break;
            }
            case 31: {
                Expression[] expressionArray4 = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), new ExpressionValue(" ", Type.SQL_CHAR), expressionArray[0]};
                expressionArray = expressionArray4;
            }
        }
        super.setArguments(expressionArray);
    }

    @Override
    public Expression getFunctionExpression() {
        switch (this.funcType) {
            case 84: {
                return new ExpressionArithmetic(36, this.nodes[0], this.nodes[1]);
            }
        }
        return super.getFunctionExpression();
    }

    @Override
    Object getValue(Session session, Object[] objectArray) {
        switch (this.funcType) {
            case 189: {
                return 0;
            }
            case 190: {
                return "Error";
            }
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                return super.getValue(session, objectArray);
            }
            case 89: {
                return session.getDatabase().getPath();
            }
            case 91: {
                return session.getDatabase().getNameString();
            }
            case 109: {
                return session.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 113: {
                return session.isReadOnlyDefault() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 111: {
                return session.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
            }
            case 112: {
                return session.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 110: {
                return Session.getIsolationString(session.isolationLevel);
            }
            case 147: {
                return Session.getIsolationString(session.isolationLevelDefault);
            }
            case 90: {
                return Session.getIsolationString(session.database.defaultIsolationLevel);
            }
            case 176: {
                switch (session.database.txManager.getTransactionControl()) {
                    case 2: {
                        return "MVCC";
                    }
                    case 1: {
                        return "MVLOCKS";
                    }
                }
                return "LOCKS";
            }
            case 167: {
                return new IntervalSecondData(session.getZoneSeconds(), 0);
            }
            case 148: {
                return new IntervalSecondData(session.sessionTimeZoneSeconds, 0);
            }
            case 99: {
                TimestampData timestampData = session.getSystemTimestamp(true);
                IntervalSecondData intervalSecondData = new IntervalSecondData(timestampData.getZone(), 0);
                return Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(intervalSecondData);
            }
            case 92: {
                int n = HsqlDateTime.getZoneSeconds();
                return new IntervalSecondData(n, 0);
            }
            case 93: {
                return "2.5.0";
            }
            case 146: {
                return session.getId();
            }
            case 72: {
                return session.actionTimestamp;
            }
            case 177: {
                return session.transactionTimestamp;
            }
            case 178: {
                return (long)session.getTransactionSize();
            }
            case 117: {
                LobData lobData = (LobData)objectArray[0];
                if (lobData == null) {
                    return null;
                }
                return lobData.getId();
            }
            case 107: {
                Number number2 = session.getLastIdentity();
                if (number2 instanceof Long) {
                    return number2;
                }
                return ValuePool.getLong(number2.longValue());
            }
            case 101: {
                return session.sessionContext.diagnosticsVariables[this.exprSubType];
            }
            case 145: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                HsqlArrayList hsqlArrayList = new HsqlArrayList();
                Object object = objectArray[0];
                Type type = this.nodes[0].getDataType();
                boolean bl = type.compare(session, objectArray[1], objectArray[0]) >= 0;
                while (true) {
                    int n = type.compare(session, object, objectArray[1]);
                    if (bl ? n > 0 : n < 0) break;
                    hsqlArrayList.add(object);
                    Object object2 = type.add(session, object, objectArray[2], this.nodes[2].getDataType());
                    n = type.compare(session, object, object2);
                    if (bl ? n >= 0 : n <= 0) break;
                    object = object2;
                }
                Object[] objectArray2 = hsqlArrayList.toArray();
                return objectArray2;
            }
            case 165: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                objectArray[1] = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                int n = ((Number)this.nodes[0].valueData).intValue();
                long l = ((Number)objectArray[1]).longValue();
                TimestampData timestampData = (TimestampData)objectArray[2];
                switch (n) {
                    case 873: 
                    case 981: {
                        long l2 = l / 1000000000L;
                        int n2 = (int)(l % 1000000000L);
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l2, n2, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 871: 
                    case 983: {
                        long l3 = l / 1000000L;
                        int n3 = (int)(l % 1000000L) * 1000;
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l3, n3, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 872: 
                    case 982: {
                        long l4 = l / 1000L;
                        int n4 = (int)(l % 1000L) * 1000000;
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l4, n4, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 264: 
                    case 984: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalSeconds(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 179: 
                    case 985: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalMinute(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 137: 
                    case 986: {
                        IntervalType intervalType = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalHour(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 78: 
                    case 735: 
                    case 736: 
                    case 987: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalDay(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 842: 
                    case 988: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalDay(l * 7L, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 183: 
                    case 989: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                    case 786: 
                    case 990: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l * 3L, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                    case 341: 
                    case 991: {
                        IntervalType intervalType = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l * 12L, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 166: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                int n = ((Number)this.nodes[0].valueData).intValue();
                TimestampData timestampData = (TimestampData)objectArray[2];
                TimestampData timestampData2 = (TimestampData)objectArray[1];
                switch (n) {
                    case 873: 
                    case 981: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(session, timestampData, timestampData2, null);
                        return 1000000000L * intervalSecondData.getSeconds() + (long)intervalSecondData.getNanos();
                    }
                    case 871: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(session, timestampData, timestampData2, null);
                        return 1000000L * intervalSecondData.getSeconds() + (long)(intervalSecondData.getNanos() / 1000);
                    }
                    case 872: 
                    case 982: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(session, timestampData, timestampData2, null);
                        return 1000L * intervalSecondData.getSeconds() + (long)(intervalSecondData.getNanos() / 1000000);
                    }
                    case 264: 
                    case 984: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 179: 
                    case 985: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 137: 
                    case 986: {
                        IntervalType intervalType = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 78: 
                    case 987: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 842: 
                    case 988: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        long l = intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                        l = l < 0L ? (l - 6L) / 7L : (l + 6L) / 7L;
                        return l;
                    }
                    case 183: 
                    case 989: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 786: 
                    case 990: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        long l = intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                        l = l < 0L ? (l - 2L) / 3L : (l + 2L) / 3L;
                        return l;
                    }
                    case 341: 
                    case 991: {
                        IntervalType intervalType = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 187: {
                Object object = this.getExtractValue(session, objectArray);
                return this.dataType.convertToDefaultType(session, object);
            }
            case 94: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return this.dataType.add(session, objectArray[0], objectArray[1], this.nodes[1].dataType);
            }
            case 95: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return this.dataType.subtract(session, objectArray[0], objectArray[1], this.nodes[1].dataType);
            }
            case 98: {
                if (objectArray[0] == null) {
                    return null;
                }
                IntervalSecondData intervalSecondData = (IntervalSecondData)Type.SQL_INTERVAL_DAY_MAX_PRECISION.subtract(session, objectArray[0], DateTimeType.epochTimestamp, Type.SQL_DATE);
                return ValuePool.getInt((int)(intervalSecondData.getSeconds() / 86400L + 1L));
            }
            case 127: {
                return Math.PI;
            }
            case 130: {
                if (this.nodes[0] == null) {
                    return session.random();
                }
                objectArray[0] = Type.SQL_BIGINT.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                long l = ((Number)objectArray[0]).longValue();
                return session.random(l);
            }
            case 140: 
            case 180: {
                int n = 103;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.dataType.isDateTimeType()) {
                    DateTimeType dateTimeType = (DateTimeType)this.dataType;
                    if (this.nodes.length > 1 && this.nodes[1] != null) {
                        if (objectArray[1] == null) {
                            return null;
                        }
                        n = HsqlDateTime.toStandardIntervalPart((String)objectArray[1]);
                    }
                    if (n < 0) {
                        throw Error.error(5566, (String)objectArray[1]);
                    }
                    return this.funcType == 140 ? dateTimeType.round(session, objectArray[0], n) : dateTimeType.truncate(session, objectArray[0], n);
                }
            }
            case 181: {
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (objectArray[1] == null) {
                        return null;
                    }
                    objectArray[1] = Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                    n = ((Number)objectArray[1]).intValue();
                }
                return this.funcType == 140 ? ((NumberType)this.dataType).round(objectArray[0], n) : ((NumberType)this.dataType).truncate(objectArray[0], n);
            }
            case 103: {
                String string2 = (String)objectArray[0];
                if (string2 == null) {
                    return null;
                }
                string2 = string2.trim();
                byte[] byArray = Base64.getDecoder().decode(string2);
                return new BinaryData(byArray, false);
            }
            case 168: {
                BinaryData binaryData = (BinaryData)objectArray[0];
                if (binaryData == null) {
                    return null;
                }
                return Base64.getEncoder().encodeToString(binaryData.getBytes());
            }
            case 169: {
                if (this.nodes[1] == null) {
                    return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                }
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
                Date date2 = (Date)((DateTimeType)this.nodes[0].dataType).convertSQLToJavaGMT(session, objectArray[0]);
                return HsqlDateTime.toFormattedDate(date2, (String)objectArray[1], simpleDateFormat);
            }
            case 173: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
            }
            case 170: 
            case 174: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isDateOrTimestampType()) {
                    return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                }
                boolean bl = this.funcType == 174;
                SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
                TimestampData timestampData = HsqlDateTime.toDate((String)objectArray[0], (String)objectArray[1], simpleDateFormat, bl);
                return timestampData;
            }
            case 163: {
                boolean bl;
                boolean bl2 = bl = this.nodes[1] == null;
                if (objectArray[0] == null) {
                    return null;
                }
                if (bl) {
                    if (this.nodes[0].dataType.isNumberType()) {
                        return new TimestampData(((Number)objectArray[0]).longValue());
                    }
                    try {
                        return Type.SQL_TIMESTAMP.convertToType(session, objectArray[0], this.nodes[0].dataType);
                    }
                    catch (HsqlException hsqlException) {
                        return Type.SQL_DATE.convertToType(session, objectArray[0], this.nodes[0].dataType);
                    }
                }
                if (objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)Type.SQL_DATE.convertToType(session, objectArray[0], this.nodes[0].dataType);
                TimeData timeData = (TimeData)Type.SQL_TIME_MAX.convertToType(session, objectArray[1], this.nodes[1].dataType);
                return new TimestampData(timestampData.getSeconds() + (long)timeData.getSeconds(), timeData.getNanos());
            }
            case 164: {
                long l;
                Calendar calendar = session.getCalendar();
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    l = ((Number)objectArray[0]).longValue();
                } else if (this.nodes[0].dataType.typeCode == 93) {
                    l = ((TimestampData)objectArray[0]).getSeconds();
                    l = HsqlDateTime.convertMillisToCalendar(calendar, l * 1000L) / 1000L;
                } else if (this.nodes[0].dataType.typeCode == 95) {
                    l = ((TimestampData)objectArray[0]).getSeconds();
                } else {
                    throw Error.error(5566, (String)objectArray[1]);
                }
                calendar.setTimeInMillis(l * 1000L);
                int n5 = HsqlDateTime.getZoneSeconds(calendar);
                return new TimestampData(l, n, n5);
            }
            case 158: {
                UUID uUID = UUID.randomUUID();
                long l = uUID.getMostSignificantBits();
                long l5 = uUID.getLeastSignificantBits();
                return new BinaryData(ArrayUtil.toByteArray(l, l5), false);
            }
            case 183: {
                if (this.nodes[0] == null) {
                    UUID uUID = UUID.randomUUID();
                    long l = uUID.getMostSignificantBits();
                    long l6 = uUID.getLeastSignificantBits();
                    return new BinaryData(ArrayUtil.toByteArray(l, l6), false);
                }
                if (objectArray[0] == null) {
                    return null;
                }
                try {
                    if (this.dataType.isBinaryType()) {
                        byte[] byArray = StringConverter.toBinaryUUID((String)objectArray[0]);
                        return new BinaryData(byArray, false);
                    }
                    return StringConverter.toStringUUID(((BinaryData)objectArray[0]).getBytes());
                }
                catch (NumberFormatException numberFormatException) {
                    throw Error.error(3459);
                }
            }
            case 185: {
                TimestampData timestampData;
                if (this.nodes[0] == null) {
                    timestampData = session.getCurrentTimestamp(true);
                } else {
                    if (objectArray[0] == null) {
                        return null;
                    }
                    timestampData = (TimestampData)objectArray[0];
                }
                long l = timestampData.getSeconds() * 1000L + (long)(timestampData.getNanos() / 1000000);
                return l;
            }
            case 184: {
                TimestampData timestampData;
                if (this.nodes[0] == null) {
                    timestampData = session.getCurrentTimestamp(true);
                } else {
                    if (objectArray[0] == null) {
                        return null;
                    }
                    timestampData = (TimestampData)objectArray[0];
                }
                return timestampData.getSeconds();
            }
            case 71: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.acos(d);
            }
            case 75: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.asin(d);
            }
            case 76: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.atan(d);
            }
            case 85: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.cos(d);
            }
            case 86: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.cosh(d);
            }
            case 87: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                double d2 = 1.0 / Math.tan(d);
                return d2;
            }
            case 100: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.toDegrees(d);
            }
            case 151: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.sin(d);
            }
            case 152: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.sinh(d);
            }
            case 161: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.tan(d);
            }
            case 162: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.tanh(d);
            }
            case 119: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                if (d < 0.0 && session.database.sqlDoubleNaN) {
                    throw Error.error(3444);
                }
                return Math.log10(d);
            }
            case 129: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.toRadians(d);
            }
            case 150: {
                if (objectArray[0] == null) {
                    return null;
                }
                if (session.database.sqlSyntaxOra && objectArray[0] instanceof Double && (Double)objectArray[0] == 0.0) {
                    return 1;
                }
                int n = ((NumberType)this.nodes[0].dataType).compareToZero(objectArray[0]);
                return n;
            }
            case 77: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                double d3 = NumberType.toDouble(objectArray[1]);
                return Math.atan2(d, d3);
            }
            case 74: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string3 = this.nodes[0].dataType.isLobType() ? ((ClobData)objectArray[0]).getSubString(session, 0L, 1) : (String)objectArray[0];
                if (string3.length() == 0) {
                    return null;
                }
                return ValuePool.getInt(string3.charAt(0));
            }
            case 83: {
                if (objectArray[0] == null) {
                    return null;
                }
                objectArray[0] = Type.SQL_INTEGER.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                int n = ((Number)objectArray[0]).intValue();
                if (Character.isValidCodePoint(n) && Character.isValidCodePoint((char)n)) {
                    return String.valueOf((char)n);
                }
                throw Error.error(3472);
            }
            case 141: {
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (objectArray[1] == null) {
                        return null;
                    }
                    n = ((Number)objectArray[1]).intValue();
                }
                return ((NumberType)this.dataType).round(objectArray[0], n);
            }
            case 153: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string4 = (String)objectArray[0];
                return new String(FunctionCustom.soundex(string4), 0, 4);
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                byte[] byArray;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                if (this.dataType.isNumberType()) {
                    long l = 0L;
                    long l7 = 0L;
                    objectArray[0] = Type.SQL_BIGINT.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                    long l8 = ((Number)objectArray[0]).longValue();
                    if (this.funcType != 80) {
                        objectArray[1] = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                        l7 = ((Number)objectArray[1]).longValue();
                    }
                    switch (this.funcType) {
                        case 78: {
                            l = l8 & l7;
                            break;
                        }
                        case 79: {
                            l = l8 & (l7 ^ 0xFFFFFFFFFFFFFFFFL);
                            break;
                        }
                        case 80: {
                            l = l8 ^ 0xFFFFFFFFFFFFFFFFL;
                            break;
                        }
                        case 81: {
                            l = l8 | l7;
                            break;
                        }
                        case 82: {
                            l = l8 ^ l7;
                            break;
                        }
                    }
                    switch (this.dataType.typeCode) {
                        case 2: 
                        case 3: {
                            return BigDecimal.valueOf(l);
                        }
                        case 25: {
                            return ValuePool.getLong(l);
                        }
                        case -6: 
                        case 4: 
                        case 5: {
                            return ValuePool.getInt((int)l);
                        }
                    }
                    throw Error.error(5561);
                }
                byte[] byArray2 = ((BinaryData)objectArray[0]).getBytes();
                byte[] byArray3 = null;
                if (this.funcType != 80) {
                    byArray3 = ((BinaryData)objectArray[1]).getBytes();
                }
                switch (this.funcType) {
                    case 78: {
                        byArray = BitMap.and(byArray2, byArray3);
                        break;
                    }
                    case 79: {
                        byArray3 = BitMap.not(byArray3);
                        byArray = BitMap.and(byArray2, byArray3);
                        break;
                    }
                    case 80: {
                        byArray = BitMap.not(byArray2);
                        break;
                    }
                    case 81: {
                        byArray = BitMap.or(byArray2, byArray3);
                        break;
                    }
                    case 82: {
                        byArray = BitMap.xor(byArray2, byArray3);
                        break;
                    }
                    default: {
                        throw Error.error(5561);
                    }
                }
                return new BinaryData(byArray, this.dataType.precision);
            }
            case 102: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                char[] cArray = FunctionCustom.soundex((String)objectArray[0]);
                char[] cArray2 = FunctionCustom.soundex((String)objectArray[1]);
                int n = 0;
                if (cArray[0] == cArray2[0]) {
                    ++n;
                }
                int n6 = 1;
                block173: for (int i = 1; i < 4; ++i) {
                    for (int j = n6; j < 4; ++j) {
                        if (cArray[j] != cArray2[i]) continue;
                        ++n;
                        n6 = j + 1;
                        continue block173;
                    }
                }
                return ValuePool.getInt(n);
            }
            case 105: {
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isBinaryType()) {
                    return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    long l = ((Number)objectArray[0]).longValue();
                    return Long.toHexString(l);
                }
                String string5 = (String)objectArray[0];
                byte[] byArray = string5.getBytes(JavaSystem.CS_ISO_8859_1);
                return StringConverter.byteArrayToHexString(byArray);
            }
            case 106: 
            case 182: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
            }
            case 131: {
                if (objectArray[0] == null) {
                    return null;
                }
                BlobData blobData = (BlobData)objectArray[0];
                byte[] byArray = blobData.getBytes(session, 0L, (int)blobData.length(session));
                return StringConverter.byteArrayToHexString(byArray);
            }
            case 136: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                objectArray[1] = Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                String string6 = (String)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                StringBuilder stringBuilder = new StringBuilder(string6.length() * n);
                while (n-- > 0) {
                    stringBuilder.append(string6);
                }
                return stringBuilder.toString();
            }
            case 137: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                String string7 = (String)objectArray[0];
                String string8 = (String)objectArray[1];
                String string9 = (String)objectArray[2];
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                if (string8.length() == 0) {
                    return string7;
                }
                while (true) {
                    int n7;
                    if ((n7 = string7.indexOf(string8, n)) == -1) break;
                    stringBuilder.append(string7, n, n7);
                    stringBuilder.append(string9);
                    n = n7 + string8.length();
                }
                stringBuilder.append(string7.substring(n));
                return stringBuilder.toString();
            }
            case 115: 
            case 139: {
                int n;
                for (n = 0; n < objectArray.length; ++n) {
                    if (objectArray[n] != null) continue;
                    return null;
                }
                n = ((Number)objectArray[1]).intValue();
                return ((CharacterType)this.dataType).substring(session, objectArray[0], 0L, n, true, this.funcType == 139);
            }
            case 155: {
                if (objectArray[0] == null) {
                    return null;
                }
                objectArray[0] = Type.SQL_INTEGER.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                int n = ((Number)objectArray[0]).intValue();
                char[] cArray = new char[n];
                ArrayUtil.fillArray(cArray, 0, ' ');
                return String.valueOf(cArray);
            }
            case 138: {
                if (objectArray[0] == null) {
                    return null;
                }
                StringBuilder stringBuilder = new StringBuilder((String)objectArray[0]);
                stringBuilder = stringBuilder.reverse();
                return stringBuilder.toString();
            }
            case 133: {
                String string10;
                int n;
                for (n = 0; n < this.nodes.length && this.nodes[n] != null; ++n) {
                    if (objectArray[n] != null) continue;
                    return null;
                }
                n = FunctionCustom.regexpParams((String)objectArray[5]);
                Pattern pattern = null;
                String string11 = (String)objectArray[0];
                String string12 = (String)objectArray[1];
                String string13 = (String)objectArray[2];
                boolean bl = this.nodes[1].getType() == 1;
                int n8 = 1;
                int n9 = 0;
                if (this.nodes[4] != null) {
                    n9 = ((Number)objectArray[4]).intValue();
                }
                if (bl) {
                    pattern = this.pattern;
                }
                if (pattern == null) {
                    pattern = Pattern.compile(string12, n);
                }
                if (bl) {
                    this.pattern = pattern;
                }
                Matcher matcher = pattern.matcher(string11);
                if (n8 > 1) {
                    matcher.region(n8 - 1, string11.length());
                }
                if (n9 == 0) {
                    string10 = matcher.replaceAll(string13);
                } else if (n9 == 1) {
                    string10 = matcher.replaceFirst(string13);
                } else {
                    throw Error.error(3472, "count");
                }
                return string10;
            }
            case 132: 
            case 134: 
            case 135: {
                Object object;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                Object object3 = this.pattern;
                if (object3 == null) {
                    object = (String)objectArray[1];
                    object3 = Pattern.compile((String)object);
                }
                object = ((Pattern)object3).matcher((String)objectArray[0]);
                switch (this.funcType) {
                    case 132: {
                        boolean bl = ((Matcher)object).matches();
                        return bl;
                    }
                    case 134: {
                        boolean bl = ((Matcher)object).find();
                        if (bl) {
                            return ((Matcher)object).group();
                        }
                        return null;
                    }
                    case 135: {
                        HsqlArrayList hsqlArrayList = new HsqlArrayList();
                        while (((Matcher)object).find()) {
                            hsqlArrayList.add(((Matcher)object).group());
                        }
                        return hsqlArrayList.toArray();
                    }
                }
            }
            case 88: {
                Object object3 = Crypto.getNewKey((String)objectArray[0], (String)objectArray[1]);
                return StringConverter.byteArrayToHexString((byte[])object3);
            }
            case 116: {
                String string14 = (String)objectArray[0];
                if (string14 == null) {
                    return null;
                }
                switch (this.dataType.typeCode) {
                    case 40: {
                        return session.sessionData.createClobFromFile(string14, (String)objectArray[1]);
                    }
                }
                return session.sessionData.createBlobFromFile(string14);
            }
            case 120: 
            case 142: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                String string15 = this.nodes[0].dataType.typeCode == 40 ? (String)Type.SQL_VARCHAR.convertToType(session, objectArray[0], this.nodes[0].dataType) : (this.nodes[0].dataType.isCharacterType() ? (String)objectArray[0] : this.nodes[0].dataType.convertToString(objectArray[0]));
                int n = (Integer)Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].dataType);
                String string16 = " ";
                if (this.nodes[2] != null && (string16 = this.nodes[2].dataType.convertToString(objectArray[2])).length() == 0) {
                    string16 = " ";
                }
                string15 = (String)Type.SQL_VARCHAR.trim(session, string15, ' ', true, true);
                string15 = StringUtil.toPaddedString(string15, n, string16, this.funcType == 142);
                if (this.dataType.isLobType()) {
                    return this.dataType.convertToType(session, string15, Type.SQL_VARCHAR);
                }
                return string15;
            }
            case 128: {
                if (objectArray[1] == null) {
                    return null;
                }
                if (objectArray[2] == null) {
                    return null;
                }
                Object[] objectArray3 = (Object[])objectArray[1];
                ArrayType arrayType = (ArrayType)this.nodes[1].dataType;
                Type type = arrayType.collectionBaseType();
                int n = ((Number)Type.SQL_INTEGER.convertToType(session, objectArray[2], this.nodes[2].dataType)).intValue();
                if (n <= 0) {
                    throw Error.error(3403);
                }
                for (int i = --n; i < objectArray3.length; ++i) {
                    if (type.compare(session, objectArray[0], objectArray3[i]) != 0) continue;
                    return ValuePool.getInt(i + 1);
                }
                return ValuePool.INTEGER_0;
            }
            case 154: {
                if (objectArray[0] == null) {
                    return null;
                }
                ArrayType arrayType = (ArrayType)this.dataType;
                SortAndSlice sortAndSlice = new SortAndSlice();
                sortAndSlice.prepareSingleColumn(1);
                sortAndSlice.sortDescending[0] = ((Number)objectArray[1]).intValue() == 410;
                sortAndSlice.sortNullsLast[0] = ((Number)objectArray[2]).intValue() == 452;
                Object[] objectArray4 = (Object[])ArrayUtil.duplicateArray(objectArray[0]);
                arrayType.sort(session, objectArray4, sortAndSlice);
                return objectArray4;
            }
            case 73: {
                if (objectArray[0] == null) {
                    return null;
                }
                if (objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                return Type.SQL_TIMESTAMP_NO_FRACTION.addMonthsSpecial(session, timestampData, n);
            }
            case 104: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)objectArray[0];
                IntervalSecondData intervalSecondData = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, objectArray[1]);
                return new TimestampData(timestampData.getSeconds() - intervalSecondData.getSeconds(), timestampData.getNanos(), (int)intervalSecondData.getSeconds());
            }
            case 114: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP_NO_FRACTION.getLastDayOfMonth(session, objectArray[0]);
            }
            case 122: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return DateTimeType.subtractMonthsSpecial(session, (TimestampData)objectArray[0], (TimestampData)objectArray[1]);
            }
            case 188: {
                if (objectArray[0] == null) {
                    return null;
                }
                Double d = NumberType.toDouble(objectArray[0]);
                if (Double.isNaN(d)) {
                    return this.dataType.convertToType(session, objectArray[1], this.nodes[1].dataType);
                }
                return objectArray[0];
            }
            case 123: {
                if (objectArray[0] == null || objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                IntervalSecondData intervalSecondData = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, objectArray[1]);
                IntervalSecondData intervalSecondData2 = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, objectArray[1]);
                Object object = Type.SQL_TIMESTAMP_WITH_TIME_ZONE.changeZone(session, objectArray[0], Type.SQL_TIMESTAMP, (int)intervalSecondData2.getSeconds(), (int)intervalSecondData.getSeconds());
                return Type.SQL_TIMESTAMP.convertToType(session, object, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
            }
            case 124: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                int n = DateTimeType.getDayOfWeek((String)objectArray[1]);
                return DateTimeType.nextDayOfWeek(session, timestampData, n);
            }
            case 125: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                Object object = Type.SQL_VARCHAR.trim(session, objectArray[1], ' ', true, true);
                object = Type.SQL_VARCHAR.upper(session, object);
                object = Type.SQL_VARCHAR.convertToDefaultType(session, object);
                int n = Tokens.get((String)object);
                int n10 = IntervalType.getFieldNameTypeForToken(n);
                switch (n10) {
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: {
                        break;
                    }
                    default: {
                        throw Error.error(5566);
                    }
                }
                double d = ((Number)objectArray[0]).doubleValue();
                return IntervalSecondData.newInterval(d, n10);
            }
            case 126: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                Object object = Type.SQL_VARCHAR.trim(session, objectArray[1], ' ', true, true);
                object = Type.SQL_VARCHAR.upper(session, object);
                object = Type.SQL_VARCHAR.convertToDefaultType(session, object);
                int n = Tokens.get((String)object);
                int n11 = IntervalType.getFieldNameTypeForToken(n);
                switch (n11) {
                    case 101: 
                    case 102: {
                        break;
                    }
                    default: {
                        throw Error.error(5566);
                    }
                }
                double d = ((Number)objectArray[0]).doubleValue();
                return IntervalMonthData.newInterval(d, n11);
            }
            case 149: {
                IntervalSecondData intervalSecondData = new IntervalSecondData(session.sessionTimeZoneSeconds, 0);
                return Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(intervalSecondData);
            }
            case 157: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP_WITH_TIME_ZONE.changeZone(session, objectArray[0], Type.SQL_TIMESTAMP_WITH_TIME_ZONE, 0, 0);
            }
            case 159: {
                TimestampData timestampData = session.getSystemTimestamp(false);
                return Type.SQL_TIMESTAMP_NO_FRACTION.convertToType(session, timestampData, Type.SQL_TIMESTAMP);
            }
            case 160: {
                return session.getSystemTimestamp(true);
            }
            case 171: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_INTERVAL_DAY_TO_SECOND.convertToType(session, objectArray[0], Type.SQL_VARCHAR);
            }
            case 172: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION.convertToType(session, objectArray[0], Type.SQL_VARCHAR);
            }
            case 175: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
            }
            case 179: {
                if (objectArray[0] == null || objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                IntKeyIntValueHashMap intKeyIntValueHashMap = this.charLookup;
                if (intKeyIntValueHashMap == null) {
                    intKeyIntValueHashMap = FunctionCustom.getTranslationMap((String)objectArray[1], (String)objectArray[2]);
                }
                return FunctionCustom.translateWithMap((String)objectArray[0], intKeyIntValueHashMap);
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    @Override
    public void resolveTypes(Session session, Expression expression2) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].resolveTypes(session, this);
        }
        block0 : switch (this.funcType) {
            case 189: {
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 190: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                super.resolveTypes(session, expression2);
                return;
            }
            case 89: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 91: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 109: 
            case 111: 
            case 112: 
            case 113: {
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 90: 
            case 93: 
            case 110: 
            case 147: 
            case 176: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 92: 
            case 148: 
            case 167: {
                this.dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                return;
            }
            case 72: 
            case 107: 
            case 117: 
            case 146: 
            case 177: 
            case 178: {
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 101: {
                this.exprSubType = 2;
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 145: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = this.nodes[0].dataType;
                    }
                } else if (this.nodes[0].dataType.isDateTimeType()) {
                    if (this.nodes[2].dataType == null) {
                        throw Error.error(5561);
                    }
                    if (!this.nodes[2].dataType.isIntervalType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = new ArrayType(this.nodes[0].getDataType(), Integer.MAX_VALUE);
                return;
            }
            case 96: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5575);
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.nodes[0].valueData = ValuePool.getInt(n);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 165;
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[2].dataType;
                return;
            }
            case 165: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2].dataType.typeCode == 91) {
                    // empty if block
                }
                this.dataType = this.nodes[2].dataType;
                if (this.dataType.typeCode == 91) {
                    n = ((Number)this.nodes[0].valueData).intValue();
                    switch (n) {
                        case 137: 
                        case 179: 
                        case 264: 
                        case 871: 
                        case 872: 
                        case 873: 
                        case 981: 
                        case 982: 
                        case 984: 
                        case 985: 
                        case 986: {
                            this.dataType = Type.SQL_TIMESTAMP;
                        }
                    }
                }
                return;
            }
            case 97: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = this.nodes[0];
                    this.nodes[0] = new ExpressionValue(ValuePool.getInt(987), Type.SQL_INTEGER);
                } else {
                    if (!this.nodes[0].dataType.isCharacterType()) {
                        throw Error.error(5563);
                    }
                    n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                    this.nodes[0].valueData = ValuePool.getInt(n);
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                this.funcType = 166;
            }
            case 166: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[2].dataType;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP;
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType.isCharacterType()) {
                    this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                }
                if (this.nodes[2].dataType.isCharacterType()) {
                    this.nodes[2] = new ExpressionOp(this.nodes[2], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                }
                block79 : switch (this.nodes[1].dataType.typeCode) {
                    case 91: {
                        if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                            throw Error.error(5563);
                        }
                        if (this.nodes[2].dataType.isDateTimeTypeWithZone()) {
                            this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                        }
                        switch ((Integer)this.nodes[0].valueData) {
                            case 987: 
                            case 988: 
                            case 989: 
                            case 990: 
                            case 991: {
                                break block79;
                            }
                        }
                        throw Error.error(5563);
                    }
                    case 93: {
                        if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                            throw Error.error(5563);
                        }
                        if (!this.nodes[2].dataType.isDateTimeTypeWithZone()) break;
                        this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                        break;
                    }
                    case 95: {
                        if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                            throw Error.error(5563);
                        }
                        if (this.nodes[2].dataType.isDateTimeTypeWithZone()) break;
                        this.nodes[2] = new ExpressionOp(this.nodes[2], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                        break;
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 186: {
                if (this.extractSpec != 0) {
                    return;
                }
                n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.extractSpec = FunctionCustom.getExtractTokenForTSIPart(n);
                this.nodes[0] = new ExpressionValue((Object)this.extractSpec, Type.SQL_INTEGER);
                this.funcType = 5;
                super.resolveTypes(session, expression2);
                return;
            }
            case 187: {
                if (this.extractSpec != 0) {
                    return;
                }
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isDateTimeType()) {
                    throw Error.error(5563);
                }
                n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.extractSpec = FunctionCustom.getExtractTokenForTSIPart(n);
                if (this.extractSpec == 735) {
                    this.extractSpec = 733;
                } else if (this.extractSpec == 183) {
                    this.extractSpec = 772;
                }
                this.nodes[0] = new ExpressionValue((Object)this.extractSpec, Type.SQL_INTEGER);
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 94: 
            case 95: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_TIMESTAMP);
                }
                if (this.nodes[1].dataType.isIntegralType()) {
                    this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_INTERVAL_DAY);
                }
                this.nodes[0].resolveTypes(session, this);
                this.nodes[1].resolveTypes(session, this);
                this.dataType = this.nodes[0].dataType;
                return;
            }
            case 98: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                switch (this.nodes[0].dataType.typeCode) {
                    case 91: 
                    case 93: 
                    case 95: {
                        break;
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 140: 
            case 180: {
                int n2;
                int n3 = n = this.nodes.length == 1 || this.nodes[1] == null ? 1 : 0;
                if (this.nodes[0].dataType == null) {
                    if (n != 0) {
                        if (expression2 instanceof ExpressionLogical || expression2 instanceof ExpressionArithmetic) {
                            for (n2 = 0; n2 < expression2.nodes.length; ++n2) {
                                if (expression2.nodes[n2].dataType == null) continue;
                                this.nodes[0].dataType = expression2.nodes[n2].dataType;
                                break;
                            }
                        }
                        if (this.nodes[0].dataType == null) {
                            this.nodes[0].dataType = Type.SQL_DECIMAL;
                        }
                        if (this.nodes[0].dataType.isNumberType()) {
                            this.nodes[0].dataType = Type.SQL_DECIMAL;
                        }
                    } else {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[1].dataType = Type.SQL_INTEGER;
                        }
                        this.nodes[0].dataType = this.nodes[1].dataType.isNumberType() ? Type.SQL_DECIMAL : Type.SQL_TIMESTAMP;
                    }
                }
                if (this.nodes[0].dataType.isDateTimeType()) {
                    if (n == 0 && !this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5566);
                    }
                    this.dataType = this.nodes[0].dataType;
                    break;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
            }
            case 181: {
                int n2;
                Number number2 = null;
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
                    number2 = ValuePool.INTEGER_0;
                } else {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTEGER;
                    } else if (!this.nodes[1].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                    if (this.nodes[1].opType == 1) {
                        number2 = (Number)this.nodes[1].getValue(session);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (number2 != null) {
                    n2 = number2;
                    if (n2 < 0) {
                        n2 = 0;
                    } else if (n2 > this.dataType.scale) {
                        n2 = this.dataType.scale;
                    }
                    if ((this.dataType.typeCode == 3 || this.dataType.typeCode == 2) && n2 != this.dataType.scale) {
                        this.dataType = new NumberType(this.dataType.typeCode, this.dataType.precision - (long)this.dataType.scale + (long)n2, n2);
                    }
                }
                return;
            }
            case 169: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1] != null) {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5563);
                    }
                    if (!this.nodes[0].dataType.isDateTimeType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = CharacterType.getCharacterType(12, 64L);
                return;
            }
            case 173: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                return;
            }
            case 170: 
            case 174: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1] == null) {
                    String string2 = "DD-MON-YYYY HH24:MI:SS";
                    if (this.funcType == 174) {
                        string2 = "DD-MON-YYYY HH24:MI:SS.FF";
                    }
                    this.nodes[1] = new ExpressionValue(string2, Type.SQL_VARCHAR);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.funcType == 170 ? Type.SQL_TIMESTAMP_NO_FRACTION : Type.SQL_TIMESTAMP;
                return;
            }
            case 163: {
                Type type = this.nodes[0].dataType;
                if (this.nodes[1] == null) {
                    if (type == null) {
                        type = this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!type.isCharacterType() && type.typeCode != 93 && type.typeCode != 95 && !type.isNumberType()) {
                        throw Error.error(5561);
                    }
                } else {
                    if (type == null) {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                            type = this.nodes[1].dataType;
                        } else {
                            type = this.nodes[1].dataType.isCharacterType() ? (this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT) : (this.nodes[0].dataType = Type.SQL_DATE);
                        }
                    }
                    if (this.nodes[1].dataType == null) {
                        if (type.isCharacterType()) {
                            this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                        } else if (type.typeCode == 91) {
                            this.nodes[1].dataType = Type.SQL_TIME_MAX;
                        }
                    }
                    if (!(type.typeCode == 91 && this.nodes[1].dataType.typeCode == 92 || type.isCharacterType() && this.nodes[1].dataType.isCharacterType())) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = Type.SQL_TIMESTAMP;
                return;
            }
            case 164: {
                Type type = this.nodes[0].dataType;
                if (type == null) {
                    type = this.nodes[0].dataType = Type.SQL_BIGINT;
                }
                if (type.typeCode != 93 && type.typeCode != 95 && !type.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                return;
            }
            case 127: {
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 158: {
                this.dataType = Type.SQL_BINARY_16;
                break;
            }
            case 183: {
                if (this.nodes[0] == null) {
                    this.dataType = Type.SQL_GUID;
                    break;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                    this.dataType = Type.SQL_GUID;
                    break;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.dataType = Type.SQL_GUID;
                    break;
                }
                if (this.nodes[0].dataType.isBinaryType() && !this.nodes[0].dataType.isLobType()) {
                    this.dataType = Type.SQL_CHAR_UUID;
                    break;
                }
                throw Error.error(5563);
            }
            case 184: 
            case 185: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                    } else if (!this.nodes[0].dataType.isDateTimeType() || this.nodes[0].dataType.typeCode == 92 || this.nodes[0].dataType.typeCode == 94) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 130: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_BIGINT;
                    } else if (!this.nodes[0].dataType.isExactNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 71: 
            case 75: 
            case 76: 
            case 85: 
            case 86: 
            case 87: 
            case 100: 
            case 119: 
            case 129: 
            case 141: 
            case 151: 
            case 152: 
            case 161: 
            case 162: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 150: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 77: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 153: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 4L);
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.funcType == 80) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType;
                } else {
                    this.dataType = this.nodes[0].dataType;
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = this.nodes[0].dataType;
                    }
                    for (n = 0; n < this.nodes.length; ++n) {
                        if (this.nodes[n].dataType != null) continue;
                        this.nodes[n].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType.getAggregateType(this.nodes[1].dataType);
                }
                switch (this.dataType.typeCode) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 25: {
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        break block0;
                    }
                }
                throw Error.error(5561);
            }
            case 74: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 83: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 1L);
                break;
            }
            case 102: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 103: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision * 3L / 4L);
                break;
            }
            case 106: 
            case 182: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision / 2L);
                break;
            }
            case 168: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[0].dataType.precision == 0L) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                    break;
                }
                long l = (this.nodes[0].dataType.precision + 2L) / 3L * 4L;
                this.dataType = CharacterType.getCharacterType(12, l);
                break;
            }
            case 105: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                    break;
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                break;
            }
            case 131: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                break;
            }
            case 136: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if ((n = (int)(this.nodes[0].dataType.isCharacterType() ? 1 : 0)) == 0 && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = n != 0 ? Type.SQL_VARCHAR_DEFAULT : Type.SQL_VARBINARY_DEFAULT;
                break;
            }
            case 137: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue("", Type.SQL_VARCHAR);
                }
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[n].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 115: 
            case 139: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : ((CharacterType)this.nodes[0].dataType).getCharacterType(this.nodes[0].dataType.precision);
                break;
            }
            case 155: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 138: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType() && !this.dataType.isLobType()) break;
                throw Error.error(5561);
            }
            case 133: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue("", Type.SQL_VARCHAR);
                }
            }
            case 132: 
            case 134: 
            case 135: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType() || this.nodes[1].dataType.isLobType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].exprSubType == 1) {
                    String string3 = (String)this.nodes[1].getValue(session);
                    this.pattern = Pattern.compile(string3);
                }
                switch (this.funcType) {
                    case 132: {
                        this.dataType = Type.SQL_BOOLEAN;
                        break block0;
                    }
                    case 133: {
                        this.dataType = Type.SQL_VARCHAR_DEFAULT;
                        break block0;
                    }
                    case 134: {
                        this.dataType = Type.SQL_VARCHAR_DEFAULT;
                        break block0;
                    }
                    case 135: {
                        this.dataType = Type.getDefaultArrayType(12);
                        break block0;
                    }
                }
                break;
            }
            case 88: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[n].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 116: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1] == null) {
                    this.dataType = Type.SQL_BLOB;
                    break;
                }
                this.dataType = Type.SQL_CLOB;
                if (this.nodes[1].dataType != null && this.nodes[1].dataType.isCharacterType()) break;
                throw Error.error(5561);
            }
            case 120: 
            case 142: {
                Number number3;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[2].dataType.isCharacterType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.typeCode != 40) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].opType != 1 || (number3 = (Number)this.nodes[1].getValue(session)) == null) break;
                this.dataType = ((CharacterType)this.dataType).getCharacterType(number3.longValue());
                break;
            }
            case 128: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType.collectionBaseType();
                }
                if (!this.nodes[1].dataType.collectionBaseType().canCompareDirect(this.nodes[0].dataType)) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER);
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[2].dataType.isIntegralType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 154: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.getInt(359), Type.SQL_INTEGER);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.getInt(423), Type.SQL_INTEGER);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 73: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 99: {
                this.dataType = CharacterType.getCharacterType(12, 6L);
                break;
            }
            case 104: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 114: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_TIMESTAMP_NO_FRACTION);
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 122: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                break;
            }
            case 188: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_DOUBLE);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 123: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 124: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 125: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                break;
            }
            case 126: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                break;
            }
            case 149: {
                this.dataType = CharacterType.getCharacterType(12, 6L);
                break;
            }
            case 157: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                this.dataType = Type.SQL_TIMESTAMP;
                break;
            }
            case 159: {
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 160: {
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 171: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                break;
            }
            case 172: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                break;
            }
            case 175: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1] == null) {
                    String string4 = "DD-MON-YYYY HH24:MI:SS:FF TZH:TZM";
                    this.nodes[1] = new ExpressionValue(string4, Type.SQL_VARCHAR);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5567);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 179: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (this.nodes[n].dataType.isCharacterType() && !this.nodes[n].dataType.isLobType()) continue;
                    throw Error.error(5563);
                }
                if (this.nodes[1].valueData != null && this.nodes[2].valueData != null) {
                    this.charLookup = FunctionCustom.getTranslationMap((String)this.nodes[1].valueData, (String)this.nodes[2].valueData);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public String getSQL() {
        switch (this.funcType) {
            case 1: {
                StringBuilder stringBuilder = new StringBuilder("LOCATE").append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    stringBuilder.append(",").append(this.nodes[3].getSQL());
                }
                stringBuilder.append(")").toString();
                return stringBuilder.toString();
            }
            case 120: 
            case 142: {
                StringBuilder stringBuilder = new StringBuilder(this.name);
                stringBuilder.append("(").append(this.nodes[0].getSQL());
                stringBuilder.append(",").append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    stringBuilder.append(",").append(this.nodes[2].getSQL());
                }
                stringBuilder.append(")").toString();
                return stringBuilder.toString();
            }
            case 5: 
            case 31: 
            case 32: {
                return super.getSQL();
            }
            case 128: {
                StringBuilder stringBuilder = new StringBuilder(this.name).append('(');
                stringBuilder.append(this.nodes[0].getSQL()).append(' ').append("IN");
                stringBuilder.append(' ').append(this.nodes[1].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 410) {
                    stringBuilder.append(' ').append("FROM");
                    stringBuilder.append(' ').append(this.nodes[2].getSQL());
                }
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
            case 154: {
                StringBuilder stringBuilder = new StringBuilder(this.name).append('(');
                stringBuilder.append(this.nodes[0].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 410) {
                    stringBuilder.append(' ').append("DESC");
                }
                if (((Number)this.nodes[2].valueData).intValue() == 452) {
                    stringBuilder.append(' ').append("NULLS").append(' ');
                    stringBuilder.append("LAST");
                }
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
            case 159: 
            case 160: {
                return this.name;
            }
            case 72: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 127: 
            case 146: 
            case 147: 
            case 148: 
            case 158: 
            case 167: 
            case 176: 
            case 177: 
            case 178: {
                return this.name + "(" + ")";
            }
            case 165: {
                String string2 = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return "TIMESTAMPADD" + "(" + string2 + "," + this.nodes[1].getSQL() + "," + this.nodes[2].getSQL() + ")";
            }
            case 166: {
                String string3 = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return "TIMESTAMPDIFF" + "(" + string3 + "," + this.nodes[1].getSQL() + "," + this.nodes[2].getSQL() + ")";
            }
            case 94: {
                return this.nodes[0].getSQL() + ' ' + '+' + this.nodes[1].getSQL();
            }
            case 95: {
                return this.nodes[0].getSQL() + ' ' + '-' + this.nodes[1].getSQL();
            }
            case 130: 
            case 183: 
            case 184: 
            case 185: {
                StringBuilder stringBuilder = new StringBuilder(this.name).append('(');
                if (this.nodes[0] != null) {
                    stringBuilder.append(this.nodes[0].getSQL());
                }
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
            case 116: 
            case 140: 
            case 163: 
            case 169: 
            case 170: 
            case 173: 
            case 174: 
            case 175: 
            case 180: 
            case 181: {
                StringBuilder stringBuilder = new StringBuilder(this.name).append('(');
                stringBuilder.append(this.nodes[0].getSQL());
                if (this.nodes.length > 1 && this.nodes[1] != null) {
                    stringBuilder.append(',').append(this.nodes[1].getSQL());
                }
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 98: 
            case 100: 
            case 103: 
            case 105: 
            case 106: 
            case 117: 
            case 119: 
            case 129: 
            case 131: 
            case 138: 
            case 141: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 161: 
            case 162: 
            case 168: 
            case 182: {
                return this.name + '(' + this.nodes[0].getSQL() + ')';
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 102: 
            case 115: 
            case 132: 
            case 134: 
            case 135: 
            case 136: 
            case 139: {
                return this.name + '(' + this.nodes[0].getSQL() + "," + this.nodes[1].getSQL() + ')';
            }
            case 101: {
                StringBuilder stringBuilder = new StringBuilder(this.name).append('(');
                stringBuilder.append("ROW_COUNT");
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
            case 133: 
            case 137: 
            case 145: {
                return this.name + '(' + this.nodes[0].getSQL() + "," + this.nodes[1].getSQL() + "," + this.nodes[2].getSQL() + ')';
            }
            case 73: 
            case 99: 
            case 104: 
            case 114: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 149: 
            case 157: 
            case 171: 
            case 172: 
            case 179: 
            case 186: 
            case 187: 
            case 188: {
                return this.getSQLSimple();
            }
        }
        return super.getSQL();
    }

    private String getSQLSimple() {
        StringBuilder stringBuilder = new StringBuilder(this.name).append('(');
        for (int i = 0; i < this.nodes.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.nodes[i].getSQL());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static char[] soundex(String string2) {
        if (string2 == null) {
            return null;
        }
        string2 = string2.toUpperCase(Locale.ENGLISH);
        int n = string2.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        int n2 = 48;
        int n3 = 0;
        for (int i = 0; i < n && n3 < 4; ++i) {
            int n4;
            char c = string2.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                n4 = 55;
            } else if (c == 'H' || c == 'W') {
                n4 = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                n4 = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                n4 = 50;
            } else if (c == 'D' || c == 'T') {
                n4 = 51;
            } else if (c == 'L') {
                n4 = 52;
            } else if (c == 'M' || c == 'N') {
                n4 = 53;
            } else {
                if (c != 'R') continue;
                n4 = 54;
            }
            if (n3 == 0) {
                cArray[n3++] = c;
                n2 = n4;
                continue;
            }
            if (n4 <= 54) {
                if (n4 == n2) continue;
                cArray[n3++] = n4;
                n2 = n4;
                continue;
            }
            if (n4 != 55) continue;
            n2 = n4;
        }
        return cArray;
    }

    private static int getTSIToken(String string2) {
        int n;
        if ("yy".equalsIgnoreCase(string2) || "yyyy".equalsIgnoreCase(string2) || "year".equalsIgnoreCase(string2)) {
            n = 991;
        } else if ("qq".equalsIgnoreCase(string2) || "quarter".equalsIgnoreCase(string2)) {
            n = 990;
        } else if ("mm".equalsIgnoreCase(string2) || "month".equalsIgnoreCase(string2)) {
            n = 989;
        } else if ("dd".equalsIgnoreCase(string2) || "day".equalsIgnoreCase(string2)) {
            n = 987;
        } else if ("dy".equalsIgnoreCase(string2) || "dayofyear".equalsIgnoreCase(string2)) {
            n = 736;
        } else if ("dw".equalsIgnoreCase(string2) || "weekday".equalsIgnoreCase(string2)) {
            n = 735;
        } else if ("wk".equalsIgnoreCase(string2) || "week".equalsIgnoreCase(string2)) {
            n = 988;
        } else if ("hh".equalsIgnoreCase(string2) || "hour".equalsIgnoreCase(string2)) {
            n = 986;
        } else if ("mi".equalsIgnoreCase(string2) || "minute".equalsIgnoreCase(string2)) {
            n = 985;
        } else if ("ss".equalsIgnoreCase(string2) || "second".equalsIgnoreCase(string2)) {
            n = 984;
        } else if ("ms".equalsIgnoreCase(string2) || "millisecond".equalsIgnoreCase(string2)) {
            n = 982;
        } else if ("mcs".equalsIgnoreCase(string2) || "microsecond".equalsIgnoreCase(string2)) {
            n = 983;
        } else if ("ns".equalsIgnoreCase(string2) || "nanosecond".equalsIgnoreCase(string2)) {
            n = 981;
        } else if ("tz".equalsIgnoreCase(string2) || "tzoffset".equalsIgnoreCase(string2)) {
            n = 822;
        } else {
            throw Error.error(5566, string2);
        }
        return n;
    }

    private static int getExtractTokenForTSIPart(int n) {
        switch (n) {
            case 981: {
                return 873;
            }
            case 982: {
                return 872;
            }
            case 984: {
                return 264;
            }
            case 985: {
                return 179;
            }
            case 986: {
                return 137;
            }
            case 987: {
                return 78;
            }
            case 735: {
                return 735;
            }
            case 736: {
                return 736;
            }
            case 822: {
                return 822;
            }
            case 988: {
                return 843;
            }
            case 989: {
                return 183;
            }
            case 990: {
                return 786;
            }
            case 991: {
                return 341;
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    static int getSQLTypeForToken(String string2) {
        int n = -1;
        if ("YEAR_MONTH".equalsIgnoreCase(string2)) {
            n = 107;
        } else if ("DAY_HOUR".equalsIgnoreCase(string2)) {
            n = 108;
        } else if ("DAY_MINUTE".equalsIgnoreCase(string2)) {
            n = 109;
        } else if ("DAY_SECOND".equalsIgnoreCase(string2)) {
            n = 110;
        } else if ("DAY_MICROSECOND".equalsIgnoreCase(string2)) {
            n = 110;
        } else if ("HOUR_MINUTE".equalsIgnoreCase(string2)) {
            n = 111;
        } else if ("HOUR_SECOND".equalsIgnoreCase(string2)) {
            n = 112;
        } else if ("HOUR_MICROSECOND".equalsIgnoreCase(string2)) {
            n = 112;
        } else if ("MINUTE_SECOND".equalsIgnoreCase(string2)) {
            n = 113;
        } else if ("MINUTE_MICROSECOND".equalsIgnoreCase(string2)) {
            n = 113;
        } else if ("SECOND_MICROSECOND".equalsIgnoreCase(string2)) {
            n = 106;
        }
        return n;
    }

    private static IntKeyIntValueHashMap getTranslationMap(String string2, String string3) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = new IntKeyIntValueHashMap();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (i >= string3.length()) {
                intKeyIntValueHashMap.put(c, -1);
                continue;
            }
            char c2 = string3.charAt(i);
            intKeyIntValueHashMap.put(c, c2);
        }
        return intKeyIntValueHashMap;
    }

    private static String translateWithMap(String string2, IntKeyIntValueHashMap intKeyIntValueHashMap) {
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            int n = intKeyIntValueHashMap.get((int)c, -2);
            if (n == -2) {
                stringBuilder.append(c);
                continue;
            }
            if (n == -1) continue;
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    private static int regexpParams(String string2) {
        int n = 0;
        if (string2 == null) {
            return n;
        }
        block6: for (int i = 0; i < string2.length(); ++i) {
            switch (string2.charAt(i)) {
                case 'i': {
                    n |= 2;
                    continue block6;
                }
                case 'c': {
                    n &= 0xFFFFFFFD;
                    n |= 0x40;
                    continue block6;
                }
                case 'n': {
                    n |= 0x20;
                    continue block6;
                }
                case 'm': {
                    n |= 8;
                    continue block6;
                }
                default: {
                    throw Error.error(3472, string2);
                }
            }
        }
        return n;
    }

    static {
        nonDeterministicFuncSet.add(72);
        nonDeterministicFuncSet.add(88);
        nonDeterministicFuncSet.add(89);
        nonDeterministicFuncSet.add(90);
        nonDeterministicFuncSet.add(92);
        nonDeterministicFuncSet.add(99);
        nonDeterministicFuncSet.add(107);
        nonDeterministicFuncSet.add(109);
        nonDeterministicFuncSet.add(113);
        nonDeterministicFuncSet.add(111);
        nonDeterministicFuncSet.add(112);
        nonDeterministicFuncSet.add(110);
        nonDeterministicFuncSet.add(146);
        nonDeterministicFuncSet.add(147);
        nonDeterministicFuncSet.add(148);
        nonDeterministicFuncSet.add(149);
        nonDeterministicFuncSet.add(158);
        nonDeterministicFuncSet.add(159);
        nonDeterministicFuncSet.add(160);
        nonDeterministicFuncSet.add(163);
        nonDeterministicFuncSet.add(167);
        nonDeterministicFuncSet.add(176);
        nonDeterministicFuncSet.add(177);
        nonDeterministicFuncSet.add(178);
        nonDeterministicFuncSet.add(183);
        nonDeterministicFuncSet.add(184);
        nonDeterministicFuncSet.add(185);
        customRegularFuncMap.put(701, 71);
        customRegularFuncMap.put(702, 72);
        customRegularFuncMap.put(705, 73);
        customRegularFuncMap.put(703, 154);
        customRegularFuncMap.put(704, 74);
        customRegularFuncMap.put(706, 75);
        customRegularFuncMap.put(707, 76);
        customRegularFuncMap.put(708, 77);
        customRegularFuncMap.put(710, 78);
        customRegularFuncMap.put(711, 79);
        customRegularFuncMap.put(712, 6);
        customRegularFuncMap.put(713, 80);
        customRegularFuncMap.put(714, 81);
        customRegularFuncMap.put(715, 82);
        customRegularFuncMap.put(36, 83);
        customRegularFuncMap.put(716, 83);
        customRegularFuncMap.put(717, 84);
        customRegularFuncMap.put(719, 85);
        customRegularFuncMap.put(720, 86);
        customRegularFuncMap.put(721, 87);
        customRegularFuncMap.put(722, 88);
        customRegularFuncMap.put(723, 43);
        customRegularFuncMap.put(724, 51);
        customRegularFuncMap.put(605, 89);
        customRegularFuncMap.put(726, 91);
        customRegularFuncMap.put(725, 90);
        customRegularFuncMap.put(727, 92);
        customRegularFuncMap.put(728, 93);
        customRegularFuncMap.put(729, 94);
        customRegularFuncMap.put(730, 95);
        customRegularFuncMap.put(731, 96);
        customRegularFuncMap.put(732, 97);
        customRegularFuncMap.put(852, 187);
        customRegularFuncMap.put(853, 186);
        customRegularFuncMap.put(78, 5);
        customRegularFuncMap.put(737, 5);
        customRegularFuncMap.put(738, 5);
        customRegularFuncMap.put(739, 5);
        customRegularFuncMap.put(740, 5);
        customRegularFuncMap.put(741, 98);
        customRegularFuncMap.put(742, 99);
        customRegularFuncMap.put(744, 100);
        customRegularFuncMap.put(412, 101);
        customRegularFuncMap.put(745, 102);
        customRegularFuncMap.put(854, 114);
        customRegularFuncMap.put(747, 103);
        customRegularFuncMap.put(748, 104);
        customRegularFuncMap.put(749, 105);
        customRegularFuncMap.put(750, 106);
        customRegularFuncMap.put(137, 5);
        customRegularFuncMap.put(138, 107);
        customRegularFuncMap.put(145, 32);
        customRegularFuncMap.put(754, 1);
        customRegularFuncMap.put(755, 109);
        customRegularFuncMap.put(756, 111);
        customRegularFuncMap.put(757, 112);
        customRegularFuncMap.put(758, 113);
        customRegularFuncMap.put(759, 110);
        customRegularFuncMap.put(761, 114);
        customRegularFuncMap.put(762, 26);
        customRegularFuncMap.put(163, 115);
        customRegularFuncMap.put(453, 7);
        customRegularFuncMap.put(764, 116);
        customRegularFuncMap.put(771, 117);
        customRegularFuncMap.put(765, 1);
        customRegularFuncMap.put(767, 14);
        customRegularFuncMap.put(768, 119);
        customRegularFuncMap.put(769, 120);
        customRegularFuncMap.put(770, 31);
        customRegularFuncMap.put(179, 5);
        customRegularFuncMap.put(183, 5);
        customRegularFuncMap.put(773, 5);
        customRegularFuncMap.put(774, 122);
        customRegularFuncMap.put(856, 188);
        customRegularFuncMap.put(855, 183);
        customRegularFuncMap.put(777, 123);
        customRegularFuncMap.put(778, 124);
        customRegularFuncMap.put(781, 125);
        customRegularFuncMap.put(782, 126);
        customRegularFuncMap.put(783, 8);
        customRegularFuncMap.put(784, 127);
        customRegularFuncMap.put(785, 128);
        customRegularFuncMap.put(786, 5);
        customRegularFuncMap.put(787, 129);
        customRegularFuncMap.put(788, 130);
        customRegularFuncMap.put(789, 131);
        customRegularFuncMap.put(790, 132);
        customRegularFuncMap.put(791, 133);
        customRegularFuncMap.put(792, 134);
        customRegularFuncMap.put(793, 135);
        customRegularFuncMap.put(248, 136);
        customRegularFuncMap.put(794, 137);
        customRegularFuncMap.put(795, 138);
        customRegularFuncMap.put(254, 139);
        customRegularFuncMap.put(796, 140);
        customRegularFuncMap.put(797, 141);
        customRegularFuncMap.put(799, 142);
        customRegularFuncMap.put(798, 31);
        customRegularFuncMap.put(264, 5);
        customRegularFuncMap.put(800, 5);
        customRegularFuncMap.put(801, 145);
        customRegularFuncMap.put(802, 146);
        customRegularFuncMap.put(803, 147);
        customRegularFuncMap.put(804, 148);
        customRegularFuncMap.put(805, 149);
        customRegularFuncMap.put(806, 150);
        customRegularFuncMap.put(807, 151);
        customRegularFuncMap.put(808, 152);
        customRegularFuncMap.put(809, 154);
        customRegularFuncMap.put(810, 153);
        customRegularFuncMap.put(536, 155);
        customRegularFuncMap.put(812, 23);
        customRegularFuncMap.put(814, 157);
        customRegularFuncMap.put(815, 159);
        customRegularFuncMap.put(816, 160);
        customRegularFuncMap.put(817, 161);
        customRegularFuncMap.put(818, 162);
        customRegularFuncMap.put(298, 163);
        customRegularFuncMap.put(819, 164);
        customRegularFuncMap.put(820, 165);
        customRegularFuncMap.put(821, 166);
        customRegularFuncMap.put(822, 167);
        customRegularFuncMap.put(823, 168);
        customRegularFuncMap.put(824, 169);
        customRegularFuncMap.put(825, 170);
        customRegularFuncMap.put(826, 171);
        customRegularFuncMap.put(827, 172);
        customRegularFuncMap.put(828, 173);
        customRegularFuncMap.put(829, 174);
        customRegularFuncMap.put(830, 175);
        customRegularFuncMap.put(832, 176);
        customRegularFuncMap.put(833, 177);
        customRegularFuncMap.put(834, 178);
        customRegularFuncMap.put(303, 179);
        customRegularFuncMap.put(835, 180);
        customRegularFuncMap.put(311, 181);
        customRegularFuncMap.put(837, 27);
        customRegularFuncMap.put(839, 185);
        customRegularFuncMap.put(840, 184);
        customRegularFuncMap.put(857, 158);
        customRegularFuncMap.put(838, 182);
        customRegularFuncMap.put(841, 183);
        customRegularFuncMap.put(842, 5);
        customRegularFuncMap.put(341, 5);
        customValueFuncMap = new IntKeyIntValueHashMap();
        customValueFuncMap.put(831, 43);
        customValueFuncMap.put(780, 52);
    }
}

