/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;

public class StatementSignal
extends Statement {
    String sqlState;
    Expression messageExpression;

    StatementSignal(int n, String string2, Expression expression2) {
        super(n, 2007);
        this.references = new OrderedHashSet();
        this.isTransactionStatement = false;
        this.sqlState = string2;
        this.messageExpression = expression2;
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.type) {
            case 108: {
                stringBuilder.append("SIGNAL").append(' ');
                stringBuilder.append("SQLSTATE");
                stringBuilder.append(' ').append('\'').append(this.sqlState).append('\'');
                break;
            }
            case 106: {
                stringBuilder.append("RESIGNAL").append(' ');
                stringBuilder.append("SQLSTATE");
                stringBuilder.append(' ').append('\'').append(this.sqlState).append('\'');
            }
        }
        return stringBuilder.toString();
    }

    protected String describe(Session session, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("STATEMENT");
        return stringBuilder.toString();
    }

    @Override
    public Result execute(Session session) {
        Result result2;
        try {
            result2 = this.getResult(session);
        }
        catch (Throwable throwable) {
            result2 = Result.newErrorResult(throwable);
        }
        if (result2.isError()) {
            result2.getException().setStatementType(this.group, this.type);
        }
        return result2;
    }

    Result getResult(Session session) {
        switch (this.type) {
            case 106: 
            case 108: {
                HsqlException hsqlException = Error.error(this.getMessage(session), this.sqlState);
                return Result.newErrorResult(hsqlException);
            }
        }
        throw Error.runtimeError(201, "StatementSignal");
    }

    void setMessage(Expression expression2) {
        this.messageExpression = expression2;
    }

    String getMessage(Session session) {
        if (this.messageExpression == null) {
            return null;
        }
        return (String)this.messageExpression.getValue(session);
    }

    @Override
    public void resolve(Session session) {
        boolean bl = false;
        switch (this.type) {
            case 106: 
            case 108: {
                bl = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSignal");
            }
        }
        if (!bl) {
            throw Error.error(5602);
        }
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public boolean isCatalogLock(int n) {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }
}

