/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.auth;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.hsqldb.lib.FrameworkLogger;

public class AuthUtils {
    private static FrameworkLogger logger = FrameworkLogger.getLog(AuthUtils.class);

    private AuthUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getInitialSchema(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT initial_schema FROM information_schema.system_users\nWHERE user_name = current_user");
            if (!resultSet.next()) {
                throw new IllegalStateException("Failed to retrieve initial_schema for current user");
            }
            String string2 = resultSet.getString(1);
            return string2;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    logger.error("Failed to close ResultSet for retrieving initial schema");
                }
            }
            resultSet = null;
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                logger.error("Failed to close Statement for retrieving db name");
            }
            statement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<String> getEnabledRoles(Connection connection) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT * FROM information_schema.enabled_roles");
            while (resultSet.next()) {
                hashSet.add(resultSet.getString(1));
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    logger.error("Failed to close ResultSet for retrieving db name");
                }
            }
            resultSet = null;
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                logger.error("Failed to close Statement for retrieving db name");
            }
            statement = null;
        }
        return hashSet;
    }
}

