/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.lib.java.JavaSystem;

public class RefCapablePropertyResourceBundle {
    private PropertyResourceBundle wrappedBundle;
    private String baseName;
    private String language;
    private String country;
    private String variant;
    private static Map<ResourceBundle, RefCapablePropertyResourceBundle> allBundles = new HashMap<ResourceBundle, RefCapablePropertyResourceBundle>();
    public static final String LS = System.getProperty("line.separator");
    private Pattern sysPropVarPattern = Pattern.compile("(?s)\\Q${\\E([^}]+?)(?:\\Q:+\\E([^}]+))?\\Q}");
    private Pattern posPattern = Pattern.compile("(?s)\\Q%{\\E(\\d)(?:\\Q:+\\E([^}]+))?\\Q}");
    private ClassLoader loader;
    public static final int THROW_BEHAVIOR = 0;
    public static final int EMPTYSTRING_BEHAVIOR = 1;
    public static final int NOOP_BEHAVIOR = 2;

    public Enumeration<String> getKeys() {
        return this.wrappedBundle.getKeys();
    }

    private RefCapablePropertyResourceBundle(String string2, PropertyResourceBundle propertyResourceBundle, ClassLoader classLoader) {
        this.baseName = string2;
        this.wrappedBundle = propertyResourceBundle;
        Locale locale = propertyResourceBundle.getLocale();
        this.loader = classLoader;
        this.language = locale.getLanguage();
        this.country = locale.getCountry();
        this.variant = locale.getVariant();
        if (this.language.length() < 1) {
            this.language = null;
        }
        if (this.country.length() < 1) {
            this.country = null;
        }
        if (this.variant.length() < 1) {
            this.variant = null;
        }
    }

    public String getExpandedString(String string2, int n) {
        String string3 = this.getString(string2);
        Matcher matcher = this.sysPropVarPattern.matcher(string3);
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            String string4 = matcher.group(1);
            String string5 = matcher.groupCount() > 1 ? matcher.group(2) : null;
            String string6 = System.getProperty(string4);
            if (string5 != null) {
                String string7 = string6 = string6 == null ? "" : string5.replaceAll("\\Q$" + string4 + "\\E\\b", Matcher.quoteReplacement(string6));
            }
            if (string6 == null) {
                switch (n) {
                    case 0: {
                        throw new RuntimeException("No Sys Property set for variable '" + string4 + "' in property value (" + string3 + ").");
                    }
                    case 1: {
                        string6 = "";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Undefined value for behavior: " + n);
                    }
                }
            }
            stringBuilder.append(string3.substring(n2, matcher.start()) + (string6 == null ? matcher.group() : string6));
            n2 = matcher.end();
        }
        return n2 < 1 ? string3 : stringBuilder.toString() + string3.substring(n2);
    }

    public String posSubst(String string2, String[] stringArray, int n) {
        Matcher matcher = this.posPattern.matcher(string2);
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            String string3;
            int n3 = Integer.parseInt(matcher.group(1)) - 1;
            String string4 = matcher.groupCount() > 1 ? matcher.group(2) : null;
            String string5 = string3 = n3 < stringArray.length ? stringArray[n3] : null;
            if (string4 != null) {
                String string6 = string3 = string3 == null ? "" : string4.replaceAll("\\Q%" + (n3 + 1) + "\\E\\b", Matcher.quoteReplacement(string3));
            }
            if (string3 == null) {
                switch (n) {
                    case 0: {
                        throw new RuntimeException(Integer.toString(stringArray.length) + " positional values given, but property string contains (" + matcher.group() + ").");
                    }
                    case 1: {
                        string3 = "";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Undefined value for behavior: " + n);
                    }
                }
            }
            stringBuilder.append(string2.substring(n2, matcher.start()) + (string3 == null ? matcher.group() : string3));
            n2 = matcher.end();
        }
        return n2 < 1 ? string2 : stringBuilder.toString() + string2.substring(n2);
    }

    public String getExpandedString(String string2, String[] stringArray, int n, int n2) {
        return this.posSubst(this.getExpandedString(string2, n), stringArray, n2);
    }

    public String getString(String string2, String[] stringArray, int n) {
        return this.posSubst(this.getString(string2), stringArray, n);
    }

    public String toString() {
        return this.baseName + " for " + this.language + " / " + this.country + " / " + this.variant;
    }

    public String getString(String string2) {
        String string3 = this.wrappedBundle.getString(string2);
        if (string3.length() < 1) {
            string3 = this.getStringFromFile(string2);
            if (string3.indexOf(13) > -1) {
                string3 = string3.replaceAll("\\Q\r\n", "\n").replaceAll("\\Q\r", "\n");
            }
            if (string3.length() > 0 && string3.charAt(string3.length() - 1) == '\n') {
                string3 = string3.substring(0, string3.length() - 1);
            }
        }
        return RefCapablePropertyResourceBundle.toNativeLs(string3);
    }

    public static String toNativeLs(String string2) {
        return LS.equals("\n") ? string2 : string2.replaceAll("\\Q\n", LS);
    }

    public static RefCapablePropertyResourceBundle getBundle(String string2, ClassLoader classLoader) {
        return RefCapablePropertyResourceBundle.getRef(string2, ResourceBundle.getBundle(string2, Locale.getDefault(), classLoader), classLoader);
    }

    public static RefCapablePropertyResourceBundle getBundle(String string2, Locale locale, ClassLoader classLoader) {
        return RefCapablePropertyResourceBundle.getRef(string2, ResourceBundle.getBundle(string2, locale, classLoader), classLoader);
    }

    private static RefCapablePropertyResourceBundle getRef(String string2, ResourceBundle resourceBundle, ClassLoader classLoader) {
        if (!(resourceBundle instanceof PropertyResourceBundle)) {
            throw new MissingResourceException("Found a Resource Bundle, but it is a " + resourceBundle.getClass().getName(), PropertyResourceBundle.class.getName(), null);
        }
        if (allBundles.containsKey(resourceBundle)) {
            return allBundles.get(resourceBundle);
        }
        RefCapablePropertyResourceBundle refCapablePropertyResourceBundle = new RefCapablePropertyResourceBundle(string2, (PropertyResourceBundle)resourceBundle, classLoader);
        allBundles.put(resourceBundle, refCapablePropertyResourceBundle);
        return refCapablePropertyResourceBundle;
    }

    private InputStream getMostSpecificStream(String string2, String string3, String string4, String string5) {
        final String string6 = this.baseName.replace('.', '/') + '/' + string2 + (string3 == null ? "" : "_" + string3) + (string4 == null ? "" : "_" + string4) + (string5 == null ? "" : "_" + string5) + ".text";
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return RefCapablePropertyResourceBundle.this.loader.getResourceAsStream(string6);
            }
        });
        return inputStream == null && string3 != null ? this.getMostSpecificStream(string2, string4 == null ? null : string3, string5 == null ? null : string4, null) : inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringFromFile(String string2) {
        int n;
        byte[] byArray = null;
        InputStream inputStream = this.getMostSpecificStream(string2, this.language, this.country, this.variant);
        if (inputStream == null) {
            throw new MissingResourceException("Key '" + string2 + "' is present in .properties file with no value, yet text file resource is missing", RefCapablePropertyResourceBundle.class.getName(), string2);
        }
        try {
            try {
                byArray = new byte[inputStream.available()];
            }
            catch (IOException iOException) {
                throw new MissingResourceException("Failed to read in value for key '" + string2 + "': " + iOException, RefCapablePropertyResourceBundle.class.getName(), string2);
            }
            catch (Throwable throwable) {
                throw new MissingResourceException("Resource is too big to read in '" + string2 + "' value in one gulp.\nPlease run the program with more RAM (try Java -Xm* switches).: " + throwable, RefCapablePropertyResourceBundle.class.getName(), string2);
            }
            try {
                int n2;
                for (n = 0; n < byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) > 0; n += n2) {
                }
            }
            catch (IOException iOException) {
                throw new MissingResourceException("Failed to read in value for '" + string2 + "': " + iOException, RefCapablePropertyResourceBundle.class.getName(), string2);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Failed to close input stream: " + iOException);
            }
        }
        if (n != byArray.length) {
            throw new MissingResourceException("Didn't read all bytes.  Read in " + n + " bytes out of " + byArray.length + " bytes for key '" + string2 + "'", RefCapablePropertyResourceBundle.class.getName(), string2);
        }
        try {
            return new String(byArray, JavaSystem.CS_ISO_8859_1);
        }
        catch (Throwable throwable) {
            throw new MissingResourceException("Value for key '" + string2 + "' too big to convert to String.  Please run the program with more RAM (try Java -Xm* switches).: " + throwable, RefCapablePropertyResourceBundle.class.getName(), string2);
        }
    }
}

