/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.java;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;

public class JavaSystem {
    public static final Charset CS_ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset CS_US_ASCII = Charset.forName("US-ASCII");
    public static final Charset CS_UTF8 = Charset.forName("UTF-8");
    private static int javaVersion;
    static final BigDecimal BD_1;
    static final BigDecimal MBD_1;

    public static int javaVersion() {
        return javaVersion;
    }

    public static long availableMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long usedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static Throwable unmap(MappedByteBuffer mappedByteBuffer) {
        if (mappedByteBuffer == null) {
            return null;
        }
        if (javaVersion > 8) {
            try {
                Class<?> clazz = Class.forName("sun.misc.Unsafe");
                Field field2 = clazz.getDeclaredField("theUnsafe");
                field2.setAccessible(true);
                Object object = field2.get(null);
                Method method = clazz.getMethod("invokeCleaner", ByteBuffer.class);
                method.invoke(object, mappedByteBuffer);
            }
            catch (Throwable throwable) {
                return throwable;
            }
        }
        try {
            Method method = mappedByteBuffer.getClass().getMethod("cleaner", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke((Object)mappedByteBuffer, new Object[0]);
            Method method2 = object.getClass().getMethod("clean", new Class[0]);
            method2.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return noSuchMethodException;
        }
        catch (InvocationTargetException invocationTargetException) {
            return invocationTargetException;
        }
        catch (Throwable throwable) {
            return throwable;
        }
        return null;
    }

    public static IOException toIOException(Throwable throwable) {
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IOException(throwable);
    }

    public static int precision(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        int n = bigDecimal.compareTo(BD_1) < 0 && bigDecimal.compareTo(MBD_1) > 0 ? bigDecimal.scale() : bigDecimal.precision();
        return n;
    }

    static {
        try {
            String string2 = System.getProperty("java.specification.version", "6");
            if (string2.startsWith("1.")) {
                string2 = string2.substring(2);
            }
            javaVersion = Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            javaVersion = 12;
        }
        BD_1 = BigDecimal.valueOf(1L);
        MBD_1 = BigDecimal.valueOf(-1L);
    }
}

