/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.UnsupportedEncodingException;
import org.hsqldb.Database;
import org.hsqldb.DatabaseType;
import org.hsqldb.HsqlException;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManagerSimple;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RAFile;
import org.hsqldb.persist.TextFileReader;
import org.hsqldb.persist.TextFileReader8;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputText;
import org.hsqldb.rowio.RowInputTextQuoted;
import org.hsqldb.rowio.RowOutputText;
import org.hsqldb.rowio.RowOutputTextQuoted;

public class TextCache
extends DataFileCache {
    TextFileSettings textFileSettings;
    protected String header;
    protected Table table;
    private LongKeyHashMap uncommittedCache;
    HsqlByteArrayOutputStream buffer = new HsqlByteArrayOutputStream(128);

    TextCache(Table table, String string2) {
        super(table.database, string2);
        this.table = table;
        this.uncommittedCache = new LongKeyHashMap();
    }

    @Override
    protected void initParams(Database database, String string2, boolean bl) {
        this.database = database;
        this.fa = FileUtil.getFileUtil();
        this.textFileSettings = new TextFileSettings(database.getProperties(), string2);
        this.dataFileName = this.textFileSettings.getFileName();
        if (this.dataFileName == null) {
            throw Error.error(301);
        }
        this.dataFileName = ((FileUtil)this.fa).canonicalOrAbsolutePath(this.dataFileName);
        this.maxCacheRows = this.textFileSettings.getMaxCacheRows();
        this.maxCacheBytes = this.textFileSettings.getMaxCacheBytes();
        this.maxDataFileSize = 274877906816L;
        this.cachedRowPadding = 1;
        this.dataFileScale = 1;
    }

    @Override
    protected void initBuffers() {
        if (this.textFileSettings.isQuoted || this.textFileSettings.isAllQuoted) {
            this.rowIn = new RowInputTextQuoted(this.textFileSettings);
            this.rowOut = new RowOutputTextQuoted(this.textFileSettings);
        } else {
            this.rowIn = new RowInputText(this.textFileSettings);
            this.rowOut = new RowOutputText(this.textFileSettings);
        }
    }

    @Override
    public void open(boolean bl) {
        this.fileFreePosition = 0L;
        try {
            int n = this.database.getType() == DatabaseType.DB_RES ? 2 : 5;
            this.dataFile = RAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
            this.fileFreePosition = this.dataFile.length();
            if (this.fileFreePosition > this.maxDataFileSize) {
                throw Error.error(468);
            }
            this.initBuffers();
            this.spaceManager = new DataSpaceManagerSimple(this, bl);
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 42, new Object[]{this.dataFileName, throwable.toString()});
        }
        this.cacheReadonly = bl;
    }

    @Override
    public void release() {
        this.close();
    }

    @Override
    public void close() {
        if (this.dataFile == null) {
            return;
        }
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            boolean bl = this.dataFile.length() <= (long)this.textFileSettings.bytesForLineEnd.length;
            this.dataFile.synch();
            this.dataFile.close();
            this.dataFile = null;
            if (bl && !this.cacheReadonly) {
                FileUtil.getFileUtil().delete(this.dataFileName);
            }
            this.uncommittedCache.clear();
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 43, new Object[]{this.dataFileName, throwable.toString()});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void purge() {
        this.writeLock.lock();
        try {
            this.uncommittedCache.clear();
            if (this.cacheReadonly) {
                this.release();
            } else {
                if (this.dataFile != null) {
                    this.dataFile.close();
                    this.dataFile = null;
                }
                FileUtil.getFileUtil().delete(this.dataFileName);
            }
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 44, new Object[]{this.dataFileName, throwable.toString()});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            long l = cachedObject.getPos();
            CachedObject cachedObject2 = (CachedObject)this.uncommittedCache.remove(l);
            if (cachedObject2 != null) {
                return;
            }
            this.cache.release(l);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removePersistence(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.clearRowImage(cachedObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void clearRowImage(CachedObject cachedObject) {
        try {
            int n = cachedObject.getStorageSize();
            this.rowOut.reset();
            HsqlByteArrayOutputStream hsqlByteArrayOutputStream = this.rowOut.getOutputStream();
            for (int i = n - this.textFileSettings.bytesForLineEnd.length; i > 0; i -= this.textFileSettings.bytesForSpace.length) {
                hsqlByteArrayOutputStream.write(this.textFileSettings.bytesForSpace);
            }
            hsqlByteArrayOutputStream.write(this.textFileSettings.bytesForLineEnd);
            this.dataFile.seek(cachedObject.getPos());
            this.dataFile.write(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size());
        }
        catch (Throwable throwable) {
            throw Error.runtimeError(201, throwable.getMessage());
        }
    }

    public void addInit(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.cache.put(cachedObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void add(CachedObject cachedObject, boolean bl) {
        this.writeLock.lock();
        try {
            this.uncommittedCache.put(cachedObject.getPos(), cachedObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedObject get(CachedObject cachedObject, PersistentStore persistentStore, boolean bl) {
        if (cachedObject == null) {
            return null;
        }
        this.writeLock.lock();
        try {
            CachedObject cachedObject2 = this.cache.get(cachedObject.getPos());
            if (cachedObject2 != null) {
                CachedObject cachedObject3 = cachedObject;
                return cachedObject3;
            }
            this.buffer.reset(cachedObject.getStorageSize());
            this.dataFile.seek(cachedObject.getPos());
            this.dataFile.read(this.buffer.getBuffer(), 0, cachedObject.getStorageSize());
            this.buffer.setSize(cachedObject.getStorageSize());
            String string2 = this.buffer.toString(this.textFileSettings.charEncoding);
            ((RowInputText)this.rowIn).setSource(string2, cachedObject.getPos(), this.buffer.size());
            persistentStore.get(cachedObject, this.rowIn);
            this.cache.put(cachedObject);
            CachedObject cachedObject4 = cachedObject;
            return cachedObject4;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public CachedObject get(long l, PersistentStore persistentStore, boolean bl) {
        throw Error.runtimeError(201, "TextCache");
    }

    @Override
    protected void saveRows(CachedObject[] cachedObjectArray, int n, int n2) {
    }

    @Override
    public void saveRow(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.setFileModified();
            this.saveRowNoLock(cachedObject);
            this.uncommittedCache.remove(cachedObject.getPos());
            this.cache.put(cachedObject);
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("saveRow failed", throwable);
            throw Error.error(466, throwable);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeaderInitialise(String string2) {
        this.header = string2;
    }

    public void setHeader(String string2) {
        if (this.textFileSettings.ignoreFirst && this.fileFreePosition == 0L) {
            try {
                this.writeHeader(string2);
                this.header = string2;
            }
            catch (HsqlException hsqlException) {
                throw new HsqlException(hsqlException, Error.getMessage(467), 467);
            }
            return;
        }
        throw Error.error(486);
    }

    private void writeHeader(String string2) {
        try {
            byte[] byArray = null;
            String string3 = string2 + TextFileSettings.NL;
            try {
                byArray = string3.getBytes(this.textFileSettings.charEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string3.getBytes();
            }
            this.dataFile.seek(0L);
            this.dataFile.write(byArray, 0, byArray.length);
            this.fileFreePosition = byArray.length;
        }
        catch (Throwable throwable) {
            throw Error.error(484, throwable);
        }
    }

    public long getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }

    public TextFileSettings getTextFileSettings() {
        return this.textFileSettings;
    }

    public boolean isIgnoreFirstLine() {
        return this.textFileSettings.ignoreFirst;
    }

    @Override
    protected void setFileModified() {
        this.fileModified = true;
    }

    public TextFileReader getTextFileReader() {
        return TextFileReader8.newTextFileReader(this.dataFile, this.textFileSettings, this.rowIn, this.cacheReadonly);
    }
}

