/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.CharArrayWriter;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.TextFileReader;
import org.hsqldb.persist.TextFileReader16;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;

public class TextFileReader8
implements TextFileReader {
    RandomAccessInterface dataFile;
    RowInputInterface rowIn;
    TextFileSettings textFileSettings;
    String header;
    boolean isReadOnly;
    StringCreator buffer;
    long position = 0L;

    TextFileReader8() {
    }

    TextFileReader8(RandomAccessInterface randomAccessInterface, TextFileSettings textFileSettings, RowInputInterface rowInputInterface, boolean bl) {
        this.dataFile = randomAccessInterface;
        this.textFileSettings = textFileSettings;
        this.rowIn = rowInputInterface;
        this.isReadOnly = bl;
        this.buffer = StringCreator.getStringCreator(Byte.TYPE, textFileSettings.charEncoding);
        this.skipBOM();
    }

    static TextFileReader newTextFileReader(RandomAccessInterface randomAccessInterface, TextFileSettings textFileSettings, RowInputInterface rowInputInterface, boolean bl) {
        if (textFileSettings.isUTF16) {
            return new TextFileReader16(randomAccessInterface, textFileSettings, rowInputInterface, bl);
        }
        return new TextFileReader8(randomAccessInterface, textFileSettings, rowInputInterface, bl);
    }

    private void skipBOM() {
        try {
            if (this.textFileSettings.isUTF8) {
                this.dataFile.seek(0L);
                if (this.dataFile.read() == 239 && this.dataFile.read() == 187 && this.dataFile.read() == 191) {
                    this.position = 3L;
                }
            }
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    @Override
    public RowInputInterface readObject() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        this.buffer.reset();
        this.position = this.findNextUsedLinePos();
        if (this.position == -1L) {
            return null;
        }
        try {
            this.dataFile.seek(this.position);
            long l = 0L;
            long l2 = -1L;
            while (!bl2) {
                int n = this.readChar();
                bl4 = false;
                if (n == -1) {
                    if (this.buffer.size() == 0) {
                        return null;
                    }
                    bl2 = true;
                    if (bl3 || this.isReadOnly) break;
                    this.dataFile.write(this.textFileSettings.bytesForLineEnd, 0, this.textFileSettings.bytesForLineEnd.length);
                    for (int i = 0; i < this.textFileSettings.bytesForLineEnd.length; ++i) {
                        this.buffer.write(this.textFileSettings.bytesForLineEnd[i]);
                    }
                    break;
                }
                if (n == this.textFileSettings.singleSeparator) {
                    if (!bl) {
                        l2 = l;
                        bl5 = false;
                        bl = false;
                    }
                } else if (n == this.textFileSettings.quoteChar) {
                    bl4 = true;
                    bl2 = bl3;
                    bl3 = false;
                    if (this.textFileSettings.isQuoted && (this.textFileSettings.singleSeparator == '\u0000' || l == l2 + 1L)) {
                        bl5 = true;
                    }
                    if (bl5) {
                        bl = !bl;
                    }
                } else {
                    switch (n) {
                        case 13: {
                            bl3 = !bl;
                            break;
                        }
                        case 10: {
                            bl2 = !bl;
                            break;
                        }
                        default: {
                            bl4 = true;
                            bl2 = bl3;
                            bl3 = false;
                        }
                    }
                }
                this.buffer.write(n);
                ++l;
            }
            if (bl2) {
                String string2;
                if (bl4) {
                    this.buffer.setSize(this.buffer.size() - 1);
                }
                try {
                    string2 = this.buffer.getString();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw Error.error(331);
                }
                ((RowInputText)this.rowIn).setSource(string2, this.position, this.buffer.getByteSize());
                this.position += (long)this.rowIn.getSize();
                return this.rowIn;
            }
            return null;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    @Override
    public void readHeaderLine() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.buffer.reset();
        try {
            this.dataFile.seek(this.position);
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
        while (!bl) {
            int n;
            bl3 = false;
            try {
                n = this.readChar();
                if (n == -1) {
                    if (this.buffer.size() == 0) {
                        return;
                    }
                    bl = true;
                    if (this.isReadOnly) break;
                    this.dataFile.write(this.textFileSettings.bytesForLineEnd, 0, this.textFileSettings.bytesForLineEnd.length);
                    for (int i = 0; i < this.textFileSettings.bytesForLineEnd.length; ++i) {
                        this.buffer.write(this.textFileSettings.bytesForLineEnd[i]);
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                throw Error.error(483);
            }
            switch (n) {
                case 13: {
                    bl2 = true;
                    break;
                }
                case 10: {
                    bl = true;
                    break;
                }
                default: {
                    bl3 = true;
                    bl = bl2;
                    bl2 = false;
                }
            }
            if (bl2 || bl) continue;
            this.buffer.write(n);
        }
        if (bl3) {
            this.buffer.setSize(this.buffer.size() - 1);
        }
        try {
            this.header = this.buffer.getString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Error.error(331);
        }
        this.position += (long)this.buffer.getByteSize();
    }

    private long findNextUsedLinePos() {
        try {
            long l = this.position;
            long l2 = this.position;
            boolean bl = false;
            this.dataFile.seek(this.position);
            block8: while (true) {
                int n = this.readChar();
                l2 += (long)this.getByteSizeForChar();
                switch (n) {
                    case 13: {
                        bl = true;
                        continue block8;
                    }
                    case 10: {
                        bl = false;
                        ((RowInputText)this.rowIn).skippedLine();
                        l = l2;
                        continue block8;
                    }
                    case 32: {
                        if (!bl) continue block8;
                        bl = false;
                        ((RowInputText)this.rowIn).skippedLine();
                        continue block8;
                    }
                    case -1: {
                        return -1L;
                    }
                }
                break;
            }
            if (bl) {
                bl = false;
                ((RowInputText)this.rowIn).skippedLine();
            }
            return l;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    int getByteSizeForChar() {
        return 1;
    }

    int readChar() {
        try {
            int n = this.dataFile.read();
            return n;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    @Override
    public String getHeaderLine() {
        return this.header;
    }

    @Override
    public long getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }

    static class StringCreatorChars
    extends StringCreator {
        private CharArrayWriter buffer = new CharArrayWriter(128);

        StringCreatorChars() {
        }

        @Override
        void reset() {
            this.buffer.reset();
        }

        @Override
        void write(int n) {
            this.buffer.write(n);
        }

        @Override
        int size() {
            return this.buffer.size();
        }

        @Override
        void setSize(int n) {
            this.buffer.setSize(n);
        }

        @Override
        String getString() {
            String string2 = new String(this.buffer.getBuffer(), 0, this.buffer.size());
            return string2;
        }

        @Override
        int getByteSize() {
            return this.buffer.size() * 2;
        }
    }

    static class StringCreatorBytes
    extends StringCreator {
        private HsqlByteArrayOutputStream buffer = new HsqlByteArrayOutputStream(128);
        private String encoding;

        StringCreatorBytes(String string2) {
            this.encoding = string2;
        }

        @Override
        void reset() {
            this.buffer.reset();
        }

        @Override
        void write(int n) {
            this.buffer.write(n);
        }

        @Override
        int size() {
            return this.buffer.size();
        }

        @Override
        void setSize(int n) {
            this.buffer.setSize(n);
        }

        @Override
        String getString() throws UnsupportedEncodingException {
            return this.buffer.toString(this.encoding);
        }

        @Override
        int getByteSize() {
            return this.buffer.size();
        }
    }

    static abstract class StringCreator {
        StringCreator() {
        }

        static StringCreator getStringCreator(Class clazz, String string2) {
            if (Byte.TYPE.equals(clazz)) {
                return new StringCreatorBytes(string2);
            }
            if (Character.TYPE.equals(clazz)) {
                return new StringCreatorChars();
            }
            throw Error.runtimeError(201, "StringCreator");
        }

        abstract void reset();

        abstract void write(int var1);

        abstract int size();

        abstract void setSize(int var1);

        abstract String getString() throws UnsupportedEncodingException;

        abstract int getByteSize();
    }
}

