/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import org.hsqldb.error.Error;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputText;

public class RowInputTextQuoted
extends RowInputText {
    private static final int NORMAL_FIELD = 0;
    private static final int NEED_END_QUOTE = 1;
    private static final int FOUND_QUOTE = 2;
    private final char quoteChar;
    int charLength = 0;

    public RowInputTextQuoted(TextFileSettings textFileSettings) {
        super(textFileSettings);
        this.quoteChar = textFileSettings.quoteChar;
    }

    @Override
    public void setSource(String string2, long l, int n) {
        super.setSource(string2, l, n);
        this.charLength = string2.length();
        for (int i = this.charLength - 1; i > -1 && (string2.charAt(i) == '\r' || string2.charAt(i) == '\n'); --i) {
            --this.charLength;
        }
    }

    @Override
    protected String getField(String string2, int n, boolean bl) {
        String string3 = null;
        if (this.next >= this.charLength || this.text.charAt(this.next) != this.quoteChar) {
            return super.getField(string2, n, bl);
        }
        try {
            ++this.field;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = false;
            int n2 = 0;
            int n3 = -1;
            if (!bl) {
                n3 = this.text.indexOf(string2, this.next);
            }
            while (this.next < this.charLength) {
                switch (n2) {
                    default: {
                        if (this.next == n3) {
                            this.next += n;
                            bl2 = true;
                            break;
                        }
                        if (this.text.charAt(this.next) == this.quoteChar) {
                            n2 = 1;
                            break;
                        }
                        stringBuilder.append(this.text.charAt(this.next));
                        break;
                    }
                    case 1: {
                        if (this.text.charAt(this.next) == this.quoteChar) {
                            n2 = 2;
                            break;
                        }
                        stringBuilder.append(this.text.charAt(this.next));
                        break;
                    }
                    case 2: {
                        if (this.text.charAt(this.next) == this.quoteChar) {
                            stringBuilder.append(this.text.charAt(this.next));
                            n2 = 1;
                            break;
                        }
                        if (!bl) {
                            n3 = this.text.indexOf(string2, this.next);
                            if (n3 < 0) {
                                n3 = this.charLength;
                            }
                            stringBuilder.append(this.text, this.next, n3);
                            this.next = n3 + n;
                            bl2 = true;
                            break;
                        }
                        this.next += n - 1;
                        n2 = 0;
                    }
                }
                if (bl2) break;
                ++this.next;
            }
            string3 = stringBuilder.toString();
        }
        catch (Exception exception) {
            String string4 = String.valueOf(this.field);
            throw Error.error(exception, 41, string4);
        }
        return string3;
    }
}

