/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.membership;

import com.clearspring.analytics.hash.MurmurHash;
import com.clearspring.analytics.stream.membership.ICompactSerializer;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;

public abstract class Filter {
    int hashCount;

    public int getHashCount() {
        return this.hashCount;
    }

    public int[] getHashBuckets(String key) {
        return Filter.getHashBuckets(key, this.hashCount, this.buckets());
    }

    public int[] getHashBuckets(byte[] key) {
        return Filter.getHashBuckets(key, this.hashCount, this.buckets());
    }

    abstract int buckets();

    public abstract void add(String var1);

    public abstract boolean isPresent(String var1);

    abstract int emptyBuckets();

    ICompactSerializer<Filter> getSerializer() {
        Method method = null;
        try {
            method = this.getClass().getMethod("serializer", new Class[0]);
            return (ICompactSerializer)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int[] getHashBuckets(String key, int hashCount, int max) {
        byte[] b;
        try {
            b = key.getBytes("UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return Filter.getHashBuckets(b, hashCount, max);
    }

    static int[] getHashBuckets(byte[] b, int hashCount, int max) {
        int[] result2 = new int[hashCount];
        int hash1 = MurmurHash.hash(b, b.length, 0);
        int hash2 = MurmurHash.hash(b, b.length, hash1);
        for (int i = 0; i < hashCount; ++i) {
            result2[i] = Math.abs((hash1 + i * hash2) % max);
        }
        return result2;
    }
}

