/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil;

import it.unimi.dsi.fastutil.BigSwapper;
import it.unimi.dsi.fastutil.ints.IntBigArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;

public class BigArrays {
    public static final int SEGMENT_SHIFT = 27;
    public static final int SEGMENT_SIZE = 0x8000000;
    public static final int SEGMENT_MASK = 0x7FFFFFF;
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    protected BigArrays() {
    }

    public static int segment(long index2) {
        return (int)(index2 >>> 27);
    }

    public static int displacement(long index2) {
        return (int)(index2 & 0x7FFFFFFL);
    }

    public static long start(int segment) {
        return (long)segment << 27;
    }

    public static long index(int segment, int displacement) {
        return BigArrays.start(segment) + (long)displacement;
    }

    public static void ensureFromTo(long bigArrayLength, long from2, long to2) {
        if (from2 < 0L) {
            throw new ArrayIndexOutOfBoundsException("Start index (" + from2 + ") is negative");
        }
        if (from2 > to2) {
            throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        if (to2 > bigArrayLength) {
            throw new ArrayIndexOutOfBoundsException("End index (" + to2 + ") is greater than big-array length (" + bigArrayLength + ")");
        }
    }

    public static void ensureOffsetLength(long bigArrayLength, long offset, long length) {
        if (offset < 0L) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Length (" + length + ") is negative");
        }
        if (offset + length > bigArrayLength) {
            throw new ArrayIndexOutOfBoundsException("Last index (" + (offset + length) + ") is greater than big-array length (" + bigArrayLength + ")");
        }
    }

    public static void ensureLength(long bigArrayLength) {
        if (bigArrayLength < 0L) {
            throw new IllegalArgumentException("Negative big-array size: " + bigArrayLength);
        }
        if (bigArrayLength >= 288230376017494016L) {
            throw new IllegalArgumentException("Big-array size too big: " + bigArrayLength);
        }
    }

    private static void inPlaceMerge(long from2, long mid, long to2, LongComparator comp, BigSwapper swapper) {
        long secondCut;
        long firstCut;
        if (from2 >= mid || mid >= to2) {
            return;
        }
        if (to2 - from2 == 2L) {
            if (comp.compare(mid, from2) < 0) {
                swapper.swap(from2, mid);
            }
            return;
        }
        if (mid - from2 > to2 - mid) {
            firstCut = from2 + (mid - from2) / 2L;
            secondCut = BigArrays.lowerBound(mid, to2, firstCut, comp);
        } else {
            secondCut = mid + (to2 - mid) / 2L;
            firstCut = BigArrays.upperBound(from2, mid, secondCut, comp);
        }
        long first2 = firstCut;
        long middle2 = mid;
        long last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            long first1 = first2;
            long last1 = middle2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
        }
        mid = firstCut + (secondCut - mid);
        BigArrays.inPlaceMerge(from2, firstCut, mid, comp, swapper);
        BigArrays.inPlaceMerge(mid, secondCut, to2, comp, swapper);
    }

    private static long lowerBound(long mid, long to2, long firstCut, LongComparator comp) {
        long len = to2 - mid;
        while (len > 0L) {
            long half = len / 2L;
            long middle = mid + half;
            if (comp.compare(middle, firstCut) < 0) {
                mid = middle + 1L;
                len -= half + 1L;
                continue;
            }
            len = half;
        }
        return mid;
    }

    private static long med3(long a, long b, long c, LongComparator comp) {
        int ab = comp.compare(a, b);
        int ac = comp.compare(a, c);
        int bc = comp.compare(b, c);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void mergeSort(long from2, long to2, LongComparator comp, BigSwapper swapper) {
        long length = to2 - from2;
        if (length < 7L) {
            for (long i = from2; i < to2; ++i) {
                for (long j = i; j > from2 && comp.compare(j - 1L, j) > 0; --j) {
                    swapper.swap(j, j - 1L);
                }
            }
            return;
        }
        long mid = from2 + to2 >>> 1;
        BigArrays.mergeSort(from2, mid, comp, swapper);
        BigArrays.mergeSort(mid, to2, comp, swapper);
        if (comp.compare(mid - 1L, mid) <= 0) {
            return;
        }
        BigArrays.inPlaceMerge(from2, mid, to2, comp, swapper);
    }

    public static void quickSort(long from2, long to2, LongComparator comp, BigSwapper swapper) {
        long c;
        long a;
        long len = to2 - from2;
        if (len < 7L) {
            for (long i = from2; i < to2; ++i) {
                for (long j = i; j > from2 && comp.compare(j - 1L, j) > 0; --j) {
                    swapper.swap(j, j - 1L);
                }
            }
            return;
        }
        long m = from2 + len / 2L;
        if (len > 7L) {
            long l = from2;
            long n = to2 - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = BigArrays.med3(l, l + s, l + 2L * s, comp);
                m = BigArrays.med3(m - s, m, m + s, comp);
                n = BigArrays.med3(n - 2L * s, n - s, n, comp);
            }
            m = BigArrays.med3(l, m, n, comp);
        }
        long b = a = from2;
        long d = c = to2 - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(b, m)) <= 0) {
                if (comparison == 0) {
                    if (a == m) {
                        m = b;
                    } else if (b == m) {
                        m = a;
                    }
                    swapper.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(c, m)) >= 0) {
                if (comparison == 0) {
                    if (c == m) {
                        m = d;
                    } else if (d == m) {
                        m = c;
                    }
                    swapper.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            if (b == m) {
                m = d;
            } else if (c == m) {
                m = c;
            }
            swapper.swap(b++, c--);
        }
        long n = from2 + len;
        long s = Math.min(a - from2, b - a);
        BigArrays.vecSwap(swapper, from2, b - s, s);
        s = Math.min(d - c, n - d - 1L);
        BigArrays.vecSwap(swapper, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            BigArrays.quickSort(from2, from2 + s, comp, swapper);
        }
        if ((s = d - c) > 1L) {
            BigArrays.quickSort(n - s, n, comp, swapper);
        }
    }

    private static long upperBound(long from2, long mid, long secondCut, LongComparator comp) {
        long len = mid - from2;
        while (len > 0L) {
            long half = len / 2L;
            long middle = from2 + half;
            if (comp.compare(secondCut, middle) < 0) {
                len = half;
                continue;
            }
            from2 = middle + 1L;
            len -= half + 1L;
        }
        return from2;
    }

    private static void vecSwap(BigSwapper swapper, long from2, long l, long s) {
        int i = 0;
        while ((long)i < s) {
            swapper.swap(from2, l);
            ++i;
            ++from2;
            ++l;
        }
    }

    public static void main(String[] arg) {
        int[][] a = IntBigArrays.newBigArray(1L << Integer.parseInt(arg[0]));
        int k = 10;
        while (k-- != 0) {
            long start2 = -System.currentTimeMillis();
            long x = 0L;
            long i = IntBigArrays.length(a);
            while (i-- != 0L) {
                x ^= i ^ (long)IntBigArrays.get(a, i);
            }
            if (x == 0L) {
                System.err.println();
            }
            System.out.println("Single loop: " + (start2 + System.currentTimeMillis()) + "ms");
            start2 = -System.currentTimeMillis();
            long y = 0L;
            int i2 = a.length;
            while (i2-- != 0) {
                int[] t = a[i2];
                int d = t.length;
                while (d-- != 0) {
                    y ^= (long)t[d] ^ BigArrays.index(i2, d);
                }
            }
            if (y == 0L) {
                System.err.println();
            }
            if (x != y) {
                throw new AssertionError();
            }
            System.out.println("Double loop: " + (start2 + System.currentTimeMillis()) + "ms");
            long z = 0L;
            long j = IntBigArrays.length(a);
            int i3 = a.length;
            while (i3-- != 0) {
                int[] t = a[i3];
                int d = t.length;
                while (d-- != 0) {
                    y ^= (long)t[d] ^ --j;
                }
            }
            if (z == 0L) {
                System.err.println();
            }
            if (x != z) {
                throw new AssertionError();
            }
            System.out.println("Double loop (with additional index): " + (start2 + System.currentTimeMillis()) + "ms");
        }
    }
}

