/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharComparator;
import java.util.Arrays;

public final class CharIndirectHeaps {
    private CharIndirectHeaps() {
    }

    public static int downHeap(char[] refArray, int[] heap, int[] inv, int size2, int i, CharComparator c) {
        assert (i < size2);
        int e = heap[i];
        char E = refArray[e];
        if (c == null) {
            int child;
            while ((child = (i << 1) + 1) < size2) {
                int t = heap[child];
                int right2 = child + 1;
                if (right2 < size2 && refArray[heap[right2]] < refArray[t]) {
                    child = right2;
                    t = heap[child];
                }
                if (E > refArray[t]) {
                    heap[i] = t;
                    inv[heap[i]] = i;
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = (i << 1) + 1) < size2) {
                int t = heap[child];
                int right3 = child + 1;
                if (right3 < size2 && c.compare(refArray[heap[right3]], refArray[t]) < 0) {
                    child = right3;
                    t = heap[child];
                }
                if (c.compare(E, refArray[t]) > 0) {
                    heap[i] = t;
                    inv[heap[i]] = i;
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        inv[e] = i;
        return i;
    }

    public static int upHeap(char[] refArray, int[] heap, int[] inv, int size2, int i, CharComparator c) {
        assert (i < size2);
        int e = heap[i];
        char E = refArray[e];
        if (c == null) {
            int parent;
            int t;
            while (i != 0 && refArray[t = heap[parent = i - 1 >>> 1]] > E) {
                heap[i] = t;
                inv[heap[i]] = i;
                i = parent;
            }
        } else {
            int parent;
            int t;
            while (i != 0 && c.compare(refArray[t = heap[parent = i - 1 >>> 1]], E) > 0) {
                heap[i] = t;
                inv[heap[i]] = i;
                i = parent;
            }
        }
        heap[i] = e;
        inv[e] = i;
        return i;
    }

    public static void makeHeap(char[] refArray, int offset, int length, int[] heap, int[] inv, CharComparator c) {
        CharArrays.ensureOffsetLength(refArray, offset, length);
        if (heap.length < length) {
            throw new IllegalArgumentException("The heap length (" + heap.length + ") is smaller than the number of elements (" + length + ")");
        }
        if (inv.length < refArray.length) {
            throw new IllegalArgumentException("The inversion array length (" + heap.length + ") is smaller than the length of the reference array (" + refArray.length + ")");
        }
        Arrays.fill(inv, 0, refArray.length, -1);
        int i = length;
        while (i-- != 0) {
            heap[i] = offset + i;
            inv[heap[i]] = i;
        }
        i = length >>> 1;
        while (i-- != 0) {
            CharIndirectHeaps.downHeap(refArray, heap, inv, length, i, c);
        }
    }

    public static void makeHeap(char[] refArray, int[] heap, int[] inv, int size2, CharComparator c) {
        int i = size2 >>> 1;
        while (i-- != 0) {
            CharIndirectHeaps.downHeap(refArray, heap, inv, size2, i, c);
        }
    }
}

