/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleBigList;
import it.unimi.dsi.fastutil.doubles.DoubleBigArrays;
import it.unimi.dsi.fastutil.doubles.DoubleBigList;
import it.unimi.dsi.fastutil.doubles.DoubleBigListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleBigListIterators;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollections;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Random;

public final class DoubleBigLists {
    public static final EmptyBigList EMPTY_BIG_LIST = new EmptyBigList();

    private DoubleBigLists() {
    }

    public static DoubleBigList shuffle(DoubleBigList l, Random random) {
        long i = l.size64();
        while (i-- != 0L) {
            long p = (random.nextLong() & Long.MAX_VALUE) % (i + 1L);
            double t = l.getDouble(i);
            l.set(i, l.getDouble(p));
            l.set(p, t);
        }
        return l;
    }

    public static DoubleBigList singleton(double element) {
        return new Singleton(element);
    }

    public static DoubleBigList singleton(Object element) {
        return new Singleton((Double)element);
    }

    public static DoubleBigList synchronize(DoubleBigList l) {
        return new SynchronizedBigList(l);
    }

    public static DoubleBigList synchronize(DoubleBigList l, Object sync) {
        return new SynchronizedBigList(l, sync);
    }

    public static DoubleBigList unmodifiable(DoubleBigList l) {
        return new UnmodifiableBigList(l);
    }

    public static DoubleBigList asBigList(DoubleList list) {
        return new ListBigList(list);
    }

    public static class ListBigList
    extends AbstractDoubleBigList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final DoubleList list;

        protected ListBigList(DoubleList list) {
            this.list = list;
        }

        private int intIndex(long index2) {
            if (index2 >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("This big list is restricted to 32-bit indices");
            }
            return (int)index2;
        }

        @Override
        public long size64() {
            return this.list.size();
        }

        @Override
        public void size(long size2) {
            this.list.size(this.intIndex(size2));
        }

        @Override
        public DoubleBigListIterator iterator() {
            return DoubleBigListIterators.asBigListIterator(this.list.iterator());
        }

        @Override
        public DoubleBigListIterator listIterator() {
            return DoubleBigListIterators.asBigListIterator(this.list.listIterator());
        }

        @Override
        public DoubleBigListIterator listIterator(long index2) {
            return DoubleBigListIterators.asBigListIterator(this.list.listIterator(this.intIndex(index2)));
        }

        @Override
        public boolean addAll(long index2, Collection<? extends Double> c) {
            return this.list.addAll(this.intIndex(index2), c);
        }

        @Override
        public DoubleBigList subList(long from2, long to2) {
            return new ListBigList(this.list.subList(this.intIndex(from2), this.intIndex(to2)));
        }

        @Override
        public boolean contains(double key) {
            return this.list.contains(key);
        }

        @Override
        public double[] toDoubleArray() {
            return this.list.toDoubleArray();
        }

        @Override
        public void removeElements(long from2, long to2) {
            this.list.removeElements(this.intIndex(from2), this.intIndex(to2));
        }

        @Override
        @Deprecated
        public double[] toDoubleArray(double[] a) {
            return this.list.toArray(a);
        }

        @Override
        public boolean addAll(long index2, DoubleCollection c) {
            return this.list.addAll(this.intIndex(index2), c);
        }

        @Override
        public boolean addAll(DoubleCollection c) {
            return this.list.addAll(c);
        }

        @Override
        public boolean addAll(long index2, DoubleBigList c) {
            return this.list.addAll(this.intIndex(index2), c);
        }

        @Override
        public boolean addAll(DoubleBigList c) {
            return this.list.addAll(c);
        }

        @Override
        public boolean containsAll(DoubleCollection c) {
            return this.list.containsAll(c);
        }

        @Override
        public boolean removeAll(DoubleCollection c) {
            return this.list.removeAll(c);
        }

        @Override
        public boolean retainAll(DoubleCollection c) {
            return this.list.retainAll(c);
        }

        @Override
        public void add(long index2, double key) {
            this.list.add(this.intIndex(index2), key);
        }

        @Override
        public boolean add(double key) {
            return this.list.add(key);
        }

        @Override
        public double getDouble(long index2) {
            return this.list.getDouble(this.intIndex(index2));
        }

        @Override
        public long indexOf(double k) {
            return this.list.indexOf(k);
        }

        @Override
        public long lastIndexOf(double k) {
            return this.list.lastIndexOf(k);
        }

        @Override
        public double removeDouble(long index2) {
            return this.list.removeDouble(this.intIndex(index2));
        }

        @Override
        public double set(long index2, double k) {
            return this.list.set(this.intIndex(index2), k);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.list.toArray(a);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Double> c) {
            return this.list.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.list.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.list.retainAll(c);
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }
    }

    public static class UnmodifiableBigList
    extends DoubleCollections.UnmodifiableCollection
    implements DoubleBigList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleBigList list;

        protected UnmodifiableBigList(DoubleBigList l) {
            super(l);
            this.list = l;
        }

        @Override
        public double getDouble(long i) {
            return this.list.getDouble(i);
        }

        @Override
        public double set(long i, double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long i, double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double removeDouble(long i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long indexOf(double k) {
            return this.list.indexOf(k);
        }

        @Override
        public long lastIndexOf(double k) {
            return this.list.lastIndexOf(k);
        }

        @Override
        public boolean addAll(long index2, Collection<? extends Double> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getElements(long from2, double[][] a, long offset, long length) {
            this.list.getElements(from2, a, offset, length);
        }

        @Override
        public void removeElements(long from2, long to2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index2, double[][] a, long offset, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index2, double[][] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void size(long size2) {
            this.list.size(size2);
        }

        @Override
        public long size64() {
            return this.list.size64();
        }

        @Override
        public DoubleBigListIterator iterator() {
            return this.listIterator();
        }

        @Override
        public DoubleBigListIterator listIterator() {
            return DoubleBigListIterators.unmodifiable(this.list.listIterator());
        }

        @Override
        public DoubleBigListIterator listIterator(long i) {
            return DoubleBigListIterators.unmodifiable(this.list.listIterator(i));
        }

        @Override
        public DoubleBigList subList(long from2, long to2) {
            return DoubleBigLists.unmodifiable(this.list.subList(from2, to2));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return this.list.equals(o);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public int compareTo(BigList<? extends Double> o) {
            return this.list.compareTo(o);
        }

        @Override
        public boolean addAll(long index2, DoubleCollection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(DoubleBigList l) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long index2, DoubleBigList l) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double get(long i) {
            return this.list.get(i);
        }

        @Override
        @Deprecated
        public void add(long i, Double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double set(long index2, Double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double remove(long i) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public long indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        @Deprecated
        public long lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }
    }

    public static class SynchronizedBigList
    extends DoubleCollections.SynchronizedCollection
    implements DoubleBigList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleBigList list;

        protected SynchronizedBigList(DoubleBigList l, Object sync) {
            super(l, sync);
            this.list = l;
        }

        protected SynchronizedBigList(DoubleBigList l) {
            super(l);
            this.list = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getDouble(long i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.getDouble(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double set(long i, double k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long i, double k) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double removeDouble(long i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.removeDouble(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long indexOf(double k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long lastIndexOf(double k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index2, Collection<? extends Double> c) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index2, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getElements(long from2, double[][] a, long offset, long length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from2, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeElements(long from2, long to2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from2, to2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(long index2, double[][] a, long offset, long length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index2, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(long index2, double[][] a) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index2, a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void size(long size2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long size64() {
            Object object = this.sync;
            synchronized (object) {
                return this.list.size64();
            }
        }

        @Override
        public DoubleBigListIterator iterator() {
            return this.list.listIterator();
        }

        @Override
        public DoubleBigListIterator listIterator() {
            return this.list.listIterator();
        }

        @Override
        public DoubleBigListIterator listIterator(long i) {
            return this.list.listIterator(i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DoubleBigList subList(long from2, long to2) {
            Object object = this.sync;
            synchronized (object) {
                return DoubleBigLists.synchronize(this.list.subList(from2, to2), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object object = this.sync;
            synchronized (object) {
                return this.list.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compareTo(BigList<? extends Double> o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index2, DoubleCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index2, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index2, DoubleBigList l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index2, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(DoubleBigList l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void add(long i, Double k) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Double get(long i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Double set(long index2, Double k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(index2, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Double remove(long i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public long indexOf(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public long lastIndexOf(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(o);
            }
        }
    }

    public static class Singleton
    extends AbstractDoubleBigList
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final double element;

        protected Singleton(double element) {
            this.element = element;
        }

        @Override
        public double getDouble(long i) {
            if (i == 0L) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double removeDouble(long i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(double k) {
            return Double.doubleToLongBits(k) == Double.doubleToLongBits(this.element);
        }

        @Override
        public double[] toDoubleArray() {
            double[] a = new double[]{this.element};
            return a;
        }

        @Override
        public DoubleBigListIterator listIterator() {
            return DoubleBigListIterators.singleton(this.element);
        }

        @Override
        public DoubleBigListIterator listIterator(long i) {
            if (i > 1L || i < 0L) {
                throw new IndexOutOfBoundsException();
            }
            DoubleBigListIterator l = this.listIterator();
            if (i == 1L) {
                l.nextDouble();
            }
            return l;
        }

        @Override
        public DoubleBigList subList(long from2, long to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            if (from2 > to2) {
                throw new IndexOutOfBoundsException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
            }
            if (from2 != 0L || to2 != 1L) {
                return EMPTY_BIG_LIST;
            }
            return this;
        }

        @Override
        public boolean addAll(long i, Collection<? extends Double> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Double> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(DoubleBigList c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i, DoubleBigList c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i, DoubleCollection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(DoubleCollection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(DoubleCollection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(DoubleCollection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size64() {
            return 1L;
        }

        public Object clone() {
            return this;
        }
    }

    public static class EmptyBigList
    extends DoubleCollections.EmptyCollection
    implements DoubleBigList,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyBigList() {
        }

        @Override
        public double getDouble(long i) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double removeDouble(long i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long index2, double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double set(long index2, double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long indexOf(double k) {
            return -1L;
        }

        @Override
        public long lastIndexOf(double k) {
            return -1L;
        }

        @Override
        public boolean addAll(long i, Collection<? extends Double> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(DoubleCollection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(DoubleBigList c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i, DoubleCollection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i, DoubleBigList c) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void add(long index2, Double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean add(Double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double get(long i) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        @Deprecated
        public Double set(long index2, Double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double remove(long k) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public long indexOf(Object k) {
            return -1L;
        }

        @Override
        @Deprecated
        public long lastIndexOf(Object k) {
            return -1L;
        }

        @Override
        public DoubleBigListIterator listIterator() {
            return DoubleBigListIterators.EMPTY_BIG_LIST_ITERATOR;
        }

        @Override
        public DoubleBigListIterator iterator() {
            return DoubleBigListIterators.EMPTY_BIG_LIST_ITERATOR;
        }

        @Override
        public DoubleBigListIterator listIterator(long i) {
            if (i == 0L) {
                return DoubleBigListIterators.EMPTY_BIG_LIST_ITERATOR;
            }
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }

        @Override
        public DoubleBigList subList(long from2, long to2) {
            if (from2 == 0L && to2 == 0L) {
                return this;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void getElements(long from2, double[][] a, long offset, long length) {
            DoubleBigArrays.ensureOffsetLength(a, offset, length);
            if (from2 != 0L) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public void removeElements(long from2, long to2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index2, double[][] a, long offset, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index2, double[][] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void size(long s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size64() {
            return 0L;
        }

        @Override
        public int compareTo(BigList<? extends Double> o) {
            if (o == this) {
                return 0;
            }
            return o.isEmpty() ? 0 : -1;
        }

        public Object clone() {
            return EMPTY_BIG_LIST;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof BigList && ((BigList)o).isEmpty();
        }

        @Override
        public String toString() {
            return "[]";
        }

        private Object readResolve() {
            return EMPTY_BIG_LIST;
        }
    }
}

