/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.BigListIterator;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.FloatBigArrays;
import it.unimi.dsi.fastutil.floats.FloatBigList;
import it.unimi.dsi.fastutil.floats.FloatBigListIterator;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractFloatBigList
extends AbstractFloatCollection
implements FloatBigList,
FloatStack {
    protected AbstractFloatBigList() {
    }

    protected void ensureIndex(long index2) {
        if (index2 < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size64()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size64() + ")");
        }
    }

    protected void ensureRestrictedIndex(long index2) {
        if (index2 < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 >= this.size64()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size64() + ")");
        }
    }

    @Override
    public void add(long index2, float k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(float k) {
        this.add(this.size64(), k);
        return true;
    }

    @Override
    public float removeFloat(long i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float set(long index2, float k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(long index2, Collection<? extends Float> c) {
        this.ensureIndex(index2);
        Iterator<? extends Float> i = c.iterator();
        boolean retVal = i.hasNext();
        while (i.hasNext()) {
            this.add(index2++, i.next());
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Float> c) {
        return this.addAll(this.size64(), c);
    }

    @Override
    public FloatBigListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public FloatBigListIterator listIterator() {
        return this.listIterator(0L);
    }

    @Override
    public FloatBigListIterator listIterator(final long index2) {
        this.ensureIndex(index2);
        return new FloatBigListIterator(){
            long pos;
            long last;
            {
                this.pos = index2;
                this.last = -1L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < AbstractFloatBigList.this.size64();
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            @Override
            public float nextFloat() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractFloatBigList.this.getFloat(this.last);
            }

            @Override
            public float previousFloat() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractFloatBigList.this.getFloat(this.pos);
            }

            @Override
            public long nextIndex() {
                return this.pos;
            }

            @Override
            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(float k) {
                AbstractFloatBigList.this.add(this.pos++, k);
                this.last = -1L;
            }

            @Override
            public void set(float k) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                AbstractFloatBigList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                AbstractFloatBigList.this.removeFloat(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }
        };
    }

    @Override
    public boolean contains(float k) {
        return this.indexOf(k) >= 0L;
    }

    @Override
    public long indexOf(float k) {
        FloatBigListIterator i = this.listIterator();
        while (i.hasNext()) {
            float e = i.nextFloat();
            if (Float.floatToIntBits(k) != Float.floatToIntBits(e)) continue;
            return i.previousIndex();
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(float k) {
        FloatBigListIterator i = this.listIterator(this.size64());
        while (i.hasPrevious()) {
            float e = i.previousFloat();
            if (Float.floatToIntBits(k) != Float.floatToIntBits(e)) continue;
            return i.nextIndex();
        }
        return -1L;
    }

    @Override
    public void size(long size2) {
        long i = this.size64();
        if (size2 > i) {
            while (i++ < size2) {
                this.add(0.0f);
            }
        } else {
            while (i-- != size2) {
                this.remove(i);
            }
        }
    }

    @Override
    public FloatBigList subList(long from2, long to2) {
        this.ensureIndex(from2);
        this.ensureIndex(to2);
        if (from2 > to2) {
            throw new IndexOutOfBoundsException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        return new FloatSubList(this, from2, to2);
    }

    @Override
    public void removeElements(long from2, long to2) {
        this.ensureIndex(to2);
        FloatBigListIterator i = this.listIterator(from2);
        long n = to2 - from2;
        if (n < 0L) {
            throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        while (n-- != 0L) {
            i.nextFloat();
            i.remove();
        }
    }

    @Override
    public void addElements(long index2, float[][] a, long offset, long length) {
        this.ensureIndex(index2);
        FloatBigArrays.ensureOffsetLength(a, offset, length);
        while (length-- != 0L) {
            this.add(index2++, FloatBigArrays.get(a, offset++));
        }
    }

    @Override
    public void addElements(long index2, float[][] a) {
        this.addElements(index2, a, 0L, FloatBigArrays.length(a));
    }

    @Override
    public void getElements(long from2, float[][] a, long offset, long length) {
        FloatBigListIterator i = this.listIterator(from2);
        FloatBigArrays.ensureOffsetLength(a, offset, length);
        if (from2 + length > this.size64()) {
            throw new IndexOutOfBoundsException("End index (" + (from2 + length) + ") is greater than list size (" + this.size64() + ")");
        }
        while (length-- != 0L) {
            FloatBigArrays.set(a, offset++, i.nextFloat());
        }
    }

    @Override
    public void clear() {
        this.removeElements(0L, this.size64());
    }

    @Override
    @Deprecated
    public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.size64());
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @Override
    public int hashCode() {
        FloatBigListIterator i = this.iterator();
        int h = 1;
        long s = this.size64();
        while (s-- != 0L) {
            float k = i.nextFloat();
            h = 31 * h + HashCommon.float2int(k);
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BigList)) {
            return false;
        }
        BigList l = (BigList)o;
        long s = this.size64();
        if (s != l.size64()) {
            return false;
        }
        if (l instanceof FloatBigList) {
            FloatBigListIterator i1 = this.listIterator();
            FloatBigListIterator i2 = ((FloatBigList)l).listIterator();
            while (s-- != 0L) {
                if (i1.nextFloat() == i2.nextFloat()) continue;
                return false;
            }
            return true;
        }
        FloatBigListIterator i1 = this.listIterator();
        BigListIterator i2 = l.listIterator();
        while (s-- != 0L) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(BigList<? extends Float> l) {
        if (l == this) {
            return 0;
        }
        if (l instanceof FloatBigList) {
            FloatBigListIterator i1 = this.listIterator();
            FloatBigListIterator i2 = ((FloatBigList)l).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                float e2;
                float e1 = i1.nextFloat();
                int r2 = Float.compare(e1, e2 = i2.nextFloat());
                if (r2 == 0) continue;
                return r2;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        FloatBigListIterator i1 = this.listIterator();
        BigListIterator<? extends Float> i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r3 = ((Comparable)i1.next()).compareTo(i2.next());
            if (r3 == 0) continue;
            return r3;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public void push(float o) {
        this.add(o);
    }

    @Override
    public float popFloat() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeFloat(this.size64() - 1L);
    }

    @Override
    public float topFloat() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getFloat(this.size64() - 1L);
    }

    @Override
    public float peekFloat(int i) {
        return this.getFloat(this.size64() - 1L - (long)i);
    }

    @Override
    public boolean rem(float k) {
        long index2 = this.indexOf(k);
        if (index2 == -1L) {
            return false;
        }
        this.removeFloat(index2);
        return true;
    }

    @Override
    public boolean addAll(long index2, FloatCollection c) {
        return this.addAll(index2, (Collection<? extends Float>)c);
    }

    @Override
    public boolean addAll(long index2, FloatBigList l) {
        return this.addAll(index2, (FloatCollection)l);
    }

    @Override
    public boolean addAll(FloatCollection c) {
        return this.addAll(this.size64(), c);
    }

    @Override
    public boolean addAll(FloatBigList l) {
        return this.addAll(this.size64(), l);
    }

    @Override
    @Deprecated
    public void add(long index2, Float ok) {
        this.add(index2, ok.floatValue());
    }

    @Override
    @Deprecated
    public Float set(long index2, Float ok) {
        return Float.valueOf(this.set(index2, ok.floatValue()));
    }

    @Override
    @Deprecated
    public Float get(long index2) {
        return Float.valueOf(this.getFloat(index2));
    }

    @Override
    @Deprecated
    public long indexOf(Object ok) {
        return this.indexOf(((Float)ok).floatValue());
    }

    @Override
    @Deprecated
    public long lastIndexOf(Object ok) {
        return this.lastIndexOf(((Float)ok).floatValue());
    }

    @Override
    @Deprecated
    public Float remove(long index2) {
        return Float.valueOf(this.removeFloat(index2));
    }

    @Override
    @Deprecated
    public void push(Float o) {
        this.push(o.floatValue());
    }

    @Override
    @Deprecated
    public Float pop() {
        return Float.valueOf(this.popFloat());
    }

    @Override
    @Deprecated
    public Float top() {
        return Float.valueOf(this.topFloat());
    }

    @Override
    @Deprecated
    public Float peek(int i) {
        return Float.valueOf(this.peekFloat(i));
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        FloatBigListIterator i = this.iterator();
        long n = this.size64();
        boolean first2 = true;
        s.append("[");
        while (n-- != 0L) {
            if (first2) {
                first2 = false;
            } else {
                s.append(", ");
            }
            float k = i.nextFloat();
            s.append(String.valueOf(k));
        }
        s.append("]");
        return s.toString();
    }

    public static class FloatSubList
    extends AbstractFloatBigList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final FloatBigList l;
        protected final long from;
        protected long to;

        public FloatSubList(FloatBigList l, long from2, long to2) {
            this.l = l;
            this.from = from2;
            this.to = to2;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size64());
            assert (this.to <= this.l.size64());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(float k) {
            this.l.add(this.to, k);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(long index2, float k) {
            this.ensureIndex(index2);
            this.l.add(this.from + index2, k);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(long index2, Collection<? extends Float> c) {
            this.ensureIndex(index2);
            this.to += (long)c.size();
            return this.l.addAll(this.from + index2, c);
        }

        @Override
        public float getFloat(long index2) {
            this.ensureRestrictedIndex(index2);
            return this.l.getFloat(this.from + index2);
        }

        @Override
        public float removeFloat(long index2) {
            this.ensureRestrictedIndex(index2);
            --this.to;
            return this.l.removeFloat(this.from + index2);
        }

        @Override
        public float set(long index2, float k) {
            this.ensureRestrictedIndex(index2);
            return this.l.set(this.from + index2, k);
        }

        @Override
        public long size64() {
            return this.to - this.from;
        }

        @Override
        public void getElements(long from2, float[][] a, long offset, long length) {
            this.ensureIndex(from2);
            if (from2 + length > this.size64()) {
                throw new IndexOutOfBoundsException("End index (" + from2 + length + ") is greater than list size (" + this.size64() + ")");
            }
            this.l.getElements(this.from + from2, a, offset, length);
        }

        @Override
        public void removeElements(long from2, long to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            this.l.removeElements(this.from + from2, this.from + to2);
            this.to -= to2 - from2;
            assert (this.assertRange());
        }

        @Override
        public void addElements(long index2, float[][] a, long offset, long length) {
            this.ensureIndex(index2);
            this.l.addElements(this.from + index2, a, offset, length);
            this.to += length;
            assert (this.assertRange());
        }

        @Override
        public FloatBigListIterator listIterator(final long index2) {
            this.ensureIndex(index2);
            return new FloatBigListIterator(){
                long pos;
                long last;
                {
                    this.pos = index2;
                    this.last = -1L;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < this.size64();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0L;
                }

                @Override
                public float nextFloat() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return l.getFloat(from + this.last);
                }

                @Override
                public float previousFloat() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return l.getFloat(from + this.pos);
                }

                @Override
                public long nextIndex() {
                    return this.pos;
                }

                @Override
                public long previousIndex() {
                    return this.pos - 1L;
                }

                @Override
                public void add(float k) {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    this.add(this.pos++, k);
                    this.last = -1L;
                    assert (this.assertRange());
                }

                @Override
                public void set(float k) {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    this.set(this.last, k);
                }

                @Override
                public void remove() {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    this.removeFloat(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1L;
                    assert (this.assertRange());
                }
            };
        }

        @Override
        public FloatBigList subList(long from2, long to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            if (from2 > to2) {
                throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
            }
            return new FloatSubList(this, from2, to2);
        }

        @Override
        public boolean rem(float k) {
            long index2 = this.indexOf(k);
            if (index2 == -1L) {
                return false;
            }
            --this.to;
            this.l.removeFloat(this.from + index2);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(long index2, FloatCollection c) {
            this.ensureIndex(index2);
            return super.addAll(index2, c);
        }

        @Override
        public boolean addAll(long index2, FloatBigList l) {
            this.ensureIndex(index2);
            return super.addAll(index2, l);
        }
    }
}

