/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.io;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanBigArrays;
import it.unimi.dsi.fastutil.booleans.BooleanIterable;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharBigArrays;
import it.unimi.dsi.fastutil.chars.CharIterable;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleBigArrays;
import it.unimi.dsi.fastutil.doubles.DoubleIterable;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatBigArrays;
import it.unimi.dsi.fastutil.floats.FloatIterable;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntBigArrays;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortBigArrays;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;

public class BinIO {
    private static final int MAX_IO_LENGTH = 0x100000;

    private BinIO() {
    }

    public static void storeObject(Object o, File file) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        oos.writeObject(o);
        oos.close();
    }

    public static void storeObject(Object o, CharSequence filename) throws IOException {
        BinIO.storeObject(o, new File(filename.toString()));
    }

    public static Object loadObject(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FastBufferedInputStream(new FileInputStream(file)));
        Object result2 = ois.readObject();
        ois.close();
        return result2;
    }

    public static Object loadObject(CharSequence filename) throws IOException, ClassNotFoundException {
        return BinIO.loadObject(new File(filename.toString()));
    }

    public static void storeObject(Object o, OutputStream s) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FastBufferedOutputStream(s));
        oos.writeObject(o);
        oos.flush();
    }

    public static Object loadObject(InputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FastBufferedInputStream(s));
        Object result2 = ois.readObject();
        return result2;
    }

    private static int read(InputStream is, byte[] a, int offset, int length) throws IOException {
        int result2;
        if (length == 0) {
            return 0;
        }
        int read2 = 0;
        do {
            if ((result2 = is.read(a, offset + read2, Math.min(length - read2, 0x100000))) >= 0) continue;
            return read2;
        } while ((read2 += result2) < length);
        return read2;
    }

    private static void write(OutputStream outputStream, byte[] a, int offset, int length) throws IOException {
        for (int written2 = 0; written2 < length; written2 += Math.min(length - written2, 0x100000)) {
            outputStream.write(a, offset + written2, Math.min(length - written2, 0x100000));
        }
    }

    private static void write(DataOutput dataOutput, byte[] a, int offset, int length) throws IOException {
        for (int written2 = 0; written2 < length; written2 += Math.min(length - written2, 0x100000)) {
            dataOutput.write(a, offset + written2, Math.min(length - written2, 0x100000));
        }
    }

    public static int loadBytes(InputStream inputStream, byte[] array2, int offset, int length) throws IOException {
        return BinIO.read(inputStream, array2, offset, length);
    }

    public static int loadBytes(InputStream inputStream, byte[] array2) throws IOException {
        return BinIO.read(inputStream, array2, 0, array2.length);
    }

    public static void storeBytes(byte[] array2, int offset, int length, OutputStream outputStream) throws IOException {
        BinIO.write(outputStream, array2, offset, length);
    }

    public static void storeBytes(byte[] array2, OutputStream outputStream) throws IOException {
        BinIO.write(outputStream, array2, 0, array2.length);
    }

    private static long read(InputStream is, byte[][] a, long offset, long length) throws IOException {
        if (length == 0L) {
            return 0L;
        }
        long read2 = 0L;
        int segment = BigArrays.segment(offset);
        int displacement = BigArrays.displacement(offset);
        do {
            int result2;
            if ((result2 = is.read(a[segment], displacement, (int)Math.min((long)(a[segment].length - displacement), Math.min(length - read2, 0x100000L)))) < 0) {
                return read2;
            }
            read2 += (long)result2;
            if ((displacement += result2) != a[segment].length) continue;
            ++segment;
            displacement = 0;
        } while (read2 < length);
        return read2;
    }

    private static void write(OutputStream outputStream, byte[][] a, long offset, long length) throws IOException {
        if (length == 0L) {
            return;
        }
        long written2 = 0L;
        int segment = BigArrays.segment(offset);
        int displacement = BigArrays.displacement(offset);
        do {
            int toWrite = (int)Math.min((long)(a[segment].length - displacement), Math.min(length - written2, 0x100000L));
            outputStream.write(a[segment], displacement, toWrite);
            written2 += (long)toWrite;
            if ((displacement += toWrite) != a[segment].length) continue;
            ++segment;
            displacement = 0;
        } while (written2 < length);
    }

    private static void write(DataOutput dataOutput, byte[][] a, long offset, long length) throws IOException {
        if (length == 0L) {
            return;
        }
        long written2 = 0L;
        int segment = BigArrays.segment(offset);
        int displacement = BigArrays.displacement(offset);
        do {
            int toWrite = (int)Math.min((long)(a[segment].length - displacement), Math.min(length - written2, 0x100000L));
            dataOutput.write(a[segment], displacement, toWrite);
            written2 += (long)toWrite;
            if ((displacement += toWrite) != a[segment].length) continue;
            ++segment;
            displacement = 0;
        } while (written2 < length);
    }

    public static long loadBytes(InputStream inputStream, byte[][] array2, long offset, long length) throws IOException {
        return BinIO.read(inputStream, array2, offset, length);
    }

    public static long loadBytes(InputStream inputStream, byte[][] array2) throws IOException {
        return BinIO.read(inputStream, array2, 0L, ByteBigArrays.length(array2));
    }

    public static void storeBytes(byte[][] array2, long offset, long length, OutputStream outputStream) throws IOException {
        BinIO.write(outputStream, array2, offset, length);
    }

    public static void storeBytes(byte[][] array2, OutputStream outputStream) throws IOException {
        BinIO.write(outputStream, array2, 0L, ByteBigArrays.length(array2));
    }

    public static int loadBytes(DataInput dataInput, byte[] array2, int offset, int length) throws IOException {
        ByteArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dataInput.readByte();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadBytes(DataInput dataInput, byte[] array2) throws IOException {
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dataInput.readByte();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadBytes(File file, byte[] array2, int offset, int length) throws IOException {
        ByteArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        int result2 = BinIO.read((InputStream)fis, array2, offset, length);
        fis.close();
        return result2;
    }

    public static int loadBytes(CharSequence filename, byte[] array2, int offset, int length) throws IOException {
        return BinIO.loadBytes(new File(filename.toString()), array2, offset, length);
    }

    public static int loadBytes(File file, byte[] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        int result2 = BinIO.read((InputStream)fis, array2, 0, array2.length);
        fis.close();
        return result2;
    }

    public static int loadBytes(CharSequence filename, byte[] array2) throws IOException {
        return BinIO.loadBytes(new File(filename.toString()), array2);
    }

    public static byte[] loadBytes(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 1L;
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        byte[] array2 = new byte[(int)length];
        if ((long)BinIO.read((InputStream)fis, array2, 0, (int)length) < length) {
            throw new EOFException();
        }
        fis.close();
        return array2;
    }

    public static byte[] loadBytes(CharSequence filename) throws IOException {
        return BinIO.loadBytes(new File(filename.toString()));
    }

    public static void storeBytes(byte[] array2, int offset, int length, DataOutput dataOutput) throws IOException {
        ByteArrays.ensureOffsetLength(array2, offset, length);
        BinIO.write(dataOutput, array2, offset, length);
    }

    public static void storeBytes(byte[] array2, DataOutput dataOutput) throws IOException {
        BinIO.write(dataOutput, array2, 0, array2.length);
    }

    public static void storeBytes(byte[] array2, int offset, int length, File file) throws IOException {
        ByteArrays.ensureOffsetLength(array2, offset, length);
        FastBufferedOutputStream os = new FastBufferedOutputStream(new FileOutputStream(file));
        BinIO.write((OutputStream)os, array2, offset, length);
        ((OutputStream)os).close();
    }

    public static void storeBytes(byte[] array2, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeBytes(array2, offset, length, new File(filename.toString()));
    }

    public static void storeBytes(byte[] array2, File file) throws IOException {
        FastBufferedOutputStream os = new FastBufferedOutputStream(new FileOutputStream(file));
        BinIO.write((OutputStream)os, array2, 0, array2.length);
        ((OutputStream)os).close();
    }

    public static void storeBytes(byte[] array2, CharSequence filename) throws IOException {
        BinIO.storeBytes(array2, new File(filename.toString()));
    }

    public static long loadBytes(DataInput dataInput, byte[][] array2, long offset, long length) throws IOException {
        ByteBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                byte[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dataInput.readByte();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadBytes(DataInput dataInput, byte[][] array2) throws IOException {
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                byte[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dataInput.readByte();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadBytes(File file, byte[][] array2, long offset, long length) throws IOException {
        ByteBigArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        long result2 = BinIO.read((InputStream)fis, array2, offset, length);
        fis.close();
        return result2;
    }

    public static long loadBytes(CharSequence filename, byte[][] array2, long offset, long length) throws IOException {
        return BinIO.loadBytes(new File(filename.toString()), array2, offset, length);
    }

    public static long loadBytes(File file, byte[][] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long result2 = BinIO.read((InputStream)fis, array2, 0L, ByteBigArrays.length(array2));
        fis.close();
        return result2;
    }

    public static long loadBytes(CharSequence filename, byte[][] array2) throws IOException {
        return BinIO.loadBytes(new File(filename.toString()), array2);
    }

    public static byte[][] loadBytesBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 1L;
        byte[][] array2 = ByteBigArrays.newBigArray(length);
        if (BinIO.read((InputStream)fis, array2, 0L, length) < length) {
            throw new EOFException();
        }
        fis.close();
        return array2;
    }

    public static byte[][] loadBytesBig(CharSequence filename) throws IOException {
        return BinIO.loadBytesBig(new File(filename.toString()));
    }

    public static void storeBytes(byte[][] array2, long offset, long length, DataOutput dataOutput) throws IOException {
        ByteBigArrays.ensureOffsetLength(array2, offset, length);
        BinIO.write(dataOutput, array2, offset, length);
    }

    public static void storeBytes(byte[][] array2, DataOutput dataOutput) throws IOException {
        BinIO.write(dataOutput, array2, 0L, ByteBigArrays.length(array2));
    }

    public static void storeBytes(byte[][] array2, long offset, long length, File file) throws IOException {
        ByteBigArrays.ensureOffsetLength(array2, offset, length);
        FastBufferedOutputStream os = new FastBufferedOutputStream(new FileOutputStream(file));
        BinIO.write((OutputStream)os, array2, offset, length);
        ((OutputStream)os).close();
    }

    public static void storeBytes(byte[][] array2, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeBytes(array2, offset, length, new File(filename.toString()));
    }

    public static void storeBytes(byte[][] array2, File file) throws IOException {
        FastBufferedOutputStream os = new FastBufferedOutputStream(new FileOutputStream(file));
        BinIO.write((OutputStream)os, array2, 0L, ByteBigArrays.length(array2));
        ((OutputStream)os).close();
    }

    public static void storeBytes(byte[][] array2, CharSequence filename) throws IOException {
        BinIO.storeBytes(array2, new File(filename.toString()));
    }

    public static void storeBytes(ByteIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeByte(i.nextByte());
        }
    }

    public static void storeBytes(ByteIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeByte(i.nextByte());
        }
        dos.close();
    }

    public static void storeBytes(ByteIterator i, CharSequence filename) throws IOException {
        BinIO.storeBytes(i, new File(filename.toString()));
    }

    public static ByteIterator asByteIterator(DataInput dataInput) {
        return new ByteDataInputWrapper(dataInput);
    }

    public static ByteIterator asByteIterator(File file) throws IOException {
        return new ByteDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static ByteIterator asByteIterator(CharSequence filename) throws IOException {
        return BinIO.asByteIterator(new File(filename.toString()));
    }

    public static ByteIterable asByteIterable(File file) {
        return () -> {
            try {
                return BinIO.asByteIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static ByteIterable asByteIterable(CharSequence filename) {
        return () -> {
            try {
                return BinIO.asByteIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int loadInts(DataInput dataInput, int[] array2, int offset, int length) throws IOException {
        IntArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dataInput.readInt();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadInts(DataInput dataInput, int[] array2) throws IOException {
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dataInput.readInt();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadInts(File file, int[] array2, int offset, int length) throws IOException {
        IntArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dis.readInt();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadInts(CharSequence filename, int[] array2, int offset, int length) throws IOException {
        return BinIO.loadInts(new File(filename.toString()), array2, offset, length);
    }

    public static int loadInts(File file, int[] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dis.readInt();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadInts(CharSequence filename, int[] array2) throws IOException {
        return BinIO.loadInts(new File(filename.toString()), array2);
    }

    public static int[] loadInts(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 4L;
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        int[] array2 = new int[(int)length];
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        while ((long)i < length) {
            array2[i] = dis.readInt();
            ++i;
        }
        dis.close();
        return array2;
    }

    public static int[] loadInts(CharSequence filename) throws IOException {
        return BinIO.loadInts(new File(filename.toString()));
    }

    public static void storeInts(int[] array2, int offset, int length, DataOutput dataOutput) throws IOException {
        IntArrays.ensureOffsetLength(array2, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeInt(array2[offset + i]);
        }
    }

    public static void storeInts(int[] array2, DataOutput dataOutput) throws IOException {
        int length = array2.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeInt(array2[i]);
        }
    }

    public static void storeInts(int[] array2, int offset, int length, File file) throws IOException {
        IntArrays.ensureOffsetLength(array2, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeInt(array2[offset + i]);
        }
        dos.close();
    }

    public static void storeInts(int[] array2, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeInts(array2, offset, length, new File(filename.toString()));
    }

    public static void storeInts(int[] array2, File file) throws IOException {
        int length = array2.length;
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeInt(array2[i]);
        }
        dos.close();
    }

    public static void storeInts(int[] array2, CharSequence filename) throws IOException {
        BinIO.storeInts(array2, new File(filename.toString()));
    }

    public static long loadInts(DataInput dataInput, int[][] array2, long offset, long length) throws IOException {
        IntBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                int[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dataInput.readInt();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadInts(DataInput dataInput, int[][] array2) throws IOException {
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                int[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dataInput.readInt();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadInts(File file, int[][] array2, long offset, long length) throws IOException {
        IntBigArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                int[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dis.readInt();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c;
    }

    public static long loadInts(CharSequence filename, int[][] array2, long offset, long length) throws IOException {
        return BinIO.loadInts(new File(filename.toString()), array2, offset, length);
    }

    public static long loadInts(File file, int[][] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                int[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dis.readInt();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c;
    }

    public static long loadInts(CharSequence filename, int[][] array2) throws IOException {
        return BinIO.loadInts(new File(filename.toString()), array2);
    }

    public static int[][] loadIntsBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 4L;
        int[][] array2 = IntBigArrays.newBigArray(length);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        for (int i = 0; i < array2.length; ++i) {
            int[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                t[d] = dis.readInt();
            }
        }
        dis.close();
        return array2;
    }

    public static int[][] loadIntsBig(CharSequence filename) throws IOException {
        return BinIO.loadIntsBig(new File(filename.toString()));
    }

    public static void storeInts(int[][] array2, long offset, long length, DataOutput dataOutput) throws IOException {
        IntBigArrays.ensureOffsetLength(array2, offset, length);
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            int[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                dataOutput.writeInt(t[d]);
            }
        }
    }

    public static void storeInts(int[][] array2, DataOutput dataOutput) throws IOException {
        for (int i = 0; i < array2.length; ++i) {
            int[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                dataOutput.writeInt(t[d]);
            }
        }
    }

    public static void storeInts(int[][] array2, long offset, long length, File file) throws IOException {
        IntBigArrays.ensureOffsetLength(array2, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            int[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                dos.writeInt(t[d]);
            }
        }
        dos.close();
    }

    public static void storeInts(int[][] array2, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeInts(array2, offset, length, new File(filename.toString()));
    }

    public static void storeInts(int[][] array2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < array2.length; ++i) {
            int[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                dos.writeInt(t[d]);
            }
        }
        dos.close();
    }

    public static void storeInts(int[][] array2, CharSequence filename) throws IOException {
        BinIO.storeInts(array2, new File(filename.toString()));
    }

    public static void storeInts(IntIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeInt(i.nextInt());
        }
    }

    public static void storeInts(IntIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeInt(i.nextInt());
        }
        dos.close();
    }

    public static void storeInts(IntIterator i, CharSequence filename) throws IOException {
        BinIO.storeInts(i, new File(filename.toString()));
    }

    public static IntIterator asIntIterator(DataInput dataInput) {
        return new IntDataInputWrapper(dataInput);
    }

    public static IntIterator asIntIterator(File file) throws IOException {
        return new IntDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static IntIterator asIntIterator(CharSequence filename) throws IOException {
        return BinIO.asIntIterator(new File(filename.toString()));
    }

    public static IntIterable asIntIterable(File file) {
        return () -> {
            try {
                return BinIO.asIntIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static IntIterable asIntIterable(CharSequence filename) {
        return () -> {
            try {
                return BinIO.asIntIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int loadLongs(DataInput dataInput, long[] array2, int offset, int length) throws IOException {
        LongArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dataInput.readLong();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadLongs(DataInput dataInput, long[] array2) throws IOException {
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dataInput.readLong();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadLongs(File file, long[] array2, int offset, int length) throws IOException {
        LongArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dis.readLong();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadLongs(CharSequence filename, long[] array2, int offset, int length) throws IOException {
        return BinIO.loadLongs(new File(filename.toString()), array2, offset, length);
    }

    public static int loadLongs(File file, long[] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dis.readLong();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadLongs(CharSequence filename, long[] array2) throws IOException {
        return BinIO.loadLongs(new File(filename.toString()), array2);
    }

    public static long[] loadLongs(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 8L;
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        long[] array2 = new long[(int)length];
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        while ((long)i < length) {
            array2[i] = dis.readLong();
            ++i;
        }
        dis.close();
        return array2;
    }

    public static long[] loadLongs(CharSequence filename) throws IOException {
        return BinIO.loadLongs(new File(filename.toString()));
    }

    public static void storeLongs(long[] array2, int offset, int length, DataOutput dataOutput) throws IOException {
        LongArrays.ensureOffsetLength(array2, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeLong(array2[offset + i]);
        }
    }

    public static void storeLongs(long[] array2, DataOutput dataOutput) throws IOException {
        int length = array2.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeLong(array2[i]);
        }
    }

    public static void storeLongs(long[] array2, int offset, int length, File file) throws IOException {
        LongArrays.ensureOffsetLength(array2, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeLong(array2[offset + i]);
        }
        dos.close();
    }

    public static void storeLongs(long[] array2, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeLongs(array2, offset, length, new File(filename.toString()));
    }

    public static void storeLongs(long[] array2, File file) throws IOException {
        int length = array2.length;
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeLong(array2[i]);
        }
        dos.close();
    }

    public static void storeLongs(long[] array2, CharSequence filename) throws IOException {
        BinIO.storeLongs(array2, new File(filename.toString()));
    }

    public static long loadLongs(DataInput dataInput, long[][] array2, long offset, long length) throws IOException {
        LongBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                long[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dataInput.readLong();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadLongs(DataInput dataInput, long[][] array2) throws IOException {
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                long[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dataInput.readLong();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadLongs(File file, long[][] array2, long offset, long length) throws IOException {
        LongBigArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                long[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dis.readLong();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c;
    }

    public static long loadLongs(CharSequence filename, long[][] array2, long offset, long length) throws IOException {
        return BinIO.loadLongs(new File(filename.toString()), array2, offset, length);
    }

    public static long loadLongs(File file, long[][] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                long[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dis.readLong();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c;
    }

    public static long loadLongs(CharSequence filename, long[][] array2) throws IOException {
        return BinIO.loadLongs(new File(filename.toString()), array2);
    }

    public static long[][] loadLongsBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 8L;
        long[][] array2 = LongBigArrays.newBigArray(length);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        for (int i = 0; i < array2.length; ++i) {
            long[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                t[d] = dis.readLong();
            }
        }
        dis.close();
        return array2;
    }

    public static long[][] loadLongsBig(CharSequence filename) throws IOException {
        return BinIO.loadLongsBig(new File(filename.toString()));
    }

    public static void storeLongs(long[][] array2, long offset, long length, DataOutput dataOutput) throws IOException {
        LongBigArrays.ensureOffsetLength(array2, offset, length);
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            long[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                dataOutput.writeLong(t[d]);
            }
        }
    }

    public static void storeLongs(long[][] array2, DataOutput dataOutput) throws IOException {
        for (int i = 0; i < array2.length; ++i) {
            long[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                dataOutput.writeLong(t[d]);
            }
        }
    }

    public static void storeLongs(long[][] array2, long offset, long length, File file) throws IOException {
        LongBigArrays.ensureOffsetLength(array2, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            long[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                dos.writeLong(t[d]);
            }
        }
        dos.close();
    }

    public static void storeLongs(long[][] array2, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeLongs(array2, offset, length, new File(filename.toString()));
    }

    public static void storeLongs(long[][] array2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < array2.length; ++i) {
            long[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                dos.writeLong(t[d]);
            }
        }
        dos.close();
    }

    public static void storeLongs(long[][] array2, CharSequence filename) throws IOException {
        BinIO.storeLongs(array2, new File(filename.toString()));
    }

    public static void storeLongs(LongIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeLong(i.nextLong());
        }
    }

    public static void storeLongs(LongIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeLong(i.nextLong());
        }
        dos.close();
    }

    public static void storeLongs(LongIterator i, CharSequence filename) throws IOException {
        BinIO.storeLongs(i, new File(filename.toString()));
    }

    public static LongIterator asLongIterator(DataInput dataInput) {
        return new LongDataInputWrapper(dataInput);
    }

    public static LongIterator asLongIterator(File file) throws IOException {
        return new LongDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static LongIterator asLongIterator(CharSequence filename) throws IOException {
        return BinIO.asLongIterator(new File(filename.toString()));
    }

    public static LongIterable asLongIterable(File file) {
        return () -> {
            try {
                return BinIO.asLongIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static LongIterable asLongIterable(CharSequence filename) {
        return () -> {
            try {
                return BinIO.asLongIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int loadDoubles(DataInput dataInput, double[] array2, int offset, int length) throws IOException {
        DoubleArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dataInput.readDouble();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadDoubles(DataInput dataInput, double[] array2) throws IOException {
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dataInput.readDouble();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadDoubles(File file, double[] array2, int offset, int length) throws IOException {
        DoubleArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dis.readDouble();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadDoubles(CharSequence filename, double[] array2, int offset, int length) throws IOException {
        return BinIO.loadDoubles(new File(filename.toString()), array2, offset, length);
    }

    public static int loadDoubles(File file, double[] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dis.readDouble();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadDoubles(CharSequence filename, double[] array2) throws IOException {
        return BinIO.loadDoubles(new File(filename.toString()), array2);
    }

    public static double[] loadDoubles(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 8L;
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        double[] array2 = new double[(int)length];
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        while ((long)i < length) {
            array2[i] = dis.readDouble();
            ++i;
        }
        dis.close();
        return array2;
    }

    public static double[] loadDoubles(CharSequence filename) throws IOException {
        return BinIO.loadDoubles(new File(filename.toString()));
    }

    public static void storeDoubles(double[] array2, int offset, int length, DataOutput dataOutput) throws IOException {
        DoubleArrays.ensureOffsetLength(array2, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeDouble(array2[offset + i]);
        }
    }

    public static void storeDoubles(double[] array2, DataOutput dataOutput) throws IOException {
        int length = array2.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeDouble(array2[i]);
        }
    }

    public static void storeDoubles(double[] array2, int offset, int length, File file) throws IOException {
        DoubleArrays.ensureOffsetLength(array2, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeDouble(array2[offset + i]);
        }
        dos.close();
    }

    public static void storeDoubles(double[] array2, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeDoubles(array2, offset, length, new File(filename.toString()));
    }

    public static void storeDoubles(double[] array2, File file) throws IOException {
        int length = array2.length;
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeDouble(array2[i]);
        }
        dos.close();
    }

    public static void storeDoubles(double[] array2, CharSequence filename) throws IOException {
        BinIO.storeDoubles(array2, new File(filename.toString()));
    }

    public static long loadDoubles(DataInput dataInput, double[][] array2, long offset, long length) throws IOException {
        DoubleBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                double[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dataInput.readDouble();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadDoubles(DataInput dataInput, double[][] array2) throws IOException {
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                double[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dataInput.readDouble();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadDoubles(File file, double[][] array2, long offset, long length) throws IOException {
        DoubleBigArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                double[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dis.readDouble();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c;
    }

    public static long loadDoubles(CharSequence filename, double[][] array2, long offset, long length) throws IOException {
        return BinIO.loadDoubles(new File(filename.toString()), array2, offset, length);
    }

    public static long loadDoubles(File file, double[][] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                double[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dis.readDouble();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c;
    }

    public static long loadDoubles(CharSequence filename, double[][] array2) throws IOException {
        return BinIO.loadDoubles(new File(filename.toString()), array2);
    }

    public static double[][] loadDoublesBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 8L;
        double[][] array2 = DoubleBigArrays.newBigArray(length);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        for (int i = 0; i < array2.length; ++i) {
            double[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                t[d] = dis.readDouble();
            }
        }
        dis.close();
        return array2;
    }

    public static double[][] loadDoublesBig(CharSequence filename) throws IOException {
        return BinIO.loadDoublesBig(new File(filename.toString()));
    }

    public static void storeDoubles(double[][] array2, long offset, long length, DataOutput dataOutput) throws IOException {
        DoubleBigArrays.ensureOffsetLength(array2, offset, length);
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            double[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                dataOutput.writeDouble(t[d]);
            }
        }
    }

    public static void storeDoubles(double[][] array2, DataOutput dataOutput) throws IOException {
        for (int i = 0; i < array2.length; ++i) {
            double[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                dataOutput.writeDouble(t[d]);
            }
        }
    }

    public static void storeDoubles(double[][] array2, long offset, long length, File file) throws IOException {
        DoubleBigArrays.ensureOffsetLength(array2, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            double[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                dos.writeDouble(t[d]);
            }
        }
        dos.close();
    }

    public static void storeDoubles(double[][] array2, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeDoubles(array2, offset, length, new File(filename.toString()));
    }

    public static void storeDoubles(double[][] array2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < array2.length; ++i) {
            double[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                dos.writeDouble(t[d]);
            }
        }
        dos.close();
    }

    public static void storeDoubles(double[][] array2, CharSequence filename) throws IOException {
        BinIO.storeDoubles(array2, new File(filename.toString()));
    }

    public static void storeDoubles(DoubleIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeDouble(i.nextDouble());
        }
    }

    public static void storeDoubles(DoubleIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeDouble(i.nextDouble());
        }
        dos.close();
    }

    public static void storeDoubles(DoubleIterator i, CharSequence filename) throws IOException {
        BinIO.storeDoubles(i, new File(filename.toString()));
    }

    public static DoubleIterator asDoubleIterator(DataInput dataInput) {
        return new DoubleDataInputWrapper(dataInput);
    }

    public static DoubleIterator asDoubleIterator(File file) throws IOException {
        return new DoubleDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static DoubleIterator asDoubleIterator(CharSequence filename) throws IOException {
        return BinIO.asDoubleIterator(new File(filename.toString()));
    }

    public static DoubleIterable asDoubleIterable(File file) {
        return () -> {
            try {
                return BinIO.asDoubleIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static DoubleIterable asDoubleIterable(CharSequence filename) {
        return () -> {
            try {
                return BinIO.asDoubleIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int loadBooleans(DataInput dataInput, boolean[] array2, int offset, int length) throws IOException {
        BooleanArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dataInput.readBoolean();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadBooleans(DataInput dataInput, boolean[] array2) throws IOException {
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dataInput.readBoolean();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadBooleans(File file, boolean[] array2, int offset, int length) throws IOException {
        BooleanArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dis.readBoolean();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadBooleans(CharSequence filename, boolean[] array2, int offset, int length) throws IOException {
        return BinIO.loadBooleans(new File(filename.toString()), array2, offset, length);
    }

    public static int loadBooleans(File file, boolean[] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dis.readBoolean();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadBooleans(CharSequence filename, boolean[] array2) throws IOException {
        return BinIO.loadBooleans(new File(filename.toString()), array2);
    }

    public static boolean[] loadBooleans(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size();
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        boolean[] array2 = new boolean[(int)length];
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        while ((long)i < length) {
            array2[i] = dis.readBoolean();
            ++i;
        }
        dis.close();
        return array2;
    }

    public static boolean[] loadBooleans(CharSequence filename) throws IOException {
        return BinIO.loadBooleans(new File(filename.toString()));
    }

    public static void storeBooleans(boolean[] array2, int offset, int length, DataOutput dataOutput) throws IOException {
        BooleanArrays.ensureOffsetLength(array2, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeBoolean(array2[offset + i]);
        }
    }

    public static void storeBooleans(boolean[] array2, DataOutput dataOutput) throws IOException {
        int length = array2.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeBoolean(array2[i]);
        }
    }

    public static void storeBooleans(boolean[] array2, int offset, int length, File file) throws IOException {
        BooleanArrays.ensureOffsetLength(array2, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeBoolean(array2[offset + i]);
        }
        dos.close();
    }

    public static void storeBooleans(boolean[] array2, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeBooleans(array2, offset, length, new File(filename.toString()));
    }

    public static void storeBooleans(boolean[] array2, File file) throws IOException {
        int length = array2.length;
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeBoolean(array2[i]);
        }
        dos.close();
    }

    public static void storeBooleans(boolean[] array2, CharSequence filename) throws IOException {
        BinIO.storeBooleans(array2, new File(filename.toString()));
    }

    public static long loadBooleans(DataInput dataInput, boolean[][] array2, long offset, long length) throws IOException {
        BooleanBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                boolean[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dataInput.readBoolean();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadBooleans(DataInput dataInput, boolean[][] array2) throws IOException {
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                boolean[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dataInput.readBoolean();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadBooleans(File file, boolean[][] array2, long offset, long length) throws IOException {
        BooleanBigArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                boolean[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dis.readBoolean();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c;
    }

    public static long loadBooleans(CharSequence filename, boolean[][] array2, long offset, long length) throws IOException {
        return BinIO.loadBooleans(new File(filename.toString()), array2, offset, length);
    }

    public static long loadBooleans(File file, boolean[][] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                boolean[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dis.readBoolean();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c;
    }

    public static long loadBooleans(CharSequence filename, boolean[][] array2) throws IOException {
        return BinIO.loadBooleans(new File(filename.toString()), array2);
    }

    public static boolean[][] loadBooleansBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size();
        boolean[][] array2 = BooleanBigArrays.newBigArray(length);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        for (int i = 0; i < array2.length; ++i) {
            boolean[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                t[d] = dis.readBoolean();
            }
        }
        dis.close();
        return array2;
    }

    public static boolean[][] loadBooleansBig(CharSequence filename) throws IOException {
        return BinIO.loadBooleansBig(new File(filename.toString()));
    }

    public static void storeBooleans(boolean[][] array2, long offset, long length, DataOutput dataOutput) throws IOException {
        BooleanBigArrays.ensureOffsetLength(array2, offset, length);
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            boolean[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                dataOutput.writeBoolean(t[d]);
            }
        }
    }

    public static void storeBooleans(boolean[][] array2, DataOutput dataOutput) throws IOException {
        for (int i = 0; i < array2.length; ++i) {
            boolean[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                dataOutput.writeBoolean(t[d]);
            }
        }
    }

    public static void storeBooleans(boolean[][] array2, long offset, long length, File file) throws IOException {
        BooleanBigArrays.ensureOffsetLength(array2, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            boolean[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                dos.writeBoolean(t[d]);
            }
        }
        dos.close();
    }

    public static void storeBooleans(boolean[][] array2, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeBooleans(array2, offset, length, new File(filename.toString()));
    }

    public static void storeBooleans(boolean[][] array2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < array2.length; ++i) {
            boolean[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                dos.writeBoolean(t[d]);
            }
        }
        dos.close();
    }

    public static void storeBooleans(boolean[][] array2, CharSequence filename) throws IOException {
        BinIO.storeBooleans(array2, new File(filename.toString()));
    }

    public static void storeBooleans(BooleanIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeBoolean(i.nextBoolean());
        }
    }

    public static void storeBooleans(BooleanIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeBoolean(i.nextBoolean());
        }
        dos.close();
    }

    public static void storeBooleans(BooleanIterator i, CharSequence filename) throws IOException {
        BinIO.storeBooleans(i, new File(filename.toString()));
    }

    public static BooleanIterator asBooleanIterator(DataInput dataInput) {
        return new BooleanDataInputWrapper(dataInput);
    }

    public static BooleanIterator asBooleanIterator(File file) throws IOException {
        return new BooleanDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static BooleanIterator asBooleanIterator(CharSequence filename) throws IOException {
        return BinIO.asBooleanIterator(new File(filename.toString()));
    }

    public static BooleanIterable asBooleanIterable(File file) {
        return () -> {
            try {
                return BinIO.asBooleanIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static BooleanIterable asBooleanIterable(CharSequence filename) {
        return () -> {
            try {
                return BinIO.asBooleanIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int loadShorts(DataInput dataInput, short[] array2, int offset, int length) throws IOException {
        ShortArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dataInput.readShort();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadShorts(DataInput dataInput, short[] array2) throws IOException {
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dataInput.readShort();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadShorts(File file, short[] array2, int offset, int length) throws IOException {
        ShortArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dis.readShort();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadShorts(CharSequence filename, short[] array2, int offset, int length) throws IOException {
        return BinIO.loadShorts(new File(filename.toString()), array2, offset, length);
    }

    public static int loadShorts(File file, short[] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dis.readShort();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadShorts(CharSequence filename, short[] array2) throws IOException {
        return BinIO.loadShorts(new File(filename.toString()), array2);
    }

    public static short[] loadShorts(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 2L;
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        short[] array2 = new short[(int)length];
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        while ((long)i < length) {
            array2[i] = dis.readShort();
            ++i;
        }
        dis.close();
        return array2;
    }

    public static short[] loadShorts(CharSequence filename) throws IOException {
        return BinIO.loadShorts(new File(filename.toString()));
    }

    public static void storeShorts(short[] array2, int offset, int length, DataOutput dataOutput) throws IOException {
        ShortArrays.ensureOffsetLength(array2, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeShort(array2[offset + i]);
        }
    }

    public static void storeShorts(short[] array2, DataOutput dataOutput) throws IOException {
        int length = array2.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeShort(array2[i]);
        }
    }

    public static void storeShorts(short[] array2, int offset, int length, File file) throws IOException {
        ShortArrays.ensureOffsetLength(array2, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeShort(array2[offset + i]);
        }
        dos.close();
    }

    public static void storeShorts(short[] array2, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeShorts(array2, offset, length, new File(filename.toString()));
    }

    public static void storeShorts(short[] array2, File file) throws IOException {
        int length = array2.length;
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeShort(array2[i]);
        }
        dos.close();
    }

    public static void storeShorts(short[] array2, CharSequence filename) throws IOException {
        BinIO.storeShorts(array2, new File(filename.toString()));
    }

    public static long loadShorts(DataInput dataInput, short[][] array2, long offset, long length) throws IOException {
        ShortBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                short[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dataInput.readShort();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadShorts(DataInput dataInput, short[][] array2) throws IOException {
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                short[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dataInput.readShort();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadShorts(File file, short[][] array2, long offset, long length) throws IOException {
        ShortBigArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                short[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dis.readShort();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c;
    }

    public static long loadShorts(CharSequence filename, short[][] array2, long offset, long length) throws IOException {
        return BinIO.loadShorts(new File(filename.toString()), array2, offset, length);
    }

    public static long loadShorts(File file, short[][] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                short[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dis.readShort();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c;
    }

    public static long loadShorts(CharSequence filename, short[][] array2) throws IOException {
        return BinIO.loadShorts(new File(filename.toString()), array2);
    }

    public static short[][] loadShortsBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 2L;
        short[][] array2 = ShortBigArrays.newBigArray(length);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        for (int i = 0; i < array2.length; ++i) {
            short[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                t[d] = dis.readShort();
            }
        }
        dis.close();
        return array2;
    }

    public static short[][] loadShortsBig(CharSequence filename) throws IOException {
        return BinIO.loadShortsBig(new File(filename.toString()));
    }

    public static void storeShorts(short[][] array2, long offset, long length, DataOutput dataOutput) throws IOException {
        ShortBigArrays.ensureOffsetLength(array2, offset, length);
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            short[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                dataOutput.writeShort(t[d]);
            }
        }
    }

    public static void storeShorts(short[][] array2, DataOutput dataOutput) throws IOException {
        for (int i = 0; i < array2.length; ++i) {
            short[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                dataOutput.writeShort(t[d]);
            }
        }
    }

    public static void storeShorts(short[][] array2, long offset, long length, File file) throws IOException {
        ShortBigArrays.ensureOffsetLength(array2, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            short[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                dos.writeShort(t[d]);
            }
        }
        dos.close();
    }

    public static void storeShorts(short[][] array2, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeShorts(array2, offset, length, new File(filename.toString()));
    }

    public static void storeShorts(short[][] array2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < array2.length; ++i) {
            short[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                dos.writeShort(t[d]);
            }
        }
        dos.close();
    }

    public static void storeShorts(short[][] array2, CharSequence filename) throws IOException {
        BinIO.storeShorts(array2, new File(filename.toString()));
    }

    public static void storeShorts(ShortIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeShort(i.nextShort());
        }
    }

    public static void storeShorts(ShortIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeShort(i.nextShort());
        }
        dos.close();
    }

    public static void storeShorts(ShortIterator i, CharSequence filename) throws IOException {
        BinIO.storeShorts(i, new File(filename.toString()));
    }

    public static ShortIterator asShortIterator(DataInput dataInput) {
        return new ShortDataInputWrapper(dataInput);
    }

    public static ShortIterator asShortIterator(File file) throws IOException {
        return new ShortDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static ShortIterator asShortIterator(CharSequence filename) throws IOException {
        return BinIO.asShortIterator(new File(filename.toString()));
    }

    public static ShortIterable asShortIterable(File file) {
        return () -> {
            try {
                return BinIO.asShortIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static ShortIterable asShortIterable(CharSequence filename) {
        return () -> {
            try {
                return BinIO.asShortIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int loadChars(DataInput dataInput, char[] array2, int offset, int length) throws IOException {
        CharArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dataInput.readChar();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadChars(DataInput dataInput, char[] array2) throws IOException {
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dataInput.readChar();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadChars(File file, char[] array2, int offset, int length) throws IOException {
        CharArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dis.readChar();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadChars(CharSequence filename, char[] array2, int offset, int length) throws IOException {
        return BinIO.loadChars(new File(filename.toString()), array2, offset, length);
    }

    public static int loadChars(File file, char[] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dis.readChar();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadChars(CharSequence filename, char[] array2) throws IOException {
        return BinIO.loadChars(new File(filename.toString()), array2);
    }

    public static char[] loadChars(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 2L;
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        char[] array2 = new char[(int)length];
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        while ((long)i < length) {
            array2[i] = dis.readChar();
            ++i;
        }
        dis.close();
        return array2;
    }

    public static char[] loadChars(CharSequence filename) throws IOException {
        return BinIO.loadChars(new File(filename.toString()));
    }

    public static void storeChars(char[] array2, int offset, int length, DataOutput dataOutput) throws IOException {
        CharArrays.ensureOffsetLength(array2, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeChar(array2[offset + i]);
        }
    }

    public static void storeChars(char[] array2, DataOutput dataOutput) throws IOException {
        int length = array2.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeChar(array2[i]);
        }
    }

    public static void storeChars(char[] array2, int offset, int length, File file) throws IOException {
        CharArrays.ensureOffsetLength(array2, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeChar(array2[offset + i]);
        }
        dos.close();
    }

    public static void storeChars(char[] array2, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeChars(array2, offset, length, new File(filename.toString()));
    }

    public static void storeChars(char[] array2, File file) throws IOException {
        int length = array2.length;
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeChar(array2[i]);
        }
        dos.close();
    }

    public static void storeChars(char[] array2, CharSequence filename) throws IOException {
        BinIO.storeChars(array2, new File(filename.toString()));
    }

    public static long loadChars(DataInput dataInput, char[][] array2, long offset, long length) throws IOException {
        CharBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                char[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dataInput.readChar();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadChars(DataInput dataInput, char[][] array2) throws IOException {
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                char[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dataInput.readChar();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadChars(File file, char[][] array2, long offset, long length) throws IOException {
        CharBigArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                char[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dis.readChar();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c;
    }

    public static long loadChars(CharSequence filename, char[][] array2, long offset, long length) throws IOException {
        return BinIO.loadChars(new File(filename.toString()), array2, offset, length);
    }

    public static long loadChars(File file, char[][] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                char[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dis.readChar();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c;
    }

    public static long loadChars(CharSequence filename, char[][] array2) throws IOException {
        return BinIO.loadChars(new File(filename.toString()), array2);
    }

    public static char[][] loadCharsBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 2L;
        char[][] array2 = CharBigArrays.newBigArray(length);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        for (int i = 0; i < array2.length; ++i) {
            char[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                t[d] = dis.readChar();
            }
        }
        dis.close();
        return array2;
    }

    public static char[][] loadCharsBig(CharSequence filename) throws IOException {
        return BinIO.loadCharsBig(new File(filename.toString()));
    }

    public static void storeChars(char[][] array2, long offset, long length, DataOutput dataOutput) throws IOException {
        CharBigArrays.ensureOffsetLength(array2, offset, length);
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            char[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                dataOutput.writeChar(t[d]);
            }
        }
    }

    public static void storeChars(char[][] array2, DataOutput dataOutput) throws IOException {
        for (int i = 0; i < array2.length; ++i) {
            char[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                dataOutput.writeChar(t[d]);
            }
        }
    }

    public static void storeChars(char[][] array2, long offset, long length, File file) throws IOException {
        CharBigArrays.ensureOffsetLength(array2, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            char[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                dos.writeChar(t[d]);
            }
        }
        dos.close();
    }

    public static void storeChars(char[][] array2, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeChars(array2, offset, length, new File(filename.toString()));
    }

    public static void storeChars(char[][] array2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < array2.length; ++i) {
            char[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                dos.writeChar(t[d]);
            }
        }
        dos.close();
    }

    public static void storeChars(char[][] array2, CharSequence filename) throws IOException {
        BinIO.storeChars(array2, new File(filename.toString()));
    }

    public static void storeChars(CharIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeChar(i.nextChar());
        }
    }

    public static void storeChars(CharIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeChar(i.nextChar());
        }
        dos.close();
    }

    public static void storeChars(CharIterator i, CharSequence filename) throws IOException {
        BinIO.storeChars(i, new File(filename.toString()));
    }

    public static CharIterator asCharIterator(DataInput dataInput) {
        return new CharDataInputWrapper(dataInput);
    }

    public static CharIterator asCharIterator(File file) throws IOException {
        return new CharDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static CharIterator asCharIterator(CharSequence filename) throws IOException {
        return BinIO.asCharIterator(new File(filename.toString()));
    }

    public static CharIterable asCharIterable(File file) {
        return () -> {
            try {
                return BinIO.asCharIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static CharIterable asCharIterable(CharSequence filename) {
        return () -> {
            try {
                return BinIO.asCharIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int loadFloats(DataInput dataInput, float[] array2, int offset, int length) throws IOException {
        FloatArrays.ensureOffsetLength(array2, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dataInput.readFloat();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadFloats(DataInput dataInput, float[] array2) throws IOException {
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dataInput.readFloat();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadFloats(File file, float[] array2, int offset, int length) throws IOException {
        FloatArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array2[i + offset] = dis.readFloat();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadFloats(CharSequence filename, float[] array2, int offset, int length) throws IOException {
        return BinIO.loadFloats(new File(filename.toString()), array2, offset, length);
    }

    public static int loadFloats(File file, float[] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        try {
            int length = array2.length;
            for (i = 0; i < length; ++i) {
                array2[i] = dis.readFloat();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadFloats(CharSequence filename, float[] array2) throws IOException {
        return BinIO.loadFloats(new File(filename.toString()), array2);
    }

    public static float[] loadFloats(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 4L;
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        float[] array2 = new float[(int)length];
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i = 0;
        while ((long)i < length) {
            array2[i] = dis.readFloat();
            ++i;
        }
        dis.close();
        return array2;
    }

    public static float[] loadFloats(CharSequence filename) throws IOException {
        return BinIO.loadFloats(new File(filename.toString()));
    }

    public static void storeFloats(float[] array2, int offset, int length, DataOutput dataOutput) throws IOException {
        FloatArrays.ensureOffsetLength(array2, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeFloat(array2[offset + i]);
        }
    }

    public static void storeFloats(float[] array2, DataOutput dataOutput) throws IOException {
        int length = array2.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeFloat(array2[i]);
        }
    }

    public static void storeFloats(float[] array2, int offset, int length, File file) throws IOException {
        FloatArrays.ensureOffsetLength(array2, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeFloat(array2[offset + i]);
        }
        dos.close();
    }

    public static void storeFloats(float[] array2, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeFloats(array2, offset, length, new File(filename.toString()));
    }

    public static void storeFloats(float[] array2, File file) throws IOException {
        int length = array2.length;
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < length; ++i) {
            dos.writeFloat(array2[i]);
        }
        dos.close();
    }

    public static void storeFloats(float[] array2, CharSequence filename) throws IOException {
        BinIO.storeFloats(array2, new File(filename.toString()));
    }

    public static long loadFloats(DataInput dataInput, float[][] array2, long offset, long length) throws IOException {
        FloatBigArrays.ensureOffsetLength(array2, offset, length);
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                float[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dataInput.readFloat();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadFloats(DataInput dataInput, float[][] array2) throws IOException {
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                float[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dataInput.readFloat();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c;
    }

    public static long loadFloats(File file, float[][] array2, long offset, long length) throws IOException {
        FloatBigArrays.ensureOffsetLength(array2, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c = 0L;
        try {
            for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
                float[] t = array2[i];
                int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
                for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                    t[d] = dis.readFloat();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c;
    }

    public static long loadFloats(CharSequence filename, float[][] array2, long offset, long length) throws IOException {
        return BinIO.loadFloats(new File(filename.toString()), array2, offset, length);
    }

    public static long loadFloats(File file, float[][] array2) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c = 0L;
        try {
            for (int i = 0; i < array2.length; ++i) {
                float[] t = array2[i];
                int l = t.length;
                for (int d = 0; d < l; ++d) {
                    t[d] = dis.readFloat();
                    ++c;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c;
    }

    public static long loadFloats(CharSequence filename, float[][] array2) throws IOException {
        return BinIO.loadFloats(new File(filename.toString()), array2);
    }

    public static float[][] loadFloatsBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 4L;
        float[][] array2 = FloatBigArrays.newBigArray(length);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        for (int i = 0; i < array2.length; ++i) {
            float[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                t[d] = dis.readFloat();
            }
        }
        dis.close();
        return array2;
    }

    public static float[][] loadFloatsBig(CharSequence filename) throws IOException {
        return BinIO.loadFloatsBig(new File(filename.toString()));
    }

    public static void storeFloats(float[][] array2, long offset, long length, DataOutput dataOutput) throws IOException {
        FloatBigArrays.ensureOffsetLength(array2, offset, length);
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            float[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                dataOutput.writeFloat(t[d]);
            }
        }
    }

    public static void storeFloats(float[][] array2, DataOutput dataOutput) throws IOException {
        for (int i = 0; i < array2.length; ++i) {
            float[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                dataOutput.writeFloat(t[d]);
            }
        }
    }

    public static void storeFloats(float[][] array2, long offset, long length, File file) throws IOException {
        FloatBigArrays.ensureOffsetLength(array2, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = BigArrays.segment(offset); i < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i) {
            float[] t = array2[i];
            int l = (int)Math.min((long)t.length, offset + length - BigArrays.start(i));
            for (int d = (int)Math.max(0L, offset - BigArrays.start(i)); d < l; ++d) {
                dos.writeFloat(t[d]);
            }
        }
        dos.close();
    }

    public static void storeFloats(float[][] array2, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeFloats(array2, offset, length, new File(filename.toString()));
    }

    public static void storeFloats(float[][] array2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i = 0; i < array2.length; ++i) {
            float[] t = array2[i];
            int l = t.length;
            for (int d = 0; d < l; ++d) {
                dos.writeFloat(t[d]);
            }
        }
        dos.close();
    }

    public static void storeFloats(float[][] array2, CharSequence filename) throws IOException {
        BinIO.storeFloats(array2, new File(filename.toString()));
    }

    public static void storeFloats(FloatIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeFloat(i.nextFloat());
        }
    }

    public static void storeFloats(FloatIterator i, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i.hasNext()) {
            dos.writeFloat(i.nextFloat());
        }
        dos.close();
    }

    public static void storeFloats(FloatIterator i, CharSequence filename) throws IOException {
        BinIO.storeFloats(i, new File(filename.toString()));
    }

    public static FloatIterator asFloatIterator(DataInput dataInput) {
        return new FloatDataInputWrapper(dataInput);
    }

    public static FloatIterator asFloatIterator(File file) throws IOException {
        return new FloatDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static FloatIterator asFloatIterator(CharSequence filename) throws IOException {
        return BinIO.asFloatIterator(new File(filename.toString()));
    }

    public static FloatIterable asFloatIterable(File file) {
        return () -> {
            try {
                return BinIO.asFloatIterator(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static FloatIterable asFloatIterable(CharSequence filename) {
        return () -> {
            try {
                return BinIO.asFloatIterator(filename);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static final class FloatDataInputWrapper
    implements FloatIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private float next;

        public FloatDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readFloat();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            return !this.endOfProcess;
        }

        @Override
        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class CharDataInputWrapper
    implements CharIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private char next;

        public CharDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readChar();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            return !this.endOfProcess;
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class ShortDataInputWrapper
    implements ShortIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private short next;

        public ShortDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readShort();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            return !this.endOfProcess;
        }

        @Override
        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class BooleanDataInputWrapper
    implements BooleanIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private boolean next;

        public BooleanDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readBoolean();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            return !this.endOfProcess;
        }

        @Override
        public boolean nextBoolean() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class DoubleDataInputWrapper
    implements DoubleIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private double next;

        public DoubleDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readDouble();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            return !this.endOfProcess;
        }

        @Override
        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class LongDataInputWrapper
    implements LongIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private long next;

        public LongDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readLong();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            return !this.endOfProcess;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class IntDataInputWrapper
    implements IntIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private int next;

        public IntDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readInt();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            return !this.endOfProcess;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class ByteDataInputWrapper
    implements ByteIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private byte next;

        public ByteDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readByte();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow2) {
                throw new RuntimeException(rethrow2);
            }
            return !this.endOfProcess;
        }

        @Override
        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }
}

