/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.BigListIterator;
import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectBigArrays;
import it.unimi.dsi.fastutil.objects.ObjectBigList;
import it.unimi.dsi.fastutil.objects.ObjectBigListIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class AbstractObjectBigList<K>
extends AbstractObjectCollection<K>
implements ObjectBigList<K>,
Stack<K> {
    protected AbstractObjectBigList() {
    }

    protected void ensureIndex(long index2) {
        if (index2 < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size64()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size64() + ")");
        }
    }

    protected void ensureRestrictedIndex(long index2) {
        if (index2 < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 >= this.size64()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size64() + ")");
        }
    }

    @Override
    public void add(long index2, K k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(K k) {
        this.add(this.size64(), k);
        return true;
    }

    @Override
    public K remove(long i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public K set(long index2, K k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(long index2, Collection<? extends K> c) {
        this.ensureIndex(index2);
        Iterator<K> i = c.iterator();
        boolean retVal = i.hasNext();
        while (i.hasNext()) {
            this.add(index2++, i.next());
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        return this.addAll(this.size64(), c);
    }

    @Override
    public ObjectBigListIterator<K> iterator() {
        return this.listIterator();
    }

    @Override
    public ObjectBigListIterator<K> listIterator() {
        return this.listIterator(0L);
    }

    @Override
    public ObjectBigListIterator<K> listIterator(final long index2) {
        this.ensureIndex(index2);
        return new ObjectBigListIterator<K>(){
            long pos;
            long last;
            {
                this.pos = index2;
                this.last = -1L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < AbstractObjectBigList.this.size64();
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractObjectBigList.this.get(this.last);
            }

            @Override
            public K previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractObjectBigList.this.get(this.pos);
            }

            @Override
            public long nextIndex() {
                return this.pos;
            }

            @Override
            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(K k) {
                AbstractObjectBigList.this.add(this.pos++, k);
                this.last = -1L;
            }

            @Override
            public void set(K k) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                AbstractObjectBigList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                AbstractObjectBigList.this.remove(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }
        };
    }

    @Override
    public boolean contains(Object k) {
        return this.indexOf(k) >= 0L;
    }

    @Override
    public long indexOf(Object k) {
        BigListIterator i = this.listIterator();
        while (i.hasNext()) {
            Object e = i.next();
            if (!Objects.equals(k, e)) continue;
            return i.previousIndex();
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(Object k) {
        BigListIterator i = this.listIterator(this.size64());
        while (i.hasPrevious()) {
            Object e = i.previous();
            if (!Objects.equals(k, e)) continue;
            return i.nextIndex();
        }
        return -1L;
    }

    @Override
    public void size(long size2) {
        long i = this.size64();
        if (size2 > i) {
            while (i++ < size2) {
                this.add((K)null);
            }
        } else {
            while (i-- != size2) {
                this.remove(i);
            }
        }
    }

    @Override
    public ObjectBigList<K> subList(long from2, long to2) {
        this.ensureIndex(from2);
        this.ensureIndex(to2);
        if (from2 > to2) {
            throw new IndexOutOfBoundsException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        return new ObjectSubList(this, from2, to2);
    }

    @Override
    public void removeElements(long from2, long to2) {
        this.ensureIndex(to2);
        BigListIterator i = this.listIterator(from2);
        long n = to2 - from2;
        if (n < 0L) {
            throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        while (n-- != 0L) {
            i.next();
            i.remove();
        }
    }

    @Override
    public void addElements(long index2, K[][] a, long offset, long length) {
        this.ensureIndex(index2);
        ObjectBigArrays.ensureOffsetLength(a, offset, length);
        while (length-- != 0L) {
            this.add(index2++, ObjectBigArrays.get(a, offset++));
        }
    }

    @Override
    public void addElements(long index2, K[][] a) {
        this.addElements(index2, a, 0L, ObjectBigArrays.length(a));
    }

    @Override
    public void getElements(long from2, Object[][] a, long offset, long length) {
        BigListIterator i = this.listIterator(from2);
        ObjectBigArrays.ensureOffsetLength(a, offset, length);
        if (from2 + length > this.size64()) {
            throw new IndexOutOfBoundsException("End index (" + (from2 + length) + ") is greater than list size (" + this.size64() + ")");
        }
        while (length-- != 0L) {
            ObjectBigArrays.set(a, offset++, i.next());
        }
    }

    @Override
    public void clear() {
        this.removeElements(0L, this.size64());
    }

    @Override
    @Deprecated
    public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.size64());
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @Override
    public int hashCode() {
        ObjectIterator i = this.iterator();
        int h = 1;
        long s = this.size64();
        while (s-- != 0L) {
            Object k = i.next();
            h = 31 * h + (k == null ? 0 : k.hashCode());
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BigList)) {
            return false;
        }
        BigList l = (BigList)o;
        long s = this.size64();
        if (s != l.size64()) {
            return false;
        }
        BigListIterator i1 = this.listIterator();
        BigListIterator i2 = l.listIterator();
        while (s-- != 0L) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(BigList<? extends K> l) {
        if (l == this) {
            return 0;
        }
        if (l instanceof ObjectBigList) {
            BigListIterator i1 = this.listIterator();
            BigListIterator i2 = ((ObjectBigList)l).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                Object e2;
                Object e1 = i1.next();
                int r2 = ((Comparable)e1).compareTo(e2 = i2.next());
                if (r2 == 0) continue;
                return r2;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        BigListIterator i1 = this.listIterator();
        BigListIterator<K> i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r3 = ((Comparable)i1.next()).compareTo(i2.next());
            if (r3 == 0) continue;
            return r3;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public void push(K o) {
        this.add(o);
    }

    @Override
    public K pop() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.remove(this.size64() - 1L);
    }

    @Override
    public K top() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(this.size64() - 1L);
    }

    @Override
    public K peek(int i) {
        return this.get(this.size64() - 1L - (long)i);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator i = this.iterator();
        long n = this.size64();
        boolean first2 = true;
        s.append("[");
        while (n-- != 0L) {
            if (first2) {
                first2 = false;
            } else {
                s.append(", ");
            }
            Object k = i.next();
            if (this == k) {
                s.append("(this big list)");
                continue;
            }
            s.append(String.valueOf(k));
        }
        s.append("]");
        return s.toString();
    }

    public static class ObjectSubList<K>
    extends AbstractObjectBigList<K>
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ObjectBigList<K> l;
        protected final long from;
        protected long to;

        public ObjectSubList(ObjectBigList<K> l, long from2, long to2) {
            this.l = l;
            this.from = from2;
            this.to = to2;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size64());
            assert (this.to <= this.l.size64());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(K k) {
            this.l.add(this.to, k);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(long index2, K k) {
            this.ensureIndex(index2);
            this.l.add(this.from + index2, k);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(long index2, Collection<? extends K> c) {
            this.ensureIndex(index2);
            this.to += (long)c.size();
            return this.l.addAll(this.from + index2, c);
        }

        @Override
        public K get(long index2) {
            this.ensureRestrictedIndex(index2);
            return this.l.get(this.from + index2);
        }

        @Override
        public K remove(long index2) {
            this.ensureRestrictedIndex(index2);
            --this.to;
            return this.l.remove(this.from + index2);
        }

        @Override
        public K set(long index2, K k) {
            this.ensureRestrictedIndex(index2);
            return this.l.set(this.from + index2, k);
        }

        @Override
        public long size64() {
            return this.to - this.from;
        }

        @Override
        public void getElements(long from2, Object[][] a, long offset, long length) {
            this.ensureIndex(from2);
            if (from2 + length > this.size64()) {
                throw new IndexOutOfBoundsException("End index (" + from2 + length + ") is greater than list size (" + this.size64() + ")");
            }
            this.l.getElements(this.from + from2, a, offset, length);
        }

        @Override
        public void removeElements(long from2, long to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            this.l.removeElements(this.from + from2, this.from + to2);
            this.to -= to2 - from2;
            assert (this.assertRange());
        }

        @Override
        public void addElements(long index2, K[][] a, long offset, long length) {
            this.ensureIndex(index2);
            this.l.addElements(this.from + index2, a, offset, length);
            this.to += length;
            assert (this.assertRange());
        }

        @Override
        public ObjectBigListIterator<K> listIterator(final long index2) {
            this.ensureIndex(index2);
            return new ObjectBigListIterator<K>(){
                long pos;
                long last;
                {
                    this.pos = index2;
                    this.last = -1L;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < this.size64();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0L;
                }

                @Override
                public K next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return l.get(from + this.last);
                }

                @Override
                public K previous() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return l.get(from + this.pos);
                }

                @Override
                public long nextIndex() {
                    return this.pos;
                }

                @Override
                public long previousIndex() {
                    return this.pos - 1L;
                }

                @Override
                public void add(K k) {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    this.add(this.pos++, k);
                    this.last = -1L;
                    assert (this.assertRange());
                }

                @Override
                public void set(K k) {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    this.set(this.last, k);
                }

                @Override
                public void remove() {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    this.remove(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1L;
                    assert (this.assertRange());
                }
            };
        }

        @Override
        public ObjectBigList<K> subList(long from2, long to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            if (from2 > to2) {
                throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
            }
            return new ObjectSubList<K>(this, from2, to2);
        }
    }
}

