/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.PartitionStates;
import org.apache.kafka.common.requests.IsolationLevel;

public class SubscriptionState {
    private static final String SUBSCRIPTION_EXCEPTION_MESSAGE = "Subscription to topics, partitions and pattern are mutually exclusive";
    private SubscriptionType subscriptionType;
    private Pattern subscribedPattern;
    private Set<String> subscription;
    private final Set<String> groupSubscription;
    private final PartitionStates<TopicPartitionState> assignment;
    private final OffsetResetStrategy defaultResetStrategy;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private ConsumerRebalanceListener rebalanceListener;

    public SubscriptionState(OffsetResetStrategy defaultResetStrategy) {
        this.defaultResetStrategy = defaultResetStrategy;
        this.subscription = Collections.emptySet();
        this.assignment = new PartitionStates();
        this.groupSubscription = new HashSet<String>();
        this.subscribedPattern = null;
        this.subscriptionType = SubscriptionType.NONE;
    }

    private void setSubscriptionType(SubscriptionType type) {
        if (this.subscriptionType == SubscriptionType.NONE) {
            this.subscriptionType = type;
        } else if (this.subscriptionType != type) {
            throw new IllegalStateException(SUBSCRIPTION_EXCEPTION_MESSAGE);
        }
    }

    public void subscribe(Set<String> topics, ConsumerRebalanceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("RebalanceListener cannot be null");
        }
        this.setSubscriptionType(SubscriptionType.AUTO_TOPICS);
        this.rebalanceListener = listener;
        this.changeSubscription(topics);
    }

    public void subscribeFromPattern(Set<String> topics) {
        if (this.subscriptionType != SubscriptionType.AUTO_PATTERN) {
            throw new IllegalArgumentException("Attempt to subscribe from pattern while subscription type set to " + (Object)((Object)this.subscriptionType));
        }
        this.changeSubscription(topics);
    }

    private void changeSubscription(Set<String> topicsToSubscribe) {
        if (!this.subscription.equals(topicsToSubscribe)) {
            this.subscription = topicsToSubscribe;
            this.groupSubscription.addAll(topicsToSubscribe);
        }
    }

    public void groupSubscribe(Collection<String> topics) {
        if (this.subscriptionType == SubscriptionType.USER_ASSIGNED) {
            throw new IllegalStateException(SUBSCRIPTION_EXCEPTION_MESSAGE);
        }
        this.groupSubscription.addAll(topics);
    }

    public void resetGroupSubscription() {
        this.groupSubscription.retainAll(this.subscription);
    }

    public void assignFromUser(Set<TopicPartition> partitions) {
        this.setSubscriptionType(SubscriptionType.USER_ASSIGNED);
        if (!this.assignment.partitionSet().equals(partitions)) {
            this.fireOnAssignment(partitions);
            HashMap<TopicPartition, TopicPartitionState> partitionToState = new HashMap<TopicPartition, TopicPartitionState>();
            for (TopicPartition partition : partitions) {
                TopicPartitionState state = this.assignment.stateValue(partition);
                if (state == null) {
                    state = new TopicPartitionState();
                }
                partitionToState.put(partition, state);
            }
            this.assignment.set(partitionToState);
        }
    }

    public void assignFromSubscribed(Collection<TopicPartition> assignments) {
        if (!this.partitionsAutoAssigned()) {
            throw new IllegalArgumentException("Attempt to dynamically assign partitions while manual assignment in use");
        }
        Map<TopicPartition, TopicPartitionState> assignedPartitionStates = SubscriptionState.partitionToStateMap(assignments);
        this.fireOnAssignment(assignedPartitionStates.keySet());
        if (this.subscribedPattern != null) {
            for (TopicPartition tp : assignments) {
                if (this.subscribedPattern.matcher(tp.topic()).matches()) continue;
                throw new IllegalArgumentException("Assigned partition " + tp + " for non-subscribed topic regex pattern; subscription pattern is " + this.subscribedPattern);
            }
        } else {
            for (TopicPartition tp : assignments) {
                if (this.subscription.contains(tp.topic())) continue;
                throw new IllegalArgumentException("Assigned partition " + tp + " for non-subscribed topic; subscription is " + this.subscription);
            }
        }
        this.assignment.set(assignedPartitionStates);
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("RebalanceListener cannot be null");
        }
        this.setSubscriptionType(SubscriptionType.AUTO_PATTERN);
        this.rebalanceListener = listener;
        this.subscribedPattern = pattern;
    }

    public boolean hasPatternSubscription() {
        return this.subscriptionType == SubscriptionType.AUTO_PATTERN;
    }

    public boolean hasNoSubscriptionOrUserAssignment() {
        return this.subscriptionType == SubscriptionType.NONE;
    }

    public void unsubscribe() {
        this.subscription = Collections.emptySet();
        this.assignment.clear();
        this.subscribedPattern = null;
        this.subscriptionType = SubscriptionType.NONE;
        this.fireOnAssignment(Collections.emptySet());
    }

    public Pattern subscribedPattern() {
        return this.subscribedPattern;
    }

    public Set<String> subscription() {
        return this.subscription;
    }

    public Set<TopicPartition> pausedPartitions() {
        return this.collectPartitions(rec$ -> ((TopicPartitionState)rec$).isPaused(), Collectors.toSet());
    }

    public Set<String> groupSubscription() {
        return this.groupSubscription;
    }

    private TopicPartitionState assignedState(TopicPartition tp) {
        TopicPartitionState state = this.assignment.stateValue(tp);
        if (state == null) {
            throw new IllegalStateException("No current assignment for partition " + tp);
        }
        return state;
    }

    public void seek(TopicPartition tp, long offset) {
        this.assignedState(tp).seek(offset);
    }

    public Set<TopicPartition> assignedPartitions() {
        return this.assignment.partitionSet();
    }

    public int numAssignedPartitions() {
        return this.assignment.size();
    }

    public List<TopicPartition> fetchablePartitions() {
        return this.collectPartitions(rec$ -> ((TopicPartitionState)rec$).isFetchable(), Collectors.toList());
    }

    public boolean partitionsAutoAssigned() {
        return this.subscriptionType == SubscriptionType.AUTO_TOPICS || this.subscriptionType == SubscriptionType.AUTO_PATTERN;
    }

    public void position(TopicPartition tp, long offset) {
        this.assignedState(tp).position(offset);
    }

    public Long position(TopicPartition tp) {
        return this.assignedState(tp).position;
    }

    public Long partitionLag(TopicPartition tp, IsolationLevel isolationLevel) {
        TopicPartitionState topicPartitionState = this.assignedState(tp);
        if (isolationLevel == IsolationLevel.READ_COMMITTED) {
            return topicPartitionState.lastStableOffset == null ? null : Long.valueOf(topicPartitionState.lastStableOffset - topicPartitionState.position);
        }
        return topicPartitionState.highWatermark == null ? null : Long.valueOf(topicPartitionState.highWatermark - topicPartitionState.position);
    }

    public Long partitionLead(TopicPartition tp) {
        TopicPartitionState topicPartitionState = this.assignedState(tp);
        return topicPartitionState.logStartOffset == null ? null : Long.valueOf(topicPartitionState.position - topicPartitionState.logStartOffset);
    }

    public void updateHighWatermark(TopicPartition tp, long highWatermark) {
        this.assignedState(tp).highWatermark = highWatermark;
    }

    public void updateLogStartOffset(TopicPartition tp, long logStartOffset) {
        this.assignedState(tp).logStartOffset = logStartOffset;
    }

    public void updateLastStableOffset(TopicPartition tp, long lastStableOffset) {
        this.assignedState(tp).lastStableOffset = lastStableOffset;
    }

    public Map<TopicPartition, OffsetAndMetadata> allConsumed() {
        HashMap<TopicPartition, OffsetAndMetadata> allConsumed = new HashMap<TopicPartition, OffsetAndMetadata>();
        this.assignment.stream().forEach(state -> {
            if (((TopicPartitionState)state.value()).hasValidPosition()) {
                allConsumed.put(state.topicPartition(), new OffsetAndMetadata(((TopicPartitionState)state.value()).position));
            }
        });
        return allConsumed;
    }

    public void requestOffsetReset(TopicPartition partition, OffsetResetStrategy offsetResetStrategy) {
        this.assignedState(partition).reset(offsetResetStrategy);
    }

    public void requestOffsetReset(TopicPartition partition) {
        this.requestOffsetReset(partition, this.defaultResetStrategy);
    }

    public void setResetPending(Set<TopicPartition> partitions, long nextAllowResetTimeMs) {
        for (TopicPartition partition : partitions) {
            this.assignedState(partition).setResetPending(nextAllowResetTimeMs);
        }
    }

    public boolean hasDefaultOffsetResetPolicy() {
        return this.defaultResetStrategy != OffsetResetStrategy.NONE;
    }

    public boolean isOffsetResetNeeded(TopicPartition partition) {
        return this.assignedState(partition).awaitingReset();
    }

    public OffsetResetStrategy resetStrategy(TopicPartition partition) {
        return this.assignedState(partition).resetStrategy;
    }

    public boolean hasAllFetchPositions() {
        return this.assignment.stream().allMatch(state -> ((TopicPartitionState)state.value()).hasValidPosition());
    }

    public Set<TopicPartition> missingFetchPositions() {
        return this.collectPartitions(rec$ -> ((TopicPartitionState)rec$).isMissingPosition(), Collectors.toSet());
    }

    private <T extends Collection<TopicPartition>> T collectPartitions(Predicate<TopicPartitionState> filter2, Collector<TopicPartition, ?, T> collector) {
        return (T)((Collection)this.assignment.stream().filter(state -> filter2.test((TopicPartitionState)state.value())).map(PartitionStates.PartitionState::topicPartition).collect(collector));
    }

    public void resetMissingPositions() {
        HashSet<TopicPartition> partitionsWithNoOffsets = new HashSet<TopicPartition>();
        this.assignment.stream().forEach(state -> {
            TopicPartition tp = state.topicPartition();
            TopicPartitionState partitionState = (TopicPartitionState)state.value();
            if (partitionState.isMissingPosition()) {
                if (this.defaultResetStrategy == OffsetResetStrategy.NONE) {
                    partitionsWithNoOffsets.add(tp);
                } else {
                    partitionState.reset(this.defaultResetStrategy);
                }
            }
        });
        if (!partitionsWithNoOffsets.isEmpty()) {
            throw new NoOffsetForPartitionException(partitionsWithNoOffsets);
        }
    }

    public Set<TopicPartition> partitionsNeedingReset(long nowMs) {
        return this.collectPartitions(state -> ((TopicPartitionState)state).awaitingReset() && ((TopicPartitionState)state).isResetAllowed(nowMs), Collectors.toSet());
    }

    public boolean isAssigned(TopicPartition tp) {
        return this.assignment.contains(tp);
    }

    public boolean isPaused(TopicPartition tp) {
        return this.isAssigned(tp) && this.assignedState(tp).paused;
    }

    public boolean isFetchable(TopicPartition tp) {
        return this.isAssigned(tp) && this.assignedState(tp).isFetchable();
    }

    public boolean hasValidPosition(TopicPartition tp) {
        return this.isAssigned(tp) && this.assignedState(tp).hasValidPosition();
    }

    public void pause(TopicPartition tp) {
        this.assignedState(tp).pause();
    }

    public void resume(TopicPartition tp) {
        this.assignedState(tp).resume();
    }

    public void resetFailed(Set<TopicPartition> partitions, long nextRetryTimeMs) {
        for (TopicPartition partition : partitions) {
            this.assignedState(partition).resetFailed(nextRetryTimeMs);
        }
    }

    public void movePartitionToEnd(TopicPartition tp) {
        this.assignment.moveToEnd(tp);
    }

    public ConsumerRebalanceListener rebalanceListener() {
        return this.rebalanceListener;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void fireOnAssignment(Set<TopicPartition> assignment) {
        for (Listener listener : this.listeners) {
            listener.onAssignment(assignment);
        }
    }

    private static Map<TopicPartition, TopicPartitionState> partitionToStateMap(Collection<TopicPartition> assignments) {
        HashMap<TopicPartition, TopicPartitionState> map23 = new HashMap<TopicPartition, TopicPartitionState>(assignments.size());
        for (TopicPartition tp : assignments) {
            map23.put(tp, new TopicPartitionState());
        }
        return map23;
    }

    public static interface Listener {
        public void onAssignment(Set<TopicPartition> var1);
    }

    private static class TopicPartitionState {
        private Long position = null;
        private Long highWatermark = null;
        private Long logStartOffset = null;
        private Long lastStableOffset = null;
        private boolean paused = false;
        private OffsetResetStrategy resetStrategy = null;
        private Long nextAllowedRetryTimeMs = null;

        TopicPartitionState() {
        }

        private void reset(OffsetResetStrategy strategy) {
            this.resetStrategy = strategy;
            this.position = null;
            this.nextAllowedRetryTimeMs = null;
        }

        private boolean isResetAllowed(long nowMs) {
            return this.nextAllowedRetryTimeMs == null || nowMs >= this.nextAllowedRetryTimeMs;
        }

        private boolean awaitingReset() {
            return this.resetStrategy != null;
        }

        private void setResetPending(long nextAllowedRetryTimeMs) {
            this.nextAllowedRetryTimeMs = nextAllowedRetryTimeMs;
        }

        private void resetFailed(long nextAllowedRetryTimeMs) {
            this.nextAllowedRetryTimeMs = nextAllowedRetryTimeMs;
        }

        private boolean hasValidPosition() {
            return this.position != null;
        }

        private boolean isMissingPosition() {
            return !this.hasValidPosition() && !this.awaitingReset();
        }

        private boolean isPaused() {
            return this.paused;
        }

        private void seek(long offset) {
            this.position = offset;
            this.resetStrategy = null;
            this.nextAllowedRetryTimeMs = null;
        }

        private void position(long offset) {
            if (!this.hasValidPosition()) {
                throw new IllegalStateException("Cannot set a new position without a valid current position");
            }
            this.position = offset;
        }

        private void pause() {
            this.paused = true;
        }

        private void resume() {
            this.paused = false;
        }

        private boolean isFetchable() {
            return !this.paused && this.hasValidPosition();
        }
    }

    private static enum SubscriptionType {
        NONE,
        AUTO_TOPICS,
        AUTO_PATTERN,
        USER_ASSIGNED;

    }
}

