/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.Bytes;

public class SyncGroupRequestData
implements ApiMessage {
    private String groupId;
    private int generationId;
    private String memberId;
    private List<SyncGroupRequestAssignment> assignments;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public SyncGroupRequestData(Readable readable, short version) {
        this.assignments = new ArrayList<SyncGroupRequestAssignment>();
        this.read(readable, version);
    }

    public SyncGroupRequestData(Struct struct, short version) {
        this.assignments = new ArrayList<SyncGroupRequestAssignment>();
        this.fromStruct(struct, version);
    }

    public SyncGroupRequestData() {
        this.groupId = "";
        this.generationId = 0;
        this.memberId = "";
        this.assignments = new ArrayList<SyncGroupRequestAssignment>();
    }

    @Override
    public short apiKey() {
        return 14;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable readable, short version) {
        this.groupId = readable.readNullableString();
        this.generationId = readable.readInt();
        this.memberId = readable.readNullableString();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.assignments.clear();
        } else {
            this.assignments.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.assignments.add(new SyncGroupRequestAssignment(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeString(this.groupId);
        writable.writeInt(this.generationId);
        writable.writeString(this.memberId);
        writable.writeInt(this.assignments.size());
        for (SyncGroupRequestAssignment element : this.assignments) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.groupId = struct.getString("group_id");
        this.generationId = struct.getInt("generation_id");
        this.memberId = struct.getString("member_id");
        Object[] nestedObjects = struct.getArray("assignments");
        this.assignments = new ArrayList<SyncGroupRequestAssignment>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.assignments.add(new SyncGroupRequestAssignment((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("group_id", (Object)this.groupId);
        struct.set("generation_id", (Object)this.generationId);
        struct.set("member_id", (Object)this.memberId);
        Struct[] nestedObjects = new Struct[this.assignments.size()];
        int i = 0;
        for (SyncGroupRequestAssignment element : this.assignments) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("assignments", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size2 = 0;
        size2 += 2;
        size2 += MessageUtil.serializedUtf8Length(this.groupId);
        size2 += 4;
        size2 += 2;
        size2 += MessageUtil.serializedUtf8Length(this.memberId);
        size2 += 4;
        for (SyncGroupRequestAssignment element : this.assignments) {
            size2 += element.size(version);
        }
        return size2;
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof SyncGroupRequestData)) {
            return false;
        }
        SyncGroupRequestData other = (SyncGroupRequestData)obj2;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.generationId != other.generationId) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        return !(this.assignments == null ? other.assignments != null : !this.assignments.equals(other.assignments));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + this.generationId;
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + (this.assignments == null ? 0 : this.assignments.hashCode());
        return hashCode;
    }

    public String toString() {
        return "SyncGroupRequestData(groupId='" + this.groupId + "', generationId=" + this.generationId + ", memberId='" + this.memberId + "', assignments=" + MessageUtil.deepToString(this.assignments.iterator()) + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public int generationId() {
        return this.generationId;
    }

    public String memberId() {
        return this.memberId;
    }

    public List<SyncGroupRequestAssignment> assignments() {
        return this.assignments;
    }

    public SyncGroupRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public SyncGroupRequestData setGenerationId(int v) {
        this.generationId = v;
        return this;
    }

    public SyncGroupRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public SyncGroupRequestData setAssignments(List<SyncGroupRequestAssignment> v) {
        this.assignments = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("group_id", Type.STRING, "The unique group identifier."), new Field("generation_id", Type.INT32, "The generation of the group."), new Field("member_id", Type.STRING, "The member ID assigned by the group."), new Field("assignments", new ArrayOf(SyncGroupRequestAssignment.SCHEMA_0), "Each assignment.")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class SyncGroupRequestAssignment
    implements Message {
        private String memberId;
        private byte[] assignment;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public SyncGroupRequestAssignment(Readable readable, short version) {
            this.read(readable, version);
        }

        public SyncGroupRequestAssignment(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public SyncGroupRequestAssignment() {
            this.memberId = "";
            this.assignment = Bytes.EMPTY;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable readable, short version) {
            this.memberId = readable.readNullableString();
            this.assignment = readable.readNullableBytes();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.memberId);
            writable.writeBytes(this.assignment);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.memberId = struct.getString("member_id");
            this.assignment = struct.getByteArray("assignment");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("member_id", (Object)this.memberId);
            struct.setByteArray("assignment", this.assignment);
            return struct;
        }

        @Override
        public int size(short version) {
            int size2 = 0;
            size2 += 2;
            size2 += MessageUtil.serializedUtf8Length(this.memberId);
            size2 += 4;
            return size2 += this.assignment.length;
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof SyncGroupRequestAssignment)) {
                return false;
            }
            SyncGroupRequestAssignment other = (SyncGroupRequestAssignment)obj2;
            if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
                return false;
            }
            return Arrays.equals(this.assignment, other.assignment);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
            hashCode = 31 * hashCode + Arrays.hashCode(this.assignment);
            return hashCode;
        }

        public String toString() {
            return "SyncGroupRequestAssignment(memberId='" + this.memberId + "', assignment=" + Arrays.toString(this.assignment) + ")";
        }

        public String memberId() {
            return this.memberId;
        }

        public byte[] assignment() {
            return this.assignment;
        }

        public SyncGroupRequestAssignment setMemberId(String v) {
            this.memberId = v;
            return this;
        }

        public SyncGroupRequestAssignment setAssignment(byte[] v) {
            this.assignment = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("member_id", Type.STRING, "The ID of the member to assign."), new Field("assignment", Type.BYTES, "The member assignment.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

