/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.Time;

public class Timer {
    private final Time time;
    private long startMs;
    private long currentTimeMs;
    private long deadlineMs;

    Timer(Time time, long timeoutMs) {
        this.time = time;
        this.update();
        this.reset(timeoutMs);
    }

    public boolean isExpired() {
        return this.currentTimeMs >= this.deadlineMs;
    }

    public boolean notExpired() {
        return !this.isExpired();
    }

    public void updateAndReset(long timeoutMs) {
        this.update();
        this.reset(timeoutMs);
    }

    public void reset(long timeoutMs) {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("Invalid negative timeout " + timeoutMs);
        }
        this.startMs = this.currentTimeMs;
        this.deadlineMs = this.currentTimeMs > Long.MAX_VALUE - timeoutMs ? Long.MAX_VALUE : this.currentTimeMs + timeoutMs;
    }

    public void update() {
        this.update(this.time.milliseconds());
    }

    public void update(long currentTimeMs) {
        this.currentTimeMs = Math.max(currentTimeMs, this.currentTimeMs);
    }

    public long remainingMs() {
        return Math.max(0L, this.deadlineMs - this.currentTimeMs);
    }

    public long currentTimeMs() {
        return this.currentTimeMs;
    }

    public long elapsedMs() {
        return this.currentTimeMs - this.startMs;
    }

    public void sleep(long durationMs) {
        long sleepDurationMs = Math.min(durationMs, this.remainingMs());
        this.time.sleep(sleepDurationMs);
        this.update();
    }
}

