/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.DatabaseType;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementSchema;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TablePeriodWorks;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.ScriptLoader;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rights.User;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.types.TimestampData;

public class StatementCommand
extends Statement {
    Object[] arguments;

    StatementCommand(int n, Object[] objectArray) {
        this(n, objectArray, null, null);
    }

    StatementCommand(int n, Object[] objectArray, HsqlNameManager.HsqlName[] hsqlNameArray, HsqlNameManager.HsqlName[] hsqlNameArray2) {
        super(n);
        this.isTransactionStatement = true;
        this.arguments = objectArray;
        if (hsqlNameArray != null) {
            this.readTableNames = hsqlNameArray;
        }
        if (hsqlNameArray2 != null) {
            this.writeTableNames = hsqlNameArray2;
        }
        switch (n) {
            case 1215: {
                this.group = 2014;
                break;
            }
            case 1150: 
            case 1151: {
                this.group = 2009;
                this.statementReturnType = 2;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1002: {
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1004: {
                String string2 = (String)this.arguments[0];
                if (string2 == null) {
                    this.statementReturnType = 2;
                }
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1005: {
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1006: {
                this.statementReturnType = 2;
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1001: {
                this.group = 2014;
                if (hsqlNameArray2.length == 0) {
                    this.group = 2015;
                }
                this.isLogged = false;
                break;
            }
            case 1052: {
                this.group = 2014;
                break;
            }
            case 1016: 
            case 1032: 
            case 1033: 
            case 1056: {
                this.isTransactionStatement = false;
                this.group = 2013;
                break;
            }
            case 1011: 
            case 1012: 
            case 1013: 
            case 1015: 
            case 1017: 
            case 1018: 
            case 1020: 
            case 1021: 
            case 1022: 
            case 1025: 
            case 1026: 
            case 1031: 
            case 1034: 
            case 1035: 
            case 1036: 
            case 1037: 
            case 1039: 
            case 1040: 
            case 1046: 
            case 1047: 
            case 1049: 
            case 1050: 
            case 1051: 
            case 1053: 
            case 1054: 
            case 1055: 
            case 1057: {
                this.group = 2013;
                break;
            }
            case 1014: {
                this.group = 2013;
                this.isLogged = false;
                break;
            }
            case 1159: 
            case 1160: 
            case 1161: {
                this.group = 2012;
                break;
            }
            case 1157: {
                this.group = 2012;
                this.isLogged = false;
                break;
            }
            case 1156: {
                this.group = 2012;
                break;
            }
            case 1155: {
                this.group = 2012;
                break;
            }
            case 1003: {
                this.group = 2014;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1158: {
                this.group = 2012;
                break;
            }
            case 1154: {
                this.group = 2013;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1091: 
            case 1092: 
            case 1093: {
                this.group = 2013;
                this.isTransactionStatement = false;
                break;
            }
            case 1120: {
                this.group = 2011;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCommand");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result2;
        try {
            result2 = this.getResult(session);
        }
        catch (Throwable throwable) {
            result2 = Result.newErrorResult(throwable, this.getSQL());
        }
        if (result2.isError()) {
            result2.getException().setStatementType(this.group, this.type);
            return result2;
        }
        try {
            if (this.isLogged) {
                session.database.logger.writeOtherStatement(session, this.sql);
            }
        }
        catch (Throwable throwable) {
            return Result.newErrorResult(throwable, this.getSQL());
        }
        return result2;
    }

    Result getResult(Session session) {
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        switch (this.type) {
            case 1215: {
                return this.getTruncateResult(session);
            }
            case 1150: {
                OrderedHashSet orderedHashSet;
                Object object;
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                boolean bl = (Boolean)this.arguments[1];
                if (bl) {
                    object = session.database.schemaManager.getSchemaObject(hsqlName);
                    orderedHashSet = object.getReferences();
                    if (orderedHashSet == null) {
                        orderedHashSet = new OrderedHashSet();
                    }
                } else {
                    orderedHashSet = new OrderedHashSet();
                    session.database.schemaManager.getCascadingReferencesTo(hsqlName, orderedHashSet);
                }
                object = Result.newSingleColumnResult("REFERENCES");
                for (int i = 0; i < orderedHashSet.size(); ++i) {
                    HsqlNameManager.HsqlName hsqlName2 = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                    String string2 = SchemaObjectSet.getName(hsqlName2.type) + ' ' + hsqlName2.getSchemaQualifiedStatementName();
                    Object[] objectArray = new Object[]{string2};
                    ((Result)object).navigator.add(objectArray);
                }
                return object;
            }
            case 1151: {
                Statement statement = (Statement)this.arguments[0];
                return Result.newSingleColumnStringResult("PLAN", statement.describe(session));
            }
            case 1001: {
                String string3 = (String)this.arguments[0];
                boolean bl = (Boolean)this.arguments[1];
                boolean bl2 = (Boolean)this.arguments[2];
                boolean bl3 = (Boolean)this.arguments[3];
                boolean bl4 = (Boolean)this.arguments[4];
                try {
                    session.checkAdmin();
                    if (session.database.getType() != DatabaseType.DB_FILE) {
                        throw Error.error(459);
                    }
                    if (session.database.isFilesReadOnly()) {
                        throw Error.error(455);
                    }
                    session.database.logger.backup(string3, bl2, bl, bl3, bl4);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1002: {
                boolean bl = (Boolean)this.arguments[0];
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.checkpoint(session, bl, true);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1011: {
                try {
                    boolean bl = (Boolean)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setIncrementBackup(bl);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1012: {
                try {
                    int n = (Integer)this.arguments[0];
                    boolean bl = this.arguments[1] == null;
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (bl) {
                        n = session.database.getProperties().getPropertyWithinRange("hsqldb.cache_rows", n);
                    }
                    session.database.logger.setCacheMaxRows(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1013: {
                try {
                    int n = (Integer)this.arguments[0];
                    boolean bl = this.arguments[1] == null;
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (bl) {
                        n = session.database.getProperties().getPropertyWithinRange("hsqldb.cache_size", n);
                    }
                    session.database.logger.setCacheSize(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1014: {
                try {
                    long l = (Long)this.arguments[0];
                    long l2 = (Long)this.arguments[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript()) {
                        session.database.logger.setFilesTimestamp(l);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1017: {
                try {
                    int n = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript()) {
                        session.database.logger.setLobFileScaleNoCheck(n);
                    } else {
                        session.database.logger.setLobFileScale(n);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1018: {
                try {
                    boolean bl = (Boolean)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript()) {
                        session.database.logger.setLobFileCompressedNoCheck(bl);
                    } else {
                        session.database.logger.setLobFileCompressed(bl);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1025: {
                try {
                    int n = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript()) {
                        session.database.logger.setDataFileScaleNoCheck(n);
                    } else {
                        session.database.logger.setDataFileScale(n);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1031: {
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.database.getType() == DatabaseType.DB_RES) {
                        return Result.updateZeroResult;
                    }
                    if (session.database.isFilesReadOnly()) {
                        return Result.updateZeroResult;
                    }
                    if (this.arguments[0] instanceof Boolean) {
                        boolean bl = (Boolean)this.arguments[0];
                        session.database.logger.setDataFileSpaces(bl);
                    } else {
                        int n = (Integer)this.arguments[0];
                        session.database.logger.setDataFileSpaces(n);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1015: {
                try {
                    int n = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (!session.database.getProperties().validateProperty("hsqldb.defrag_limit", n)) {
                        throw Error.error(5556);
                    }
                    session.database.logger.setDefagLimit(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1016: {
                try {
                    int n = (Integer)this.arguments[0];
                    boolean bl = (Boolean)this.arguments[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setEventLogLevel(n, bl);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1022: {
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    Object object = this.arguments[0];
                    if (object instanceof Boolean) {
                        boolean bl = (Boolean)this.arguments[0];
                        session.database.logger.setNioDataFile(bl);
                    } else {
                        int n = (Integer)this.arguments[0];
                        session.database.logger.setNioMaxSize(n);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1020: {
                try {
                    boolean bl = (Boolean)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setLogData(bl);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1021: {
                try {
                    int n = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setLogSize(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1032: {
                try {
                    String string4 = (String)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1026: {
                try {
                    int n = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setScriptType(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1033: {
                try {
                    int n = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setWriteDelay(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1036: {
                try {
                    Routine routine = (Routine)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.userManager.setExtAuthenticationFunction(routine);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1040: {
                try {
                    Routine routine = (Routine)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.userManager.setPasswordCheckFunction(routine);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1057: {
                try {
                    String string5 = (String)this.arguments[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (!session.isProcessingScript()) {
                        return Result.updateZeroResult;
                    }
                    session.database.granteeManager.setDigestAlgo(string5);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1047: {
                try {
                    String string6 = (String)this.arguments[0];
                    boolean bl = (Boolean)this.arguments[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.collation.setCollation(string6, bl);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1049: {
                boolean bl = (Boolean)this.arguments[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.setReferentialIntegrity(bl);
                return Result.updateZeroResult;
            }
            case 1050: {
                String string7 = (String)this.arguments[0];
                boolean bl = (Boolean)this.arguments[1];
                int n = ((Number)this.arguments[2]).intValue();
                session.checkAdmin();
                session.checkDDLWrite();
                if ("sql.live_object".equals(string7)) {
                    session.database.setLiveObject(bl);
                } else if ("sql.restrict_exec".equals(string7)) {
                    session.database.setRestrictExec(bl);
                } else if ("sql.enforce_names".equals(string7)) {
                    session.database.setStrictNames(bl);
                } else if ("sql.regular_names".equals(string7)) {
                    session.database.setRegularNames(bl);
                } else if ("sql.enforce_size".equals(string7)) {
                    session.database.setStrictColumnSize(bl);
                } else if ("sql.enforce_types".equals(string7)) {
                    session.database.setStrictTypes(bl);
                } else if ("sql.enforce_refs".equals(string7)) {
                    session.database.setStrictReferences(bl);
                } else if ("sql.enforce_tdc_delete".equals(string7)) {
                    session.database.setStrictTDCD(bl);
                } else if ("sql.enforce_tdc_update".equals(string7)) {
                    session.database.setStrictTDCU(bl);
                } else if ("jdbc.translate_tti_types".equals(string7)) {
                    session.database.setTranslateTTI(bl);
                } else if ("sql.char_literal".equals(string7)) {
                    session.database.setCharacterLiteral(bl);
                } else if ("sql.concat_nulls".equals(string7)) {
                    session.database.setConcatNulls(bl);
                } else if ("sql.nulls_first".equals(string7)) {
                    session.database.setNullsFirst(bl);
                } else if ("sql.nulls_order".equals(string7)) {
                    session.database.setNullsOrder(bl);
                } else if ("sql.unique_nulls".equals(string7)) {
                    session.database.setUniqueNulls(bl);
                } else if ("sql.convert_trunc".equals(string7)) {
                    session.database.setConvertTrunc(bl);
                } else if ("sql.avg_scale".equals(string7)) {
                    session.database.setAvgScale(n);
                } else if ("sql.double_nan".equals(string7)) {
                    session.database.setDoubleNaN(bl);
                } else if ("sql.longvar_is_lob".equals(string7)) {
                    session.database.setLongVarIsLob(bl);
                } else if ("sql.ignore_case".equals(string7)) {
                    session.database.setIgnoreCase(bl);
                    session.setIgnoreCase(bl);
                } else if ("sql.syntax_db2".equals(string7)) {
                    session.database.setSyntaxDb2(bl);
                } else if ("sql.syntax_mss".equals(string7)) {
                    session.database.setSyntaxMss(bl);
                } else if ("sql.syntax_mys".equals(string7)) {
                    session.database.setSyntaxMys(bl);
                } else if ("sql.syntax_ora".equals(string7)) {
                    session.database.setSyntaxOra(bl);
                } else if ("sql.syntax_pgs".equals(string7)) {
                    session.database.setSyntaxPgs(bl);
                } else if ("sql.sys_index_names".equals(string7)) {
                    session.database.setSysIndexNames(bl);
                }
                return Result.updateZeroResult;
            }
            case 1034: {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.schemaManager.setDefaultSchemaHsqlName(hsqlName);
                session.database.schemaManager.setSchemaChangeTimestamp();
                return Result.updateZeroResult;
            }
            case 1035: {
                Integer n = (Integer)this.arguments[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.schemaManager.setDefaultTableType(n);
                return Result.updateZeroResult;
            }
            case 1052: {
                try {
                    int n = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.database.txManager.setTransactionControl(session, n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1053: {
                try {
                    int n = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.database.defaultIsolationLevel = n;
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1054: {
                try {
                    boolean bl = (Boolean)this.arguments[0];
                    session.checkAdmin();
                    session.database.txConflictRollback = bl;
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1055: {
                try {
                    boolean bl = (Boolean)this.arguments[0];
                    session.checkAdmin();
                    session.database.txInterruptRollback = bl;
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1037: {
                try {
                    int n = (Integer)this.arguments[0];
                    session.checkAdmin();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1039: {
                try {
                    String string8 = (String)this.arguments[0];
                    Object object = this.arguments[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1046: {
                int n = (Integer)this.arguments[0];
                session.checkAdmin();
                session.database.setResultMaxMemoryRows(n);
                return Result.updateZeroResult;
            }
            case 1051: {
                try {
                    String string9 = (String)this.arguments[0];
                    HsqlProperties hsqlProperties = null;
                    session.checkAdmin();
                    if (string9.length() > 0) {
                        hsqlProperties = HsqlProperties.delimitedArgPairsToProps(string9, "=", ";", null);
                        if (hsqlProperties.getErrorKeys().length > 0) {
                            throw Error.error(482, hsqlProperties.getErrorKeys()[0]);
                        }
                        session.database.logger.setDefaultTextTableProperties(string9, hsqlProperties);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1056: {
                try {
                    String string10 = (String)this.arguments[0];
                    session.checkAdmin();
                    session.database.setDatabaseName(string10);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1004: {
                ScriptWriterText scriptWriterText = null;
                String string11 = (String)this.arguments[0];
                Integer n = (Integer)this.arguments[1];
                Integer n2 = (Integer)this.arguments[2];
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[3];
                TimestampData timestampData = (TimestampData)this.arguments[4];
                try {
                    session.checkAdmin();
                    if (string11 == null) {
                        return session.database.getScript(false);
                    }
                    scriptWriterText = new ScriptWriterText(session.database, string11, true, true, true);
                    switch (n2) {
                        case 2: {
                            scriptWriterText.writeAll();
                            break;
                        }
                        case 540: {
                            scriptWriterText.writeDDL();
                            break;
                        }
                        case 399: {
                            if (hsqlName == null) {
                                scriptWriterText.writeExistingData(false);
                                break;
                            }
                            Table table = session.database.schemaManager.getUserTable(hsqlName);
                            scriptWriterText.setIncludeTableInit(true);
                            scriptWriterText.writeTableData(table);
                            break;
                        }
                        case 331: {
                            scriptWriterText.writeVersioningData(timestampData);
                        }
                    }
                    scriptWriterText.close();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1003: {
                try {
                    int n = (Integer)this.arguments[0];
                    session.checkAdmin();
                    session.database.close(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1005: {
                try {
                    String string12 = (String)this.arguments[0];
                    int n = (Integer)this.arguments[1];
                    Boolean bl = (Boolean)this.arguments[2];
                    return ScriptLoader.loadScriptData(session, string12, n, bl);
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1006: {
                try {
                    int n = (Integer)this.arguments[1];
                    Result result2 = Result.newDoubleColumnResult("TABLE_NAME", "INFO");
                    return result2;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1160: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                    Table table = session.database.schemaManager.getUserTable(hsqlName.name, hsqlName.schema.name);
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (!session.database.logger.isFileDatabase()) {
                        return Result.updateZeroResult;
                    }
                    if (session.database.logger.getDataFileSpaces() == 0) {
                        throw Error.error(457);
                    }
                    if (table.getSpaceID() != 7) {
                        return Result.updateZeroResult;
                    }
                    DataFileCache dataFileCache = session.database.logger.getCache();
                    if (dataFileCache == null) {
                        return Result.updateZeroResult;
                    }
                    DataSpaceManager dataSpaceManager = dataFileCache.spaceManager;
                    int n = dataSpaceManager.getNewTableSpaceID();
                    table.setSpaceID(n);
                    if (!table.isCached()) {
                        return Result.updateZeroResult;
                    }
                    TableSpaceManager tableSpaceManager = dataSpaceManager.getTableSpace(n);
                    PersistentStore persistentStore = table.getRowStore(session);
                    persistentStore.setSpaceManager(tableSpaceManager);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1161: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                    int n = (Integer)this.arguments[1];
                    Table table = session.database.schemaManager.getUserTable(hsqlName.name, hsqlName.schema.name);
                    if (!session.isProcessingScript()) {
                        return Result.updateZeroResult;
                    }
                    if (table.getTableType() != 5) {
                        return Result.updateZeroResult;
                    }
                    if (table.getSpaceID() != 7) {
                        return Result.updateZeroResult;
                    }
                    table.setSpaceID(n);
                    if (table.store == null) {
                        return Result.updateZeroResult;
                    }
                    DataFileCache dataFileCache = session.database.logger.getCache();
                    if (dataFileCache == null) {
                        return Result.updateZeroResult;
                    }
                    DataSpaceManager dataSpaceManager = dataFileCache.spaceManager;
                    TableSpaceManager tableSpaceManager = dataSpaceManager.getTableSpace(table.getSpaceID());
                    table.store.setSpaceManager(tableSpaceManager);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1159: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                    int[] nArray = (int[])this.arguments[1];
                    Table table = session.database.schemaManager.getUserTable(hsqlName.name, hsqlName.schema.name);
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isCached() && !table.isText()) {
                        throw Error.error(457);
                    }
                    Index index2 = table.getIndexForColumns(session, nArray);
                    if (index2 != null) {
                        Index[] indexArray = table.getIndexList();
                        for (int i = 0; i < indexArray.length; ++i) {
                            indexArray[i].setClustered(false);
                        }
                        index2.setClustered(true);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1154: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                    String string13 = (String)this.arguments[1];
                    Integer n = (Integer)this.arguments[2];
                    Table table = session.database.schemaManager.getUserTable(hsqlName.name, hsqlName.schema.name);
                    if (session.isProcessingScript()) {
                        table.setIndexRoots(session, string13);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1155: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                    Table table = session.database.schemaManager.getUserTable(hsqlName.name, hsqlName.schema.name);
                    boolean bl = (Boolean)this.arguments[1];
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    table.setDataReadOnly(bl);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1156: 
            case 1157: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                    Table table = session.database.schemaManager.getUserTable(hsqlName.name, hsqlName.schema.name);
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isText()) {
                        HsqlException hsqlException = Error.error(321);
                        return Result.newErrorResult(hsqlException, this.sql);
                    }
                    if (this.arguments[1] != null) {
                        boolean bl = (Boolean)this.arguments[1];
                        if (bl) {
                            ((TextTable)table).connect(session);
                        } else {
                            ((TextTable)table).disconnect();
                        }
                        session.database.schemaManager.setSchemaChangeTimestamp();
                        return Result.updateZeroResult;
                    }
                    String string14 = (String)this.arguments[2];
                    boolean bl = (Boolean)this.arguments[3];
                    boolean bl5 = (Boolean)this.arguments[4];
                    if (bl5) {
                        ((TextTable)table).setHeader(string14);
                    } else {
                        ((TextTable)table).setDataSource(session, string14, bl, false);
                    }
                    return Result.updateZeroResult;
                }
                catch (Throwable throwable) {
                    HsqlException hsqlException;
                    if (!(throwable instanceof HsqlException)) {
                        hsqlException = Error.error(467, throwable.toString());
                    }
                    if (session.isProcessingLog() || session.isProcessingScript()) {
                        session.addWarning(hsqlException);
                        session.database.logger.logWarningEvent("Problem processing SET TABLE SOURCE", hsqlException);
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1158: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                    int n = (Integer)this.arguments[1];
                    Table table = session.database.schemaManager.getUserTable(hsqlName.name, hsqlName.schema.name);
                    if (table.getTableType() == n) {
                        return Result.updateZeroResult;
                    }
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    TableWorks tableWorks = new TableWorks(session, table);
                    boolean bl = tableWorks.setTableType(session, n);
                    if (!bl) {
                        throw Error.error(467);
                    }
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    if (hsqlName.schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
                        session.database.lobManager.compileStatements();
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1091: {
                User user = (User)this.arguments[0];
                boolean bl = (Boolean)this.arguments[1];
                session.checkAdmin();
                session.checkDDLWrite();
                user.isLocalOnly = bl;
                session.database.schemaManager.setSchemaChangeTimestamp();
                return Result.updateZeroResult;
            }
            case 1092: {
                try {
                    User user = (User)this.arguments[0];
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[1];
                    session.checkDDLWrite();
                    if (user == null) {
                        user = session.getUser();
                    } else {
                        session.checkAdmin();
                        session.checkDDLWrite();
                        user = session.database.userManager.get(user.getName().getNameString());
                    }
                    if (hsqlName != null) {
                        hsqlName = session.database.schemaManager.getSchemaHsqlName(hsqlName.name);
                    }
                    user.setInitialSchema(hsqlName);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1093: {
                try {
                    User user = this.arguments[0] == null ? session.getUser() : (User)this.arguments[0];
                    String string15 = (String)this.arguments[1];
                    boolean bl = (Boolean)this.arguments[2];
                    session.checkDDLWrite();
                    session.database.userManager.setPassword(session, user, string15, bl);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1120: {
                try {
                    long l = ((Number)this.arguments[0]).longValue();
                    int n = ((Number)this.arguments[1]).intValue();
                    Session session2 = session.database.sessionManager.getSession(l);
                    if (session2 == null) {
                        throw Error.error(4500);
                    }
                    switch (n) {
                        case 2: {
                            session.database.txManager.resetSession(session, session2, 3);
                            break;
                        }
                        case 294: {
                            session.database.txManager.resetSession(session, session2, 2);
                            break;
                        }
                        case 250: {
                            session.database.txManager.resetSession(session, session2, 1);
                            break;
                        }
                        case 42: {
                            session.database.txManager.resetSession(session, session2, 6);
                            break;
                        }
                        case 247: {
                            session.database.txManager.resetSession(session, session2, 4);
                            break;
                        }
                        case 99: {
                            session.database.txManager.resetSession(session, session2, 5);
                        }
                    }
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
                return Result.updateZeroResult;
            }
        }
        throw Error.runtimeError(201, "StatementCommand");
    }

    Result getTruncateResult(Session session) {
        try {
            Object object;
            Object[] objectArray;
            Object object2;
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
            boolean bl = (Boolean)this.arguments[1];
            boolean bl2 = (Boolean)this.arguments[2];
            TimestampData timestampData = (TimestampData)this.arguments[3];
            if (hsqlName.type == 3) {
                object2 = session.database.schemaManager.getUserTable(hsqlName);
                objectArray = new Table[]{object2};
                session.getGrantee().checkDelete((SchemaObject)object2);
                if (timestampData != null) {
                    TablePeriodWorks tablePeriodWorks = new TablePeriodWorks(session, (Table)object2);
                    long l = tablePeriodWorks.removeOldRows(timestampData.getSeconds());
                    return Result.newUpdateCountResult(0);
                }
                if (!bl2) {
                    for (int i = 0; i < ((Table)object2).fkMainConstraints.length; ++i) {
                        HsqlNameManager.HsqlName hsqlName2;
                        if (((Table)object2).fkMainConstraints[i].getRef() == object2 || ((TableBase)(object = session.database.schemaManager.getUserTable(hsqlName2 = ((Table)object2).fkMainConstraints[i].getRef().getName()))).isEmpty(session)) continue;
                        throw Error.error(8, ((Table)object).getName().name);
                    }
                }
            } else {
                Object object3;
                session.database.schemaManager.getSchemaHsqlName(hsqlName.name);
                object2 = session.database.schemaManager.getTables(hsqlName.name);
                objectArray = new Table[((BaseHashMap)object2).size()];
                ((HashMappedList)object2).toValuesArray(objectArray);
                StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName);
                if (!bl2) {
                    object3 = new OrderedHashSet();
                    session.database.schemaManager.getCascadingReferencesToSchema(hsqlName, (OrderedHashSet)object3);
                    for (int i = 0; i < ((BaseHashMap)object3).size(); ++i) {
                        Table table;
                        object = (HsqlNameManager.HsqlName)((OrderedHashSet)object3).get(i);
                        if (((HsqlNameManager.HsqlName)object).type != 5 || ((HsqlNameManager.HsqlName)object).parent.type != 3 || (table = session.database.schemaManager.getUserTable(((HsqlNameManager.HsqlName)object).parent)).isEmpty(session)) continue;
                        throw Error.error(8, table.getName().name);
                    }
                }
                if (bl) {
                    object3 = session.database.schemaManager.databaseObjectIterator(hsqlName.name, 7);
                    while (object3.hasNext()) {
                        NumberSequence numberSequence = (NumberSequence)object3.next();
                        numberSequence.reset();
                    }
                }
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object object4 = objectArray[i];
                PersistentStore persistentStore = ((Table)object4).getRowStore(session);
                persistentStore.removeAll();
                if (!bl || ((Table)object4).identitySequence == null) continue;
                ((Table)object4).identitySequence.reset();
            }
            return Result.updateZeroResult;
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException, this.sql);
        }
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 1151: {
                return ResultMetaData.newSingleColumnMetaData("PLAN");
            }
            case 1150: {
                return ResultMetaData.newSingleColumnMetaData("REFERENCES");
            }
            case 1004: {
                if (this.statementReturnType == 2) {
                    return ResultMetaData.newSingleColumnMetaData("STATEMENTS");
                }
                return super.getResultMetaData();
            }
        }
        return super.getResultMetaData();
    }

    @Override
    public boolean isAutoCommitStatement() {
        return this.isTransactionStatement;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }
}

