/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.Right;

public abstract class StatementDMQL
extends Statement {
    Table targetTable;
    Table baseTable;
    int[] baseColumnMap;
    RangeVariable[] targetRangeVariables = RangeVariable.emptyArray;
    Table sourceTable;
    Expression condition;
    boolean restartIdentity;
    int[] insertColumnMap = ValuePool.emptyIntArray;
    int[] updateColumnMap = ValuePool.emptyIntArray;
    int[] baseUpdateColumnMap = ValuePool.emptyIntArray;
    Expression[] updateExpressions = Expression.emptyArray;
    Expression[][] multiColumnValues;
    Expression insertExpression;
    boolean[] insertCheckColumns;
    boolean[] updateCheckColumns;
    Expression updatableTableCheck;
    RangeVariable checkRangeVariable;
    QueryExpression queryExpression;
    HsqlNameManager.HsqlName cursorName;
    TableDerived[] subqueries = TableDerived.emptyArray;
    int rangeIteratorCount;
    NumberSequence[] sequences;
    Routine[] routines;
    RangeVariable[] rangeVariables;

    StatementDMQL(int n, int n2, HsqlNameManager.HsqlName hsqlName) {
        super(n, n2);
        this.schemaName = hsqlName;
        this.isTransactionStatement = true;
    }

    void setBaseIndexColumnMap() {
        if (this.targetTable != this.baseTable) {
            this.baseColumnMap = this.targetTable.getBaseTableColumnMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Session session) {
        Result result2;
        if (this.targetTable != null && session.isReadOnly() && !this.targetTable.isTemp()) {
            HsqlException hsqlException = Error.error(3706);
            return Result.newErrorResult(hsqlException);
        }
        if (this.isExplain) {
            return this.getExplainResult(session);
        }
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result2 = this.getResult(session);
        }
        catch (Throwable throwable) {
            result2 = Result.newErrorResult(throwable);
            result2.getException().setStatementType(this.group, this.type);
        }
        finally {
            this.clearStructures(session);
        }
        return result2;
    }

    private Result getExplainResult(Session session) {
        HsqlNameManager.HsqlName hsqlName;
        int n;
        Result result2 = Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        OrderedHashSet orderedHashSet = this.getReferences();
        result2.navigator.add(new Object[]{"Object References"});
        for (n = 0; n < orderedHashSet.size(); ++n) {
            hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(n);
            result2.navigator.add(new Object[]{hsqlName.getSchemaQualifiedStatementName()});
        }
        result2.navigator.add(new Object[]{"Read Locks"});
        for (n = 0; n < this.readTableNames.length; ++n) {
            hsqlName = this.readTableNames[n];
            result2.navigator.add(new Object[]{hsqlName.getSchemaQualifiedStatementName()});
        }
        result2.navigator.add(new Object[]{"WriteLocks"});
        for (n = 0; n < this.writeTableNames.length; ++n) {
            hsqlName = this.writeTableNames[n];
            result2.navigator.add(new Object[]{hsqlName.getSchemaQualifiedStatementName()});
        }
        return result2;
    }

    abstract Result getResult(Session var1);

    abstract void collectTableNamesForRead(OrderedHashSet var1);

    abstract void collectTableNamesForWrite(OrderedHashSet var1);

    boolean[] getInsertOrUpdateColumnCheckList() {
        switch (this.type) {
            case 55: {
                return this.insertCheckColumns;
            }
            case 92: {
                return this.updateCheckColumns;
            }
            case 56: {
                boolean[] blArray = (boolean[])ArrayUtil.duplicateArray(this.insertCheckColumns);
                ArrayUtil.orBooleanArray(this.updateCheckColumns, blArray);
                return blArray;
            }
        }
        return null;
    }

    void materializeSubQueries(Session session) {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < this.subqueries.length; ++i) {
            TableDerived tableDerived = this.subqueries[i];
            if (!hashSet.add(tableDerived) || tableDerived.isCorrelated()) continue;
            tableDerived.materialise(session);
        }
    }

    TableDerived[] getSubqueries(Session session) {
        int n;
        OrderedHashSet orderedHashSet = null;
        for (n = 0; n < this.targetRangeVariables.length; ++n) {
            if (this.targetRangeVariables[n] == null) continue;
            OrderedHashSet orderedHashSet2 = this.targetRangeVariables[n].getSubqueries();
            orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet2);
        }
        for (n = 0; n < this.updateExpressions.length; ++n) {
            orderedHashSet = this.updateExpressions[n].collectAllSubqueries(orderedHashSet);
        }
        if (this.insertExpression != null) {
            orderedHashSet = this.insertExpression.collectAllSubqueries(orderedHashSet);
        }
        if (this.condition != null) {
            orderedHashSet = this.condition.collectAllSubqueries(orderedHashSet);
        }
        if (this.queryExpression != null) {
            OrderedHashSet orderedHashSet3 = this.queryExpression.getSubqueries();
            orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet3);
        }
        if (this.updatableTableCheck != null) {
            OrderedHashSet orderedHashSet4 = this.updatableTableCheck.getSubqueries();
            orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet4);
        }
        if (orderedHashSet == null || orderedHashSet.size() == 0) {
            return TableDerived.emptyArray;
        }
        Object[] objectArray = new TableDerived[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray);
        return objectArray;
    }

    @Override
    void setDatabaseObjects(Session session, ParserDQL.CompileContext compileContext) {
        this.parameters = compileContext.getParameters();
        this.setParameterMetaData();
        this.subqueries = this.getSubqueries(session);
        this.rangeIteratorCount = compileContext.getRangeVarCount();
        this.rangeVariables = compileContext.getAllRangeVariables();
        this.sequences = compileContext.getSequences();
        this.routines = compileContext.getRoutines();
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        this.collectTableNamesForWrite(orderedHashSet);
        if (orderedHashSet.size() > 0) {
            this.writeTableNames = new HsqlNameManager.HsqlName[orderedHashSet.size()];
            orderedHashSet.toArray(this.writeTableNames);
            orderedHashSet.clear();
        }
        this.collectTableNamesForRead(orderedHashSet);
        orderedHashSet.removeAll(this.writeTableNames);
        if (orderedHashSet.size() > 0) {
            this.readTableNames = new HsqlNameManager.HsqlName[orderedHashSet.size()];
            orderedHashSet.toArray(this.readTableNames);
        }
        if (this.readTableNames.length == 0 && this.writeTableNames.length == 0 && (this.type == 44 || this.type == 70)) {
            this.isTransactionStatement = false;
        }
        this.references = compileContext.getSchemaObjectNames();
        if (this.targetTable != null) {
            this.references.add(this.targetTable.getName());
            if (this.targetTable == this.baseTable) {
                if (this.insertCheckColumns != null) {
                    this.targetTable.getColumnNames(this.insertCheckColumns, this.references);
                }
                if (this.updateCheckColumns != null) {
                    this.targetTable.getColumnNames(this.updateCheckColumns, this.references);
                }
            }
        }
    }

    void checkAccessRights(Session session) {
        int n;
        if (this.targetTable != null && !this.targetTable.isTemp()) {
            Grantee grantee;
            if (!session.isProcessingScript()) {
                this.targetTable.checkDataReadOnly();
            }
            if ((grantee = this.targetTable.getOwner()) != null && grantee.isSystem() && !session.getUser().isSystem()) {
                throw Error.error(5501, this.targetTable.getName().name);
            }
            session.checkReadWrite();
        }
        if (session.isAdmin()) {
            return;
        }
        for (n = 0; n < this.sequences.length; ++n) {
            session.getGrantee().checkAccess(this.sequences[n]);
        }
        for (n = 0; n < this.routines.length; ++n) {
            if (this.routines[n].isLibraryRoutine()) continue;
            session.getGrantee().checkAccess(this.routines[n]);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            RangeVariable rangeVariable = this.rangeVariables[n];
            if (rangeVariable.isViewSubquery || rangeVariable.rangeTable.getSchemaName() == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            Right right2 = session.getGrantee().checkSelect(rangeVariable.rangeTable, rangeVariable.usedColumns);
            ExpressionLogical expressionLogical = right2.getFilterExpression();
            rangeVariable.setFilterExpression(session, expressionLogical);
        }
        switch (this.type) {
            case 10: {
                break;
            }
            case 55: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                break;
            }
            case 44: {
                break;
            }
            case 19: {
                session.getGrantee().checkDelete(this.targetTable);
                break;
            }
            case 92: {
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                break;
            }
            case 56: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
            }
        }
    }

    Result getWriteAccessResult(Session session) {
        try {
            if (this.targetTable != null && !this.targetTable.isTemp()) {
                session.checkReadWrite();
            }
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
        return null;
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 19: 
            case 55: 
            case 56: 
            case 92: {
                return ResultMetaData.emptyResultMetaData;
            }
        }
        throw Error.runtimeError(201, "StatementDMQL");
    }

    @Override
    public ResultMetaData getParametersMetaData() {
        return this.parameterMetaData;
    }

    @Override
    public String describe(Session session) {
        try {
            return this.describeImpl(session);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return throwable.toString();
        }
    }

    String describeImpl(Session session) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        switch (this.type) {
            case 44: {
                stringBuilder.append(this.queryExpression.describe(session, 0));
                this.appendParams(stringBuilder).append('\n');
                this.appendSubqueries(session, stringBuilder, 2);
                return stringBuilder.toString();
            }
            case 55: {
                if (this.queryExpression == null) {
                    stringBuilder.append("INSERT VALUES");
                    stringBuilder.append('[').append('\n');
                    this.appendMultiColumns(stringBuilder, this.insertColumnMap).append('\n');
                    this.appendTable(stringBuilder).append('\n');
                    this.appendParams(stringBuilder).append('\n');
                    this.appendSubqueries(session, stringBuilder, 2).append(']');
                    return stringBuilder.toString();
                }
                stringBuilder.append("INSERT SELECT");
                stringBuilder.append('[').append('\n');
                this.appendColumns(stringBuilder, this.insertColumnMap).append('\n');
                this.appendTable(stringBuilder).append('\n');
                stringBuilder.append(this.queryExpression.describe(session, n)).append('\n');
                this.appendParams(stringBuilder).append('\n');
                this.appendSubqueries(session, stringBuilder, 2).append(']');
                return stringBuilder.toString();
            }
            case 92: {
                stringBuilder.append("UPDATE");
                stringBuilder.append('[').append('\n');
                this.appendColumns(stringBuilder, this.updateColumnMap).append('\n');
                this.appendTable(stringBuilder).append('\n');
                this.appendCondition(session, stringBuilder);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    stringBuilder.append(this.targetRangeVariables[i].describe(session, n)).append('\n');
                }
                this.appendParams(stringBuilder).append('\n');
                this.appendSubqueries(session, stringBuilder, 2).append(']');
                return stringBuilder.toString();
            }
            case 19: {
                stringBuilder.append("DELETE");
                stringBuilder.append('[').append('\n');
                this.appendTable(stringBuilder).append('\n');
                this.appendCondition(session, stringBuilder);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    stringBuilder.append(this.targetRangeVariables[i].describe(session, n)).append('\n');
                }
                this.appendParams(stringBuilder).append('\n');
                this.appendSubqueries(session, stringBuilder, 2).append(']');
                return stringBuilder.toString();
            }
            case 10: {
                stringBuilder.append("CALL");
                stringBuilder.append('[').append(']');
                return stringBuilder.toString();
            }
            case 56: {
                stringBuilder.append("MERGE");
                stringBuilder.append('[').append('\n');
                this.appendMultiColumns(stringBuilder, this.insertColumnMap).append('\n');
                this.appendColumns(stringBuilder, this.updateColumnMap).append('\n');
                this.appendTable(stringBuilder).append('\n');
                this.appendCondition(session, stringBuilder);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    stringBuilder.append(this.targetRangeVariables[i].describe(session, n)).append('\n');
                }
                this.appendParams(stringBuilder).append('\n');
                this.appendSubqueries(session, stringBuilder, 2).append(']');
                return stringBuilder.toString();
            }
        }
        return "UNKNOWN";
    }

    private StringBuilder appendSubqueries(Session session, StringBuilder stringBuilder, int n) {
        stringBuilder.append("SUBQUERIES[");
        for (int i = 0; i < this.subqueries.length; ++i) {
            stringBuilder.append("\n[level=").append(this.subqueries[i].depth).append('\n');
            if (this.subqueries[i].queryExpression == null) {
                for (int j = 0; j < n; ++j) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append("value expression");
            } else {
                stringBuilder.append(this.subqueries[i].queryExpression.describe(session, n));
            }
            stringBuilder.append("]");
        }
        stringBuilder.append(']');
        return stringBuilder;
    }

    private StringBuilder appendTable(StringBuilder stringBuilder) {
        stringBuilder.append("TABLE[").append(this.targetTable.getName().name).append(']');
        return stringBuilder;
    }

    private StringBuilder appendSourceTable(StringBuilder stringBuilder) {
        stringBuilder.append("SOURCE TABLE[").append(this.sourceTable.getName().name).append(']');
        return stringBuilder;
    }

    private StringBuilder appendColumns(StringBuilder stringBuilder, int[] nArray) {
        int n;
        if (nArray == null || this.updateExpressions.length == 0) {
            return stringBuilder;
        }
        stringBuilder.append("COLUMNS=[");
        for (n = 0; n < nArray.length; ++n) {
            stringBuilder.append('\n').append(nArray[n]).append(':').append(' ').append(this.targetTable.getColumn(nArray[n]).getNameString());
        }
        for (n = 0; n < this.updateExpressions.length; ++n) {
            stringBuilder.append('[').append(this.updateExpressions[n]).append(']');
        }
        stringBuilder.append(']');
        return stringBuilder;
    }

    private StringBuilder appendMultiColumns(StringBuilder stringBuilder, int[] nArray) {
        if (nArray == null || this.multiColumnValues == null) {
            return stringBuilder;
        }
        stringBuilder.append("COLUMNS=[");
        for (int i = 0; i < this.multiColumnValues.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                stringBuilder.append('\n').append(nArray[j]).append(':').append(' ').append(this.targetTable.getColumn((int)nArray[j]).getName().name).append('[').append(this.multiColumnValues[i][j]).append(']');
            }
        }
        stringBuilder.append(']');
        return stringBuilder;
    }

    private StringBuilder appendParams(StringBuilder stringBuilder) {
        stringBuilder.append("PARAMETERS=[");
        for (int i = 0; i < this.parameters.length; ++i) {
            stringBuilder.append('\n').append('@').append(i).append('[').append(this.parameters[i].describe(null, 0)).append(']');
        }
        stringBuilder.append(']');
        return stringBuilder;
    }

    private StringBuilder appendCondition(Session session, StringBuilder stringBuilder) {
        return this.condition == null ? stringBuilder.append("CONDITION[]\n") : stringBuilder.append("CONDITION[").append(this.condition.describe(session, 0)).append("]\n");
    }

    @Override
    public void resolve(Session session) {
    }

    @Override
    public final boolean isCatalogLock(int n) {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }

    @Override
    public void clearStructures(Session session) {
        session.sessionContext.clearStructures(this);
    }
}

