/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.hsqldb.ColumnBase;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class JDBCArrayBasic
implements Array {
    Type arrayType;
    Type elementType;
    Object[] data;

    @Override
    public String getBaseTypeName() throws SQLException {
        this.checkClosed();
        return this.elementType.getNameString();
    }

    @Override
    public int getBaseType() throws SQLException {
        this.checkClosed();
        return this.elementType.getJDBCTypeCode();
    }

    @Override
    public Object getArray() {
        return this.data;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map23) throws SQLException {
        return this.getArray();
    }

    @Override
    public Object getArray(long l, int n) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(this.data.length, l - 1L, n)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        Object[] objectArray = new Object[n];
        System.arraycopy(this.data, (int)l - 1, objectArray, 0, n);
        return objectArray;
    }

    @Override
    public Object getArray(long l, int n, Map<String, Class<?>> map23) throws SQLException {
        return this.getArray(l, n);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        Result result2 = this.newColumnResult(0L, this.data.length);
        return JDBCResultSet.newJDBCResultSet(result2, result2.metaData);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map23) throws SQLException {
        return this.getResultSet();
    }

    @Override
    public ResultSet getResultSet(long l, int n) throws SQLException {
        this.checkClosed();
        Result result2 = this.newColumnResult(l - 1L, n);
        return new JDBCResultSet(null, result2, result2.metaData);
    }

    @Override
    public ResultSet getResultSet(long l, int n, Map<String, Class<?>> map23) throws SQLException {
        return this.getResultSet(l, n);
    }

    public String toString() {
        if (this.arrayType == null) {
            this.arrayType = Type.getDefaultArrayType(this.elementType.typeCode);
        }
        return this.arrayType.convertToString(this.data);
    }

    @Override
    public void free() throws SQLException {
    }

    public JDBCArrayBasic(Object[] objectArray, Type type) {
        this.data = objectArray;
        this.elementType = type;
    }

    Object[] getArrayInternal() {
        return this.data;
    }

    private Result newColumnResult(long l, int n) throws SQLException {
        if (!JDBCClobClient.isInLimits(this.data.length, l, n)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        Type[] typeArray = new Type[]{Type.SQL_INTEGER, this.elementType};
        ResultMetaData resultMetaData = ResultMetaData.newSimpleResultMetaData(typeArray);
        resultMetaData.columnLabels = new String[]{"C1", "C2"};
        resultMetaData.colIndexes = new int[]{-1, -1};
        resultMetaData.columns = new ColumnBase[2];
        for (int i = 0; i < resultMetaData.columns.length; ++i) {
            ColumnBase columnBase = new ColumnBase("", "", "", "");
            columnBase.setType(typeArray[i]);
            resultMetaData.columns[i] = columnBase;
        }
        RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient();
        int n2 = (int)l;
        while ((long)n2 < l + (long)n) {
            Object[] objectArray = new Object[]{n2 + 1, this.data[n2]};
            rowSetNavigatorClient.add(objectArray);
            ++n2;
        }
        Result result2 = Result.newDataResult(resultMetaData);
        result2.setNavigator(rowSetNavigatorClient);
        return result2;
    }

    private void checkClosed() throws SQLException {
    }
}

